#!/usr/bin/env python
# Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
# Copyright (C) 2009-2026 German Aerospace Center (DLR) and others.
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# https://www.eclipse.org/legal/epl-2.0/
# This Source Code may also be made available under the following Secondary
# Licenses when the conditions for such availability set forth in the Eclipse
# Public License 2.0 are satisfied: GNU General Public License, version 2
# or later which is available at
# https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
# SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later

# @file    test.py
# @author  Pablo Alvarez Lopez
# @date    2016-11-25

# import common functions for netedit tests
import os
import sys

sys.path.append(os.path.join(os.environ.get("SUMO_HOME", "."), "tools"))
import neteditTestFunctions as netedit  # noqa

# Open netedit
neteditProcess, referencePosition = netedit.setupAndStart()

# go to additional mode
netedit.changeMode("additional")

# select parkingArea
netedit.changeElement("additionalFrame", "parkingArea")

# create parkingArea in mode "Reference Left"
netedit.leftClick(referencePosition, netedit.positions.elements.edgeCenter1)

# select space
netedit.changeElement("additionalFrame", "space")

# set invalid length (dummy)
netedit.selectAdditionalChild(netedit.attrs.parkingSpace.create.parent, 0)
netedit.modifyAttribute(netedit.attrs.parkingSpace.create.length, "dummyLength")

# try to create area
netedit.leftClick(referencePosition, netedit.positions.elements.additionals.squaredA)

# set invalid height (empty)
netedit.modifyAttribute(netedit.attrs.parkingSpace.create.length, "")

# try to create area
netedit.leftClick(referencePosition, netedit.positions.elements.additionals.squaredA)

# set invalid height (negative)
netedit.modifyAttribute(netedit.attrs.parkingSpace.create.length, "-4")

# try to create area
netedit.leftClick(referencePosition, netedit.positions.elements.additionals.squaredB)

# set valid height
netedit.modifyAttribute(netedit.attrs.parkingSpace.create.length, "3.1")

# create area
netedit.leftClick(referencePosition, netedit.positions.elements.additionals.squaredB)

# Check undo redo
netedit.checkUndoRedo(referencePosition)

# save netedit config
netedit.saveExistentFile("neteditConfig")

# quit netedit
netedit.quit(neteditProcess)
