import { IDisposable } from '@lumino/disposable';
import { Widget } from '@lumino/widgets';
import { ITableOfContentsRegistry, TableOfContents } from './tokens';
/**
 * Class for registering table of contents generators.
 */
export declare class TableOfContentsRegistry implements ITableOfContentsRegistry {
    /**
     * Finds a table of contents model for a widget.
     *
     * ## Notes
     *
     * -   If unable to find a table of contents model, the method return `undefined`.
     *
     * @param widget - widget
     * @param configuration - Default model configuration
     * @returns Table of contents model
     */
    getModel(widget: Widget, configuration?: TableOfContents.IConfig): TableOfContents.Model | undefined;
    /**
     * Adds a table of contents generator to the registry.
     *
     * @param generator - table of contents generator
     */
    add(generator: TableOfContents.IFactory): IDisposable;
    private _generators;
    private _idCounter;
}
