"use strict";
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.signalToPromise = void 0;
const coreutils_1 = require("@lumino/coreutils");
/**
 * Convert a signal into a promise for the first emitted value.
 *
 * @param signal - The signal we are listening to.
 * @param timeout - Timeout to wait for signal in ms (not timeout if not defined or 0)
 *
 * @returns a Promise that resolves with a `(sender, args)` pair.
 */
function signalToPromise(signal, timeout) {
    const waitForSignal = new coreutils_1.PromiseDelegate();
    function cleanup() {
        signal.disconnect(slot);
    }
    function slot(sender, args) {
        cleanup();
        waitForSignal.resolve([sender, args]);
    }
    signal.connect(slot);
    if ((timeout !== null && timeout !== void 0 ? timeout : 0) > 0) {
        setTimeout(() => {
            cleanup();
            waitForSignal.reject(`Signal not emitted within ${timeout} ms.`);
        }, timeout);
    }
    return waitForSignal.promise;
}
exports.signalToPromise = signalToPromise;
//# sourceMappingURL=signal.js.map