/*
 * Decompiled with CFR 0.152.
 */
package org.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fontbox.ttf.NameRecord;
import org.fontbox.ttf.TTFDataStream;
import org.fontbox.ttf.TTFTable;
import org.fontbox.ttf.TrueTypeFont;

public class NamingTable
extends TTFTable {
    public static final String TAG = "name";
    private List nameRecords = new ArrayList();

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        NameRecord nr;
        int formatSelector = data.readUnsignedShort();
        int numberOfNameRecords = data.readUnsignedShort();
        int offsetToStartOfStringStorage = data.readUnsignedShort();
        int i = 0;
        while (i < numberOfNameRecords) {
            nr = new NameRecord();
            nr.initData(ttf, data);
            this.nameRecords.add(nr);
            ++i;
        }
        i = 0;
        while (i < numberOfNameRecords) {
            nr = (NameRecord)this.nameRecords.get(i);
            data.seek(this.getOffset() + 6L + (long)(numberOfNameRecords * 2 * 6) + (long)nr.getStringOffset());
            int platform = nr.getPlatformId();
            int encoding = nr.getPlatformEncodingId();
            String charset = "ISO-8859-1";
            if (platform == 3 && encoding == 1) {
                charset = "UTF-16";
            } else if (platform == 2) {
                if (encoding == 0) {
                    charset = "US-ASCII";
                } else if (encoding == 1) {
                    charset = "ISO-10646-1";
                } else if (encoding == 2) {
                    charset = "ISO-8859-1";
                }
            }
            String string = data.readString(nr.getStringLength(), charset);
            nr.setString(string);
            ++i;
        }
    }

    public List getNameRecords() {
        return this.nameRecords;
    }
}

