/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.interfaces.GOST3410PrivateKey;

public class CMSSignedGenerator {
    public static final String DATA = PKCSObjectIdentifiers.data.getId();
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();

    protected CMSSignedGenerator() {
    }

    protected String getEncOID(PrivateKey privateKey, String string) {
        String string2 = null;
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_RSA;
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_DSA;
            if (!string.equals(DIGEST_SHA1)) {
                throw new IllegalArgumentException("can't mix DSA with anything but SHA1");
            }
        } else if ("ECDSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_ECDSA;
            if (!string.equals(DIGEST_SHA1)) {
                throw new IllegalArgumentException("can't mix ECDSA with anything but SHA1");
            }
        } else if (privateKey instanceof GOST3410PrivateKey || "GOST3410".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_GOST3410;
        } else if ("ECGOST3410".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_ECGOST3410;
        }
        return string2;
    }

    protected ASN1Set getSignedAttributeSet(DERObjectIdentifier dERObjectIdentifier, byte[] byArray, AttributeTable attributeTable, boolean bl) {
        if (attributeTable != null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            if (attributeTable.get(CMSAttributes.contentType) == null) {
                aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)dERObjectIdentifier)));
            } else {
                aSN1EncodableVector.add((DEREncodable)attributeTable.get(CMSAttributes.contentType));
            }
            if (attributeTable.get(CMSAttributes.signingTime) == null) {
                aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new Time(new Date()))));
            } else {
                aSN1EncodableVector.add((DEREncodable)attributeTable.get(CMSAttributes.signingTime));
            }
            if (byArray != null) {
                aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(byArray))));
            } else {
                aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DERNull())));
            }
            ASN1EncodableVector aSN1EncodableVector2 = attributeTable.toASN1EncodableVector();
            for (int i = 0; i != aSN1EncodableVector2.size(); ++i) {
                Attribute attribute = Attribute.getInstance((Object)aSN1EncodableVector2.get(i));
                DERObjectIdentifier dERObjectIdentifier2 = attribute.getAttrType();
                if (dERObjectIdentifier2.equals((Object)CMSAttributes.contentType) || dERObjectIdentifier2.equals((Object)CMSAttributes.signingTime) || dERObjectIdentifier2.equals((Object)CMSAttributes.messageDigest)) continue;
                aSN1EncodableVector.add((DEREncodable)attribute);
            }
            return new DERSet((DEREncodableVector)aSN1EncodableVector);
        }
        if (bl) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)dERObjectIdentifier)));
            aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new DERUTCTime(new Date()))));
            if (byArray != null) {
                aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(byArray))));
            } else {
                aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DERNull())));
            }
            return new DERSet((DEREncodableVector)aSN1EncodableVector);
        }
        return null;
    }

    protected ASN1Set getUnsignedAttributeSet(AttributeTable attributeTable) {
        if (attributeTable != null) {
            return new DERSet((DEREncodableVector)attributeTable.toASN1EncodableVector());
        }
        return null;
    }
}

