/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOption;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

public class EmptyForInitializerPadCheck
extends AbstractOptionCheck {
    public EmptyForInitializerPadCheck() {
        super(PadOption.NOSPACE);
    }

    public int[] getDefaultTokens() {
        return new int[]{35};
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getChildCount() == 0) {
            DetailAST semi = (DetailAST)aAST.getNextSibling();
            int semiLineIdx = semi.getLineNo() - 1;
            String line = this.getLines()[semiLineIdx];
            int before = semi.getColumnNo() - 1;
            if (!Utils.whitespaceBefore(before, line)) {
                AbstractOption abstractOption = this.getAbstractOption();
                if (PadOption.NOSPACE == abstractOption && Character.isWhitespace(line.charAt(before))) {
                    this.log(semi.getLineNo(), before, "ws.preceded", (Object)";");
                } else if (PadOption.SPACE == abstractOption && !Character.isWhitespace(line.charAt(before))) {
                    this.log(semi.getLineNo(), before, "ws.notPreceded", (Object)";");
                }
            }
        }
    }
}

