/*
 * Decompiled with CFR 0.152.
 */
package test.pdfbox.encryption;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.encryption.AccessPermission;
import org.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.pdfbox.pdmodel.encryption.PublicKeyRecipient;

public class TestPublicKeyEncryption
extends TestCase {
    private AccessPermission accessPermission = new AccessPermission();
    private AccessPermission accessPermission2;
    private File publicCert1;
    private File privateCert1;
    private File publicCert2;
    private File privateCert2;
    private File input;
    private File output;
    private String password1 = "test1";
    private String password2 = "test2";
    static /* synthetic */ Class class$test$pdfbox$encryption$TestPublicKeyEncryption;

    public TestPublicKeyEncryption(String name) {
        super(name);
        this.accessPermission.setCanAssembleDocument(false);
        this.accessPermission.setCanExtractContent(false);
        this.accessPermission.setCanExtractForAccessibility(true);
        this.accessPermission.setCanFillInForm(false);
        this.accessPermission.setCanModify(false);
        this.accessPermission.setCanModifyAnnotations(false);
        this.accessPermission.setCanPrint(false);
        this.accessPermission.setCanPrintDegraded(false);
        this.accessPermission2 = new AccessPermission();
        this.accessPermission2.setCanAssembleDocument(false);
        this.accessPermission2.setCanExtractContent(false);
        this.accessPermission2.setCanExtractForAccessibility(true);
        this.accessPermission2.setCanFillInForm(false);
        this.accessPermission2.setCanModify(false);
        this.accessPermission2.setCanModifyAnnotations(false);
        this.accessPermission2.setCanPrint(true);
        this.accessPermission2.setCanPrintDegraded(false);
        this.publicCert1 = new File("test/encryption/test1.der");
        this.privateCert1 = new File("test/encryption/test1.pfx");
        this.publicCert2 = new File("test/encryption/test2.der");
        this.privateCert2 = new File("test/encryption/test2.pfx");
        this.input = new File("test/input/Exolab.pdf");
        this.output = new File("test/encryption/output.pdf");
        Assert.assertTrue((this.publicCert1.exists() && this.publicCert1.isFile() ? 1 : 0) != 0);
        Assert.assertTrue((this.privateCert1.exists() && this.privateCert1.isFile() ? 1 : 0) != 0);
        Assert.assertTrue((this.publicCert2.exists() && this.publicCert2.isFile() ? 1 : 0) != 0);
        Assert.assertTrue((this.privateCert2.exists() && this.privateCert2.isFile() ? 1 : 0) != 0);
        Assert.assertTrue((this.input.exists() && this.input.isFile() ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(class$test$pdfbox$encryption$TestPublicKeyEncryption == null ? (class$test$pdfbox$encryption$TestPublicKeyEncryption = TestPublicKeyEncryption.class$("test.pdfbox.encryption.TestPublicKeyEncryption")) : class$test$pdfbox$encryption$TestPublicKeyEncryption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProtectionError() throws Exception {
        PDDocument doc = PDDocument.load(this.input);
        this.protect(doc, this.publicCert1.getAbsolutePath());
        doc.save(this.output.getAbsolutePath());
        doc.close();
        PDDocument doc2 = PDDocument.load(this.output);
        CryptographyException e = null;
        try {
            this.open(doc2, this.privateCert2.getAbsolutePath(), this.password2);
        }
        catch (CryptographyException ex) {
            try {
                e = ex;
                System.out.println(ex.getMessage());
            }
            catch (Throwable throwable) {
                Assert.assertNotNull(e);
                throw throwable;
            }
            Assert.assertNotNull((Object)e);
        }
        Assert.assertNotNull((Object)e);
    }

    public void testProtection() throws Exception {
        PDDocument doc = PDDocument.load(this.input);
        this.protect(doc, this.publicCert1.getAbsolutePath());
        doc.save(this.output.getAbsolutePath());
        doc.close();
        PDDocument doc2 = PDDocument.load(this.output);
        Assert.assertNotNull((Object)doc2);
        this.open(doc2, this.privateCert1.getAbsolutePath(), this.password1);
        Assert.assertTrue((boolean)doc2.isEncrypted());
        AccessPermission currentAp = doc2.getCurrentAccessPermission();
        Assert.assertFalse((boolean)currentAp.canAssembleDocument());
        Assert.assertFalse((boolean)currentAp.canExtractContent());
        Assert.assertTrue((boolean)currentAp.canExtractForAccessibility());
        Assert.assertFalse((boolean)currentAp.canFillInForm());
        Assert.assertFalse((boolean)currentAp.canModify());
        Assert.assertFalse((boolean)currentAp.canModifyAnnotations());
        Assert.assertFalse((boolean)currentAp.canPrint());
        Assert.assertFalse((boolean)currentAp.canPrintDegraded());
        doc2.close();
    }

    public void testMultipleRecipients() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        PDDocument doc = PDDocument.load(this.input);
        PublicKeyProtectionPolicy ppp = new PublicKeyProtectionPolicy();
        PublicKeyRecipient recip1 = new PublicKeyRecipient();
        PublicKeyRecipient recip2 = new PublicKeyRecipient();
        recip1.setPermission(this.accessPermission);
        recip2.setPermission(this.accessPermission2);
        FileInputStream inStream = new FileInputStream(this.publicCert1);
        Assert.assertNotNull((Object)cf);
        X509Certificate certificate1 = (X509Certificate)cf.generateCertificate(inStream);
        ((InputStream)inStream).close();
        FileInputStream inStream2 = new FileInputStream(this.publicCert2);
        Assert.assertNotNull((Object)cf);
        X509Certificate certificate2 = (X509Certificate)cf.generateCertificate(inStream2);
        ((InputStream)inStream).close();
        recip1.setX509(certificate1);
        recip2.setX509(certificate2);
        ppp.addRecipient(recip1);
        ppp.addRecipient(recip2);
        doc.protect(ppp);
        doc.save(this.output.getAbsolutePath());
        doc.close();
        PDDocument docOpen1 = PDDocument.load(this.output);
        KeyStore ks1 = KeyStore.getInstance("PKCS12");
        ks1.load(new FileInputStream(this.privateCert1), this.password1.toCharArray());
        PublicKeyDecryptionMaterial pdm = new PublicKeyDecryptionMaterial(ks1, null, this.password1);
        docOpen1.openProtection(pdm);
        docOpen1.close();
        PDDocument docOpen2 = PDDocument.load(this.output);
        KeyStore ks2 = KeyStore.getInstance("PKCS12");
        ks2.load(new FileInputStream(this.privateCert2), this.password2.toCharArray());
        PublicKeyDecryptionMaterial pdm2 = new PublicKeyDecryptionMaterial(ks2, null, this.password2);
        docOpen2.openProtection(pdm2);
        docOpen2.close();
    }

    private void protect(PDDocument doc, String certPath) throws Exception {
        FileInputStream inStream = new FileInputStream(certPath);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Assert.assertNotNull((Object)cf);
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(inStream);
        Assert.assertNotNull((Object)certificate);
        ((InputStream)inStream).close();
        PublicKeyProtectionPolicy ppp = new PublicKeyProtectionPolicy();
        PublicKeyRecipient recip = new PublicKeyRecipient();
        recip.setPermission(this.accessPermission);
        recip.setX509(certificate);
        ppp.addRecipient(recip);
        doc.protect(ppp);
    }

    private void open(PDDocument doc, String certPath, String password) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(new FileInputStream(certPath), password.toCharArray());
        PublicKeyDecryptionMaterial pdm = new PublicKeyDecryptionMaterial(ks, null, password);
        doc.openProtection(pdm);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

