/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import sun.net.dns.ResolverConfiguration;

public final class DnsDetect {
    private final List<String> searchlist;
    private final String postfix;

    public DnsDetect(String stackUuid) throws IOException {
        this.postfix = stackUuid == null ? "" : "_" + stackUuid;
        ResolverConfiguration rc = ResolverConfiguration.open();
        this.searchlist = rc.searchlist();
        this.searchlist.add(0, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String query(String name, String type) {
        try (InitialDirContext context = new InitialDirContext();){
            context.addToEnvironment("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            Iterator<String> iterator = this.searchlist.iterator();
            while (iterator.hasNext()) {
                String domain = iterator.next();
                String qname = domain.isEmpty() ? name : name + "." + domain;
                try {
                    Object result;
                    Attributes attributes = context.getAttributes(qname, new String[]{type});
                    Attribute attribute = attributes.get(type);
                    if (attribute == null || (result = attribute.get()) == null) continue;
                    String string = result.toString();
                    return string;
                }
                catch (NamingException namingException) {}
            }
            return null;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return null;
    }

    public String queryEndpoint() throws IOException {
        String result = this.query("crs-endpoint" + this.postfix, "CNAME");
        return result == null ? null : (result.endsWith(".") ? result.substring(0, result.length() - 1) : result);
    }

    public String queryMailbox() throws IOException {
        return this.query("crs-mailbox" + this.postfix, "TXT");
    }

    public String getRecordNamePostfix() {
        return this.postfix;
    }
}

