<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/isc_dhcpd/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/isc_dhcpd/metadata.yaml"
sidebar_label: "ISC DHCP"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/DNS and DHCP Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# ISC DHCP


<img src="https://netdata.cloud/img/isc.png" width="150"/>


Plugin: go.d.plugin
Module: isc_dhcpd

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors ISC DHCP lease usage by reading the DHCP client lease database (dhcpd.leases).




This collector is only supported on the following platforms:

- Linux
- BSD

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per ISC DHCP instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| isc_dhcpd.active_leases_total | active | leases |

### Per ISC DHCP instance

These metrics refer to the DHCP pool.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| dhcp_pool_name | The DHCP pool name defined in the collector configuration. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| isc_dhcpd.dhcp_pool_utilization | utilization | percent |
| isc_dhcpd.dhcp_pool_active_leases | active | leases |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/isc_dhcpd.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/isc_dhcpd.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| leases_path | Path to DHCP client lease database. | /var/lib/dhcp/dhcpd.leases | no |
| pools | List of IP pools to monitor. |  | yes |

##### pools

List of IP pools to monitor.

- IP range syntax: see [supported formats](https://github.com/netdata/netdata/tree/master/src/go/plugin/go.d/pkg/iprange#supported-formats).
- Syntax:

```yaml
pools:
  - name: "POOL_NAME1"
    networks: "SPACE SEPARATED LIST OF IP RANGES"
  - name: "POOL_NAME2"
    networks: "SPACE SEPARATED LIST OF IP RANGES"
```


</details>

#### Examples

##### Basic

A basic example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    pools:
      - name: lan
        networks: "192.168.0.0/24 192.168.1.0/24 192.168.2.0/24"
      - name: wifi
        networks: "10.0.0.0/24"

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `isc_dhcpd` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m isc_dhcpd
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m isc_dhcpd -j jobName
  ```

### Getting Logs

If you're encountering problems with the `isc_dhcpd` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep isc_dhcpd
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep isc_dhcpd /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep isc_dhcpd
```


