<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/rabbitmq/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/rabbitmq/metadata.yaml"
sidebar_label: "RabbitMQ"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Message Brokers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# RabbitMQ


<img src="https://netdata.cloud/img/rabbitmq.svg" width="150"/>


Plugin: go.d.plugin
Module: rabbitmq

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors RabbitMQ instances.

It collects data using an HTTP-based API provided by the [management plugin](https://www.rabbitmq.com/management.html).
The following endpoints are used:

- `/api/definitions` (one-time retrieval, used to obtain the cluster ID and name)
- `/api/overview`
- `/api/nodes`
- `/api/vhosts`
- `/api/queues` (disabled by default)




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per cluster

These metrics refer to the RabbitMQ Cluster.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_id | Unique identifier for the cluster, automatically assigned by RabbitMQ. |
| cluster_name | User-defined name of the cluster as set using `rabbitmqctl set_cluster_name`. If not set, it will be "unset". |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rabbitmq.messages_count | ready, unacknowledged | messages |
| rabbitmq.messages_rate | ack, publish, publish_in, publish_out, confirm, deliver, deliver_no_ack, get, get_empty, get_no_ack, deliver_get, redeliver, return_unroutable | messages/s |
| rabbitmq.objects_count | channels, consumers, connections, queues, exchanges | messages |
| rabbitmq.connection_churn_rate | created, closed | operations/s |
| rabbitmq.channel_churn_rate | created, closed | operations/s |
| rabbitmq.queue_churn_rate | created, deleted, declared | operations/s |

### Per node

These metrics refer to the RabbitMQ node.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_id | Unique identifier for the cluster, automatically assigned by RabbitMQ. |
| cluster_name | User-defined name of the cluster as set using `rabbitmqctl set_cluster_name <NAME>`. If not set, it will be "unset". |
| node | Name of the node. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rabbitmq.node_avail_status | running, down | status |
| rabbitmq.node_network_partition_status | clear, detected | status |
| rabbitmq.node_mem_alarm_status | clear, triggered | status |
| rabbitmq.node_disk_free_alarm_status | clear, triggered | status |
| rabbitmq.node_file_descriptors_usage | used | fd |
| rabbitmq.node_sockets_usage | used | sockets |
| rabbitmq.node_erlang_processes_usage | used | processes |
| rabbitmq.node_erlang_run_queue_processes_count | length | processes |
| rabbitmq.node_memory_usage | used | bytes |
| rabbitmq.node_disk_space_free_size | free | bytes |
| rabbitmq.node_uptime | uptime | seconds |

### Per cluster peer

These metrics refer to the RabbiMQ cluster peer.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_id | Unique identifier for the cluster, automatically assigned by RabbitMQ. |
| cluster_name | User-defined name of the cluster as set using `rabbitmqctl set_cluster_name <NAME>`. If not set, it will be "unset". |
| node | Name of the node. |
| peer | Name of the remote node in the cluster. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rabbitmq.node_peer_cluster_link_traffic | received, sent | bytes/s |

### Per vhost

These metrics refer to the virtual host.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_id | Unique identifier for the cluster, automatically assigned by RabbitMQ. |
| cluster_name | User-defined name of the cluster as set using `rabbitmqctl set_cluster_name <NAME>`. If not set, it will be "unset". |
| vhost | Name of the virtual host. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rabbitmq.vhost_status | running, stopped, partial | status |
| rabbitmq.vhost_messages_count | ready, unacknowledged | messages |
| rabbitmq.vhost_messages_rate | ack, publish, publish_in, publish_out, confirm, deliver, deliver_no_ack, get, get_no_ack, deliver_get, redeliver, return_unroutable | messages/s |

### Per queue

These metrics refer to the virtual host queue.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_id | Unique identifier for the cluster, automatically assigned by RabbitMQ. |
| cluster_name | User-defined name of the cluster as set using `rabbitmqctl set_cluster_name <NAME>`. If not set, it will be "unset". |
| node | Name of the node. |
| vhost | Name of the virtual host. |
| queue | Name of the queue. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rabbitmq.queue_status | running, down, idle, crashed, stopped, minority, terminated | status |
| rabbitmq.queue_messages_count | ready, unacknowledged, paged_out, persistent | messages |
| rabbitmq.queue_messages_rate | ack, publish, publish_in, publish_out, confirm, deliver, deliver_no_ack, get, get_no_ack, deliver_get, redeliver, return_unroutable | messages/s |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ rabbitmq_node_avail_status_down ](https://github.com/netdata/netdata/blob/master/src/health/health.d/rabbitmq.conf) | rabbitmq.node_avail_status | RabbitMQ node is down (node ${label:node} cluster ${label:cluster_id}) |
| [ rabbitmq_node_network_partition_status ](https://github.com/netdata/netdata/blob/master/src/health/health.d/rabbitmq.conf) | rabbitmq.node_network_partition_status | RabbitMQ network partition detected (node ${label:node} cluster ${label:cluster_id}) |
| [ rabbitmq_node_mem_alarm_status_triggered ](https://github.com/netdata/netdata/blob/master/src/health/health.d/rabbitmq.conf) | rabbitmq.node_mem_alarm_status | RabbitMQ mem alarm triggered (node ${label:node} cluster ${label:cluster_id}) |
| [ rabbitmq.node_disk_free_alarm_status_triggered ](https://github.com/netdata/netdata/blob/master/src/health/health.d/rabbitmq.conf) | rabbitmq.node_disk_free_alarm_status | RabbitMQ disk free alarm triggered (node ${label:node} cluster ${label:cluster_id}) |
| [ rabbitmq_vhost_status_unhealthy ](https://github.com/netdata/netdata/blob/master/src/health/health.d/rabbitmq.conf) | rabbitmq.vhost_status | RabbitMQ vhost is not healthy (vhost ${label:vhost} cluster ${label:cluster_id}) |
| [ rabbitmq_queue_status_minority ](https://github.com/netdata/netdata/blob/master/src/health/health.d/rabbitmq.conf) | rabbitmq.queue_status | RabbitMQ queue insufficient online members (queue ${label:queue} node ${label:node} cluster ${label:cluster_id}) |
| [ rabbitmq_queue_status_unhealthy ](https://github.com/netdata/netdata/blob/master/src/health/health.d/rabbitmq.conf) | rabbitmq.queue_status | RabbitMQ queue is unhealthy (queue ${label:queue} node ${label:node} cluster ${label:cluster_id}) |


## Setup

### Prerequisites

#### Enable management plugin.

The management plugin is included in the RabbitMQ distribution, but disabled.
To enable see [Management Plugin](https://www.rabbitmq.com/management.html#getting-started) documentation.



### Configuration

#### File

The configuration file name for this integration is `go.d/rabbitmq.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/rabbitmq.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. | http://localhost:15672 | yes |
| collect_queues_metrics | Collect stats per vhost per queues. Enabling this can introduce serious overhead on both Netdata and RabbitMQ if many queues are configured and used. | no | no |
| timeout | HTTP request timeout. | 1 | no |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:15672

```
</details>

##### Basic HTTP auth

Local server with basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:15672
    username: admin
    password: password

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:15672

  - name: remote
    url: http://192.0.2.0:15672

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `rabbitmq` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m rabbitmq
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m rabbitmq -j jobName
  ```

### Getting Logs

If you're encountering problems with the `rabbitmq` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep rabbitmq
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep rabbitmq /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep rabbitmq
```


