/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

public class DefaultLifecycleMapping
implements LifecycleMapping {
    private List<Lifecycle> lifecycles;
    private Map<String, Lifecycle> lifecycleMap;
    @Deprecated
    private Map<String, LifecyclePhase> phases;

    @Deprecated
    public DefaultLifecycleMapping() {
    }

    public DefaultLifecycleMapping(List<Lifecycle> lifecycles) {
        this.lifecycleMap = Collections.unmodifiableMap(lifecycles.stream().collect(Collectors.toMap(Lifecycle::getId, Function.identity())));
    }

    private void initLifecycleMap() {
        block4: {
            if (this.lifecycleMap != null) break block4;
            this.lifecycleMap = new HashMap<String, Lifecycle>();
            if (this.lifecycles != null) {
                for (Lifecycle lifecycle : this.lifecycles) {
                    this.lifecycleMap.put(lifecycle.getId(), lifecycle);
                }
            } else {
                String[] lifecycleIds;
                for (String lifecycleId : lifecycleIds = new String[]{"default", "clean", "site"}) {
                    Map<String, LifecyclePhase> phases = this.getLifecyclePhases(lifecycleId);
                    if (phases == null) continue;
                    Lifecycle lifecycle = new Lifecycle();
                    lifecycle.setId(lifecycleId);
                    lifecycle.setLifecyclePhases(phases);
                    this.lifecycleMap.put(lifecycleId, lifecycle);
                }
            }
        }
    }

    @Override
    public Map<String, Lifecycle> getLifecycles() {
        this.initLifecycleMap();
        return this.lifecycleMap;
    }

    @Override
    @Deprecated
    public List<String> getOptionalMojos(String lifecycle) {
        return null;
    }

    private Map<String, LifecyclePhase> getLifecyclePhases(String lifecycle) {
        this.initLifecycleMap();
        Lifecycle lifecycleMapping = this.lifecycleMap.get(lifecycle);
        if (lifecycleMapping != null) {
            return lifecycleMapping.getLifecyclePhases();
        }
        if ("default".equals(lifecycle)) {
            return this.phases;
        }
        return null;
    }

    @Override
    @Deprecated
    public Map<String, String> getPhases(String lifecycle) {
        return LifecyclePhase.toLegacyMap(this.getLifecyclePhases(lifecycle));
    }
}

