# Hermetic Android NDK C++ toolchain

This directory defines a hermetic C++ toolchain suite to compile with the Android NDK.

## Motivation

Bazel has a built-in
[`android_ndk_repository`](https://bazel.build/reference/be/android#android_ndk_repository) rule,
which generates C++ toolchains based on a local NDK installation provided via the
`ANDROID_NDK_HOME` environment variable. However, this rule breaks
[hermeticity](https://bazel.build/concepts/hermeticity), and requires the user to provide an NDK
installation.

This directory provides a `download_android_ndk` repository rule, which downloads the Android NDK
under `external/ndk_linux_amd64`, and a C++ toolchain suite that targets 32- and 64-bit ARM.

## Design

The C++ toolchain suite is based on the C++ toolchain generated by the `android_ndk_repository`
rule.

Steps taken:

- Build SkCMS with the `android_ndk_repository` rule at
[this revision](https://skia.googlesource.com/skcms/+/30c8e303800c256febb03a09fdcda7f75d119b1b/WORKSPACE#22).
- Inspect the contents of `bazel-skcms/external/androidndk/BUILD.bazel` and
`bazel-skcms/external/androidndk/cc_toolchain_config.bzl`, which are generated by said rule.
- Extract the useful parts into the C++ toolchain defined in this directory.

### Trampoline scripts

The
[`cc_common.create_cc_toolchain_config_info`](https://bazel.build/rules/lib/cc_common#create_cc_toolchain_config_info)
function expects tool paths to point to files under the directory in which it is invoked. This
means we cannot directly reference tools under `external/ndk_linux_amd64`. The solution is to use
"trampoline" scripts that pass through any command-line arguments to the NDK binaries under
`external/android_sdk`.
