/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.platform;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.util.StringUtils;

public final class Platform
extends AbstractModelObject<Platform>
implements Domain {
    private static final long serialVersionUID = -5939953296773672903L;
    private final Map<String, String> replacements = new LinkedHashMap<String, String>();
    @JsonIgnore
    private final org.jreleaser.model.api.platform.Platform immutable = new org.jreleaser.model.api.platform.Platform(){
        private static final long serialVersionUID = 7959953437571066163L;

        public Map<String, String> getReplacements() {
            return Collections.unmodifiableMap(Platform.this.replacements);
        }

        public String applyReplacements(String platform) {
            return Platform.this.applyReplacements(platform);
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Platform.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.platform.Platform asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Platform source) {
        this.setReplacements(this.merge(this.replacements, source.replacements));
    }

    public boolean isSet() {
        return !this.replacements.isEmpty();
    }

    public Map<String, String> getReplacements() {
        return this.replacements;
    }

    public void setReplacements(Map<String, String> replacements) {
        this.replacements.putAll(replacements);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("replacements", this.replacements);
        return map;
    }

    public String applyReplacements(String platform) {
        if (StringUtils.isBlank((String)platform)) {
            return platform;
        }
        for (Map.Entry<String, String> e : this.replacements.entrySet()) {
            if (!e.getKey().equals(platform)) continue;
            return e.getValue();
        }
        CharSequence[] parts = platform.split("-");
        for (int i = 0; i < parts.length; ++i) {
            for (Map.Entry<String, String> e : this.replacements.entrySet()) {
                if (!e.getKey().equals(parts[i])) continue;
                parts[i] = e.getValue();
            }
        }
        return String.join((CharSequence)"-", parts);
    }

    public Platform mergeValues(Platform other) {
        Platform merged = new Platform();
        LinkedHashMap<String, String> full = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> partial = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : this.replacements.entrySet()) {
            if (e.getKey().contains("-")) {
                full.put(e.getKey(), e.getValue());
                continue;
            }
            partial.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : other.replacements.entrySet()) {
            if (e.getKey().contains("-")) {
                full.put(e.getKey(), e.getValue());
                continue;
            }
            partial.put(e.getKey(), e.getValue());
        }
        merged.replacements.putAll(full);
        merged.replacements.putAll(partial);
        return merged;
    }
}

