/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.release.Changelog;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.release.BaseReleaser;

public class ForgejoReleaser
extends BaseReleaser<org.jreleaser.model.api.release.ForgejoReleaser, ForgejoReleaser> {
    private static final long serialVersionUID = 7907765447614974335L;
    private Boolean draft;
    @JsonIgnore
    private final org.jreleaser.model.api.release.ForgejoReleaser immutable = new org.jreleaser.model.api.release.ForgejoReleaser(){
        private static final long serialVersionUID = 6619063750320880824L;

        public boolean isPrerelease() {
            return ForgejoReleaser.this.isPrerelease();
        }

        public boolean isDraft() {
            return ForgejoReleaser.this.isDraft();
        }

        public String getServiceName() {
            return ForgejoReleaser.this.getServiceName();
        }

        public boolean isReleaseSupported() {
            return ForgejoReleaser.this.isReleaseSupported();
        }

        public String getCanonicalRepoName() {
            return ForgejoReleaser.this.getCanonicalRepoName();
        }

        public String getReverseRepoHost() {
            return ForgejoReleaser.this.getReverseRepoHost();
        }

        public boolean isMatch() {
            return ForgejoReleaser.this.isMatch();
        }

        public String getHost() {
            return ForgejoReleaser.this.getHost();
        }

        public String getName() {
            return ForgejoReleaser.this.getName();
        }

        public String getRepoUrl() {
            return ForgejoReleaser.this.getRepoUrl();
        }

        public String getRepoCloneUrl() {
            return ForgejoReleaser.this.getRepoCloneUrl();
        }

        public String getCommitUrl() {
            return ForgejoReleaser.this.getCommitUrl();
        }

        public String getSrcUrl() {
            return ForgejoReleaser.this.getSrcUrl();
        }

        public String getDownloadUrl() {
            return ForgejoReleaser.this.getDownloadUrl();
        }

        public String getReleaseNotesUrl() {
            return ForgejoReleaser.this.getReleaseNotesUrl();
        }

        public String getLatestReleaseUrl() {
            return ForgejoReleaser.this.getLatestReleaseUrl();
        }

        public String getIssueTrackerUrl() {
            return ForgejoReleaser.this.getIssueTrackerUrl();
        }

        public String getUsername() {
            return ForgejoReleaser.this.getUsername();
        }

        public String getToken() {
            return ForgejoReleaser.this.getToken();
        }

        public String getTagName() {
            return ForgejoReleaser.this.getTagName();
        }

        public String getPreviousTagName() {
            return ForgejoReleaser.this.getPreviousTagName();
        }

        public String getReleaseName() {
            return ForgejoReleaser.this.getReleaseName();
        }

        public String getBranch() {
            return ForgejoReleaser.this.getBranch();
        }

        public String getBranchPush() {
            return ForgejoReleaser.this.getBranchPush();
        }

        public Releaser.Prerelease getPrerelease() {
            return ForgejoReleaser.this.getPrerelease().asImmutable();
        }

        public boolean isSign() {
            return ForgejoReleaser.this.isSign();
        }

        public Changelog getChangelog() {
            return ForgejoReleaser.this.getChangelog().asImmutable();
        }

        public Releaser.Milestone getMilestone() {
            return ForgejoReleaser.this.getMilestone().asImmutable();
        }

        public Releaser.Issues getIssues() {
            return ForgejoReleaser.this.getIssues().asImmutable();
        }

        public boolean isSkipTag() {
            return ForgejoReleaser.this.isSkipTag();
        }

        public boolean isSkipRelease() {
            return ForgejoReleaser.this.isSkipRelease();
        }

        public boolean isOverwrite() {
            return ForgejoReleaser.this.isOverwrite();
        }

        public Releaser.Update getUpdate() {
            return ForgejoReleaser.this.getUpdate().asImmutable();
        }

        public String getApiEndpoint() {
            return ForgejoReleaser.this.getApiEndpoint();
        }

        public boolean isArtifacts() {
            return ForgejoReleaser.this.isArtifacts();
        }

        public boolean isFiles() {
            return ForgejoReleaser.this.isFiles();
        }

        public boolean isChecksums() {
            return ForgejoReleaser.this.isChecksums();
        }

        public boolean isCatalogs() {
            return ForgejoReleaser.this.isCatalogs();
        }

        public boolean isSignatures() {
            return ForgejoReleaser.this.isSignatures();
        }

        public Active getUploadAssets() {
            return ForgejoReleaser.this.getUploadAssets();
        }

        public CommitAuthor getCommitAuthor() {
            return ForgejoReleaser.this.getCommitAuthor().asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ForgejoReleaser.this.asMap(full));
        }

        public boolean isEnabled() {
            return ForgejoReleaser.this.isEnabled();
        }

        public String getOwner() {
            return ForgejoReleaser.this.getOwner();
        }

        public Integer getConnectTimeout() {
            return ForgejoReleaser.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return ForgejoReleaser.this.getReadTimeout();
        }
    };

    public ForgejoReleaser() {
        this("forgejo");
    }

    ForgejoReleaser(String name) {
        super(name, true);
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/src/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/download/{{tagName}}/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/tag/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/issues");
    }

    @Override
    public org.jreleaser.model.api.release.ForgejoReleaser asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ForgejoReleaser source) {
        super.merge(source);
        this.draft = this.merge(this.draft, source.draft);
    }

    public boolean isDraft() {
        return null != this.draft && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public boolean isDraftSet() {
        return null != this.draft;
    }

    @Override
    public String getReverseRepoHost() {
        return null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("draft", this.isDraft());
        return map;
    }
}

