/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.announce.Announcer;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;

public final class WebhooksAnnouncer
extends AbstractAnnouncer<WebhooksAnnouncer, org.jreleaser.model.api.announce.WebhooksAnnouncer> {
    private static final long serialVersionUID = 6152385950214311240L;
    private final Map<String, WebhookAnnouncer> webhooks = new LinkedHashMap<String, WebhookAnnouncer>();
    @JsonIgnore
    private final org.jreleaser.model.api.announce.WebhooksAnnouncer immutable = new org.jreleaser.model.api.announce.WebhooksAnnouncer(){
        private static final long serialVersionUID = -8196857821339657945L;
        private Map<String, ? extends org.jreleaser.model.api.announce.WebhookAnnouncer> webhooks;

        public String getType() {
            return "webhooks";
        }

        public Map<String, ? extends org.jreleaser.model.api.announce.WebhookAnnouncer> getWebhooks() {
            if (null == this.webhooks) {
                this.webhooks = WebhooksAnnouncer.this.webhooks.values().stream().map(WebhookAnnouncer::asImmutable).collect(Collectors.toMap(Announcer::getName, Function.identity()));
            }
            return this.webhooks;
        }

        public String getName() {
            return WebhooksAnnouncer.this.getName();
        }

        public boolean isSnapshotSupported() {
            return WebhooksAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return WebhooksAnnouncer.this.getActive();
        }

        public boolean isEnabled() {
            return WebhooksAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(WebhooksAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return WebhooksAnnouncer.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(WebhooksAnnouncer.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return WebhooksAnnouncer.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return WebhooksAnnouncer.this.getReadTimeout();
        }
    };

    public WebhooksAnnouncer() {
        super("webhooks");
    }

    @Override
    public org.jreleaser.model.api.announce.WebhooksAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(WebhooksAnnouncer source) {
        super.merge(source);
        this.setWebhooks(this.mergeModel(this.webhooks, source.webhooks));
    }

    public Map<String, WebhookAnnouncer> getWebhooks() {
        return this.webhooks;
    }

    public void setWebhooks(Map<String, WebhookAnnouncer> webhooks) {
        this.webhooks.clear();
        this.webhooks.putAll(webhooks);
    }

    public void addWebhook(WebhookAnnouncer webhook) {
        this.webhooks.put(webhook.getName(), webhook);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        this.asMap(full, props);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        this.webhooks.values().stream().filter(w -> full || w.isEnabled()).map(d -> d.asMap(full)).forEach(props::putAll);
    }
}

