/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.StringUtils;

public class EntriesFindJarProcessor
implements JarProcessor<Set<String>> {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";
    private final JarFileResolver jarFileResolver;
    private String entryName;
    private String entryPattern;

    public EntriesFindJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public String getEntryPattern() {
        return this.entryPattern;
    }

    public void setEntryPattern(String entryPattern) {
        this.entryPattern = entryPattern;
    }

    @Override
    public Set<JarProcessor.JarFileResult<Set<String>>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<Set<String>>> set = new TreeSet<JarProcessor.JarFileResult<Set<String>>>();
        this.entryPattern = this.normalizePattern(this.entryPattern);
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            set.add(this.processJarFile(jarFile, this.entryPattern));
        }
        return set;
    }

    protected JarProcessor.JarFileResult<Set<String>> processJarFile(JarFile jarFile, String pattern) {
        JarProcessor.JarFileResult<Set<String>> jarFileResult;
        block23: {
            TreeSet<String> entries = new TreeSet<String>();
            JarFile jarFile2 = jarFile;
            try {
                block22: {
                    if (StringUtils.isNotBlank(pattern)) {
                        try (FileSystem zipfs = FileSystems.newFileSystem(Path.of(jarFile.getName(), new String[0]), this.getClass().getClassLoader());){
                            PathMatcher pathMatcher = zipfs.getPathMatcher(pattern);
                            try (Stream<Path> stream = Files.walk(zipfs.getPath("/", new String[0]), new FileVisitOption[0]);){
                                stream.filter(pathMatcher::matches).forEach(path -> this.processJarEntry(jarFile, zipfs, (Path)path, (Set<String>)entries));
                                break block22;
                            }
                        }
                    }
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry entry = jarEntries.nextElement();
                        String name = entry.getName();
                        if (!name.equals(this.entryName)) continue;
                        this.processJarEntry(jarFile, entry, entries);
                        break;
                    }
                }
                jarFileResult = JarProcessor.JarFileResult.of(jarFile, Collections.unmodifiableSet(entries));
                if (jarFile2 == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile2 != null) {
                        try {
                            jarFile2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return JarProcessor.JarFileResult.of(jarFile, Collections.unmodifiableSet(entries));
                }
            }
            jarFile2.close();
        }
        return jarFileResult;
    }

    protected void processJarEntry(JarFile jarFile, FileSystem zipfs, Path path, Set<String> entries) {
        String entryName = path.toString();
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        }
        entries.add(entryName);
    }

    protected void processJarEntry(JarFile jarFile, JarEntry entry, Set<String> entries) {
        String entryName = entry.getName();
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        }
        entries.add(entryName);
    }

    private String normalizePattern(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return pattern;
        }
        if (!((String)pattern).startsWith(GLOB_PREFIX) && !((String)pattern).startsWith(REGEX_PREFIX)) {
            pattern = GLOB_PREFIX + (String)pattern;
        }
        if (((String)pattern).startsWith(GLOB_PREFIX)) {
            String path = ((String)pattern).substring(GLOB_PREFIX.length());
            if (path.startsWith("**") || path.startsWith("/")) {
                return pattern;
            }
            return "glob:**/" + path;
        }
        return pattern;
    }
}

