subroutine uv_residual_comm(line,error)
  use gkernel_interfaces
  use clean_default
  use gbl_message
  use imager_interfaces, except_this => uv_residual_comm
  !---------------------------------------------------------------------
  ! @ private
  !*
  ! IMAGER -- Dispatch routine for command  
  !     UV_RESIDUAL [CLEAN|CCT|[Func1 ... FuncN] [/QUIET]
  !     [/WIDGET Nfunc] [/SAVE File] [/RESULT]
  !---------------------------------------------------------------------
  character(len=*), intent(inout) :: line !! Command line
  logical, intent(inout) :: error         !! Error flag
  !
  character(len=*), parameter :: comm='UV_RESIDUAL'
  character(len=12) :: key
  integer :: iarg, nk
  !
  if (last_resid.eq.' ') then
    call map_message(seve%e,comm,'No CLEAN or UV_FIT performed')
    error = .true. 
    return
  endif
  !
  key = last_resid
  call sic_ke(line,0,1,key,nk,.false.,error)
  !
  if (key.eq.'CCT'.or.key.eq.'CLEAN') then
    iarg = 2
    key = 'CCT'
  else if (key.eq.'FIT'.or.key.eq.'UV_FIT') then
    iarg = 2
    key = 'UV_FIT'
  else
    iarg = 1
    key = last_resid
  endif
  !  
  if (key.eq.'CCT') then
    call uv_residual_clean(line,comm,iarg,error)
  else
    call uvfit_residual_model(line,comm,iarg,error)
  endif
end subroutine uv_residual_comm
!
subroutine uv_residual_clean(line,task,iarg,error)
  use gkernel_interfaces
  use imager_interfaces, except_this=>uv_residual_clean
  use clean_def
  use clean_arrays
  use clean_types
  use clean_default
  use gbl_message
  !------------------------------------------------------------------------
  ! @ private
  !*
  ! IMAGER  - Support for command  
  !      UV_RESIDUAL [FIELDS List]
  !
  !   Remove all Clean Components from a UV Table
  !
  ! Input :
  !     a precessed UV table
  !     a list of Clean Components, in DCCT format
  !      i.e. (x,y,v)(iplane,icomponent)
  !     this organisation is not efficient, and one may need to switch to
  !           (x,y,v,)(icomponent,iplane)
  !     which is more easily transmitted
  ! Output :
  !     a precessed, rotated, shifted UV table, sorted in V,
  !     ordered in (U,V,W,D,T,iant,jant,nchan(real,imag,weig))
  !!
  !------------------------------------------------------------------------
  character(len=*), intent(inout) :: line !! Command line
  character(len=*), intent(in) :: task    !! Calling command
  integer, intent(in) :: iarg             !! Pointer to FIELDS argument list
  logical, intent(out) :: error           !! Error flag
  !
  ! Constants
  integer, parameter :: o_field=1
  character(len=*), parameter :: rname='UV_RESIDUAL'
  logical, parameter :: subtract = .true.
  !
  ! Local ---
  real, pointer :: duv_previous(:,:), duv_next(:,:)
  logical :: do_clean, do_resi 
  integer :: ier
  !
  ! Code ----
  error = .false.
  if (themap%nfields.ne.0) then
    call map_message(seve%w,rname,'UV data is a Mosaic - UNDER TESTS !!!')
    call uv_shift_mosaic(line,rname,error)
    if (error) return
  endif
  !
  call map_message(seve%i,rname,'Subtracting CLEAN components')
  nullify(duv_previous,duv_next)
  call sic_delvariable('UV_RESIDUAL',.false.,error)
  !
  ! Do the job. 
  uv_resid_updated = .true.
  ! do_clean = .false.  means do not re-image with Clean components added, 
  ! and thus, do not store in duv_next, but rather in DUVF 
  ! ("Fit" or "Residual" buffer)
  do_clean = .false. 
!USELESS!  if (.not.do_clean) duv_previous => duv   ! Start from current UV buffer
  do_resi = .true.
  !
  ! Allocate the UVF area
  call gdf_copy_header(huv,huvf,error)
!  huvf%gil%dim(2) = nu
!  huvf%gil%dim(2) = nv
!  huvf%gil%nvisi = nv
  allocate(duvf(huvf%gil%dim(1),huvf%gil%dim(2)),stat=ier)   !NEW!
  if (ier.ne.0) then
    call map_message(seve%e,task,'MODEL Memory allocation failure')
    error = .true.
    return
  endif
!!      duv_next => duvf
  PRINT *,'Calling SUB_UV_RESIDUAL with DUV and DUVF'
  call sub_uv_residual(task,line,iarg,duv,duvf, &
    &   do_clean,do_resi,subtract,error)
  if (error) return
  !
  call sic_mapgildas('UV_RESIDUAL',huvf,error,duvf)
  !  
end subroutine uv_residual_clean
!
subroutine uv_model_comm_bis(line,error)
  use gkernel_interfaces
  use imager_interfaces, except_this=>uv_model_comm_bis
  use clean_def
  use clean_arrays
  use clean_types
  use clean_default
  use gbl_message
  !------------------------------------------------------------------------
  ! @ private
  !*
  ! IMAGER  - Support for command  
  !      UV_MODEL [FIELDS List]
  !
  !   Make a Model UV table for Clean Components and an input UV Table
  !
  ! Input :
  !     a precessed UV table
  !     a list of Clean Components, in DCCT format
  !      i.e. (x,y,v)(iplane,icomponent)
  !     this organisation is not efficient, and one may need to switch to
  !           (x,y,v,)(icomponent,iplane)
  !     which is more easily transmitted
  ! Output :
  !     a precessed, rotated, shifted UV table, sorted in V,
  !     ordered in (U,V,W,D,T,iant,jant,nchan(real,imag,weig))
  !!
  !------------------------------------------------------------------------
  character(len=*), intent(inout) :: line !! Command line
!  character(len=*), intent(in) :: task    !! Calling command
!  integer, intent(in) :: iarg             !! Pointer to FIELDS argument list
  logical, intent(out) :: error           !! Error flag
  !
  character(len=12) :: task    !! Calling command
  integer :: iarg             !! Pointer to FIELDS argument list

  ! Constants
  integer, parameter :: o_field=1
  character(len=*), parameter :: rname='UV_MODEL'
  logical, parameter :: subtract = .false.    ! Compute Model, not residual
  !
  ! Local ---
  type(gildas) :: htmp
  real, pointer :: duv_previous(:,:), duv_next(:,:)
  logical :: do_clean, do_resi 
  integer :: ier
  !
  task  = rname
  iarg = 1
  !
  ! Code ----
  error = .false.
  if (themap%nfields.ne.0) then
    call map_message(seve%w,rname,'UV data is a Mosaic - UNDER TESTS !!!')
    call uv_shift_mosaic(line,rname,error)
    if (error) return
  endif
  !
  call map_message(seve%i,rname,'Subtracting CLEAN components')
  nullify(duv_previous,duv_next)
  call sic_delvariable('UV_MODEL',.false.,error)
  !
  ! Temporary
  call gildas_null(htmp,'UVT')
  call gdf_copy_header(huv,htmp,error)  ! Save
  call gdf_copy_header(hself,huv,error) ! Test
  !
  call gildas_null(huvm,type='UVT')
  if (allocated(duvm)) deallocate(duvm)
  call gdf_copy_header(huv,huvm,error)
  allocate (duvm(huvm%gil%dim(1),huvm%gil%dim(2)),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,rname,'UV Model allocation error')
    call gdf_copy_header(htmp,huv,error)  ! Save
    error = .true.
    return
  endif
  !
  ! Do the job. 
  uv_resid_updated = .true.
  do_clean = .false. 
  do_resi = .true.
  !
  ! Buffer choice will depend on the MODEL option
  Print *,'Calling SUB_UV_RESIDUAL with DUVSELF and DUVM'
  call sub_uv_residual(task,line,iarg,duvself,duvm, &
    &   do_clean,do_resi,subtract,error)
  if (error) then
    call gdf_copy_header(htmp,huv,error)  ! Restore
    error = .true.
    return
  endif
  call gdf_copy_header(htmp,huv,error)  ! Restore
  !
  call sic_mapgildas('UV_MODEL',huvm,error,duvm)
  !  
end subroutine uv_model_comm_bis
