/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.rendering;

import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.problems.FileLocation;
import org.gradle.api.problems.LineInFileLocation;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.problems.internal.rendering.PartialProblemWriter;
import org.gradle.problems.internal.rendering.RenderOptions;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.Nullable;

class ProblemBodyWriter
implements PartialProblemWriter {
    ProblemBodyWriter() {
    }

    @Override
    public void write(InternalProblem problem, RenderOptions options, PrintWriter output) {
        String problemSubMessage = ProblemBodyWriter.getContextualMessage(problem);
        if (problemSubMessage != null) {
            output.printf("%n", new Object[0]);
            ProblemBodyWriter.indent(output, problemSubMessage, 2);
        }
        if (problem.getDetails() != null) {
            output.printf("%n", new Object[0]);
            ProblemBodyWriter.indent(output, problem.getDetails(), problemSubMessage == null ? 2 : 4);
        }
        if (options.isRenderSolutions() && !problem.getSolutions().isEmpty()) {
            for (String solution : problem.getSolutions()) {
                output.printf("%n", new Object[0]);
                String[] lines = solution.split("\\r?\\n");
                ProblemBodyWriter.indent(output, "Solution: " + lines[0], 4);
                for (int i = 1; i < lines.length; ++i) {
                    output.printf("%n", new Object[0]);
                    ProblemBodyWriter.indent(output, lines[i], 14);
                }
            }
        }
        if (options.isRenderSolutions() && problem.getDefinition().getDocumentationLink() != null) {
            output.printf("%n", new Object[0]);
            ProblemBodyWriter.indent(output, "Documentation: " + problem.getDefinition().getDocumentationLink().getUrl(), 4);
        }
        List fileLocations = problem.getOriginLocations().stream().filter(FileLocation.class::isInstance).map(FileLocation.class::cast).collect(Collectors.toList());
        for (FileLocation location : fileLocations) {
            output.printf("%n", new Object[0]);
            ProblemBodyWriter.indent(output, "Location: " + location.getPath(), 4);
            if (!(location instanceof LineInFileLocation)) continue;
            LineInFileLocation lineLocation = (LineInFileLocation)location;
            output.printf(" line " + lineLocation.getLine(), new Object[0]);
        }
    }

    private static @Nullable String getContextualMessage(InternalProblem problem) {
        if (problem.getContextualLabel() != null) {
            return problem.getContextualLabel();
        }
        if (problem.getException() != null) {
            return problem.getException().getLocalizedMessage();
        }
        return null;
    }

    static void indent(PrintWriter output, @Nullable String message, int level) {
        if (message == null) {
            return;
        }
        String prefix = Strings.repeat((String)" ", (int)level);
        String formatted = TextUtil.indent((String)message, (String)prefix);
        output.print(formatted);
    }
}

