/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.JvmComponentDependencies;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.JvmTestSuiteTarget;
import org.gradle.api.plugins.jvm.internal.DefaultJvmTestSuiteTarget;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.testing.toolchains.internal.FrameworkCachingJvmTestToolchain;
import org.gradle.api.testing.toolchains.internal.JUnit4TestToolchain;
import org.gradle.api.testing.toolchains.internal.JUnit4ToolchainParameters;
import org.gradle.api.testing.toolchains.internal.JUnitJupiterTestToolchain;
import org.gradle.api.testing.toolchains.internal.JUnitJupiterToolchainParameters;
import org.gradle.api.testing.toolchains.internal.JvmTestToolchain;
import org.gradle.api.testing.toolchains.internal.JvmTestToolchainParameters;
import org.gradle.api.testing.toolchains.internal.KotlinTestTestToolchain;
import org.gradle.api.testing.toolchains.internal.KotlinTestToolchainParameters;
import org.gradle.api.testing.toolchains.internal.LegacyJUnit4TestToolchain;
import org.gradle.api.testing.toolchains.internal.SpockTestToolchain;
import org.gradle.api.testing.toolchains.internal.SpockToolchainParameters;
import org.gradle.api.testing.toolchains.internal.TestNGTestToolchain;
import org.gradle.api.testing.toolchains.internal.TestNGToolchainParameters;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

public abstract class DefaultJvmTestSuite
implements JvmTestSuite {
    private final SourceSet sourceSet;
    private final String name;
    private final TaskDependencyFactory taskDependencyFactory;
    private final ToolchainFactory toolchainFactory;

    @Inject
    public DefaultJvmTestSuite(String name, SourceSetContainer sourceSets, ConfigurationContainer configurations, TaskDependencyFactory taskDependencyFactory) {
        this.name = name;
        this.sourceSet = (SourceSet)sourceSets.create(this.getName());
        this.taskDependencyFactory = taskDependencyFactory;
        this.toolchainFactory = new ToolchainFactory(this.getObjectFactory(), (ServiceLookup)this.getParentServices(), this.getInstantiatorFactory());
        this.getTargets().registerBinding(JvmTestSuiteTarget.class, DefaultJvmTestSuiteTarget.class);
        if (name.equals("test")) {
            this.getTestToolchain().convention((Object)this.toolchainFactory.getOrCreate(LegacyJUnit4TestToolchain.class));
        } else {
            JUnitJupiterTestToolchain toolchain = this.toolchainFactory.getOrCreate(JUnitJupiterTestToolchain.class);
            this.getTestToolchain().convention((Object)toolchain);
            ((JUnitJupiterToolchainParameters)toolchain.getParameters()).getJupiterVersion().convention((Object)"5.12.2");
        }
        this.addTestFrameworkDependenciesToDependencies();
        configurations.named(this.sourceSet.getCompileOnlyConfigurationName(), compileOnly -> compileOnly.fromDependencyCollector(this.getDependencies().getCompileOnly()));
        configurations.named(this.sourceSet.getImplementationConfigurationName(), implementation -> implementation.fromDependencyCollector(this.getDependencies().getImplementation()));
        configurations.named(this.sourceSet.getRuntimeOnlyConfigurationName(), runtimeOnly -> runtimeOnly.fromDependencyCollector(this.getDependencies().getRuntimeOnly()));
        configurations.named(this.sourceSet.getAnnotationProcessorConfigurationName(), annotationProcessor -> annotationProcessor.fromDependencyCollector(this.getDependencies().getAnnotationProcessor()));
        this.addDefaultTestTarget();
        this.getTargets().withType(JvmTestSuiteTarget.class).configureEach(target -> target.getTestTask().configure(this::initializeTestFramework));
    }

    private void addTestFrameworkDependenciesToDependencies() {
        JvmComponentDependencies dependencies = this.getDependencies();
        dependencies.getCompileOnly().bundle(this.getTestToolchain().map(JvmTestToolchain::getCompileOnlyDependencies));
        dependencies.getImplementation().bundle(this.getTestToolchain().map(JvmTestToolchain::getImplementationDependencies));
        dependencies.getRuntimeOnly().bundle(this.getTestToolchain().map(JvmTestToolchain::getRuntimeOnlyDependencies));
    }

    private void initializeTestFramework(Test task) {
        task.getTestFrameworkProperty().convention(this.getTestToolchain().map(toolchain -> toolchain.createTestFramework(task)));
    }

    private void addDefaultTestTarget() {
        String target = this.getName().equals("test") ? "test" : this.getName();
        this.getTargets().register(target);
    }

    protected abstract Property<JvmTestToolchain<?>> getTestToolchain();

    public String getName() {
        return this.name;
    }

    @Inject
    public abstract ObjectFactory getObjectFactory();

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @Inject
    public abstract InstantiatorFactory getInstantiatorFactory();

    @Inject
    public abstract ServiceRegistry getParentServices();

    @Override
    public SourceSet getSources() {
        return this.sourceSet;
    }

    @Override
    public void sources(Action<? super SourceSet> configuration) {
        configuration.execute((Object)this.getSources());
    }

    public abstract ExtensiblePolymorphicDomainObjectContainer<JvmTestSuiteTarget> getTargets();

    @Override
    public void useJUnit() {
        this.useJUnit((Action<JUnit4ToolchainParameters>)Actions.doNothing());
    }

    @Override
    public void useJUnit(String version) {
        this.useJUnit((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useJUnit(Provider<String> version) {
        this.useJUnit((Action<JUnit4ToolchainParameters>)((Action)parameters -> parameters.getVersion().set(version)));
    }

    private void useJUnit(Action<JUnit4ToolchainParameters> action) {
        this.setToolchainAndConfigure(JUnit4TestToolchain.class, parameters -> {
            parameters.getVersion().convention((Object)"4.13.2");
            action.execute(parameters);
        });
    }

    @Override
    public void useJUnitJupiter() {
        this.useJUnitJupiter((Action<JUnitJupiterToolchainParameters>)Actions.doNothing());
    }

    @Override
    public void useJUnitJupiter(String version) {
        this.useJUnitJupiter((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useJUnitJupiter(Provider<String> version) {
        this.useJUnitJupiter((Action<JUnitJupiterToolchainParameters>)((Action)parameters -> parameters.getJupiterVersion().set(version)));
    }

    private void useJUnitJupiter(Action<JUnitJupiterToolchainParameters> action) {
        this.setToolchainAndConfigure(JUnitJupiterTestToolchain.class, parameters -> {
            parameters.getJupiterVersion().convention((Object)"5.12.2");
            action.execute(parameters);
        });
    }

    @Override
    public void useSpock() {
        this.useSpock((Action<SpockToolchainParameters>)Actions.doNothing());
    }

    @Override
    public void useSpock(String version) {
        this.useSpock((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useSpock(Provider<String> version) {
        this.useSpock((Action<SpockToolchainParameters>)((Action)parameters -> parameters.getSpockVersion().set(version)));
    }

    private void useSpock(Action<SpockToolchainParameters> action) {
        this.setToolchainAndConfigure(SpockTestToolchain.class, parameters -> {
            parameters.getSpockVersion().convention((Object)"2.3-groovy-4.0");
            action.execute(parameters);
        });
    }

    @Override
    public void useKotlinTest() {
        this.useKotlinTest((Action<KotlinTestToolchainParameters>)Actions.doNothing());
    }

    @Override
    public void useKotlinTest(String version) {
        this.useKotlinTest((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useKotlinTest(Provider<String> version) {
        this.useKotlinTest((Action<KotlinTestToolchainParameters>)((Action)parameters -> parameters.getKotlinTestVersion().set(version)));
    }

    private void useKotlinTest(Action<KotlinTestToolchainParameters> action) {
        this.setToolchainAndConfigure(KotlinTestTestToolchain.class, parameters -> {
            parameters.getKotlinTestVersion().convention((Object)"2.2.21");
            action.execute(parameters);
        });
    }

    @Override
    public void useTestNG() {
        this.useTestNG((Action<TestNGToolchainParameters>)Actions.doNothing());
    }

    @Override
    public void useTestNG(String version) {
        this.useTestNG((Provider<String>)this.getProviderFactory().provider(() -> version));
    }

    @Override
    public void useTestNG(Provider<String> version) {
        this.useTestNG((Action<TestNGToolchainParameters>)((Action)parameters -> parameters.getVersion().set(version)));
    }

    private void useTestNG(Action<TestNGToolchainParameters> action) {
        this.setToolchainAndConfigure(TestNGTestToolchain.class, parameters -> {
            parameters.getVersion().convention((Object)"7.11.0");
            action.execute(parameters);
        });
    }

    private <T extends JvmTestToolchainParameters> void setToolchainAndConfigure(Class<? extends JvmTestToolchain<T>> toolchainType, Action<T> action) {
        JvmTestToolchain<T> toolchain = this.toolchainFactory.getOrCreate(toolchainType);
        this.getTestToolchain().set(toolchain);
        action.execute(toolchain.getParameters());
    }

    @Override
    public void dependencies(Action<? super JvmComponentDependencies> action) {
        action.execute((Object)this.getDependencies());
    }

    public TaskDependency getBuildDependencies() {
        return this.taskDependencyFactory.visitingDependencies(context -> this.getTargets().forEach(arg_0 -> ((TaskDependencyResolveContext)context).add(arg_0)));
    }

    private static class ToolchainFactory {
        private final ObjectFactory objectFactory;
        private final ServiceLookup parentServices;
        private final InstantiatorFactory instantiatorFactory;
        private final Map<Class<? extends JvmTestToolchain<?>>, JvmTestToolchain<?>> cache = new HashMap();

        public ToolchainFactory(ObjectFactory objectFactory, ServiceLookup parentServices, InstantiatorFactory instantiatorFactory) {
            this.objectFactory = objectFactory;
            this.parentServices = parentServices;
            this.instantiatorFactory = instantiatorFactory;
        }

        public <T extends JvmTestToolchain<?>> T getOrCreate(Class<T> type) {
            return (T)((JvmTestToolchain)Cast.uncheckedCast((Object)this.cache.computeIfAbsent(type, t -> this.create((Class)Cast.uncheckedCast((Object)type)))));
        }

        private <T extends JvmTestToolchainParameters> JvmTestToolchain<T> create(Class<? extends JvmTestToolchain<T>> type) {
            IsolationScheme isolationScheme = new IsolationScheme((Class)Cast.uncheckedCast(JvmTestToolchain.class), JvmTestToolchainParameters.class, JvmTestToolchainParameters.None.class);
            Class parametersType = isolationScheme.parameterTypeFor(type);
            JvmTestToolchainParameters parameters = parametersType == null ? null : (JvmTestToolchainParameters)this.objectFactory.newInstance(parametersType, new Object[0]);
            ServiceLookup lookup = isolationScheme.servicesForImplementation((Object)parameters, this.parentServices, Collections.singleton(DependencyFactory.class));
            return new FrameworkCachingJvmTestToolchain((JvmTestToolchain)this.instantiatorFactory.decorate(lookup).newInstance(type, new Object[0]));
        }
    }
}

