"""Generated client library for bigquerymigration version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.bigquerymigration.v2 import bigquerymigration_v2_messages as messages


class BigquerymigrationV2(base_api.BaseApiClient):
  """Generated client library for service bigquerymigration version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://bigquerymigration.googleapis.com/'
  MTLS_BASE_URL = 'https://bigquerymigration.mtls.googleapis.com/'

  _PACKAGE = 'bigquerymigration'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v2'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'BigquerymigrationV2'
  _URL_VERSION = 'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new bigquerymigration handle."""
    url = url or self.BASE_URL
    super(BigquerymigrationV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_subtaskTypes = self.ProjectsLocationsSubtaskTypesService(self)
    self.projects_locations_taskTypes = self.ProjectsLocationsTaskTypesService(self)
    self.projects_locations_workflows_subtasks = self.ProjectsLocationsWorkflowsSubtasksService(self)
    self.projects_locations_workflows = self.ProjectsLocationsWorkflowsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsSubtaskTypesService(base_api.BaseApiService):
    """Service class for the projects_locations_subtaskTypes resource."""

    _NAME = 'projects_locations_subtaskTypes'

    def __init__(self, client):
      super(BigquerymigrationV2.ProjectsLocationsSubtaskTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def FinishSubtask(self, request, global_params=None):
      r"""Finishes a migration subtask via the subtask type.

      Args:
        request: (BigquerymigrationProjectsLocationsSubtaskTypesFinishSubtaskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('FinishSubtask')
      return self._RunMethod(
          config, request, global_params=global_params)

    FinishSubtask.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/subtaskTypes/{subtaskTypesId}:finishSubtask',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.subtaskTypes.finishSubtask',
        ordered_params=['subtaskType'],
        path_params=['subtaskType'],
        query_params=[],
        relative_path='v2/{+subtaskType}:finishSubtask',
        request_field='googleCloudBigqueryMigrationV2FinishSubtaskRequest',
        request_type_name='BigquerymigrationProjectsLocationsSubtaskTypesFinishSubtaskRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def ReceiveMigrationSubtask(self, request, global_params=None):
      r"""Assigns a migration subtask to the caller, if available. Example: `/v2/projects/123/locations/us/subtaskTypes:receiveMigrationSubtask`.

      Args:
        request: (BigquerymigrationProjectsLocationsSubtaskTypesReceiveMigrationSubtaskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2ReceiveMigrationSubtaskResponse) The response message.
      """
      config = self.GetMethodConfig('ReceiveMigrationSubtask')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReceiveMigrationSubtask.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/subtaskTypes:receiveMigrationSubtask',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.subtaskTypes.receiveMigrationSubtask',
        ordered_params=['projectLocation'],
        path_params=['projectLocation'],
        query_params=[],
        relative_path='v2/{+projectLocation}:receiveMigrationSubtask',
        request_field='googleCloudBigqueryMigrationV2ReceiveMigrationSubtaskRequest',
        request_type_name='BigquerymigrationProjectsLocationsSubtaskTypesReceiveMigrationSubtaskRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2ReceiveMigrationSubtaskResponse',
        supports_download=False,
    )

    def RenewSubtaskLease(self, request, global_params=None):
      r"""Renew a lease for a migration subtask by subtask type.

      Args:
        request: (BigquerymigrationProjectsLocationsSubtaskTypesRenewSubtaskLeaseRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2RenewSubtaskLeaseResponse) The response message.
      """
      config = self.GetMethodConfig('RenewSubtaskLease')
      return self._RunMethod(
          config, request, global_params=global_params)

    RenewSubtaskLease.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/subtaskTypes/{subtaskTypesId}:renewSubtaskLease',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.subtaskTypes.renewSubtaskLease',
        ordered_params=['subtaskType'],
        path_params=['subtaskType'],
        query_params=[],
        relative_path='v2/{+subtaskType}:renewSubtaskLease',
        request_field='googleCloudBigqueryMigrationV2RenewSubtaskLeaseRequest',
        request_type_name='BigquerymigrationProjectsLocationsSubtaskTypesRenewSubtaskLeaseRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2RenewSubtaskLeaseResponse',
        supports_download=False,
    )

  class ProjectsLocationsTaskTypesService(base_api.BaseApiService):
    """Service class for the projects_locations_taskTypes resource."""

    _NAME = 'projects_locations_taskTypes'

    def __init__(self, client):
      super(BigquerymigrationV2.ProjectsLocationsTaskTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def FinishMigrationTaskOrchestration(self, request, global_params=None):
      r"""Updates a migration task's state via the task type. Transition from ORCHESTRATING to either RUNNING or FAILED, depending on the provided state, i.e. whether orchrestration was successful or not.

      Args:
        request: (BigquerymigrationProjectsLocationsTaskTypesFinishMigrationTaskOrchestrationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('FinishMigrationTaskOrchestration')
      return self._RunMethod(
          config, request, global_params=global_params)

    FinishMigrationTaskOrchestration.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/taskTypes/{taskTypesId}:finishMigrationTaskOrchestration',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.taskTypes.finishMigrationTaskOrchestration',
        ordered_params=['taskType'],
        path_params=['taskType'],
        query_params=[],
        relative_path='v2/{+taskType}:finishMigrationTaskOrchestration',
        request_field='googleCloudBigqueryMigrationV2FinishMigrationTaskOrchestrationRequest',
        request_type_name='BigquerymigrationProjectsLocationsTaskTypesFinishMigrationTaskOrchestrationRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def ReceiveMigrationTask(self, request, global_params=None):
      r"""Assigns a migration task to the caller (usually an Orchestrator), if available. Example: `/v2/projects/123/locations/us/taskTypes:receiveMigrationTask`. The caller must define at least one type in the request parameters. The service creates a lease and marks the newly assigned task as ORCHESTRATING.

      Args:
        request: (BigquerymigrationProjectsLocationsTaskTypesReceiveMigrationTaskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2ReceiveMigrationTaskResponse) The response message.
      """
      config = self.GetMethodConfig('ReceiveMigrationTask')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReceiveMigrationTask.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/taskTypes:receiveMigrationTask',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.taskTypes.receiveMigrationTask',
        ordered_params=['projectLocation'],
        path_params=['projectLocation'],
        query_params=[],
        relative_path='v2/{+projectLocation}/taskTypes:receiveMigrationTask',
        request_field='googleCloudBigqueryMigrationV2ReceiveMigrationTaskRequest',
        request_type_name='BigquerymigrationProjectsLocationsTaskTypesReceiveMigrationTaskRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2ReceiveMigrationTaskResponse',
        supports_download=False,
    )

    def RenewTaskLease(self, request, global_params=None):
      r"""Renew a lease for a migration task by task type.

      Args:
        request: (BigquerymigrationProjectsLocationsTaskTypesRenewTaskLeaseRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2RenewTaskLeaseResponse) The response message.
      """
      config = self.GetMethodConfig('RenewTaskLease')
      return self._RunMethod(
          config, request, global_params=global_params)

    RenewTaskLease.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/taskTypes/{taskTypesId}:renewTaskLease',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.taskTypes.renewTaskLease',
        ordered_params=['taskType'],
        path_params=['taskType'],
        query_params=[],
        relative_path='v2/{+taskType}:renewTaskLease',
        request_field='googleCloudBigqueryMigrationV2RenewTaskLeaseRequest',
        request_type_name='BigquerymigrationProjectsLocationsTaskTypesRenewTaskLeaseRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2RenewTaskLeaseResponse',
        supports_download=False,
    )

  class ProjectsLocationsWorkflowsSubtasksService(base_api.BaseApiService):
    """Service class for the projects_locations_workflows_subtasks resource."""

    _NAME = 'projects_locations_workflows_subtasks'

    def __init__(self, client):
      super(BigquerymigrationV2.ProjectsLocationsWorkflowsSubtasksService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a previously created migration subtask.

      Args:
        request: (BigquerymigrationProjectsLocationsWorkflowsSubtasksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2MigrationSubtask) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/subtasks/{subtasksId}',
        http_method='GET',
        method_id='bigquerymigration.projects.locations.workflows.subtasks.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['readMask'],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BigquerymigrationProjectsLocationsWorkflowsSubtasksGetRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2MigrationSubtask',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists previously created migration subtasks.

      Args:
        request: (BigquerymigrationProjectsLocationsWorkflowsSubtasksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2ListMigrationSubtasksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}/subtasks',
        http_method='GET',
        method_id='bigquerymigration.projects.locations.workflows.subtasks.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken', 'readMask'],
        relative_path='v2/{+parent}/subtasks',
        request_field='',
        request_type_name='BigquerymigrationProjectsLocationsWorkflowsSubtasksListRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2ListMigrationSubtasksResponse',
        supports_download=False,
    )

  class ProjectsLocationsWorkflowsService(base_api.BaseApiService):
    """Service class for the projects_locations_workflows resource."""

    _NAME = 'projects_locations_workflows'

    def __init__(self, client):
      super(BigquerymigrationV2.ProjectsLocationsWorkflowsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a migration workflow.

      Args:
        request: (BigquerymigrationProjectsLocationsWorkflowsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2MigrationWorkflow) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/workflows',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.workflows.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/workflows',
        request_field='googleCloudBigqueryMigrationV2MigrationWorkflow',
        request_type_name='BigquerymigrationProjectsLocationsWorkflowsCreateRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2MigrationWorkflow',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a migration workflow by name.

      Args:
        request: (BigquerymigrationProjectsLocationsWorkflowsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}',
        http_method='DELETE',
        method_id='bigquerymigration.projects.locations.workflows.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BigquerymigrationProjectsLocationsWorkflowsDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a previously created migration workflow.

      Args:
        request: (BigquerymigrationProjectsLocationsWorkflowsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2MigrationWorkflow) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}',
        http_method='GET',
        method_id='bigquerymigration.projects.locations.workflows.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['readMask'],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BigquerymigrationProjectsLocationsWorkflowsGetRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2MigrationWorkflow',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists previously created migration workflow.

      Args:
        request: (BigquerymigrationProjectsLocationsWorkflowsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2ListMigrationWorkflowsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/workflows',
        http_method='GET',
        method_id='bigquerymigration.projects.locations.workflows.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'readMask'],
        relative_path='v2/{+parent}/workflows',
        request_field='',
        request_type_name='BigquerymigrationProjectsLocationsWorkflowsListRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2ListMigrationWorkflowsResponse',
        supports_download=False,
    )

    def Start(self, request, global_params=None):
      r"""Starts a previously created migration workflow. I.e., the state transitions from DRAFT to RUNNING. This is a no-op if the state is already RUNNING. An error will be signaled if the state is anything other than DRAFT or RUNNING.

      Args:
        request: (BigquerymigrationProjectsLocationsWorkflowsStartRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Start')
      return self._RunMethod(
          config, request, global_params=global_params)

    Start.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/workflows/{workflowsId}:start',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.workflows.start',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:start',
        request_field='googleCloudBigqueryMigrationV2StartMigrationWorkflowRequest',
        request_type_name='BigquerymigrationProjectsLocationsWorkflowsStartRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(BigquerymigrationV2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def TranslateQuery(self, request, global_params=None):
      r"""Translates input queries from source dialects to GoogleSQL.

      Args:
        request: (BigquerymigrationProjectsLocationsTranslateQueryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudBigqueryMigrationV2TranslateQueryResponse) The response message.
      """
      config = self.GetMethodConfig('TranslateQuery')
      return self._RunMethod(
          config, request, global_params=global_params)

    TranslateQuery.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}:translateQuery',
        http_method='POST',
        method_id='bigquerymigration.projects.locations.translateQuery',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}:translateQuery',
        request_field='googleCloudBigqueryMigrationV2TranslateQueryRequest',
        request_type_name='BigquerymigrationProjectsLocationsTranslateQueryRequest',
        response_type_name='GoogleCloudBigqueryMigrationV2TranslateQueryResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(BigquerymigrationV2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
