<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw webhosting`
This API allows you to list and restore backups for your cPanel and WordPress Web Hosting service.
  
- [Backups](#backups)
  - [Get info about a backup specified by the backup ID.](#get-info-about-a-backup-specified-by-the-backup-id.)
  - [List all available backups for a hosting account.](#list-all-available-backups-for-a-hosting-account.)
  - [Restore an entire backup to your hosting environment.](#restore-an-entire-backup-to-your-hosting-environment.)
- [Backups items](#backups-items)
  - [List items within a specific backup, grouped by type.](#list-items-within-a-specific-backup,-grouped-by-type.)
  - [Restore specific items from a backup (e.g., a database or mailbox).](#restore-specific-items-from-a-backup-(e.g.,-a-database-or-mailbox).)
- [Control Panels](#control-panels)
  - ["List the control panels type: cpanel or plesk."](#"list-the-control-panels-type:-cpanel-or-plesk.")
- [Database](#database)
  - ["Create a new database within your hosting plan"](#"create-a-new-database-within-your-hosting-plan")
  - ["Delete a database within your hosting plan"](#"delete-a-database-within-your-hosting-plan")
  - ["Get details of a database within your hosting plan"](#"get-details-of-a-database-within-your-hosting-plan")
  - ["List all databases within your hosting plan"](#"list-all-databases-within-your-hosting-plan")
- [Database User](#database-user)
  - ["Assign a database user to a database"](#"assign-a-database-user-to-a-database")
  - ["Change the password of a database user"](#"change-the-password-of-a-database-user")
  - ["Create a new database user"](#"create-a-new-database-user")
  - ["Delete a database user"](#"delete-a-database-user")
  - ["Get details of a database user"](#"get-details-of-a-database-user")
  - ["List all database users"](#"list-all-database-users")
  - ["Unassign a database user from a database"](#"unassign-a-database-user-from-a-database")
- [Domain information commands](#domain-information-commands)
  - [Get DNS records](#get-dns-records)
- [Domain information commands](#domain-information-commands)
  - [Check whether you own this domain or not.](#check-whether-you-own-this-domain-or-not.)
  - [Retrieve detailed information about a specific domain, including its status, DNS configuration, and ownership.](#retrieve-detailed-information-about-a-specific-domain,-including-its-status,-dns-configuration,-and-ownership.)
  - [Synchronize your DNS records on the Elements Console and on cPanel.](#synchronize-your-dns-records-on-the-elements-console-and-on-cpanel.)
- [Domain information commands](#domain-information-commands)
  - [Search for available domains based on domain name.](#search-for-available-domains-based-on-domain-name.)
- [Free domains](#free-domains)
  - [Check whether a given slug and free domain combination is available.](#check-whether-a-given-slug-and-free-domain-combination-is-available.)
  - [Retrieve the list of free root domains available for a Web Hosting.](#retrieve-the-list-of-free-root-domains-available-for-a-web-hosting.)
- [FTP Account](#ftp-account)
  - [Create a new FTP account within your hosting plan.](#create-a-new-ftp-account-within-your-hosting-plan.)
  - [Delete a specific FTP account within your hosting plan.](#delete-a-specific-ftp-account-within-your-hosting-plan.)
  - [List all FTP accounts within your hosting plan.](#list-all-ftp-accounts-within-your-hosting-plan.)
- [Hosting management commands](#hosting-management-commands)
  - [Order a Web Hosting plan](#order-a-web-hosting-plan)
  - [Create a user session](#create-a-user-session)
  - [Delete a Web Hosting plan](#delete-a-web-hosting-plan)
  - [Get a Web Hosting plan](#get-a-web-hosting-plan)
  - [List all Web Hosting plans](#list-all-web-hosting-plans)
  - [Update a Web Hosting plan](#update-a-web-hosting-plan)
- [Mail Account](#mail-account)
  - [Update the password of a mail account within your hosting plan.](#update-the-password-of-a-mail-account-within-your-hosting-plan.)
  - [Create a new mail account within your hosting plan.](#create-a-new-mail-account-within-your-hosting-plan.)
  - [Delete a mail account within your hosting plan.](#delete-a-mail-account-within-your-hosting-plan.)
  - [List all mail accounts within your hosting plan.](#list-all-mail-accounts-within-your-hosting-plan.)
- [Offer](#offer)
  - [List all available hosting offers along with their specific options.](#list-all-available-hosting-offers-along-with-their-specific-options.)
- [Progresses](#progresses)
  - [Retrieve detailed information about a specific progress by its ID.](#retrieve-detailed-information-about-a-specific-progress-by-its-id.)
  - [List recent progresses associated with a specific backup, grouped by type.](#list-recent-progresses-associated-with-a-specific-backup,-grouped-by-type.)
- [Website](#website)
  - [List all websites for a specific hosting.](#list-all-websites-for-a-specific-hosting.)

  
## Backups

Backups represent snapshots of your hosting environment.
You can list and restore individual items such as files, databases,
or mailboxes.


### Get info about a backup specified by the backup ID.

Get info about a backup specified by the backup ID.

**Usage:**

```
scw webhosting backup get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting account |
| backup-id | Required | ID of the backup to retrieve |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all available backups for a hosting account.

List all available backups for a hosting account.

**Usage:**

```
scw webhosting backup list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting account |
| order-by | One of: `created_at_desc`, `created_at_asc` | Order in which to return the list of backups |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Restore an entire backup to your hosting environment.

Restore an entire backup to your hosting environment.

**Usage:**

```
scw webhosting backup restore [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting account |
| backup-id | Required | ID of the backup to fully restore |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Backups items

Backups represent dedicated snapshots of services of your hosting.
You can list and restore individual items such as files, databases,
or mailboxes.


### List items within a specific backup, grouped by type.

List items within a specific backup, grouped by type.

**Usage:**

```
scw webhosting backup-item list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting account |
| backup-id |  | ID of the backup to list items from |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Restore specific items from a backup (e.g., a database or mailbox).

Restore specific items from a backup (e.g., a database or mailbox).

**Usage:**

```
scw webhosting backup-item restore [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting account |
| item-ids.{index} |  | List of backup item IDs to restore individually |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Control Panels

Control panels represent the kind of administration panel to manage your Web Hosting plan, cPanel or plesk.


### "List the control panels type: cpanel or plesk."

"List the control panels type: cpanel or plesk.".

**Usage:**

```
scw webhosting control-panel list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Database

Databases represent the databases you can create and manage within your Web Hosting plan. Supported types are MySQL and PostgreSQL.


### "Create a new database within your hosting plan"

"Create a new database within your hosting plan".

**Usage:**

```
scw webhosting database create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan where the database will be created |
| database-name |  | Name of the database to be created |
| new-user.username |  |  |
| new-user.password |  |  |
| existing-username |  | (Optional) Username to link an existing user to the database |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### "Delete a database within your hosting plan"

"Delete a database within your hosting plan".

**Usage:**

```
scw webhosting database delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| database-name | Required | Name of the database to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### "Get details of a database within your hosting plan"

"Get details of a database within your hosting plan".

**Usage:**

```
scw webhosting database get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| database-name | Required | Name of the database |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### "List all databases within your hosting plan"

"List all databases within your hosting plan".

**Usage:**

```
scw webhosting database list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| order-by | One of: `database_name_asc`, `database_name_desc` | Sort order of databases in the response |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Database User

Database users represent the users that can access and manage the databases in your Web Hosting plan.


### "Assign a database user to a database"

"Assign a database user to a database".

**Usage:**

```
scw webhosting database-user assign [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| username |  | Name of the user to assign |
| database-name | Required | Name of the database to be assigned |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### "Change the password of a database user"

"Change the password of a database user".

**Usage:**

```
scw webhosting database-user change-password [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| username | Required | Name of the user to update |
| password |  | New password |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### "Create a new database user"

"Create a new database user".

**Usage:**

```
scw webhosting database-user create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| username |  | Name of the user to create |
| password |  | Password of the user to create |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### "Delete a database user"

"Delete a database user".

**Usage:**

```
scw webhosting database-user delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| username | Required | Name of the database user to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### "Get details of a database user"

"Get details of a database user".

**Usage:**

```
scw webhosting database-user get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| username | Required | Name of the database user to retrieve details |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### "List all database users"

"List all database users".

**Usage:**

```
scw webhosting database-user list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| order-by | One of: `username_asc`, `username_desc` | Sort order of database users in the response |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### "Unassign a database user from a database"

"Unassign a database user from a database".

**Usage:**

```
scw webhosting database-user unassign [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| username |  | Name of the user to unassign |
| database-name | Required | Name of the database to be unassigned |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Domain information commands

With a Scaleway Web Hosting plan, you can manage your domain, configure your web hosting services, manage your emails and more. Get dns records status and check if you own the domain with these calls.


### Get DNS records

Get the set of DNS records of a specified domain associated with a Web Hosting plan's domain.

**Usage:**

```
scw webhosting dns-records get-dns-records [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain | Required | Domain associated with the DNS records |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Get DNS records associated to the given domain
```
scw webhosting dns-records get-dns-records domain=foo.com
```




## Domain information commands

With a Scaleway Web Hosting plan, you can manage your domain, configure your web hosting services, manage your emails and more. Get dns records status and check if you own the domain with these calls.


### Check whether you own this domain or not.

Check whether you own this domain or not.

**Usage:**

```
scw webhosting domain check-ownership [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| domain | Required | Domain for which ownership is to be verified. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Retrieve detailed information about a specific domain, including its status, DNS configuration, and ownership.

Retrieve detailed information about a specific domain, including its status, DNS configuration, and ownership.

**Usage:**

```
scw webhosting domain get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-name | Required | Domain name to get. |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Synchronize your DNS records on the Elements Console and on cPanel.

Synchronize your DNS records on the Elements Console and on cPanel.

**Usage:**

```
scw webhosting domain sync-dns-records [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain | Required | Domain for which the DNS records will be synchronized. |
| ~~update-web-records~~ | Deprecated | Whether or not to synchronize the web records (deprecated, use auto_config_domain_dns). |
| ~~update-mail-records~~ | Deprecated | Whether or not to synchronize the mail records (deprecated, use auto_config_domain_dns). |
| ~~update-all-records~~ | Deprecated | Whether or not to synchronize all types of records. This one has priority (deprecated, use auto_config_domain_dns). |
| ~~update-nameservers~~ | Deprecated | Whether or not to synchronize domain nameservers (deprecated, use auto_config_domain_dns). |
| custom-records.{index}.name |  |  |
| custom-records.{index}.type | One of: `unknown_type`, `a`, `cname`, `mx`, `txt`, `ns`, `aaaa` |  |
| auto-config-domain-dns.nameservers |  | Whether or not to synchronize domain nameservers. |
| auto-config-domain-dns.web-records |  | Whether or not to synchronize web records. |
| auto-config-domain-dns.mail-records |  | Whether or not to synchronize mail records. |
| auto-config-domain-dns.all-records |  | Whether or not to synchronize all types of records. Takes priority over the other fields. |
| auto-config-domain-dns.none |  | No automatic domain configuration. Users must configure their domain for the Web Hosting to work. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Domain information commands

With a Scaleway Web Hosting plan, you can manage your domain, configure your web hosting services, manage your emails and more. Get dns records status and check if you own the domain with these calls.


### Search for available domains based on domain name.

Search for available domains based on domain name.

**Usage:**

```
scw webhosting domain-availability search [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-name |  | Domain name to search. |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Free domains

A free subdomain provided by Scaleway for your hosting.


### Check whether a given slug and free domain combination is available.

Check whether a given slug and free domain combination is available.

**Usage:**

```
scw webhosting freedomain check-availability [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| slug |  | Custom prefix used for the free domain. |
| root-domain |  | Free root domain provided by Web Hosting, selected from the list returned by `ListFreeRootDomains`. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Retrieve the list of free root domains available for a Web Hosting.

Retrieve the list of free root domains available for a Web Hosting.

**Usage:**

```
scw webhosting freedomain list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## FTP Account

FTP accounts represent the access credentials for FTP (File Transfer Protocol) used to manage files on your web hosting plan.


### Create a new FTP account within your hosting plan.

Create a new FTP account within your hosting plan.

**Usage:**

```
scw webhosting ftp-account create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| username |  | Username for the new FTP account |
| path |  | Path for the new FTP account |
| password |  | Password for the new FTP account |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a specific FTP account within your hosting plan.

Delete a specific FTP account within your hosting plan.

**Usage:**

```
scw webhosting ftp-account delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| username | Required | Username of the FTP account to be deleted |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all FTP accounts within your hosting plan.

List all FTP accounts within your hosting plan.

**Usage:**

```
scw webhosting ftp-account list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `username_asc`, `username_desc` | Sort order of FTP accounts in the response |
| hosting-id | Required | UUID of the hosting plan |
| domain |  | Domain to filter the FTP accounts |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Hosting management commands

With a Scaleway Web Hosting plan, you can manage your domain, configure your web hosting services, manage your emails and more. Create, list, update and delete your Web Hosting plans with these calls.


### Order a Web Hosting plan

Order a Web Hosting plan, specifying the offer type required via the `offer_id` parameter.

**Usage:**

```
scw webhosting hosting create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id |  | ID of the selected offer for the Web Hosting plan |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| email |  | Contact email for the Web Hosting client |
| tags.{index} |  | List of tags for the Web Hosting plan |
| domain |  | Domain name to link to the Web Hosting plan. You must already own this domain name, and have completed the DNS validation process beforehand |
| subdomain |  | The name prefix to use as a free subdomain (for example, `mysite`) assigned to the Web Hosting plan. The full domain will be automatically created by adding it to the fixed base domain (e.g. `mysite.scw.site`). You do not need to include the base domain yourself. |
| offer-options.{index}.id |  | Offer option ID |
| offer-options.{index}.quantity |  | The option requested quantity to set for the Web Hosting plan |
| language | One of: `unknown_language_code`, `en_US`, `fr_FR`, `de_DE` | Default language for the control panel interface |
| domain-configuration.update-nameservers |  |  |
| domain-configuration.update-web-record |  |  |
| domain-configuration.update-mail-record |  |  |
| domain-configuration.update-all-records |  |  |
| skip-welcome-email |  | Indicates whether to skip a welcome email to the contact email containing hosting info. |
| auto-config-domain-dns.nameservers |  | Whether or not to synchronize domain nameservers. |
| auto-config-domain-dns.web-records |  | Whether or not to synchronize web records. |
| auto-config-domain-dns.mail-records |  | Whether or not to synchronize mail records. |
| auto-config-domain-dns.all-records |  | Whether or not to synchronize all types of records. Takes priority over the other fields. |
| auto-config-domain-dns.none |  | No automatic domain configuration. Users must configure their domain for the Web Hosting to work. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create a user session

Create a user session.

**Usage:**

```
scw webhosting hosting create-session [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | Hosting ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a Web Hosting plan

Delete a Web Hosting plan, specified by its `hosting_id`. Note that deletion is not immediate: it will take place at the end of the calendar month, after which time your Web Hosting plan and all its data (files and emails) will be irreversibly lost.

**Usage:**

```
scw webhosting hosting delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | Hosting ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Delete a Hosting with the given ID
```
scw webhosting hosting delete hosting-id=a3244331-5d32-4e36-9bf9-b60233e201c7
```




### Get a Web Hosting plan

Get the details of one of your existing Web Hosting plans, specified by its `hosting_id`.

**Usage:**

```
scw webhosting hosting get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | Hosting ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Get a Hosting with the given ID
```
scw webhosting hosting get hosting-id=a3244331-5d32-4e36-9bf9-b60233e201c7
```




### List all Web Hosting plans

List all of your existing Web Hosting plans. Various filters are available to limit the results, including filtering by domain, status, tag and Project ID.

**Usage:**

```
scw webhosting hosting list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order for Web Hosting plans in the response |
| tags.{index} |  | Tags to filter for, only Web Hosting plans with matching tags will be returned |
| statuses.{index} | One of: `unknown_status`, `delivering`, `ready`, `deleting`, `error`, `locked`, `migrating`, `updating` | Statuses to filter for, only Web Hosting plans with matching statuses will be returned |
| domain |  | Domain to filter for, only Web Hosting plans associated with this domain will be returned |
| project-id |  | Project ID to filter for, only Web Hosting plans from this Project will be returned |
| control-panels.{index} |  | Name of the control panel to filter for, only Web Hosting plans from this control panel will be returned |
| subdomain |  | Optional free subdomain linked to the Web Hosting plan |
| organization-id |  | Organization ID to filter for, only Web Hosting plans from this Organization will be returned |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |


**Examples:**


List all hostings of a given project ID
```
scw webhosting hosting list project-id=a3244331-5d32-4e36-9bf9-b60233e201c7 organization-id=a3244331-5d32-4e36-9bf9-b60233e201c7
```




### Update a Web Hosting plan

Update the details of one of your existing Web Hosting plans, specified by its `hosting_id`. You can update parameters including the contact email address, tags, options and offer.

**Usage:**

```
scw webhosting hosting update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | Hosting ID |
| email |  | New contact email for the Web Hosting plan |
| tags.{index} |  | New tags for the Web Hosting plan |
| offer-options.{index}.id |  | Offer option ID |
| offer-options.{index}.quantity |  | The option requested quantity to set for the Web Hosting plan |
| offer-id |  | ID of the new offer for the Web Hosting plan |
| protected |  | Whether the hosting is protected or not |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Update the contact email of a given hosting
```
scw webhosting hosting update hosting-id=11111111-1111-1111-1111-111111111111 email=foobar@example.com
```

Overwrite tags of a given hosting
```
scw webhosting hosting update hosting-id=11111111-1111-1111-1111-111111111111 tags.0=foo tags.1=bar
```




## Mail Account

Mail accounts represent the email addresses you can create and manage within your Web Hosting plan.


### Update the password of a mail account within your hosting plan.

Update the password of a mail account within your hosting plan.

**Usage:**

```
scw webhosting mail-account change-password [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| domain |  | Domain part of the mail account address |
| username |  | Username part of the mail account address |
| password |  | New password for the mail account |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create a new mail account within your hosting plan.

Create a new mail account within your hosting plan.

**Usage:**

```
scw webhosting mail-account create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| domain |  | Domain part of the mail account address |
| username |  | Username part address of the mail account address |
| password |  | Password for the new mail account |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a mail account within your hosting plan.

Delete a mail account within your hosting plan.

**Usage:**

```
scw webhosting mail-account delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| domain |  | Domain part of the mail account address |
| username |  | Username part of the mail account address |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all mail accounts within your hosting plan.

List all mail accounts within your hosting plan.

**Usage:**

```
scw webhosting mail-account list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `username_asc`, `username_desc`, `domain_asc`, `domain_desc` | Sort order of mail accounts in the response |
| hosting-id | Required | UUID of the hosting plan |
| domain |  | Domain to filter the mail accounts |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Offer

Offers represent the available Web Hosting plans and their associated options.


### List all available hosting offers along with their specific options.

List all available hosting offers along with their specific options.

**Usage:**

```
scw webhosting offer list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `price_asc` | Sort order for Web Hosting offers in the response |
| hosting-id |  | UUID of the hosting plan |
| control-panels.{index} |  | Name of the control panel(s) to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Progresses

Progresses give details on the advancement of a backup,.


### Retrieve detailed information about a specific progress by its ID.

Retrieve detailed information about a specific progress by its ID.

**Usage:**

```
scw webhosting progress get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | ID of the hosting associated with the progress. |
| progress-id | Required | ID of the progress to retrieve. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List recent progresses associated with a specific backup, grouped by type.

List recent progresses associated with a specific backup, grouped by type.

**Usage:**

```
scw webhosting progress list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | ID of the hosting linked to the progress. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Website

Websites represent the domains and paths hosted within your Web Hosting plan.


### List all websites for a specific hosting.

List all websites for a specific hosting.

**Usage:**

```
scw webhosting website list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hosting-id | Required | UUID of the hosting plan |
| order-by | One of: `domain_asc`, `domain_desc` | Sort order for Web Hosting websites in the response |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



