// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// INetworkClient ...
type INetworkClient interface {
	// GetByID retrieves a network by its ID. If the network does not exist, nil is returned.
	GetByID(ctx context.Context, id int64) (*Network, *Response, error)
	// GetByName retrieves a network by its name. If the network does not exist, nil is returned.
	GetByName(ctx context.Context, name string) (*Network, *Response, error)
	// Get retrieves a network by its ID if the input can be parsed as an integer, otherwise it
	// retrieves a network by its name. If the network does not exist, nil is returned.
	Get(ctx context.Context, idOrName string) (*Network, *Response, error)
	// List returns a list of networks for a specific page.
	//
	// Please note that filters specified in opts are not taken into account
	// when their value corresponds to their zero value or when they are empty.
	List(ctx context.Context, opts NetworkListOpts) ([]*Network, *Response, error)
	// All returns all networks.
	All(ctx context.Context) ([]*Network, error)
	// AllWithOpts returns all networks for the given options.
	AllWithOpts(ctx context.Context, opts NetworkListOpts) ([]*Network, error)
	// Delete deletes a network.
	Delete(ctx context.Context, network *Network) (*Response, error)
	// Update updates a network.
	Update(ctx context.Context, network *Network, opts NetworkUpdateOpts) (*Network, *Response, error)
	// Create creates a new network.
	Create(ctx context.Context, opts NetworkCreateOpts) (*Network, *Response, error)
	// ChangeIPRange changes the IP range of a network.
	ChangeIPRange(ctx context.Context, network *Network, opts NetworkChangeIPRangeOpts) (*Action, *Response, error)
	// AddSubnet adds a subnet to a network.
	AddSubnet(ctx context.Context, network *Network, opts NetworkAddSubnetOpts) (*Action, *Response, error)
	// DeleteSubnet deletes a subnet from a network.
	DeleteSubnet(ctx context.Context, network *Network, opts NetworkDeleteSubnetOpts) (*Action, *Response, error)
	// AddRoute adds a route to a network.
	AddRoute(ctx context.Context, network *Network, opts NetworkAddRouteOpts) (*Action, *Response, error)
	// DeleteRoute deletes a route from a network.
	DeleteRoute(ctx context.Context, network *Network, opts NetworkDeleteRouteOpts) (*Action, *Response, error)
	// ChangeProtection changes the resource protection level of a network.
	ChangeProtection(ctx context.Context, network *Network, opts NetworkChangeProtectionOpts) (*Action, *Response, error)
}
