/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	v1alpha3 "k8s.io/kops/pkg/apis/kops/v1alpha3"
	kopsv1alpha3 "k8s.io/kops/pkg/client/clientset_generated/clientset/typed/kops/v1alpha3"
)

// fakeClusters implements ClusterInterface
type fakeClusters struct {
	*gentype.FakeClientWithList[*v1alpha3.Cluster, *v1alpha3.ClusterList]
	Fake *FakeKopsV1alpha3
}

func newFakeClusters(fake *FakeKopsV1alpha3, namespace string) kopsv1alpha3.ClusterInterface {
	return &fakeClusters{
		gentype.NewFakeClientWithList[*v1alpha3.Cluster, *v1alpha3.ClusterList](
			fake.Fake,
			namespace,
			v1alpha3.SchemeGroupVersion.WithResource("clusters"),
			v1alpha3.SchemeGroupVersion.WithKind("Cluster"),
			func() *v1alpha3.Cluster { return &v1alpha3.Cluster{} },
			func() *v1alpha3.ClusterList { return &v1alpha3.ClusterList{} },
			func(dst, src *v1alpha3.ClusterList) { dst.ListMeta = src.ListMeta },
			func(list *v1alpha3.ClusterList) []*v1alpha3.Cluster { return gentype.ToPointerSlice(list.Items) },
			func(list *v1alpha3.ClusterList, items []*v1alpha3.Cluster) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
