#compdef ggc
# Code generated by go run tools/cmd/gencompletions/main.go; DO NOT EDIT.

_ggc() {
    local context state line
    typeset -A opt_args

    _arguments -C \
        '1: :_ggc_commands' \
        '*::arg:->args'

    case $state in
        args)
            case $line[1] in
                add)
                    _ggc_add
                    ;;
                branch)
                    _ggc_branch
                    ;;
                clean)
                    _ggc_clean
                    ;;
                commit)
                    _ggc_commit
                    ;;
                config)
                    _ggc_config
                    ;;
                diff)
                    _ggc_diff
                    ;;
                fetch)
                    _ggc_fetch
                    ;;
                hook)
                    _ggc_hook
                    ;;
                log)
                    _ggc_log
                    ;;
                pull)
                    _ggc_pull
                    ;;
                push)
                    _ggc_push
                    ;;
                rebase)
                    _ggc_rebase
                    ;;
                remote)
                    _ggc_remote
                    ;;
                restore)
                    _ggc_restore
                    ;;
                stash)
                    _ggc_stash
                    ;;
                status)
                    _ggc_status
                    ;;
                tag)
                    _ggc_tag
                    ;;
            esac
            ;;
    esac
}

_ggc_commands() {
    local commands
    commands=(
        'add:Stage changes for the next commit'
        'branch:List, create, and manage branches'
        'clean:Remove untracked files and directories'
        'commit:Create commits from staged changes'
        'config:Get and set ggc configuration'
        'diff:Inspect changes between commits, the index, and the working tree'
        'fetch:Download objects and refs from remotes'
        'help:Show help information for commands'
        'hook:Manage Git hooks'
        'log:Inspect commit history'
        'pull:Fetch and integrate from the remote'
        'push:Update remote branches'
        'quit:Exit interactive mode'
        'rebase:Reapply commits on top of another base tip'
        'remote:Manage remotes'
        'restore:Restore files in working tree or staging area'
        'stash:Save and reapply work-in-progress changes'
        'status:Show working tree status'
        'tag:Create, list, and manage tags'
        'version:Display current ggc version'
    )
    _describe 'commands' commands
}
_ggc_add() {
    local subcommands
    subcommands=(
        'interactive:Add changes interactively'
        'patch:Add changes interactively (patch mode)'
    )
    if (( CURRENT == 2 )); then
        _describe 'add subcommands' subcommands
    fi
    local files
    files=(${(f)"$(ggc __complete files 2>/dev/null)"})
    if [[ ${#files[@]} -gt 0 ]]; then
        _describe 'files' files
    else
        _files
    fi
}
_ggc_branch() {
    local subcommands
    subcommands=(
        'checkout:Switch to an existing branch'
        'contains:Show branches containing a commit'
        'create:Create and checkout a new branch'
        'current:Show current branch name'
        'delete:Delete local branch'
        'info:Show detailed branch information'
        'list:Show detailed branch listing'
        'move:Move branch to specified commit'
        'rename:Rename a branch'
        'set:Set upstream for a branch'
        'sort:List branches sorted by date or name'
    )
    if (( CURRENT == 2 )); then
        _describe 'branch subcommands' subcommands
    fi
    case $words[2] in
        delete)
            if (( CURRENT == 3 )); then
                _values 'keyword' 'merged'
            fi
            return
            ;;
        list)
            if (( CURRENT == 3 )); then
                _values 'keyword' 'local' 'remote' 'verbose'
            fi
            return
            ;;
        set)
            if (( CURRENT == 3 )); then
                _values 'keyword' 'upstream'
            fi
            return
            ;;
    esac
    if [[ $words[2] == "checkout" ]]; then
        local branches
        branches=(${(f)"$(ggc __complete branch 2>/dev/null)"})
        if [[ ${#branches[@]} -gt 0 ]]; then
            _describe 'branches' branches
        fi
        if (( CURRENT == 3 )); then
            _values 'keyword' 'remote'
        fi
        return
    fi
}
_ggc_clean() {
    local subcommands
    subcommands=(
        'dirs:Clean untracked directories'
        'files:Clean untracked files'
        'interactive:Clean files interactively'
    )
    if (( CURRENT == 2 )); then
        _describe 'clean subcommands' subcommands
    fi
}
_ggc_commit() {
    local subcommands
    subcommands=(
        'allow:Create an empty commit'
        'amend:Amend previous commit (editor)'
    )
    if (( CURRENT == 2 )); then
        _describe 'commit subcommands' subcommands
    fi
    case $words[2] in
        allow)
            if (( CURRENT == 3 )); then
                _values 'keyword' 'empty'
            fi
            return
            ;;
        amend)
            if (( CURRENT == 3 )); then
                _values 'keyword' 'no-edit'
            fi
            return
            ;;
    esac
}
_ggc_config() {
    local subcommands
    subcommands=(
        'get:Get a specific config value'
        'list:List all configuration'
        'set:Set a configuration value'
    )
    if (( CURRENT == 2 )); then
        _describe 'config subcommands' subcommands
    fi
}
_ggc_diff() {
    local subcommands
    subcommands=(
        'head:Alias for default diff against HEAD'
        'staged:Show staged changes'
        'unstaged:Show unstaged changes'
    )
    if (( CURRENT == 2 )); then
        _describe 'diff subcommands' subcommands
    fi
}
_ggc_fetch() {
    local subcommands
    subcommands=(
        'prune:Fetch and clean stale references'
    )
    if (( CURRENT == 2 )); then
        _describe 'fetch subcommands' subcommands
    fi
}
_ggc_hook() {
    local subcommands
    subcommands=(
        'disable:Disable a hook'
        'edit:Edit a hook'\''s contents'
        'enable:Enable a hook'
        'install:Install a hook'
        'list:List all hooks'
        'uninstall:Uninstall an existing hook'
    )
    if (( CURRENT == 2 )); then
        _describe 'hook subcommands' subcommands
    fi
}
_ggc_log() {
    local subcommands
    subcommands=(
        'graph:Show log with graph'
        'simple:Show simple historical log'
    )
    if (( CURRENT == 2 )); then
        _describe 'log subcommands' subcommands
    fi
}
_ggc_pull() {
    local subcommands
    subcommands=(
        'current:Pull current branch from remote repository'
        'rebase:Pull and rebase'
    )
    if (( CURRENT == 2 )); then
        _describe 'pull subcommands' subcommands
    fi
}
_ggc_push() {
    local subcommands
    subcommands=(
        'current:Push current branch to remote repository'
        'force:Force push current branch'
    )
    if (( CURRENT == 2 )); then
        _describe 'push subcommands' subcommands
    fi
}
_ggc_rebase() {
    local subcommands
    subcommands=(
        'abort:Abort an in-progress rebase'
        'continue:Continue an in-progress rebase'
        'interactive:Interactive rebase'
        'skip:Skip current patch and continue'
    )
    if (( CURRENT == 2 )); then
        _describe 'rebase subcommands' subcommands
        case $words[$CURRENT] in
            (continue|abort|skip|interactive)
                ;;
            (*)
                local branches
                branches=(${(f)"$(ggc __complete branch 2>/dev/null)"})
                if [[ ${#branches[@]} -gt 0 ]]; then
                    _describe 'branches' branches
                fi
                ;;
        esac
        return
    fi
}
_ggc_remote() {
    local subcommands
    subcommands=(
        'add:Add remote repository'
        'list:List all remote repositories'
        'remove:Remove remote repository'
        'set-url:Change remote URL'
    )
    if (( CURRENT == 2 )); then
        _describe 'remote subcommands' subcommands
    fi
}
_ggc_restore() {
    local subcommands
    subcommands=(
        'staged:Unstage file (restore from HEAD to index)'
    )
    if (( CURRENT == 2 )); then
        _describe 'restore subcommands' subcommands
    fi
}
_ggc_stash() {
    local subcommands
    subcommands=(
        'apply:Apply stash without removing it'
        'branch:Create branch from stash'
        'clear:Remove all stashes'
        'create:Create stash and return object name'
        'drop:Remove the latest stash'
        'list:List all stashes'
        'pop:Apply and remove the latest stash'
        'push:Save changes to new stash'
        'save:Save changes to new stash with message'
        'show:Show changes in stash'
        'store:Store stash object'
    )
    if (( CURRENT == 2 )); then
        _describe 'stash subcommands' subcommands
    fi
    case $words[2] in
        push)
            if (( CURRENT == 3 )); then
                _values 'keyword' '-m'
            fi
            return
            ;;
    esac
}
_ggc_status() {
    local subcommands
    subcommands=(
        'short:Show concise status (porcelain format)'
    )
    if (( CURRENT == 2 )); then
        _describe 'status subcommands' subcommands
    fi
}
_ggc_tag() {
    local subcommands
    subcommands=(
        'annotated:Create annotated tag'
        'create:Create tag'
        'delete:Delete tag'
        'list:List all tags'
        'push:Push tags to remote'
        'show:Show tag information'
    )
    if (( CURRENT == 2 )); then
        _describe 'tag subcommands' subcommands
    fi
}

compdef _ggc ggc
