// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package unicodedata

import "unicode"

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.

// GraphemeBreakProperty: CR
var GraphemeBreakCR = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x000d, Hi: 0x000d, Stride: 1},
	},
	LatinOffset: 1,
}

// GraphemeBreakProperty: Control
var GraphemeBreakControl = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0000, Hi: 0x0009, Stride: 1},
		{Lo: 0x000b, Hi: 0x000c, Stride: 1},
		{Lo: 0x000e, Hi: 0x001f, Stride: 1},
		{Lo: 0x007f, Hi: 0x009f, Stride: 1},
		{Lo: 0x00ad, Hi: 0x061c, Stride: 1391},
		{Lo: 0x180e, Hi: 0x200b, Stride: 2045},
		{Lo: 0x200e, Hi: 0x200f, Stride: 1},
		{Lo: 0x2028, Hi: 0x202e, Stride: 1},
		{Lo: 0x2060, Hi: 0x206f, Stride: 1},
		{Lo: 0xfeff, Hi: 0xfff0, Stride: 241},
		{Lo: 0xfff1, Hi: 0xfffb, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x13430, Hi: 0x1343f, Stride: 1},
		{Lo: 0x1bca0, Hi: 0x1bca3, Stride: 1},
		{Lo: 0x1d173, Hi: 0x1d17a, Stride: 1},
		{Lo: 0xe0000, Hi: 0xe001f, Stride: 1},
		{Lo: 0xe0080, Hi: 0xe00ff, Stride: 1},
		{Lo: 0xe01f0, Hi: 0xe0fff, Stride: 1},
	},
	LatinOffset: 4,
}

// GraphemeBreakProperty: Extend
var GraphemeBreakExtend = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0300, Hi: 0x036f, Stride: 1},
		{Lo: 0x0483, Hi: 0x0489, Stride: 1},
		{Lo: 0x0591, Hi: 0x05bd, Stride: 1},
		{Lo: 0x05bf, Hi: 0x05c1, Stride: 2},
		{Lo: 0x05c2, Hi: 0x05c4, Stride: 2},
		{Lo: 0x05c5, Hi: 0x05c7, Stride: 2},
		{Lo: 0x0610, Hi: 0x061a, Stride: 1},
		{Lo: 0x064b, Hi: 0x065f, Stride: 1},
		{Lo: 0x0670, Hi: 0x06d6, Stride: 102},
		{Lo: 0x06d7, Hi: 0x06dc, Stride: 1},
		{Lo: 0x06df, Hi: 0x06e4, Stride: 1},
		{Lo: 0x06e7, Hi: 0x06e8, Stride: 1},
		{Lo: 0x06ea, Hi: 0x06ed, Stride: 1},
		{Lo: 0x0711, Hi: 0x0730, Stride: 31},
		{Lo: 0x0731, Hi: 0x074a, Stride: 1},
		{Lo: 0x07a6, Hi: 0x07b0, Stride: 1},
		{Lo: 0x07eb, Hi: 0x07f3, Stride: 1},
		{Lo: 0x07fd, Hi: 0x0816, Stride: 25},
		{Lo: 0x0817, Hi: 0x0819, Stride: 1},
		{Lo: 0x081b, Hi: 0x0823, Stride: 1},
		{Lo: 0x0825, Hi: 0x0827, Stride: 1},
		{Lo: 0x0829, Hi: 0x082d, Stride: 1},
		{Lo: 0x0859, Hi: 0x085b, Stride: 1},
		{Lo: 0x0898, Hi: 0x089f, Stride: 1},
		{Lo: 0x08ca, Hi: 0x08e1, Stride: 1},
		{Lo: 0x08e3, Hi: 0x0902, Stride: 1},
		{Lo: 0x093a, Hi: 0x093c, Stride: 2},
		{Lo: 0x0941, Hi: 0x0948, Stride: 1},
		{Lo: 0x094d, Hi: 0x0951, Stride: 4},
		{Lo: 0x0952, Hi: 0x0957, Stride: 1},
		{Lo: 0x0962, Hi: 0x0963, Stride: 1},
		{Lo: 0x0981, Hi: 0x09bc, Stride: 59},
		{Lo: 0x09be, Hi: 0x09c1, Stride: 3},
		{Lo: 0x09c2, Hi: 0x09c4, Stride: 1},
		{Lo: 0x09cd, Hi: 0x09d7, Stride: 10},
		{Lo: 0x09e2, Hi: 0x09e3, Stride: 1},
		{Lo: 0x09fe, Hi: 0x0a01, Stride: 3},
		{Lo: 0x0a02, Hi: 0x0a3c, Stride: 58},
		{Lo: 0x0a41, Hi: 0x0a42, Stride: 1},
		{Lo: 0x0a47, Hi: 0x0a48, Stride: 1},
		{Lo: 0x0a4b, Hi: 0x0a4d, Stride: 1},
		{Lo: 0x0a51, Hi: 0x0a70, Stride: 31},
		{Lo: 0x0a71, Hi: 0x0a75, Stride: 4},
		{Lo: 0x0a81, Hi: 0x0a82, Stride: 1},
		{Lo: 0x0abc, Hi: 0x0ac1, Stride: 5},
		{Lo: 0x0ac2, Hi: 0x0ac5, Stride: 1},
		{Lo: 0x0ac7, Hi: 0x0ac8, Stride: 1},
		{Lo: 0x0acd, Hi: 0x0ae2, Stride: 21},
		{Lo: 0x0ae3, Hi: 0x0afa, Stride: 23},
		{Lo: 0x0afb, Hi: 0x0aff, Stride: 1},
		{Lo: 0x0b01, Hi: 0x0b3c, Stride: 59},
		{Lo: 0x0b3e, Hi: 0x0b3f, Stride: 1},
		{Lo: 0x0b41, Hi: 0x0b44, Stride: 1},
		{Lo: 0x0b4d, Hi: 0x0b55, Stride: 8},
		{Lo: 0x0b56, Hi: 0x0b57, Stride: 1},
		{Lo: 0x0b62, Hi: 0x0b63, Stride: 1},
		{Lo: 0x0b82, Hi: 0x0bbe, Stride: 60},
		{Lo: 0x0bc0, Hi: 0x0bcd, Stride: 13},
		{Lo: 0x0bd7, Hi: 0x0c00, Stride: 41},
		{Lo: 0x0c04, Hi: 0x0c3c, Stride: 56},
		{Lo: 0x0c3e, Hi: 0x0c40, Stride: 1},
		{Lo: 0x0c46, Hi: 0x0c48, Stride: 1},
		{Lo: 0x0c4a, Hi: 0x0c4d, Stride: 1},
		{Lo: 0x0c55, Hi: 0x0c56, Stride: 1},
		{Lo: 0x0c62, Hi: 0x0c63, Stride: 1},
		{Lo: 0x0c81, Hi: 0x0cbc, Stride: 59},
		{Lo: 0x0cbf, Hi: 0x0cc2, Stride: 3},
		{Lo: 0x0cc6, Hi: 0x0ccc, Stride: 6},
		{Lo: 0x0ccd, Hi: 0x0cd5, Stride: 8},
		{Lo: 0x0cd6, Hi: 0x0ce2, Stride: 12},
		{Lo: 0x0ce3, Hi: 0x0d00, Stride: 29},
		{Lo: 0x0d01, Hi: 0x0d3b, Stride: 58},
		{Lo: 0x0d3c, Hi: 0x0d3e, Stride: 2},
		{Lo: 0x0d41, Hi: 0x0d44, Stride: 1},
		{Lo: 0x0d4d, Hi: 0x0d57, Stride: 10},
		{Lo: 0x0d62, Hi: 0x0d63, Stride: 1},
		{Lo: 0x0d81, Hi: 0x0dca, Stride: 73},
		{Lo: 0x0dcf, Hi: 0x0dd2, Stride: 3},
		{Lo: 0x0dd3, Hi: 0x0dd4, Stride: 1},
		{Lo: 0x0dd6, Hi: 0x0ddf, Stride: 9},
		{Lo: 0x0e31, Hi: 0x0e34, Stride: 3},
		{Lo: 0x0e35, Hi: 0x0e3a, Stride: 1},
		{Lo: 0x0e47, Hi: 0x0e4e, Stride: 1},
		{Lo: 0x0eb1, Hi: 0x0eb4, Stride: 3},
		{Lo: 0x0eb5, Hi: 0x0ebc, Stride: 1},
		{Lo: 0x0ec8, Hi: 0x0ece, Stride: 1},
		{Lo: 0x0f18, Hi: 0x0f19, Stride: 1},
		{Lo: 0x0f35, Hi: 0x0f39, Stride: 2},
		{Lo: 0x0f71, Hi: 0x0f7e, Stride: 1},
		{Lo: 0x0f80, Hi: 0x0f84, Stride: 1},
		{Lo: 0x0f86, Hi: 0x0f87, Stride: 1},
		{Lo: 0x0f8d, Hi: 0x0f97, Stride: 1},
		{Lo: 0x0f99, Hi: 0x0fbc, Stride: 1},
		{Lo: 0x0fc6, Hi: 0x102d, Stride: 103},
		{Lo: 0x102e, Hi: 0x1030, Stride: 1},
		{Lo: 0x1032, Hi: 0x1037, Stride: 1},
		{Lo: 0x1039, Hi: 0x103a, Stride: 1},
		{Lo: 0x103d, Hi: 0x103e, Stride: 1},
		{Lo: 0x1058, Hi: 0x1059, Stride: 1},
		{Lo: 0x105e, Hi: 0x1060, Stride: 1},
		{Lo: 0x1071, Hi: 0x1074, Stride: 1},
		{Lo: 0x1082, Hi: 0x1085, Stride: 3},
		{Lo: 0x1086, Hi: 0x108d, Stride: 7},
		{Lo: 0x109d, Hi: 0x135d, Stride: 704},
		{Lo: 0x135e, Hi: 0x135f, Stride: 1},
		{Lo: 0x1712, Hi: 0x1714, Stride: 1},
		{Lo: 0x1732, Hi: 0x1733, Stride: 1},
		{Lo: 0x1752, Hi: 0x1753, Stride: 1},
		{Lo: 0x1772, Hi: 0x1773, Stride: 1},
		{Lo: 0x17b4, Hi: 0x17b5, Stride: 1},
		{Lo: 0x17b7, Hi: 0x17bd, Stride: 1},
		{Lo: 0x17c6, Hi: 0x17c9, Stride: 3},
		{Lo: 0x17ca, Hi: 0x17d3, Stride: 1},
		{Lo: 0x17dd, Hi: 0x180b, Stride: 46},
		{Lo: 0x180c, Hi: 0x180d, Stride: 1},
		{Lo: 0x180f, Hi: 0x1885, Stride: 118},
		{Lo: 0x1886, Hi: 0x18a9, Stride: 35},
		{Lo: 0x1920, Hi: 0x1922, Stride: 1},
		{Lo: 0x1927, Hi: 0x1928, Stride: 1},
		{Lo: 0x1932, Hi: 0x1939, Stride: 7},
		{Lo: 0x193a, Hi: 0x193b, Stride: 1},
		{Lo: 0x1a17, Hi: 0x1a18, Stride: 1},
		{Lo: 0x1a1b, Hi: 0x1a56, Stride: 59},
		{Lo: 0x1a58, Hi: 0x1a5e, Stride: 1},
		{Lo: 0x1a60, Hi: 0x1a62, Stride: 2},
		{Lo: 0x1a65, Hi: 0x1a6c, Stride: 1},
		{Lo: 0x1a73, Hi: 0x1a7c, Stride: 1},
		{Lo: 0x1a7f, Hi: 0x1ab0, Stride: 49},
		{Lo: 0x1ab1, Hi: 0x1ace, Stride: 1},
		{Lo: 0x1b00, Hi: 0x1b03, Stride: 1},
		{Lo: 0x1b34, Hi: 0x1b3a, Stride: 1},
		{Lo: 0x1b3c, Hi: 0x1b42, Stride: 6},
		{Lo: 0x1b6b, Hi: 0x1b73, Stride: 1},
		{Lo: 0x1b80, Hi: 0x1b81, Stride: 1},
		{Lo: 0x1ba2, Hi: 0x1ba5, Stride: 1},
		{Lo: 0x1ba8, Hi: 0x1ba9, Stride: 1},
		{Lo: 0x1bab, Hi: 0x1bad, Stride: 1},
		{Lo: 0x1be6, Hi: 0x1be8, Stride: 2},
		{Lo: 0x1be9, Hi: 0x1bed, Stride: 4},
		{Lo: 0x1bef, Hi: 0x1bf1, Stride: 1},
		{Lo: 0x1c2c, Hi: 0x1c33, Stride: 1},
		{Lo: 0x1c36, Hi: 0x1c37, Stride: 1},
		{Lo: 0x1cd0, Hi: 0x1cd2, Stride: 1},
		{Lo: 0x1cd4, Hi: 0x1ce0, Stride: 1},
		{Lo: 0x1ce2, Hi: 0x1ce8, Stride: 1},
		{Lo: 0x1ced, Hi: 0x1cf4, Stride: 7},
		{Lo: 0x1cf8, Hi: 0x1cf9, Stride: 1},
		{Lo: 0x1dc0, Hi: 0x1dff, Stride: 1},
		{Lo: 0x200c, Hi: 0x20d0, Stride: 196},
		{Lo: 0x20d1, Hi: 0x20f0, Stride: 1},
		{Lo: 0x2cef, Hi: 0x2cf1, Stride: 1},
		{Lo: 0x2d7f, Hi: 0x2de0, Stride: 97},
		{Lo: 0x2de1, Hi: 0x2dff, Stride: 1},
		{Lo: 0x302a, Hi: 0x302f, Stride: 1},
		{Lo: 0x3099, Hi: 0x309a, Stride: 1},
		{Lo: 0xa66f, Hi: 0xa672, Stride: 1},
		{Lo: 0xa674, Hi: 0xa67d, Stride: 1},
		{Lo: 0xa69e, Hi: 0xa69f, Stride: 1},
		{Lo: 0xa6f0, Hi: 0xa6f1, Stride: 1},
		{Lo: 0xa802, Hi: 0xa806, Stride: 4},
		{Lo: 0xa80b, Hi: 0xa825, Stride: 26},
		{Lo: 0xa826, Hi: 0xa82c, Stride: 6},
		{Lo: 0xa8c4, Hi: 0xa8c5, Stride: 1},
		{Lo: 0xa8e0, Hi: 0xa8f1, Stride: 1},
		{Lo: 0xa8ff, Hi: 0xa926, Stride: 39},
		{Lo: 0xa927, Hi: 0xa92d, Stride: 1},
		{Lo: 0xa947, Hi: 0xa951, Stride: 1},
		{Lo: 0xa980, Hi: 0xa982, Stride: 1},
		{Lo: 0xa9b3, Hi: 0xa9b6, Stride: 3},
		{Lo: 0xa9b7, Hi: 0xa9b9, Stride: 1},
		{Lo: 0xa9bc, Hi: 0xa9bd, Stride: 1},
		{Lo: 0xa9e5, Hi: 0xaa29, Stride: 68},
		{Lo: 0xaa2a, Hi: 0xaa2e, Stride: 1},
		{Lo: 0xaa31, Hi: 0xaa32, Stride: 1},
		{Lo: 0xaa35, Hi: 0xaa36, Stride: 1},
		{Lo: 0xaa43, Hi: 0xaa4c, Stride: 9},
		{Lo: 0xaa7c, Hi: 0xaab0, Stride: 52},
		{Lo: 0xaab2, Hi: 0xaab4, Stride: 1},
		{Lo: 0xaab7, Hi: 0xaab8, Stride: 1},
		{Lo: 0xaabe, Hi: 0xaabf, Stride: 1},
		{Lo: 0xaac1, Hi: 0xaaec, Stride: 43},
		{Lo: 0xaaed, Hi: 0xaaf6, Stride: 9},
		{Lo: 0xabe5, Hi: 0xabe8, Stride: 3},
		{Lo: 0xabed, Hi: 0xfb1e, Stride: 20273},
		{Lo: 0xfe00, Hi: 0xfe0f, Stride: 1},
		{Lo: 0xfe20, Hi: 0xfe2f, Stride: 1},
		{Lo: 0xff9e, Hi: 0xff9f, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x101fd, Hi: 0x102e0, Stride: 227},
		{Lo: 0x10376, Hi: 0x1037a, Stride: 1},
		{Lo: 0x10a01, Hi: 0x10a03, Stride: 1},
		{Lo: 0x10a05, Hi: 0x10a06, Stride: 1},
		{Lo: 0x10a0c, Hi: 0x10a0f, Stride: 1},
		{Lo: 0x10a38, Hi: 0x10a3a, Stride: 1},
		{Lo: 0x10a3f, Hi: 0x10ae5, Stride: 166},
		{Lo: 0x10ae6, Hi: 0x10d24, Stride: 574},
		{Lo: 0x10d25, Hi: 0x10d27, Stride: 1},
		{Lo: 0x10eab, Hi: 0x10eac, Stride: 1},
		{Lo: 0x10efd, Hi: 0x10eff, Stride: 1},
		{Lo: 0x10f46, Hi: 0x10f50, Stride: 1},
		{Lo: 0x10f82, Hi: 0x10f85, Stride: 1},
		{Lo: 0x11001, Hi: 0x11038, Stride: 55},
		{Lo: 0x11039, Hi: 0x11046, Stride: 1},
		{Lo: 0x11070, Hi: 0x11073, Stride: 3},
		{Lo: 0x11074, Hi: 0x1107f, Stride: 11},
		{Lo: 0x11080, Hi: 0x11081, Stride: 1},
		{Lo: 0x110b3, Hi: 0x110b6, Stride: 1},
		{Lo: 0x110b9, Hi: 0x110ba, Stride: 1},
		{Lo: 0x110c2, Hi: 0x11100, Stride: 62},
		{Lo: 0x11101, Hi: 0x11102, Stride: 1},
		{Lo: 0x11127, Hi: 0x1112b, Stride: 1},
		{Lo: 0x1112d, Hi: 0x11134, Stride: 1},
		{Lo: 0x11173, Hi: 0x11180, Stride: 13},
		{Lo: 0x11181, Hi: 0x111b6, Stride: 53},
		{Lo: 0x111b7, Hi: 0x111be, Stride: 1},
		{Lo: 0x111c9, Hi: 0x111cc, Stride: 1},
		{Lo: 0x111cf, Hi: 0x1122f, Stride: 96},
		{Lo: 0x11230, Hi: 0x11231, Stride: 1},
		{Lo: 0x11234, Hi: 0x11236, Stride: 2},
		{Lo: 0x11237, Hi: 0x1123e, Stride: 7},
		{Lo: 0x11241, Hi: 0x112df, Stride: 158},
		{Lo: 0x112e3, Hi: 0x112ea, Stride: 1},
		{Lo: 0x11300, Hi: 0x11301, Stride: 1},
		{Lo: 0x1133b, Hi: 0x1133c, Stride: 1},
		{Lo: 0x1133e, Hi: 0x11340, Stride: 2},
		{Lo: 0x11357, Hi: 0x11366, Stride: 15},
		{Lo: 0x11367, Hi: 0x1136c, Stride: 1},
		{Lo: 0x11370, Hi: 0x11374, Stride: 1},
		{Lo: 0x11438, Hi: 0x1143f, Stride: 1},
		{Lo: 0x11442, Hi: 0x11444, Stride: 1},
		{Lo: 0x11446, Hi: 0x1145e, Stride: 24},
		{Lo: 0x114b0, Hi: 0x114b3, Stride: 3},
		{Lo: 0x114b4, Hi: 0x114b8, Stride: 1},
		{Lo: 0x114ba, Hi: 0x114bd, Stride: 3},
		{Lo: 0x114bf, Hi: 0x114c0, Stride: 1},
		{Lo: 0x114c2, Hi: 0x114c3, Stride: 1},
		{Lo: 0x115af, Hi: 0x115b2, Stride: 3},
		{Lo: 0x115b3, Hi: 0x115b5, Stride: 1},
		{Lo: 0x115bc, Hi: 0x115bd, Stride: 1},
		{Lo: 0x115bf, Hi: 0x115c0, Stride: 1},
		{Lo: 0x115dc, Hi: 0x115dd, Stride: 1},
		{Lo: 0x11633, Hi: 0x1163a, Stride: 1},
		{Lo: 0x1163d, Hi: 0x1163f, Stride: 2},
		{Lo: 0x11640, Hi: 0x116ab, Stride: 107},
		{Lo: 0x116ad, Hi: 0x116b0, Stride: 3},
		{Lo: 0x116b1, Hi: 0x116b5, Stride: 1},
		{Lo: 0x116b7, Hi: 0x1171d, Stride: 102},
		{Lo: 0x1171e, Hi: 0x1171f, Stride: 1},
		{Lo: 0x11722, Hi: 0x11725, Stride: 1},
		{Lo: 0x11727, Hi: 0x1172b, Stride: 1},
		{Lo: 0x1182f, Hi: 0x11837, Stride: 1},
		{Lo: 0x11839, Hi: 0x1183a, Stride: 1},
		{Lo: 0x11930, Hi: 0x1193b, Stride: 11},
		{Lo: 0x1193c, Hi: 0x1193e, Stride: 2},
		{Lo: 0x11943, Hi: 0x119d4, Stride: 145},
		{Lo: 0x119d5, Hi: 0x119d7, Stride: 1},
		{Lo: 0x119da, Hi: 0x119db, Stride: 1},
		{Lo: 0x119e0, Hi: 0x11a01, Stride: 33},
		{Lo: 0x11a02, Hi: 0x11a0a, Stride: 1},
		{Lo: 0x11a33, Hi: 0x11a38, Stride: 1},
		{Lo: 0x11a3b, Hi: 0x11a3e, Stride: 1},
		{Lo: 0x11a47, Hi: 0x11a51, Stride: 10},
		{Lo: 0x11a52, Hi: 0x11a56, Stride: 1},
		{Lo: 0x11a59, Hi: 0x11a5b, Stride: 1},
		{Lo: 0x11a8a, Hi: 0x11a96, Stride: 1},
		{Lo: 0x11a98, Hi: 0x11a99, Stride: 1},
		{Lo: 0x11c30, Hi: 0x11c36, Stride: 1},
		{Lo: 0x11c38, Hi: 0x11c3d, Stride: 1},
		{Lo: 0x11c3f, Hi: 0x11c92, Stride: 83},
		{Lo: 0x11c93, Hi: 0x11ca7, Stride: 1},
		{Lo: 0x11caa, Hi: 0x11cb0, Stride: 1},
		{Lo: 0x11cb2, Hi: 0x11cb3, Stride: 1},
		{Lo: 0x11cb5, Hi: 0x11cb6, Stride: 1},
		{Lo: 0x11d31, Hi: 0x11d36, Stride: 1},
		{Lo: 0x11d3a, Hi: 0x11d3c, Stride: 2},
		{Lo: 0x11d3d, Hi: 0x11d3f, Stride: 2},
		{Lo: 0x11d40, Hi: 0x11d45, Stride: 1},
		{Lo: 0x11d47, Hi: 0x11d90, Stride: 73},
		{Lo: 0x11d91, Hi: 0x11d95, Stride: 4},
		{Lo: 0x11d97, Hi: 0x11ef3, Stride: 348},
		{Lo: 0x11ef4, Hi: 0x11f00, Stride: 12},
		{Lo: 0x11f01, Hi: 0x11f36, Stride: 53},
		{Lo: 0x11f37, Hi: 0x11f3a, Stride: 1},
		{Lo: 0x11f40, Hi: 0x11f42, Stride: 2},
		{Lo: 0x13440, Hi: 0x13447, Stride: 7},
		{Lo: 0x13448, Hi: 0x13455, Stride: 1},
		{Lo: 0x16af0, Hi: 0x16af4, Stride: 1},
		{Lo: 0x16b30, Hi: 0x16b36, Stride: 1},
		{Lo: 0x16f4f, Hi: 0x16f8f, Stride: 64},
		{Lo: 0x16f90, Hi: 0x16f92, Stride: 1},
		{Lo: 0x16fe4, Hi: 0x1bc9d, Stride: 19641},
		{Lo: 0x1bc9e, Hi: 0x1cf00, Stride: 4706},
		{Lo: 0x1cf01, Hi: 0x1cf2d, Stride: 1},
		{Lo: 0x1cf30, Hi: 0x1cf46, Stride: 1},
		{Lo: 0x1d165, Hi: 0x1d167, Stride: 2},
		{Lo: 0x1d168, Hi: 0x1d169, Stride: 1},
		{Lo: 0x1d16e, Hi: 0x1d172, Stride: 1},
		{Lo: 0x1d17b, Hi: 0x1d182, Stride: 1},
		{Lo: 0x1d185, Hi: 0x1d18b, Stride: 1},
		{Lo: 0x1d1aa, Hi: 0x1d1ad, Stride: 1},
		{Lo: 0x1d242, Hi: 0x1d244, Stride: 1},
		{Lo: 0x1da00, Hi: 0x1da36, Stride: 1},
		{Lo: 0x1da3b, Hi: 0x1da6c, Stride: 1},
		{Lo: 0x1da75, Hi: 0x1da84, Stride: 15},
		{Lo: 0x1da9b, Hi: 0x1da9f, Stride: 1},
		{Lo: 0x1daa1, Hi: 0x1daaf, Stride: 1},
		{Lo: 0x1e000, Hi: 0x1e006, Stride: 1},
		{Lo: 0x1e008, Hi: 0x1e018, Stride: 1},
		{Lo: 0x1e01b, Hi: 0x1e021, Stride: 1},
		{Lo: 0x1e023, Hi: 0x1e024, Stride: 1},
		{Lo: 0x1e026, Hi: 0x1e02a, Stride: 1},
		{Lo: 0x1e08f, Hi: 0x1e130, Stride: 161},
		{Lo: 0x1e131, Hi: 0x1e136, Stride: 1},
		{Lo: 0x1e2ae, Hi: 0x1e2ec, Stride: 62},
		{Lo: 0x1e2ed, Hi: 0x1e2ef, Stride: 1},
		{Lo: 0x1e4ec, Hi: 0x1e4ef, Stride: 1},
		{Lo: 0x1e8d0, Hi: 0x1e8d6, Stride: 1},
		{Lo: 0x1e944, Hi: 0x1e94a, Stride: 1},
		{Lo: 0x1f3fb, Hi: 0x1f3ff, Stride: 1},
		{Lo: 0xe0020, Hi: 0xe007f, Stride: 1},
		{Lo: 0xe0100, Hi: 0xe01ef, Stride: 1},
	},
}

// GraphemeBreakProperty: L
var GraphemeBreakL = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x1100, Hi: 0x115f, Stride: 1},
		{Lo: 0xa960, Hi: 0xa97c, Stride: 1},
	},
}

// GraphemeBreakProperty: LF
var GraphemeBreakLF = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x000a, Hi: 0x000a, Stride: 1},
	},
	LatinOffset: 1,
}

// GraphemeBreakProperty: LV
var GraphemeBreakLV = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0xac00, Hi: 0xd788, Stride: 28},
	},
}

// GraphemeBreakProperty: LVT
var GraphemeBreakLVT = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0xac01, Hi: 0xac1b, Stride: 1},
		{Lo: 0xac1d, Hi: 0xac37, Stride: 1},
		{Lo: 0xac39, Hi: 0xac53, Stride: 1},
		{Lo: 0xac55, Hi: 0xac6f, Stride: 1},
		{Lo: 0xac71, Hi: 0xac8b, Stride: 1},
		{Lo: 0xac8d, Hi: 0xaca7, Stride: 1},
		{Lo: 0xaca9, Hi: 0xacc3, Stride: 1},
		{Lo: 0xacc5, Hi: 0xacdf, Stride: 1},
		{Lo: 0xace1, Hi: 0xacfb, Stride: 1},
		{Lo: 0xacfd, Hi: 0xad17, Stride: 1},
		{Lo: 0xad19, Hi: 0xad33, Stride: 1},
		{Lo: 0xad35, Hi: 0xad4f, Stride: 1},
		{Lo: 0xad51, Hi: 0xad6b, Stride: 1},
		{Lo: 0xad6d, Hi: 0xad87, Stride: 1},
		{Lo: 0xad89, Hi: 0xada3, Stride: 1},
		{Lo: 0xada5, Hi: 0xadbf, Stride: 1},
		{Lo: 0xadc1, Hi: 0xaddb, Stride: 1},
		{Lo: 0xaddd, Hi: 0xadf7, Stride: 1},
		{Lo: 0xadf9, Hi: 0xae13, Stride: 1},
		{Lo: 0xae15, Hi: 0xae2f, Stride: 1},
		{Lo: 0xae31, Hi: 0xae4b, Stride: 1},
		{Lo: 0xae4d, Hi: 0xae67, Stride: 1},
		{Lo: 0xae69, Hi: 0xae83, Stride: 1},
		{Lo: 0xae85, Hi: 0xae9f, Stride: 1},
		{Lo: 0xaea1, Hi: 0xaebb, Stride: 1},
		{Lo: 0xaebd, Hi: 0xaed7, Stride: 1},
		{Lo: 0xaed9, Hi: 0xaef3, Stride: 1},
		{Lo: 0xaef5, Hi: 0xaf0f, Stride: 1},
		{Lo: 0xaf11, Hi: 0xaf2b, Stride: 1},
		{Lo: 0xaf2d, Hi: 0xaf47, Stride: 1},
		{Lo: 0xaf49, Hi: 0xaf63, Stride: 1},
		{Lo: 0xaf65, Hi: 0xaf7f, Stride: 1},
		{Lo: 0xaf81, Hi: 0xaf9b, Stride: 1},
		{Lo: 0xaf9d, Hi: 0xafb7, Stride: 1},
		{Lo: 0xafb9, Hi: 0xafd3, Stride: 1},
		{Lo: 0xafd5, Hi: 0xafef, Stride: 1},
		{Lo: 0xaff1, Hi: 0xb00b, Stride: 1},
		{Lo: 0xb00d, Hi: 0xb027, Stride: 1},
		{Lo: 0xb029, Hi: 0xb043, Stride: 1},
		{Lo: 0xb045, Hi: 0xb05f, Stride: 1},
		{Lo: 0xb061, Hi: 0xb07b, Stride: 1},
		{Lo: 0xb07d, Hi: 0xb097, Stride: 1},
		{Lo: 0xb099, Hi: 0xb0b3, Stride: 1},
		{Lo: 0xb0b5, Hi: 0xb0cf, Stride: 1},
		{Lo: 0xb0d1, Hi: 0xb0eb, Stride: 1},
		{Lo: 0xb0ed, Hi: 0xb107, Stride: 1},
		{Lo: 0xb109, Hi: 0xb123, Stride: 1},
		{Lo: 0xb125, Hi: 0xb13f, Stride: 1},
		{Lo: 0xb141, Hi: 0xb15b, Stride: 1},
		{Lo: 0xb15d, Hi: 0xb177, Stride: 1},
		{Lo: 0xb179, Hi: 0xb193, Stride: 1},
		{Lo: 0xb195, Hi: 0xb1af, Stride: 1},
		{Lo: 0xb1b1, Hi: 0xb1cb, Stride: 1},
		{Lo: 0xb1cd, Hi: 0xb1e7, Stride: 1},
		{Lo: 0xb1e9, Hi: 0xb203, Stride: 1},
		{Lo: 0xb205, Hi: 0xb21f, Stride: 1},
		{Lo: 0xb221, Hi: 0xb23b, Stride: 1},
		{Lo: 0xb23d, Hi: 0xb257, Stride: 1},
		{Lo: 0xb259, Hi: 0xb273, Stride: 1},
		{Lo: 0xb275, Hi: 0xb28f, Stride: 1},
		{Lo: 0xb291, Hi: 0xb2ab, Stride: 1},
		{Lo: 0xb2ad, Hi: 0xb2c7, Stride: 1},
		{Lo: 0xb2c9, Hi: 0xb2e3, Stride: 1},
		{Lo: 0xb2e5, Hi: 0xb2ff, Stride: 1},
		{Lo: 0xb301, Hi: 0xb31b, Stride: 1},
		{Lo: 0xb31d, Hi: 0xb337, Stride: 1},
		{Lo: 0xb339, Hi: 0xb353, Stride: 1},
		{Lo: 0xb355, Hi: 0xb36f, Stride: 1},
		{Lo: 0xb371, Hi: 0xb38b, Stride: 1},
		{Lo: 0xb38d, Hi: 0xb3a7, Stride: 1},
		{Lo: 0xb3a9, Hi: 0xb3c3, Stride: 1},
		{Lo: 0xb3c5, Hi: 0xb3df, Stride: 1},
		{Lo: 0xb3e1, Hi: 0xb3fb, Stride: 1},
		{Lo: 0xb3fd, Hi: 0xb417, Stride: 1},
		{Lo: 0xb419, Hi: 0xb433, Stride: 1},
		{Lo: 0xb435, Hi: 0xb44f, Stride: 1},
		{Lo: 0xb451, Hi: 0xb46b, Stride: 1},
		{Lo: 0xb46d, Hi: 0xb487, Stride: 1},
		{Lo: 0xb489, Hi: 0xb4a3, Stride: 1},
		{Lo: 0xb4a5, Hi: 0xb4bf, Stride: 1},
		{Lo: 0xb4c1, Hi: 0xb4db, Stride: 1},
		{Lo: 0xb4dd, Hi: 0xb4f7, Stride: 1},
		{Lo: 0xb4f9, Hi: 0xb513, Stride: 1},
		{Lo: 0xb515, Hi: 0xb52f, Stride: 1},
		{Lo: 0xb531, Hi: 0xb54b, Stride: 1},
		{Lo: 0xb54d, Hi: 0xb567, Stride: 1},
		{Lo: 0xb569, Hi: 0xb583, Stride: 1},
		{Lo: 0xb585, Hi: 0xb59f, Stride: 1},
		{Lo: 0xb5a1, Hi: 0xb5bb, Stride: 1},
		{Lo: 0xb5bd, Hi: 0xb5d7, Stride: 1},
		{Lo: 0xb5d9, Hi: 0xb5f3, Stride: 1},
		{Lo: 0xb5f5, Hi: 0xb60f, Stride: 1},
		{Lo: 0xb611, Hi: 0xb62b, Stride: 1},
		{Lo: 0xb62d, Hi: 0xb647, Stride: 1},
		{Lo: 0xb649, Hi: 0xb663, Stride: 1},
		{Lo: 0xb665, Hi: 0xb67f, Stride: 1},
		{Lo: 0xb681, Hi: 0xb69b, Stride: 1},
		{Lo: 0xb69d, Hi: 0xb6b7, Stride: 1},
		{Lo: 0xb6b9, Hi: 0xb6d3, Stride: 1},
		{Lo: 0xb6d5, Hi: 0xb6ef, Stride: 1},
		{Lo: 0xb6f1, Hi: 0xb70b, Stride: 1},
		{Lo: 0xb70d, Hi: 0xb727, Stride: 1},
		{Lo: 0xb729, Hi: 0xb743, Stride: 1},
		{Lo: 0xb745, Hi: 0xb75f, Stride: 1},
		{Lo: 0xb761, Hi: 0xb77b, Stride: 1},
		{Lo: 0xb77d, Hi: 0xb797, Stride: 1},
		{Lo: 0xb799, Hi: 0xb7b3, Stride: 1},
		{Lo: 0xb7b5, Hi: 0xb7cf, Stride: 1},
		{Lo: 0xb7d1, Hi: 0xb7eb, Stride: 1},
		{Lo: 0xb7ed, Hi: 0xb807, Stride: 1},
		{Lo: 0xb809, Hi: 0xb823, Stride: 1},
		{Lo: 0xb825, Hi: 0xb83f, Stride: 1},
		{Lo: 0xb841, Hi: 0xb85b, Stride: 1},
		{Lo: 0xb85d, Hi: 0xb877, Stride: 1},
		{Lo: 0xb879, Hi: 0xb893, Stride: 1},
		{Lo: 0xb895, Hi: 0xb8af, Stride: 1},
		{Lo: 0xb8b1, Hi: 0xb8cb, Stride: 1},
		{Lo: 0xb8cd, Hi: 0xb8e7, Stride: 1},
		{Lo: 0xb8e9, Hi: 0xb903, Stride: 1},
		{Lo: 0xb905, Hi: 0xb91f, Stride: 1},
		{Lo: 0xb921, Hi: 0xb93b, Stride: 1},
		{Lo: 0xb93d, Hi: 0xb957, Stride: 1},
		{Lo: 0xb959, Hi: 0xb973, Stride: 1},
		{Lo: 0xb975, Hi: 0xb98f, Stride: 1},
		{Lo: 0xb991, Hi: 0xb9ab, Stride: 1},
		{Lo: 0xb9ad, Hi: 0xb9c7, Stride: 1},
		{Lo: 0xb9c9, Hi: 0xb9e3, Stride: 1},
		{Lo: 0xb9e5, Hi: 0xb9ff, Stride: 1},
		{Lo: 0xba01, Hi: 0xba1b, Stride: 1},
		{Lo: 0xba1d, Hi: 0xba37, Stride: 1},
		{Lo: 0xba39, Hi: 0xba53, Stride: 1},
		{Lo: 0xba55, Hi: 0xba6f, Stride: 1},
		{Lo: 0xba71, Hi: 0xba8b, Stride: 1},
		{Lo: 0xba8d, Hi: 0xbaa7, Stride: 1},
		{Lo: 0xbaa9, Hi: 0xbac3, Stride: 1},
		{Lo: 0xbac5, Hi: 0xbadf, Stride: 1},
		{Lo: 0xbae1, Hi: 0xbafb, Stride: 1},
		{Lo: 0xbafd, Hi: 0xbb17, Stride: 1},
		{Lo: 0xbb19, Hi: 0xbb33, Stride: 1},
		{Lo: 0xbb35, Hi: 0xbb4f, Stride: 1},
		{Lo: 0xbb51, Hi: 0xbb6b, Stride: 1},
		{Lo: 0xbb6d, Hi: 0xbb87, Stride: 1},
		{Lo: 0xbb89, Hi: 0xbba3, Stride: 1},
		{Lo: 0xbba5, Hi: 0xbbbf, Stride: 1},
		{Lo: 0xbbc1, Hi: 0xbbdb, Stride: 1},
		{Lo: 0xbbdd, Hi: 0xbbf7, Stride: 1},
		{Lo: 0xbbf9, Hi: 0xbc13, Stride: 1},
		{Lo: 0xbc15, Hi: 0xbc2f, Stride: 1},
		{Lo: 0xbc31, Hi: 0xbc4b, Stride: 1},
		{Lo: 0xbc4d, Hi: 0xbc67, Stride: 1},
		{Lo: 0xbc69, Hi: 0xbc83, Stride: 1},
		{Lo: 0xbc85, Hi: 0xbc9f, Stride: 1},
		{Lo: 0xbca1, Hi: 0xbcbb, Stride: 1},
		{Lo: 0xbcbd, Hi: 0xbcd7, Stride: 1},
		{Lo: 0xbcd9, Hi: 0xbcf3, Stride: 1},
		{Lo: 0xbcf5, Hi: 0xbd0f, Stride: 1},
		{Lo: 0xbd11, Hi: 0xbd2b, Stride: 1},
		{Lo: 0xbd2d, Hi: 0xbd47, Stride: 1},
		{Lo: 0xbd49, Hi: 0xbd63, Stride: 1},
		{Lo: 0xbd65, Hi: 0xbd7f, Stride: 1},
		{Lo: 0xbd81, Hi: 0xbd9b, Stride: 1},
		{Lo: 0xbd9d, Hi: 0xbdb7, Stride: 1},
		{Lo: 0xbdb9, Hi: 0xbdd3, Stride: 1},
		{Lo: 0xbdd5, Hi: 0xbdef, Stride: 1},
		{Lo: 0xbdf1, Hi: 0xbe0b, Stride: 1},
		{Lo: 0xbe0d, Hi: 0xbe27, Stride: 1},
		{Lo: 0xbe29, Hi: 0xbe43, Stride: 1},
		{Lo: 0xbe45, Hi: 0xbe5f, Stride: 1},
		{Lo: 0xbe61, Hi: 0xbe7b, Stride: 1},
		{Lo: 0xbe7d, Hi: 0xbe97, Stride: 1},
		{Lo: 0xbe99, Hi: 0xbeb3, Stride: 1},
		{Lo: 0xbeb5, Hi: 0xbecf, Stride: 1},
		{Lo: 0xbed1, Hi: 0xbeeb, Stride: 1},
		{Lo: 0xbeed, Hi: 0xbf07, Stride: 1},
		{Lo: 0xbf09, Hi: 0xbf23, Stride: 1},
		{Lo: 0xbf25, Hi: 0xbf3f, Stride: 1},
		{Lo: 0xbf41, Hi: 0xbf5b, Stride: 1},
		{Lo: 0xbf5d, Hi: 0xbf77, Stride: 1},
		{Lo: 0xbf79, Hi: 0xbf93, Stride: 1},
		{Lo: 0xbf95, Hi: 0xbfaf, Stride: 1},
		{Lo: 0xbfb1, Hi: 0xbfcb, Stride: 1},
		{Lo: 0xbfcd, Hi: 0xbfe7, Stride: 1},
		{Lo: 0xbfe9, Hi: 0xc003, Stride: 1},
		{Lo: 0xc005, Hi: 0xc01f, Stride: 1},
		{Lo: 0xc021, Hi: 0xc03b, Stride: 1},
		{Lo: 0xc03d, Hi: 0xc057, Stride: 1},
		{Lo: 0xc059, Hi: 0xc073, Stride: 1},
		{Lo: 0xc075, Hi: 0xc08f, Stride: 1},
		{Lo: 0xc091, Hi: 0xc0ab, Stride: 1},
		{Lo: 0xc0ad, Hi: 0xc0c7, Stride: 1},
		{Lo: 0xc0c9, Hi: 0xc0e3, Stride: 1},
		{Lo: 0xc0e5, Hi: 0xc0ff, Stride: 1},
		{Lo: 0xc101, Hi: 0xc11b, Stride: 1},
		{Lo: 0xc11d, Hi: 0xc137, Stride: 1},
		{Lo: 0xc139, Hi: 0xc153, Stride: 1},
		{Lo: 0xc155, Hi: 0xc16f, Stride: 1},
		{Lo: 0xc171, Hi: 0xc18b, Stride: 1},
		{Lo: 0xc18d, Hi: 0xc1a7, Stride: 1},
		{Lo: 0xc1a9, Hi: 0xc1c3, Stride: 1},
		{Lo: 0xc1c5, Hi: 0xc1df, Stride: 1},
		{Lo: 0xc1e1, Hi: 0xc1fb, Stride: 1},
		{Lo: 0xc1fd, Hi: 0xc217, Stride: 1},
		{Lo: 0xc219, Hi: 0xc233, Stride: 1},
		{Lo: 0xc235, Hi: 0xc24f, Stride: 1},
		{Lo: 0xc251, Hi: 0xc26b, Stride: 1},
		{Lo: 0xc26d, Hi: 0xc287, Stride: 1},
		{Lo: 0xc289, Hi: 0xc2a3, Stride: 1},
		{Lo: 0xc2a5, Hi: 0xc2bf, Stride: 1},
		{Lo: 0xc2c1, Hi: 0xc2db, Stride: 1},
		{Lo: 0xc2dd, Hi: 0xc2f7, Stride: 1},
		{Lo: 0xc2f9, Hi: 0xc313, Stride: 1},
		{Lo: 0xc315, Hi: 0xc32f, Stride: 1},
		{Lo: 0xc331, Hi: 0xc34b, Stride: 1},
		{Lo: 0xc34d, Hi: 0xc367, Stride: 1},
		{Lo: 0xc369, Hi: 0xc383, Stride: 1},
		{Lo: 0xc385, Hi: 0xc39f, Stride: 1},
		{Lo: 0xc3a1, Hi: 0xc3bb, Stride: 1},
		{Lo: 0xc3bd, Hi: 0xc3d7, Stride: 1},
		{Lo: 0xc3d9, Hi: 0xc3f3, Stride: 1},
		{Lo: 0xc3f5, Hi: 0xc40f, Stride: 1},
		{Lo: 0xc411, Hi: 0xc42b, Stride: 1},
		{Lo: 0xc42d, Hi: 0xc447, Stride: 1},
		{Lo: 0xc449, Hi: 0xc463, Stride: 1},
		{Lo: 0xc465, Hi: 0xc47f, Stride: 1},
		{Lo: 0xc481, Hi: 0xc49b, Stride: 1},
		{Lo: 0xc49d, Hi: 0xc4b7, Stride: 1},
		{Lo: 0xc4b9, Hi: 0xc4d3, Stride: 1},
		{Lo: 0xc4d5, Hi: 0xc4ef, Stride: 1},
		{Lo: 0xc4f1, Hi: 0xc50b, Stride: 1},
		{Lo: 0xc50d, Hi: 0xc527, Stride: 1},
		{Lo: 0xc529, Hi: 0xc543, Stride: 1},
		{Lo: 0xc545, Hi: 0xc55f, Stride: 1},
		{Lo: 0xc561, Hi: 0xc57b, Stride: 1},
		{Lo: 0xc57d, Hi: 0xc597, Stride: 1},
		{Lo: 0xc599, Hi: 0xc5b3, Stride: 1},
		{Lo: 0xc5b5, Hi: 0xc5cf, Stride: 1},
		{Lo: 0xc5d1, Hi: 0xc5eb, Stride: 1},
		{Lo: 0xc5ed, Hi: 0xc607, Stride: 1},
		{Lo: 0xc609, Hi: 0xc623, Stride: 1},
		{Lo: 0xc625, Hi: 0xc63f, Stride: 1},
		{Lo: 0xc641, Hi: 0xc65b, Stride: 1},
		{Lo: 0xc65d, Hi: 0xc677, Stride: 1},
		{Lo: 0xc679, Hi: 0xc693, Stride: 1},
		{Lo: 0xc695, Hi: 0xc6af, Stride: 1},
		{Lo: 0xc6b1, Hi: 0xc6cb, Stride: 1},
		{Lo: 0xc6cd, Hi: 0xc6e7, Stride: 1},
		{Lo: 0xc6e9, Hi: 0xc703, Stride: 1},
		{Lo: 0xc705, Hi: 0xc71f, Stride: 1},
		{Lo: 0xc721, Hi: 0xc73b, Stride: 1},
		{Lo: 0xc73d, Hi: 0xc757, Stride: 1},
		{Lo: 0xc759, Hi: 0xc773, Stride: 1},
		{Lo: 0xc775, Hi: 0xc78f, Stride: 1},
		{Lo: 0xc791, Hi: 0xc7ab, Stride: 1},
		{Lo: 0xc7ad, Hi: 0xc7c7, Stride: 1},
		{Lo: 0xc7c9, Hi: 0xc7e3, Stride: 1},
		{Lo: 0xc7e5, Hi: 0xc7ff, Stride: 1},
		{Lo: 0xc801, Hi: 0xc81b, Stride: 1},
		{Lo: 0xc81d, Hi: 0xc837, Stride: 1},
		{Lo: 0xc839, Hi: 0xc853, Stride: 1},
		{Lo: 0xc855, Hi: 0xc86f, Stride: 1},
		{Lo: 0xc871, Hi: 0xc88b, Stride: 1},
		{Lo: 0xc88d, Hi: 0xc8a7, Stride: 1},
		{Lo: 0xc8a9, Hi: 0xc8c3, Stride: 1},
		{Lo: 0xc8c5, Hi: 0xc8df, Stride: 1},
		{Lo: 0xc8e1, Hi: 0xc8fb, Stride: 1},
		{Lo: 0xc8fd, Hi: 0xc917, Stride: 1},
		{Lo: 0xc919, Hi: 0xc933, Stride: 1},
		{Lo: 0xc935, Hi: 0xc94f, Stride: 1},
		{Lo: 0xc951, Hi: 0xc96b, Stride: 1},
		{Lo: 0xc96d, Hi: 0xc987, Stride: 1},
		{Lo: 0xc989, Hi: 0xc9a3, Stride: 1},
		{Lo: 0xc9a5, Hi: 0xc9bf, Stride: 1},
		{Lo: 0xc9c1, Hi: 0xc9db, Stride: 1},
		{Lo: 0xc9dd, Hi: 0xc9f7, Stride: 1},
		{Lo: 0xc9f9, Hi: 0xca13, Stride: 1},
		{Lo: 0xca15, Hi: 0xca2f, Stride: 1},
		{Lo: 0xca31, Hi: 0xca4b, Stride: 1},
		{Lo: 0xca4d, Hi: 0xca67, Stride: 1},
		{Lo: 0xca69, Hi: 0xca83, Stride: 1},
		{Lo: 0xca85, Hi: 0xca9f, Stride: 1},
		{Lo: 0xcaa1, Hi: 0xcabb, Stride: 1},
		{Lo: 0xcabd, Hi: 0xcad7, Stride: 1},
		{Lo: 0xcad9, Hi: 0xcaf3, Stride: 1},
		{Lo: 0xcaf5, Hi: 0xcb0f, Stride: 1},
		{Lo: 0xcb11, Hi: 0xcb2b, Stride: 1},
		{Lo: 0xcb2d, Hi: 0xcb47, Stride: 1},
		{Lo: 0xcb49, Hi: 0xcb63, Stride: 1},
		{Lo: 0xcb65, Hi: 0xcb7f, Stride: 1},
		{Lo: 0xcb81, Hi: 0xcb9b, Stride: 1},
		{Lo: 0xcb9d, Hi: 0xcbb7, Stride: 1},
		{Lo: 0xcbb9, Hi: 0xcbd3, Stride: 1},
		{Lo: 0xcbd5, Hi: 0xcbef, Stride: 1},
		{Lo: 0xcbf1, Hi: 0xcc0b, Stride: 1},
		{Lo: 0xcc0d, Hi: 0xcc27, Stride: 1},
		{Lo: 0xcc29, Hi: 0xcc43, Stride: 1},
		{Lo: 0xcc45, Hi: 0xcc5f, Stride: 1},
		{Lo: 0xcc61, Hi: 0xcc7b, Stride: 1},
		{Lo: 0xcc7d, Hi: 0xcc97, Stride: 1},
		{Lo: 0xcc99, Hi: 0xccb3, Stride: 1},
		{Lo: 0xccb5, Hi: 0xcccf, Stride: 1},
		{Lo: 0xccd1, Hi: 0xcceb, Stride: 1},
		{Lo: 0xcced, Hi: 0xcd07, Stride: 1},
		{Lo: 0xcd09, Hi: 0xcd23, Stride: 1},
		{Lo: 0xcd25, Hi: 0xcd3f, Stride: 1},
		{Lo: 0xcd41, Hi: 0xcd5b, Stride: 1},
		{Lo: 0xcd5d, Hi: 0xcd77, Stride: 1},
		{Lo: 0xcd79, Hi: 0xcd93, Stride: 1},
		{Lo: 0xcd95, Hi: 0xcdaf, Stride: 1},
		{Lo: 0xcdb1, Hi: 0xcdcb, Stride: 1},
		{Lo: 0xcdcd, Hi: 0xcde7, Stride: 1},
		{Lo: 0xcde9, Hi: 0xce03, Stride: 1},
		{Lo: 0xce05, Hi: 0xce1f, Stride: 1},
		{Lo: 0xce21, Hi: 0xce3b, Stride: 1},
		{Lo: 0xce3d, Hi: 0xce57, Stride: 1},
		{Lo: 0xce59, Hi: 0xce73, Stride: 1},
		{Lo: 0xce75, Hi: 0xce8f, Stride: 1},
		{Lo: 0xce91, Hi: 0xceab, Stride: 1},
		{Lo: 0xcead, Hi: 0xcec7, Stride: 1},
		{Lo: 0xcec9, Hi: 0xcee3, Stride: 1},
		{Lo: 0xcee5, Hi: 0xceff, Stride: 1},
		{Lo: 0xcf01, Hi: 0xcf1b, Stride: 1},
		{Lo: 0xcf1d, Hi: 0xcf37, Stride: 1},
		{Lo: 0xcf39, Hi: 0xcf53, Stride: 1},
		{Lo: 0xcf55, Hi: 0xcf6f, Stride: 1},
		{Lo: 0xcf71, Hi: 0xcf8b, Stride: 1},
		{Lo: 0xcf8d, Hi: 0xcfa7, Stride: 1},
		{Lo: 0xcfa9, Hi: 0xcfc3, Stride: 1},
		{Lo: 0xcfc5, Hi: 0xcfdf, Stride: 1},
		{Lo: 0xcfe1, Hi: 0xcffb, Stride: 1},
		{Lo: 0xcffd, Hi: 0xd017, Stride: 1},
		{Lo: 0xd019, Hi: 0xd033, Stride: 1},
		{Lo: 0xd035, Hi: 0xd04f, Stride: 1},
		{Lo: 0xd051, Hi: 0xd06b, Stride: 1},
		{Lo: 0xd06d, Hi: 0xd087, Stride: 1},
		{Lo: 0xd089, Hi: 0xd0a3, Stride: 1},
		{Lo: 0xd0a5, Hi: 0xd0bf, Stride: 1},
		{Lo: 0xd0c1, Hi: 0xd0db, Stride: 1},
		{Lo: 0xd0dd, Hi: 0xd0f7, Stride: 1},
		{Lo: 0xd0f9, Hi: 0xd113, Stride: 1},
		{Lo: 0xd115, Hi: 0xd12f, Stride: 1},
		{Lo: 0xd131, Hi: 0xd14b, Stride: 1},
		{Lo: 0xd14d, Hi: 0xd167, Stride: 1},
		{Lo: 0xd169, Hi: 0xd183, Stride: 1},
		{Lo: 0xd185, Hi: 0xd19f, Stride: 1},
		{Lo: 0xd1a1, Hi: 0xd1bb, Stride: 1},
		{Lo: 0xd1bd, Hi: 0xd1d7, Stride: 1},
		{Lo: 0xd1d9, Hi: 0xd1f3, Stride: 1},
		{Lo: 0xd1f5, Hi: 0xd20f, Stride: 1},
		{Lo: 0xd211, Hi: 0xd22b, Stride: 1},
		{Lo: 0xd22d, Hi: 0xd247, Stride: 1},
		{Lo: 0xd249, Hi: 0xd263, Stride: 1},
		{Lo: 0xd265, Hi: 0xd27f, Stride: 1},
		{Lo: 0xd281, Hi: 0xd29b, Stride: 1},
		{Lo: 0xd29d, Hi: 0xd2b7, Stride: 1},
		{Lo: 0xd2b9, Hi: 0xd2d3, Stride: 1},
		{Lo: 0xd2d5, Hi: 0xd2ef, Stride: 1},
		{Lo: 0xd2f1, Hi: 0xd30b, Stride: 1},
		{Lo: 0xd30d, Hi: 0xd327, Stride: 1},
		{Lo: 0xd329, Hi: 0xd343, Stride: 1},
		{Lo: 0xd345, Hi: 0xd35f, Stride: 1},
		{Lo: 0xd361, Hi: 0xd37b, Stride: 1},
		{Lo: 0xd37d, Hi: 0xd397, Stride: 1},
		{Lo: 0xd399, Hi: 0xd3b3, Stride: 1},
		{Lo: 0xd3b5, Hi: 0xd3cf, Stride: 1},
		{Lo: 0xd3d1, Hi: 0xd3eb, Stride: 1},
		{Lo: 0xd3ed, Hi: 0xd407, Stride: 1},
		{Lo: 0xd409, Hi: 0xd423, Stride: 1},
		{Lo: 0xd425, Hi: 0xd43f, Stride: 1},
		{Lo: 0xd441, Hi: 0xd45b, Stride: 1},
		{Lo: 0xd45d, Hi: 0xd477, Stride: 1},
		{Lo: 0xd479, Hi: 0xd493, Stride: 1},
		{Lo: 0xd495, Hi: 0xd4af, Stride: 1},
		{Lo: 0xd4b1, Hi: 0xd4cb, Stride: 1},
		{Lo: 0xd4cd, Hi: 0xd4e7, Stride: 1},
		{Lo: 0xd4e9, Hi: 0xd503, Stride: 1},
		{Lo: 0xd505, Hi: 0xd51f, Stride: 1},
		{Lo: 0xd521, Hi: 0xd53b, Stride: 1},
		{Lo: 0xd53d, Hi: 0xd557, Stride: 1},
		{Lo: 0xd559, Hi: 0xd573, Stride: 1},
		{Lo: 0xd575, Hi: 0xd58f, Stride: 1},
		{Lo: 0xd591, Hi: 0xd5ab, Stride: 1},
		{Lo: 0xd5ad, Hi: 0xd5c7, Stride: 1},
		{Lo: 0xd5c9, Hi: 0xd5e3, Stride: 1},
		{Lo: 0xd5e5, Hi: 0xd5ff, Stride: 1},
		{Lo: 0xd601, Hi: 0xd61b, Stride: 1},
		{Lo: 0xd61d, Hi: 0xd637, Stride: 1},
		{Lo: 0xd639, Hi: 0xd653, Stride: 1},
		{Lo: 0xd655, Hi: 0xd66f, Stride: 1},
		{Lo: 0xd671, Hi: 0xd68b, Stride: 1},
		{Lo: 0xd68d, Hi: 0xd6a7, Stride: 1},
		{Lo: 0xd6a9, Hi: 0xd6c3, Stride: 1},
		{Lo: 0xd6c5, Hi: 0xd6df, Stride: 1},
		{Lo: 0xd6e1, Hi: 0xd6fb, Stride: 1},
		{Lo: 0xd6fd, Hi: 0xd717, Stride: 1},
		{Lo: 0xd719, Hi: 0xd733, Stride: 1},
		{Lo: 0xd735, Hi: 0xd74f, Stride: 1},
		{Lo: 0xd751, Hi: 0xd76b, Stride: 1},
		{Lo: 0xd76d, Hi: 0xd787, Stride: 1},
		{Lo: 0xd789, Hi: 0xd7a3, Stride: 1},
	},
}

// GraphemeBreakProperty: Prepend
var GraphemeBreakPrepend = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0600, Hi: 0x0605, Stride: 1},
		{Lo: 0x06dd, Hi: 0x070f, Stride: 50},
		{Lo: 0x0890, Hi: 0x0891, Stride: 1},
		{Lo: 0x08e2, Hi: 0x0d4e, Stride: 1132},
	},
	R32: []unicode.Range32{
		{Lo: 0x110bd, Hi: 0x110cd, Stride: 16},
		{Lo: 0x111c2, Hi: 0x111c3, Stride: 1},
		{Lo: 0x1193f, Hi: 0x11941, Stride: 2},
		{Lo: 0x11a3a, Hi: 0x11a84, Stride: 74},
		{Lo: 0x11a85, Hi: 0x11a89, Stride: 1},
		{Lo: 0x11d46, Hi: 0x11f02, Stride: 444},
	},
}

// GraphemeBreakProperty: Regional_Indicator
var GraphemeBreakRegional_Indicator = &unicode.RangeTable{
	R32: []unicode.Range32{
		{Lo: 0x1f1e6, Hi: 0x1f1ff, Stride: 1},
	},
}

// GraphemeBreakProperty: SpacingMark
var GraphemeBreakSpacingMark = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0903, Hi: 0x093b, Stride: 56},
		{Lo: 0x093e, Hi: 0x0940, Stride: 1},
		{Lo: 0x0949, Hi: 0x094c, Stride: 1},
		{Lo: 0x094e, Hi: 0x094f, Stride: 1},
		{Lo: 0x0982, Hi: 0x0983, Stride: 1},
		{Lo: 0x09bf, Hi: 0x09c0, Stride: 1},
		{Lo: 0x09c7, Hi: 0x09c8, Stride: 1},
		{Lo: 0x09cb, Hi: 0x09cc, Stride: 1},
		{Lo: 0x0a03, Hi: 0x0a3e, Stride: 59},
		{Lo: 0x0a3f, Hi: 0x0a40, Stride: 1},
		{Lo: 0x0a83, Hi: 0x0abe, Stride: 59},
		{Lo: 0x0abf, Hi: 0x0ac0, Stride: 1},
		{Lo: 0x0ac9, Hi: 0x0acb, Stride: 2},
		{Lo: 0x0acc, Hi: 0x0b02, Stride: 54},
		{Lo: 0x0b03, Hi: 0x0b40, Stride: 61},
		{Lo: 0x0b47, Hi: 0x0b48, Stride: 1},
		{Lo: 0x0b4b, Hi: 0x0b4c, Stride: 1},
		{Lo: 0x0bbf, Hi: 0x0bc1, Stride: 2},
		{Lo: 0x0bc2, Hi: 0x0bc6, Stride: 4},
		{Lo: 0x0bc7, Hi: 0x0bc8, Stride: 1},
		{Lo: 0x0bca, Hi: 0x0bcc, Stride: 1},
		{Lo: 0x0c01, Hi: 0x0c03, Stride: 1},
		{Lo: 0x0c41, Hi: 0x0c44, Stride: 1},
		{Lo: 0x0c82, Hi: 0x0c83, Stride: 1},
		{Lo: 0x0cbe, Hi: 0x0cc0, Stride: 2},
		{Lo: 0x0cc1, Hi: 0x0cc3, Stride: 2},
		{Lo: 0x0cc4, Hi: 0x0cc7, Stride: 3},
		{Lo: 0x0cc8, Hi: 0x0cca, Stride: 2},
		{Lo: 0x0ccb, Hi: 0x0cf3, Stride: 40},
		{Lo: 0x0d02, Hi: 0x0d03, Stride: 1},
		{Lo: 0x0d3f, Hi: 0x0d40, Stride: 1},
		{Lo: 0x0d46, Hi: 0x0d48, Stride: 1},
		{Lo: 0x0d4a, Hi: 0x0d4c, Stride: 1},
		{Lo: 0x0d82, Hi: 0x0d83, Stride: 1},
		{Lo: 0x0dd0, Hi: 0x0dd1, Stride: 1},
		{Lo: 0x0dd8, Hi: 0x0dde, Stride: 1},
		{Lo: 0x0df2, Hi: 0x0df3, Stride: 1},
		{Lo: 0x0e33, Hi: 0x0eb3, Stride: 128},
		{Lo: 0x0f3e, Hi: 0x0f3f, Stride: 1},
		{Lo: 0x0f7f, Hi: 0x1031, Stride: 178},
		{Lo: 0x103b, Hi: 0x103c, Stride: 1},
		{Lo: 0x1056, Hi: 0x1057, Stride: 1},
		{Lo: 0x1084, Hi: 0x1715, Stride: 1681},
		{Lo: 0x1734, Hi: 0x17b6, Stride: 130},
		{Lo: 0x17be, Hi: 0x17c5, Stride: 1},
		{Lo: 0x17c7, Hi: 0x17c8, Stride: 1},
		{Lo: 0x1923, Hi: 0x1926, Stride: 1},
		{Lo: 0x1929, Hi: 0x192b, Stride: 1},
		{Lo: 0x1930, Hi: 0x1931, Stride: 1},
		{Lo: 0x1933, Hi: 0x1938, Stride: 1},
		{Lo: 0x1a19, Hi: 0x1a1a, Stride: 1},
		{Lo: 0x1a55, Hi: 0x1a57, Stride: 2},
		{Lo: 0x1a6d, Hi: 0x1a72, Stride: 1},
		{Lo: 0x1b04, Hi: 0x1b3b, Stride: 55},
		{Lo: 0x1b3d, Hi: 0x1b41, Stride: 1},
		{Lo: 0x1b43, Hi: 0x1b44, Stride: 1},
		{Lo: 0x1b82, Hi: 0x1ba1, Stride: 31},
		{Lo: 0x1ba6, Hi: 0x1ba7, Stride: 1},
		{Lo: 0x1baa, Hi: 0x1be7, Stride: 61},
		{Lo: 0x1bea, Hi: 0x1bec, Stride: 1},
		{Lo: 0x1bee, Hi: 0x1bf2, Stride: 4},
		{Lo: 0x1bf3, Hi: 0x1c24, Stride: 49},
		{Lo: 0x1c25, Hi: 0x1c2b, Stride: 1},
		{Lo: 0x1c34, Hi: 0x1c35, Stride: 1},
		{Lo: 0x1ce1, Hi: 0x1cf7, Stride: 22},
		{Lo: 0xa823, Hi: 0xa824, Stride: 1},
		{Lo: 0xa827, Hi: 0xa880, Stride: 89},
		{Lo: 0xa881, Hi: 0xa8b4, Stride: 51},
		{Lo: 0xa8b5, Hi: 0xa8c3, Stride: 1},
		{Lo: 0xa952, Hi: 0xa953, Stride: 1},
		{Lo: 0xa983, Hi: 0xa9b4, Stride: 49},
		{Lo: 0xa9b5, Hi: 0xa9ba, Stride: 5},
		{Lo: 0xa9bb, Hi: 0xa9be, Stride: 3},
		{Lo: 0xa9bf, Hi: 0xa9c0, Stride: 1},
		{Lo: 0xaa2f, Hi: 0xaa30, Stride: 1},
		{Lo: 0xaa33, Hi: 0xaa34, Stride: 1},
		{Lo: 0xaa4d, Hi: 0xaaeb, Stride: 158},
		{Lo: 0xaaee, Hi: 0xaaef, Stride: 1},
		{Lo: 0xaaf5, Hi: 0xabe3, Stride: 238},
		{Lo: 0xabe4, Hi: 0xabe6, Stride: 2},
		{Lo: 0xabe7, Hi: 0xabe9, Stride: 2},
		{Lo: 0xabea, Hi: 0xabec, Stride: 2},
	},
	R32: []unicode.Range32{
		{Lo: 0x11000, Hi: 0x11002, Stride: 2},
		{Lo: 0x11082, Hi: 0x110b0, Stride: 46},
		{Lo: 0x110b1, Hi: 0x110b2, Stride: 1},
		{Lo: 0x110b7, Hi: 0x110b8, Stride: 1},
		{Lo: 0x1112c, Hi: 0x11145, Stride: 25},
		{Lo: 0x11146, Hi: 0x11182, Stride: 60},
		{Lo: 0x111b3, Hi: 0x111b5, Stride: 1},
		{Lo: 0x111bf, Hi: 0x111c0, Stride: 1},
		{Lo: 0x111ce, Hi: 0x1122c, Stride: 94},
		{Lo: 0x1122d, Hi: 0x1122e, Stride: 1},
		{Lo: 0x11232, Hi: 0x11233, Stride: 1},
		{Lo: 0x11235, Hi: 0x112e0, Stride: 171},
		{Lo: 0x112e1, Hi: 0x112e2, Stride: 1},
		{Lo: 0x11302, Hi: 0x11303, Stride: 1},
		{Lo: 0x1133f, Hi: 0x11341, Stride: 2},
		{Lo: 0x11342, Hi: 0x11344, Stride: 1},
		{Lo: 0x11347, Hi: 0x11348, Stride: 1},
		{Lo: 0x1134b, Hi: 0x1134d, Stride: 1},
		{Lo: 0x11362, Hi: 0x11363, Stride: 1},
		{Lo: 0x11435, Hi: 0x11437, Stride: 1},
		{Lo: 0x11440, Hi: 0x11441, Stride: 1},
		{Lo: 0x11445, Hi: 0x114b1, Stride: 108},
		{Lo: 0x114b2, Hi: 0x114b9, Stride: 7},
		{Lo: 0x114bb, Hi: 0x114bc, Stride: 1},
		{Lo: 0x114be, Hi: 0x114c1, Stride: 3},
		{Lo: 0x115b0, Hi: 0x115b1, Stride: 1},
		{Lo: 0x115b8, Hi: 0x115bb, Stride: 1},
		{Lo: 0x115be, Hi: 0x11630, Stride: 114},
		{Lo: 0x11631, Hi: 0x11632, Stride: 1},
		{Lo: 0x1163b, Hi: 0x1163c, Stride: 1},
		{Lo: 0x1163e, Hi: 0x116ac, Stride: 110},
		{Lo: 0x116ae, Hi: 0x116af, Stride: 1},
		{Lo: 0x116b6, Hi: 0x11726, Stride: 112},
		{Lo: 0x1182c, Hi: 0x1182e, Stride: 1},
		{Lo: 0x11838, Hi: 0x11931, Stride: 249},
		{Lo: 0x11932, Hi: 0x11935, Stride: 1},
		{Lo: 0x11937, Hi: 0x11938, Stride: 1},
		{Lo: 0x1193d, Hi: 0x11940, Stride: 3},
		{Lo: 0x11942, Hi: 0x119d1, Stride: 143},
		{Lo: 0x119d2, Hi: 0x119d3, Stride: 1},
		{Lo: 0x119dc, Hi: 0x119df, Stride: 1},
		{Lo: 0x119e4, Hi: 0x11a39, Stride: 85},
		{Lo: 0x11a57, Hi: 0x11a58, Stride: 1},
		{Lo: 0x11a97, Hi: 0x11c2f, Stride: 408},
		{Lo: 0x11c3e, Hi: 0x11ca9, Stride: 107},
		{Lo: 0x11cb1, Hi: 0x11cb4, Stride: 3},
		{Lo: 0x11d8a, Hi: 0x11d8e, Stride: 1},
		{Lo: 0x11d93, Hi: 0x11d94, Stride: 1},
		{Lo: 0x11d96, Hi: 0x11ef5, Stride: 351},
		{Lo: 0x11ef6, Hi: 0x11f03, Stride: 13},
		{Lo: 0x11f34, Hi: 0x11f35, Stride: 1},
		{Lo: 0x11f3e, Hi: 0x11f3f, Stride: 1},
		{Lo: 0x11f41, Hi: 0x16f51, Stride: 20496},
		{Lo: 0x16f52, Hi: 0x16f87, Stride: 1},
		{Lo: 0x16ff0, Hi: 0x16ff1, Stride: 1},
		{Lo: 0x1d166, Hi: 0x1d16d, Stride: 7},
	},
}

// GraphemeBreakProperty: T
var GraphemeBreakT = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x11a8, Hi: 0x11ff, Stride: 1},
		{Lo: 0xd7cb, Hi: 0xd7fb, Stride: 1},
	},
}

// GraphemeBreakProperty: V
var GraphemeBreakV = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x1160, Hi: 0x11a7, Stride: 1},
		{Lo: 0xd7b0, Hi: 0xd7c6, Stride: 1},
	},
}

// GraphemeBreakProperty: ZWJ
var GraphemeBreakZWJ = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x200d, Hi: 0x200d, Stride: 1},
	},
}

// contains all the runes having a non nil grapheme break property
var graphemeBreakAll = &unicode.RangeTable{
	R16: []unicode.Range16{
		{Lo: 0x0000, Hi: 0x001f, Stride: 1},
		{Lo: 0x007f, Hi: 0x009f, Stride: 1},
		{Lo: 0x00ad, Hi: 0x00ad, Stride: 1},
		{Lo: 0x0300, Hi: 0x036f, Stride: 1},
		{Lo: 0x0483, Hi: 0x0489, Stride: 1},
		{Lo: 0x0591, Hi: 0x05bd, Stride: 1},
		{Lo: 0x05bf, Hi: 0x05c1, Stride: 2},
		{Lo: 0x05c2, Hi: 0x05c4, Stride: 2},
		{Lo: 0x05c5, Hi: 0x05c7, Stride: 2},
		{Lo: 0x0600, Hi: 0x0605, Stride: 1},
		{Lo: 0x0610, Hi: 0x061a, Stride: 1},
		{Lo: 0x061c, Hi: 0x061c, Stride: 1},
		{Lo: 0x064b, Hi: 0x065f, Stride: 1},
		{Lo: 0x0670, Hi: 0x06d6, Stride: 102},
		{Lo: 0x06d7, Hi: 0x06dd, Stride: 1},
		{Lo: 0x06df, Hi: 0x06e4, Stride: 1},
		{Lo: 0x06e7, Hi: 0x06e8, Stride: 1},
		{Lo: 0x06ea, Hi: 0x06ed, Stride: 1},
		{Lo: 0x070f, Hi: 0x070f, Stride: 1},
		{Lo: 0x0711, Hi: 0x0730, Stride: 31},
		{Lo: 0x0731, Hi: 0x074a, Stride: 1},
		{Lo: 0x07a6, Hi: 0x07b0, Stride: 1},
		{Lo: 0x07eb, Hi: 0x07f3, Stride: 1},
		{Lo: 0x07fd, Hi: 0x0816, Stride: 25},
		{Lo: 0x0817, Hi: 0x0819, Stride: 1},
		{Lo: 0x081b, Hi: 0x0823, Stride: 1},
		{Lo: 0x0825, Hi: 0x0827, Stride: 1},
		{Lo: 0x0829, Hi: 0x082d, Stride: 1},
		{Lo: 0x0859, Hi: 0x085b, Stride: 1},
		{Lo: 0x0890, Hi: 0x0891, Stride: 1},
		{Lo: 0x0898, Hi: 0x089f, Stride: 1},
		{Lo: 0x08ca, Hi: 0x0903, Stride: 1},
		{Lo: 0x093a, Hi: 0x093c, Stride: 1},
		{Lo: 0x093e, Hi: 0x094f, Stride: 1},
		{Lo: 0x0951, Hi: 0x0957, Stride: 1},
		{Lo: 0x0962, Hi: 0x0963, Stride: 1},
		{Lo: 0x0981, Hi: 0x0983, Stride: 1},
		{Lo: 0x09bc, Hi: 0x09be, Stride: 2},
		{Lo: 0x09bf, Hi: 0x09c4, Stride: 1},
		{Lo: 0x09c7, Hi: 0x09c8, Stride: 1},
		{Lo: 0x09cb, Hi: 0x09cd, Stride: 1},
		{Lo: 0x09d7, Hi: 0x09d7, Stride: 10},
		{Lo: 0x09e2, Hi: 0x09e3, Stride: 1},
		{Lo: 0x09fe, Hi: 0x0a01, Stride: 3},
		{Lo: 0x0a02, Hi: 0x0a03, Stride: 1},
		{Lo: 0x0a3c, Hi: 0x0a3e, Stride: 2},
		{Lo: 0x0a3f, Hi: 0x0a42, Stride: 1},
		{Lo: 0x0a47, Hi: 0x0a48, Stride: 1},
		{Lo: 0x0a4b, Hi: 0x0a4d, Stride: 1},
		{Lo: 0x0a51, Hi: 0x0a70, Stride: 31},
		{Lo: 0x0a71, Hi: 0x0a75, Stride: 4},
		{Lo: 0x0a81, Hi: 0x0a83, Stride: 1},
		{Lo: 0x0abc, Hi: 0x0abe, Stride: 2},
		{Lo: 0x0abf, Hi: 0x0ac5, Stride: 1},
		{Lo: 0x0ac7, Hi: 0x0ac9, Stride: 1},
		{Lo: 0x0acb, Hi: 0x0acd, Stride: 1},
		{Lo: 0x0ae2, Hi: 0x0ae2, Stride: 21},
		{Lo: 0x0ae3, Hi: 0x0afa, Stride: 23},
		{Lo: 0x0afb, Hi: 0x0aff, Stride: 1},
		{Lo: 0x0b01, Hi: 0x0b03, Stride: 1},
		{Lo: 0x0b3c, Hi: 0x0b3c, Stride: 1},
		{Lo: 0x0b3e, Hi: 0x0b44, Stride: 1},
		{Lo: 0x0b47, Hi: 0x0b48, Stride: 1},
		{Lo: 0x0b4b, Hi: 0x0b4d, Stride: 1},
		{Lo: 0x0b55, Hi: 0x0b57, Stride: 1},
		{Lo: 0x0b62, Hi: 0x0b63, Stride: 1},
		{Lo: 0x0b82, Hi: 0x0bbe, Stride: 60},
		{Lo: 0x0bbf, Hi: 0x0bc2, Stride: 1},
		{Lo: 0x0bc6, Hi: 0x0bc8, Stride: 1},
		{Lo: 0x0bca, Hi: 0x0bcd, Stride: 1},
		{Lo: 0x0bd7, Hi: 0x0c00, Stride: 41},
		{Lo: 0x0c01, Hi: 0x0c04, Stride: 1},
		{Lo: 0x0c3c, Hi: 0x0c3c, Stride: 56},
		{Lo: 0x0c3e, Hi: 0x0c44, Stride: 1},
		{Lo: 0x0c46, Hi: 0x0c48, Stride: 1},
		{Lo: 0x0c4a, Hi: 0x0c4d, Stride: 1},
		{Lo: 0x0c55, Hi: 0x0c56, Stride: 1},
		{Lo: 0x0c62, Hi: 0x0c63, Stride: 1},
		{Lo: 0x0c81, Hi: 0x0c83, Stride: 1},
		{Lo: 0x0cbc, Hi: 0x0cbe, Stride: 2},
		{Lo: 0x0cbf, Hi: 0x0cc4, Stride: 1},
		{Lo: 0x0cc6, Hi: 0x0cc8, Stride: 1},
		{Lo: 0x0cca, Hi: 0x0ccd, Stride: 1},
		{Lo: 0x0cd5, Hi: 0x0cd5, Stride: 8},
		{Lo: 0x0cd6, Hi: 0x0ce2, Stride: 12},
		{Lo: 0x0ce3, Hi: 0x0cf3, Stride: 16},
		{Lo: 0x0d00, Hi: 0x0d03, Stride: 1},
		{Lo: 0x0d3b, Hi: 0x0d3c, Stride: 1},
		{Lo: 0x0d3e, Hi: 0x0d44, Stride: 1},
		{Lo: 0x0d46, Hi: 0x0d48, Stride: 1},
		{Lo: 0x0d4a, Hi: 0x0d4e, Stride: 1},
		{Lo: 0x0d57, Hi: 0x0d57, Stride: 1},
		{Lo: 0x0d62, Hi: 0x0d63, Stride: 1},
		{Lo: 0x0d81, Hi: 0x0d83, Stride: 1},
		{Lo: 0x0dca, Hi: 0x0dcf, Stride: 5},
		{Lo: 0x0dd0, Hi: 0x0dd4, Stride: 1},
		{Lo: 0x0dd6, Hi: 0x0dd6, Stride: 1},
		{Lo: 0x0dd8, Hi: 0x0ddf, Stride: 1},
		{Lo: 0x0df2, Hi: 0x0df3, Stride: 1},
		{Lo: 0x0e31, Hi: 0x0e33, Stride: 2},
		{Lo: 0x0e34, Hi: 0x0e3a, Stride: 1},
		{Lo: 0x0e47, Hi: 0x0e4e, Stride: 1},
		{Lo: 0x0eb1, Hi: 0x0eb3, Stride: 2},
		{Lo: 0x0eb4, Hi: 0x0ebc, Stride: 1},
		{Lo: 0x0ec8, Hi: 0x0ece, Stride: 1},
		{Lo: 0x0f18, Hi: 0x0f19, Stride: 1},
		{Lo: 0x0f35, Hi: 0x0f39, Stride: 2},
		{Lo: 0x0f3e, Hi: 0x0f3f, Stride: 1},
		{Lo: 0x0f71, Hi: 0x0f84, Stride: 1},
		{Lo: 0x0f86, Hi: 0x0f87, Stride: 1},
		{Lo: 0x0f8d, Hi: 0x0f97, Stride: 1},
		{Lo: 0x0f99, Hi: 0x0fbc, Stride: 1},
		{Lo: 0x0fc6, Hi: 0x102d, Stride: 103},
		{Lo: 0x102e, Hi: 0x1037, Stride: 1},
		{Lo: 0x1039, Hi: 0x103e, Stride: 1},
		{Lo: 0x1056, Hi: 0x1059, Stride: 1},
		{Lo: 0x105e, Hi: 0x1060, Stride: 1},
		{Lo: 0x1071, Hi: 0x1074, Stride: 1},
		{Lo: 0x1082, Hi: 0x1084, Stride: 2},
		{Lo: 0x1085, Hi: 0x1086, Stride: 1},
		{Lo: 0x108d, Hi: 0x109d, Stride: 16},
		{Lo: 0x1100, Hi: 0x11ff, Stride: 1},
		{Lo: 0x135d, Hi: 0x135f, Stride: 1},
		{Lo: 0x1712, Hi: 0x1715, Stride: 1},
		{Lo: 0x1732, Hi: 0x1734, Stride: 1},
		{Lo: 0x1752, Hi: 0x1753, Stride: 1},
		{Lo: 0x1772, Hi: 0x1773, Stride: 1},
		{Lo: 0x17b4, Hi: 0x17d3, Stride: 1},
		{Lo: 0x17dd, Hi: 0x180b, Stride: 46},
		{Lo: 0x180c, Hi: 0x180f, Stride: 1},
		{Lo: 0x1885, Hi: 0x1885, Stride: 118},
		{Lo: 0x1886, Hi: 0x18a9, Stride: 35},
		{Lo: 0x1920, Hi: 0x192b, Stride: 1},
		{Lo: 0x1930, Hi: 0x193b, Stride: 1},
		{Lo: 0x1a17, Hi: 0x1a1b, Stride: 1},
		{Lo: 0x1a55, Hi: 0x1a5e, Stride: 1},
		{Lo: 0x1a60, Hi: 0x1a62, Stride: 2},
		{Lo: 0x1a65, Hi: 0x1a7c, Stride: 1},
		{Lo: 0x1a7f, Hi: 0x1ab0, Stride: 49},
		{Lo: 0x1ab1, Hi: 0x1ace, Stride: 1},
		{Lo: 0x1b00, Hi: 0x1b04, Stride: 1},
		{Lo: 0x1b34, Hi: 0x1b44, Stride: 1},
		{Lo: 0x1b6b, Hi: 0x1b73, Stride: 1},
		{Lo: 0x1b80, Hi: 0x1b82, Stride: 1},
		{Lo: 0x1ba1, Hi: 0x1bad, Stride: 1},
		{Lo: 0x1be6, Hi: 0x1bf3, Stride: 1},
		{Lo: 0x1c24, Hi: 0x1c37, Stride: 1},
		{Lo: 0x1cd0, Hi: 0x1cd2, Stride: 1},
		{Lo: 0x1cd4, Hi: 0x1ce8, Stride: 1},
		{Lo: 0x1ced, Hi: 0x1cf4, Stride: 7},
		{Lo: 0x1cf7, Hi: 0x1cf9, Stride: 1},
		{Lo: 0x1dc0, Hi: 0x1dff, Stride: 1},
		{Lo: 0x200b, Hi: 0x200f, Stride: 1},
		{Lo: 0x2028, Hi: 0x202e, Stride: 1},
		{Lo: 0x2060, Hi: 0x206f, Stride: 1},
		{Lo: 0x20d0, Hi: 0x20f0, Stride: 1},
		{Lo: 0x2cef, Hi: 0x2cf1, Stride: 1},
		{Lo: 0x2d7f, Hi: 0x2de0, Stride: 97},
		{Lo: 0x2de1, Hi: 0x2dff, Stride: 1},
		{Lo: 0x302a, Hi: 0x302f, Stride: 1},
		{Lo: 0x3099, Hi: 0x309a, Stride: 1},
		{Lo: 0xa66f, Hi: 0xa672, Stride: 1},
		{Lo: 0xa674, Hi: 0xa67d, Stride: 1},
		{Lo: 0xa69e, Hi: 0xa69f, Stride: 1},
		{Lo: 0xa6f0, Hi: 0xa6f1, Stride: 1},
		{Lo: 0xa802, Hi: 0xa806, Stride: 4},
		{Lo: 0xa80b, Hi: 0xa80b, Stride: 1},
		{Lo: 0xa823, Hi: 0xa827, Stride: 1},
		{Lo: 0xa82c, Hi: 0xa880, Stride: 84},
		{Lo: 0xa881, Hi: 0xa8b4, Stride: 51},
		{Lo: 0xa8b5, Hi: 0xa8c5, Stride: 1},
		{Lo: 0xa8e0, Hi: 0xa8f1, Stride: 1},
		{Lo: 0xa8ff, Hi: 0xa926, Stride: 39},
		{Lo: 0xa927, Hi: 0xa92d, Stride: 1},
		{Lo: 0xa947, Hi: 0xa953, Stride: 1},
		{Lo: 0xa960, Hi: 0xa97c, Stride: 1},
		{Lo: 0xa980, Hi: 0xa983, Stride: 1},
		{Lo: 0xa9b3, Hi: 0xa9c0, Stride: 1},
		{Lo: 0xa9e5, Hi: 0xaa29, Stride: 68},
		{Lo: 0xaa2a, Hi: 0xaa36, Stride: 1},
		{Lo: 0xaa43, Hi: 0xaa4c, Stride: 9},
		{Lo: 0xaa4d, Hi: 0xaa4d, Stride: 1},
		{Lo: 0xaa7c, Hi: 0xaab0, Stride: 52},
		{Lo: 0xaab2, Hi: 0xaab4, Stride: 1},
		{Lo: 0xaab7, Hi: 0xaab8, Stride: 1},
		{Lo: 0xaabe, Hi: 0xaabf, Stride: 1},
		{Lo: 0xaac1, Hi: 0xaaeb, Stride: 42},
		{Lo: 0xaaec, Hi: 0xaaef, Stride: 1},
		{Lo: 0xaaf5, Hi: 0xaaf6, Stride: 1},
		{Lo: 0xabe3, Hi: 0xabea, Stride: 1},
		{Lo: 0xabec, Hi: 0xabed, Stride: 1},
		{Lo: 0xac00, Hi: 0xd7a3, Stride: 1},
		{Lo: 0xd7b0, Hi: 0xd7c6, Stride: 1},
		{Lo: 0xd7cb, Hi: 0xd7fb, Stride: 1},
		{Lo: 0xfb1e, Hi: 0xfb1e, Stride: 1},
		{Lo: 0xfe00, Hi: 0xfe0f, Stride: 1},
		{Lo: 0xfe20, Hi: 0xfe2f, Stride: 1},
		{Lo: 0xfeff, Hi: 0xfeff, Stride: 1},
		{Lo: 0xff9e, Hi: 0xff9f, Stride: 1},
		{Lo: 0xfff0, Hi: 0xfffb, Stride: 1},
	},
	R32: []unicode.Range32{
		{Lo: 0x101fd, Hi: 0x102e0, Stride: 227},
		{Lo: 0x10376, Hi: 0x1037a, Stride: 1},
		{Lo: 0x10a01, Hi: 0x10a03, Stride: 1},
		{Lo: 0x10a05, Hi: 0x10a06, Stride: 1},
		{Lo: 0x10a0c, Hi: 0x10a0f, Stride: 1},
		{Lo: 0x10a38, Hi: 0x10a3a, Stride: 1},
		{Lo: 0x10a3f, Hi: 0x10ae5, Stride: 166},
		{Lo: 0x10ae6, Hi: 0x10d24, Stride: 574},
		{Lo: 0x10d25, Hi: 0x10d27, Stride: 1},
		{Lo: 0x10eab, Hi: 0x10eac, Stride: 1},
		{Lo: 0x10efd, Hi: 0x10eff, Stride: 1},
		{Lo: 0x10f46, Hi: 0x10f50, Stride: 1},
		{Lo: 0x10f82, Hi: 0x10f85, Stride: 1},
		{Lo: 0x11000, Hi: 0x11002, Stride: 1},
		{Lo: 0x11038, Hi: 0x11046, Stride: 1},
		{Lo: 0x11070, Hi: 0x11073, Stride: 3},
		{Lo: 0x11074, Hi: 0x1107f, Stride: 11},
		{Lo: 0x11080, Hi: 0x11082, Stride: 1},
		{Lo: 0x110b0, Hi: 0x110ba, Stride: 1},
		{Lo: 0x110bd, Hi: 0x110c2, Stride: 5},
		{Lo: 0x110cd, Hi: 0x11100, Stride: 51},
		{Lo: 0x11101, Hi: 0x11102, Stride: 1},
		{Lo: 0x11127, Hi: 0x11134, Stride: 1},
		{Lo: 0x11145, Hi: 0x11146, Stride: 1},
		{Lo: 0x11173, Hi: 0x11180, Stride: 13},
		{Lo: 0x11181, Hi: 0x11182, Stride: 1},
		{Lo: 0x111b3, Hi: 0x111c0, Stride: 1},
		{Lo: 0x111c2, Hi: 0x111c3, Stride: 1},
		{Lo: 0x111c9, Hi: 0x111cc, Stride: 1},
		{Lo: 0x111ce, Hi: 0x111cf, Stride: 1},
		{Lo: 0x1122c, Hi: 0x11237, Stride: 1},
		{Lo: 0x1123e, Hi: 0x1123e, Stride: 7},
		{Lo: 0x11241, Hi: 0x112df, Stride: 158},
		{Lo: 0x112e0, Hi: 0x112ea, Stride: 1},
		{Lo: 0x11300, Hi: 0x11303, Stride: 1},
		{Lo: 0x1133b, Hi: 0x1133c, Stride: 1},
		{Lo: 0x1133e, Hi: 0x11344, Stride: 1},
		{Lo: 0x11347, Hi: 0x11348, Stride: 1},
		{Lo: 0x1134b, Hi: 0x1134d, Stride: 1},
		{Lo: 0x11357, Hi: 0x11357, Stride: 1},
		{Lo: 0x11362, Hi: 0x11363, Stride: 1},
		{Lo: 0x11366, Hi: 0x1136c, Stride: 1},
		{Lo: 0x11370, Hi: 0x11374, Stride: 1},
		{Lo: 0x11435, Hi: 0x11446, Stride: 1},
		{Lo: 0x1145e, Hi: 0x114b0, Stride: 82},
		{Lo: 0x114b1, Hi: 0x114c3, Stride: 1},
		{Lo: 0x115af, Hi: 0x115b5, Stride: 1},
		{Lo: 0x115b8, Hi: 0x115c0, Stride: 1},
		{Lo: 0x115dc, Hi: 0x115dd, Stride: 1},
		{Lo: 0x11630, Hi: 0x11640, Stride: 1},
		{Lo: 0x116ab, Hi: 0x116b7, Stride: 1},
		{Lo: 0x1171d, Hi: 0x1171f, Stride: 1},
		{Lo: 0x11722, Hi: 0x1172b, Stride: 1},
		{Lo: 0x1182c, Hi: 0x1183a, Stride: 1},
		{Lo: 0x11930, Hi: 0x11935, Stride: 1},
		{Lo: 0x11937, Hi: 0x11938, Stride: 1},
		{Lo: 0x1193b, Hi: 0x11943, Stride: 1},
		{Lo: 0x119d1, Hi: 0x119d7, Stride: 1},
		{Lo: 0x119da, Hi: 0x119e0, Stride: 1},
		{Lo: 0x119e4, Hi: 0x11a01, Stride: 29},
		{Lo: 0x11a02, Hi: 0x11a0a, Stride: 1},
		{Lo: 0x11a33, Hi: 0x11a3e, Stride: 1},
		{Lo: 0x11a47, Hi: 0x11a51, Stride: 10},
		{Lo: 0x11a52, Hi: 0x11a5b, Stride: 1},
		{Lo: 0x11a84, Hi: 0x11a99, Stride: 1},
		{Lo: 0x11c2f, Hi: 0x11c36, Stride: 1},
		{Lo: 0x11c38, Hi: 0x11c3f, Stride: 1},
		{Lo: 0x11c92, Hi: 0x11ca7, Stride: 1},
		{Lo: 0x11ca9, Hi: 0x11cb6, Stride: 1},
		{Lo: 0x11d31, Hi: 0x11d36, Stride: 1},
		{Lo: 0x11d3a, Hi: 0x11d3c, Stride: 2},
		{Lo: 0x11d3d, Hi: 0x11d3f, Stride: 2},
		{Lo: 0x11d40, Hi: 0x11d47, Stride: 1},
		{Lo: 0x11d8a, Hi: 0x11d8e, Stride: 1},
		{Lo: 0x11d90, Hi: 0x11d91, Stride: 1},
		{Lo: 0x11d93, Hi: 0x11d97, Stride: 1},
		{Lo: 0x11ef3, Hi: 0x11ef6, Stride: 1},
		{Lo: 0x11f00, Hi: 0x11f03, Stride: 1},
		{Lo: 0x11f34, Hi: 0x11f3a, Stride: 1},
		{Lo: 0x11f3e, Hi: 0x11f42, Stride: 1},
		{Lo: 0x13430, Hi: 0x13440, Stride: 1},
		{Lo: 0x13447, Hi: 0x13455, Stride: 1},
		{Lo: 0x16af0, Hi: 0x16af4, Stride: 1},
		{Lo: 0x16b30, Hi: 0x16b36, Stride: 1},
		{Lo: 0x16f4f, Hi: 0x16f51, Stride: 2},
		{Lo: 0x16f52, Hi: 0x16f87, Stride: 1},
		{Lo: 0x16f8f, Hi: 0x16f92, Stride: 1},
		{Lo: 0x16fe4, Hi: 0x16fe4, Stride: 1},
		{Lo: 0x16ff0, Hi: 0x16ff1, Stride: 1},
		{Lo: 0x1bc9d, Hi: 0x1bc9e, Stride: 1},
		{Lo: 0x1bca0, Hi: 0x1bca3, Stride: 1},
		{Lo: 0x1cf00, Hi: 0x1cf2d, Stride: 1},
		{Lo: 0x1cf30, Hi: 0x1cf46, Stride: 1},
		{Lo: 0x1d165, Hi: 0x1d169, Stride: 1},
		{Lo: 0x1d16d, Hi: 0x1d182, Stride: 1},
		{Lo: 0x1d185, Hi: 0x1d18b, Stride: 1},
		{Lo: 0x1d1aa, Hi: 0x1d1ad, Stride: 1},
		{Lo: 0x1d242, Hi: 0x1d244, Stride: 1},
		{Lo: 0x1da00, Hi: 0x1da36, Stride: 1},
		{Lo: 0x1da3b, Hi: 0x1da6c, Stride: 1},
		{Lo: 0x1da75, Hi: 0x1da84, Stride: 15},
		{Lo: 0x1da9b, Hi: 0x1da9f, Stride: 1},
		{Lo: 0x1daa1, Hi: 0x1daaf, Stride: 1},
		{Lo: 0x1e000, Hi: 0x1e006, Stride: 1},
		{Lo: 0x1e008, Hi: 0x1e018, Stride: 1},
		{Lo: 0x1e01b, Hi: 0x1e021, Stride: 1},
		{Lo: 0x1e023, Hi: 0x1e024, Stride: 1},
		{Lo: 0x1e026, Hi: 0x1e02a, Stride: 1},
		{Lo: 0x1e08f, Hi: 0x1e130, Stride: 161},
		{Lo: 0x1e131, Hi: 0x1e136, Stride: 1},
		{Lo: 0x1e2ae, Hi: 0x1e2ec, Stride: 62},
		{Lo: 0x1e2ed, Hi: 0x1e2ef, Stride: 1},
		{Lo: 0x1e4ec, Hi: 0x1e4ef, Stride: 1},
		{Lo: 0x1e8d0, Hi: 0x1e8d6, Stride: 1},
		{Lo: 0x1e944, Hi: 0x1e94a, Stride: 1},
		{Lo: 0x1f1e6, Hi: 0x1f1ff, Stride: 1},
		{Lo: 0x1f3fb, Hi: 0x1f3ff, Stride: 1},
		{Lo: 0xe0000, Hi: 0xe0fff, Stride: 1},
	},
	LatinOffset: 3,
}

var graphemeBreaks = [...]*unicode.RangeTable{
	GraphemeBreakCR,                 // CR
	GraphemeBreakControl,            // Control
	GraphemeBreakExtend,             // Extend
	GraphemeBreakL,                  // L
	GraphemeBreakLF,                 // LF
	GraphemeBreakLV,                 // LV
	GraphemeBreakLVT,                // LVT
	GraphemeBreakPrepend,            // Prepend
	GraphemeBreakRegional_Indicator, // Regional_Indicator
	GraphemeBreakSpacingMark,        // SpacingMark
	GraphemeBreakT,                  // T
	GraphemeBreakV,                  // V
	GraphemeBreakZWJ,                // ZWJ
}
