package fontscan

import "github.com/go-text/typesetting/language"

// Copyright © 2002 Keith Packard
//
// Permission to use, copy, modify, distribute, and sell this software and its
// documentation for any purpose is hereby granted without fee, provided that
// the above copyright notice appear in all copies and that both that
// copyright notice and this permission notice appear in supporting
// documentation, and that the name of the author(s) not be used in
// advertising or publicity pertaining to distribution of the software without
// specific, written prior permission.  The authors make no
// representations about the suitability of this software for any purpose.  It
// is provided "as is" without express or implied warranty.
//
// THE AUTHOR(S) DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
// INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
// EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY SPECIAL, INDIRECT OR
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
// DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
// TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// languagesRunes stores the runes commonly used to write a language
var languagesRunes = [...]struct {
	lang  language.Language
	runes RuneSet // sorted, inclusive ranges
}{
	{ /** index: 0 */
		"aa",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x08104404, 0x08104404}},
		},
	},
	{ /** index: 1 */
		"ab",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff8002, 0xffffffff, 0x8002ffff, 0x00000000, 0xc0000000, 0xf0fc33c0, 0x03000000, 0x00000003}},
		},
	},
	{ /** index: 2 */
		"af",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x0810cf00, 0x0810cf00}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 3 */
		"agr",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x04000000}},
		},
	},
	{ /** index: 4 */
		"ak",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00220008, 0x00220008}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000300, 0x00000000, 0x00000300, 0x00010040, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00000048, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x30000000, 0x00000000, 0x03000000}},
		},
	},
	{ /** index: 5 */
		"am",
		RuneSet{
			{ref: 0x0012, set: pageSet{0xff7fff7f, 0xff01ff7f, 0x00003d7f, 0xffff7fff, 0xffff3d7f, 0x003d7fff, 0xff7f7f00, 0x00ff7fff}},
			{ref: 0x0013, set: pageSet{0x003d7fff, 0xffffffff, 0x007fff7f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 6 */
		"an",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x140a2202, 0x140a2202}},
		},
	},
	{ /** index: 7 */
		"anp",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 8 */
		"ar",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07fffffe, 0x000007fe, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 9 */
		"as",
		RuneSet{
			{ref: 0x0009, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfff99fee, 0xd3c4fdff, 0xb000399f, 0x00030000}},
		},
	},
	{ /** index: 10 */
		"ast",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x140a2202, 0x140a2202}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00c00030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 11 */
		"av",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0042, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 12 */
		"ay",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10028010, 0x10028010}},
		},
	},
	{ /** index: 13 */
		"ayc",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x10028010}},
		},
	},
	{ /** index: 14 */
		"az-az",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10400080, 0x10400080}},
			{ref: 0x0001, set: pageSet{0xc0000000, 0x00030000, 0xc0000000, 0x00000000, 0x00008000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 15 */
		"az-ir",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07ffffde, 0x001009f6, 0x40000000, 0x01000040, 0x00008200, 0x00001000, 0x00000000}},
		},
	},
	{ /** index: 16 */
		"ba",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0000, 0xffffffff, 0x0000ffff, 0x00000000, 0x030c0000, 0x0c00cc0f, 0x03000000, 0x00000300}},
		},
	},
	{ /** index: 17 */
		"be",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff4040, 0xffffffff, 0x4040ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 18 */
		"bem",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 19 */
		"ber-dz",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00110000, 0x00000000, 0x00000000, 0x000000c0}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08000000, 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00003000, 0x00000030, 0x00000000, 0x0000300c, 0x000c0000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 20 */
		"ber-ma",
		RuneSet{
			{ref: 0x002d, set: pageSet{0x00000000, 0x3a8b0000, 0x9e78e6b9, 0x0000802e, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 21 */
		"bg",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0000, 0xffffd7ff, 0x0000d7ff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 22 */
		"bh",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 23 */
		"bhb",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 24 */
		"bho",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 25 */
		"bi",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10008200, 0x10008200}},
		},
	},
	{ /** index: 26 */
		"bin",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x060c3303, 0x060c3303}},
			{ref: 0x0003, set: pageSet{0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x00003000, 0x00000000}},
		},
	},
	{ /** index: 27 */
		"bm",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000c00, 0x00000000, 0x20010040, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08100000, 0x00040000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 28 */
		"bn",
		RuneSet{
			{ref: 0x0009, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfff99fee, 0xd3c5fdff, 0xb000399f, 0x00000000}},
		},
	},
	{ /** index: 29 */
		"bo",
		RuneSet{
			{ref: 0x000f, set: pageSet{0x00000000, 0x00000000, 0xfffffeff, 0x3d7e03ff, 0xfeff0003, 0x03ffffff, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 30 */
		"br",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x12120404, 0x12120404}},
		},
	},
	{ /** index: 31 */
		"brx",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xfff99fee, 0xf3e5fdff, 0x0007399f, 0x0001ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 32 */
		"bs",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000330c0, 0x00000000, 0x00000000, 0x60000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 33 */
		"bua",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x0c00c000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 34 */
		"byn",
		RuneSet{
			{ref: 0x0012, set: pageSet{0xff7fff7f, 0xff01ff00, 0x3d7f3d7f, 0xffff7fff, 0xffff0000, 0x003d7fff, 0xff7f7f3d, 0x00ff7fff}},
			{ref: 0x0013, set: pageSet{0x003d7fff, 0xffffffff, 0x007fff00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 35 */
		"ca",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x140ca381, 0x140ca381}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x80000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 36 */
		"ce",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0042, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 37 */
		"ch",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10020004, 0x10020004}},
		},
	},
	{ /** index: 38 */
		"chm",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000030, 0x000c0000, 0x030300c0}},
		},
	},
	{ /** index: 39 */
		"chr",
		RuneSet{
			{ref: 0x0013, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0x001fffff}},
		},
	},
	{ /** index: 40 */
		"ckb",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x061ef5c0, 0x000001f6, 0x40000000, 0x01040040, 0x00208210, 0x00005040, 0x00000000}},
		},
	},
	{ /** index: 41 */
		"cmn",
		RuneSet{
			{ref: 0x004e, set: pageSet{0xc373ff8b, 0x1b0f6840, 0xf34ce9ac, 0xc0080200, 0xca3e795c, 0x06487976, 0xf7f02fdf, 0xa8ff033a}},
			{ref: 0x004f, set: pageSet{0x233fef37, 0xfd59b004, 0xfffff3ca, 0xfff9de9f, 0x7df7abff, 0x8eecc000, 0xffdbeebf, 0x45fad003}},
			{ref: 0x0050, set: pageSet{0xdffefae1, 0x10abbfef, 0xfcaaffeb, 0x24fdef3f, 0x7f7678ad, 0xedfff00c, 0x2cfacff6, 0xeb6bf7f9}},
			{ref: 0x0051, set: pageSet{0x95bf1ffd, 0xbfbf6677, 0xfeb43bfb, 0x11e27bae, 0x41bea681, 0x72c31435, 0x71917d70, 0x276b0003}},
			{ref: 0x0052, set: pageSet{0x70cf57cb, 0x0def4732, 0xfc747eda, 0xbdb4fe06, 0x8bca3f9f, 0x58007e49, 0xebec228f, 0xddbb8a5c}},
			{ref: 0x0053, set: pageSet{0xb6e7ef60, 0xf293a40f, 0x549e37bb, 0x9bafd04b, 0xf7d4c414, 0x0a1430b0, 0x88d02f08, 0x192fff7e}},
			{ref: 0x0054, set: pageSet{0xfb07ffda, 0x7beb7ff1, 0x0010c5ef, 0xfdff99ff, 0x056779d7, 0xfdcbffe7, 0x4040c3ff, 0xbd8e6ff7}},
			{ref: 0x0055, set: pageSet{0x0497dffa, 0x5bfff4c0, 0xd0e7ed7b, 0xf8e0047e, 0xb73eff9f, 0x882e7dfe, 0xbe7ffffd, 0xf6c483fe}},
			{ref: 0x0056, set: pageSet{0xb8fdf357, 0xef7dd680, 0x47885767, 0xc3dfff7d, 0x37a9f0ff, 0x70fc7de0, 0xec9a3f6f, 0x86814cb3}},
			{ref: 0x0057, set: pageSet{0xdd5c3f9e, 0x4819f70d, 0x0007fea3, 0x38ffaf56, 0xefb8980d, 0xb760403d, 0x9035d8ce, 0x3fff72bf}},
			{ref: 0x0058, set: pageSet{0x7a117ff7, 0xabfff7bb, 0x6fbeff00, 0xfe72a93c, 0xf11bcfef, 0xf40adb6b, 0xef7ec3e6, 0xf6109b9c}},
			{ref: 0x0059, set: pageSet{0x16f4f048, 0x5182feb5, 0x15bbc7b1, 0xfbdf6e87, 0x63cde43f, 0x7e7ec1ff, 0x7d5ffdeb, 0xfcfe777b}},
			{ref: 0x005a, set: pageSet{0xdbea960b, 0x53e86229, 0xfdef37df, 0xbd8136f5, 0xfcbddc18, 0xffffd2e4, 0xffe03fd7, 0xabf87f6f}},
			{ref: 0x005b, set: pageSet{0x6ed99bae, 0xf115f5fb, 0xbdfb79a9, 0xadaf5a3c, 0x1facdbba, 0x837971fc, 0xc35f7cf7, 0x0567dfff}},
			{ref: 0x005c, set: pageSet{0x8467ff9a, 0xdf8b1534, 0x3373f9f3, 0x5e1af7bd, 0xa03fbf40, 0x01ebffff, 0xcfdddfc0, 0xabd37500}},
			{ref: 0x005d, set: pageSet{0xeed6f8c3, 0xb7ff43fd, 0x42275eaf, 0xf6869bac, 0xf6bc27d7, 0x35b7f787, 0xe176aacd, 0xe29f49e7}},
			{ref: 0x005e, set: pageSet{0xaff2545c, 0x61d82b3f, 0xbbb8fc3b, 0x7b7dffcf, 0x1ce0bf95, 0x43ff7dfd, 0xfffe5ff6, 0xc4ced3ef}},
			{ref: 0x005f, set: pageSet{0xadbc8db6, 0x11eb63dc, 0x23d0df59, 0xf3dbbeb4, 0xdbc71fe7, 0xfae4ff63, 0x63f7b22b, 0xadbaed3b}},
			{ref: 0x0060, set: pageSet{0x7efffe01, 0x02bcfff7, 0xef3932ff, 0x8005fffc, 0xbcf577fb, 0xfff7010d, 0xbf3afffb, 0xdfff0057}},
			{ref: 0x0061, set: pageSet{0xbd7def7b, 0xc8d4db88, 0xed7cfff3, 0x56ff5dee, 0xac5f7e0d, 0xd57fff96, 0xc1403fee, 0xffe76ff9}},
			{ref: 0x0062, set: pageSet{0x8e77779b, 0xe45d6ebf, 0x5f1f6fcf, 0xfedfe07f, 0x01fed7db, 0xfb7bff00, 0x1fdfffd4, 0xfffff800}},
			{ref: 0x0063, set: pageSet{0x007bfb8f, 0x7f5cbf00, 0x07f3ffff, 0x3de7eba0, 0xfbd7f7bf, 0x6003ffbf, 0xbfedfffd, 0x027fefbb}},
			{ref: 0x0064, set: pageSet{0xddfdfe40, 0xe2f9fdff, 0xfb1f680b, 0xaffdfbe3, 0xf7ed9fa4, 0xf80f7a7d, 0x0fd5eebe, 0xfd9fbb5d}},
			{ref: 0x0065, set: pageSet{0x3bf9f2db, 0xebccfe7f, 0x73fa876a, 0x9ffc95fc, 0xfaf7109f, 0xbbcdddb7, 0xeccdf87e, 0x3c3ff366}},
			{ref: 0x0066, set: pageSet{0xb03ffffd, 0x067ee9f7, 0xfe0696ae, 0x5fd7d576, 0xa3f33fd1, 0x6fb7cf07, 0x7f449fd1, 0xd3dd7b59}},
			{ref: 0x0067, set: pageSet{0xa9bdaf3b, 0xff3a7dcf, 0xf6ebfbe0, 0xffffb401, 0xb7bf7afa, 0x0ffdc000, 0xff1fff7f, 0x95fffefc}},
			{ref: 0x0068, set: pageSet{0xb5dc0000, 0x3f3eef63, 0x001bfb7f, 0xfbf6e800, 0xb8df9eef, 0x003fff9f, 0xf5ff7bd0, 0x3fffdfdb}},
			{ref: 0x0069, set: pageSet{0x00bffdf0, 0xbbbd8420, 0xffdedf37, 0x0ff3ff6d, 0x5efb604c, 0xfafbfffb, 0x0219fe5e, 0xf9de79f4}},
			{ref: 0x006a, set: pageSet{0xebfaa7f7, 0xff3401eb, 0xef73ebd3, 0xc040afd7, 0xdcff72bb, 0x2fd8f17f, 0xfe0bb8ec, 0x1f0bdda3}},
			{ref: 0x006b, set: pageSet{0x47cf8f1d, 0xffdeb12b, 0xda737fee, 0xcbc424ff, 0xcbf2f75d, 0xb4edecfd, 0x4dddbff9, 0xfb8d99dd}},
			{ref: 0x006c, set: pageSet{0xaf7bbb7f, 0xc959ddfb, 0xfab5fc4f, 0x6d5fafe3, 0x3f7dffff, 0xffdb7800, 0x7effb6ff, 0x022ffbaf}},
			{ref: 0x006d, set: pageSet{0xefc7ff9b, 0xffffffa5, 0xc7000007, 0xfff1f7ff, 0x01bf7ffd, 0xfdbcdc00, 0xffffbff5, 0x3effff7f}},
			{ref: 0x006e, set: pageSet{0xbe000029, 0xff7ff9ff, 0xfd7e6efb, 0x039ecbff, 0xfbdde300, 0xf6dfccff, 0x117fffff, 0xfbf6f800}},
			{ref: 0x006f, set: pageSet{0xd73ce7ef, 0xdfeffeef, 0xedbfc00b, 0xfdcdfedf, 0x40fd7bf5, 0xb75fffff, 0xf930ffdf, 0xdc97fbdf}},
			{ref: 0x0070, set: pageSet{0xbff2fef3, 0xdfbf8fdf, 0xede6177f, 0x35530f7f, 0x877e447c, 0x45bbfa12, 0x779eede0, 0xbfd98017}},
			{ref: 0x0071, set: pageSet{0xde897e55, 0x0447c16f, 0xf75d7ade, 0x290557ff, 0xfe9586f7, 0xf32f97b3, 0x9f75cfff, 0xfb1771f7}},
			{ref: 0x0072, set: pageSet{0xee1934ee, 0xef6137cc, 0xef4c9fd6, 0xfbddd68f, 0x6def7b73, 0xa431d7fe, 0x97d75e7f, 0xffd80f5b}},
			{ref: 0x0073, set: pageSet{0x7bce9d83, 0xdcff22ec, 0xef87763d, 0xfdeddfe7, 0xa0fc4fff, 0xdbfc3b77, 0x7fdc3ded, 0xf5706fa9}},
			{ref: 0x0074, set: pageSet{0x2c403ffb, 0x847fff7f, 0xdeb7ec57, 0xf22fe69c, 0xd5b50feb, 0xede7afeb, 0xfff08c2f, 0xe8f0537f}},
			{ref: 0x0075, set: pageSet{0xb5ffb99d, 0xe78fff66, 0xbe10d981, 0xe3c19c7c, 0x27339cd1, 0xff6d0cbc, 0xefb7fcb7, 0xffffa0df}},
			{ref: 0x0076, set: pageSet{0xfe7bbf0b, 0x353fa3ff, 0x97cd13cc, 0xfb277637, 0x7e6ccfd6, 0xed31ec50, 0xfc1c677c, 0x5fbff6fa}},
			{ref: 0x0077, set: pageSet{0xae2f0fba, 0x7ffea3ad, 0xde74fcf0, 0xf200ffef, 0xfea2fbbf, 0xbcff3daf, 0x5fb9f694, 0x3f8ff3ad}},
			{ref: 0x0078, set: pageSet{0xa01ff26c, 0x01bfffef, 0x70057728, 0xda03ff35, 0xc7fad2f9, 0x5c1d3fbf, 0xec33ff3a, 0xfe9cb7af}},
			{ref: 0x0079, set: pageSet{0x7a9f5236, 0xe722bffa, 0xfcff9ff7, 0xb61d2fbb, 0x1dfded06, 0xefdf7dd7, 0xf166eb23, 0x0dc07ed9}},
			{ref: 0x007a, set: pageSet{0xdfbf3d3d, 0xba83c945, 0x9dd07dd1, 0xcf737b87, 0xc3f59ff3, 0xc5fedf0d, 0x83020cb3, 0xaec0e879}},
			{ref: 0x007b, set: pageSet{0x6f0fc773, 0x093ffd7d, 0x0157fff1, 0x01ff62fb, 0x3bf3fdb4, 0x43b2b013, 0xff305ed3, 0xeb9f0fff}},
			{ref: 0x007c, set: pageSet{0xf203feef, 0xfb893fef, 0x9e9937a9, 0xa72cdef9, 0xc1f63733, 0xfe3e812e, 0xf2f75d20, 0x69d7d585}},
			{ref: 0x007d, set: pageSet{0xffffffff, 0xff6fdb07, 0xd97fc4ff, 0xbe0fefce, 0xf05ef17b, 0xffb7f6cf, 0xef845ef7, 0x0edfd7cb}},
			{ref: 0x007e, set: pageSet{0xfcffff08, 0xffffee3f, 0xd7ff13ff, 0x7ffdaf0f, 0x1ffabdc7, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0xe7400000, 0xf933bd38, 0xfeed7feb, 0x7c767fe8, 0xffefb3f7, 0xd8b7feaf, 0xfbbfff6f}},
			{ref: 0x0080, set: pageSet{0xdbf7f8fb, 0xe2f91752, 0x754785c8, 0xe3ef9090, 0x3f6d9ef4, 0x0536ee2e, 0x7ff3f7bc, 0x7f3fa07b}},
			{ref: 0x0081, set: pageSet{0xeb600567, 0x6601babe, 0x583ffcd8, 0x87dfcaf7, 0xffa0bfcd, 0xfebf5bcd, 0xefa7b6fd, 0xdf9c77ef}},
			{ref: 0x0082, set: pageSet{0xf8773fb7, 0xb7fc9d27, 0xdfefcab5, 0xf1b6fb5a, 0xef1fec39, 0x7ffbfbbf, 0xdafe000d, 0x4e7fbdfb}},
			{ref: 0x0083, set: pageSet{0x5ac033ff, 0x9ffebff5, 0x005fffbf, 0xfdf80000, 0x6ffdffca, 0xa001cffd, 0xfbf2dfff, 0xff7fdfbf}},
			{ref: 0x0084, set: pageSet{0x080ffeda, 0xbfffba08, 0xeed77afd, 0x67f9fbeb, 0xff93e044, 0x9f57df97, 0x08dffef7, 0xfedfdf80}},
			{ref: 0x0085, set: pageSet{0xf7feffc5, 0x6803fffb, 0x6bfa67fb, 0x5fe27fff, 0xff73ffff, 0xe7fb87df, 0xf7a7ebfd, 0xefc7bf7e}},
			{ref: 0x0086, set: pageSet{0xdf821ef3, 0xdf7e76ff, 0xda7d79c9, 0x1e9befbe, 0x77fb7ce0, 0xfffb87be, 0xffdb1bff, 0x4fe03f5c}},
			{ref: 0x0087, set: pageSet{0x5f0e7fff, 0xddbf77ff, 0xfffff04f, 0x0ff8ffff, 0xfddfa3be, 0xfffdfc1c, 0xfb9e1f7d, 0xdedcbdff}},
			{ref: 0x0088, set: pageSet{0xbafb3f6f, 0xfbefdf7f, 0x2eec7d1b, 0xf2f7af8e, 0xcfee7b0f, 0x77c61d96, 0xfff57e07, 0x7fdfd982}},
			{ref: 0x0089, set: pageSet{0xc7ff5ee6, 0x79effeee, 0xffcf9a56, 0xde5efe5f, 0xf9e8896e, 0xe6c4f45e, 0xbe7c0001, 0xdddf3b7f}},
			{ref: 0x008a, set: pageSet{0xe9efd59d, 0xde5334ac, 0x4bf7f573, 0x9eff7b4f, 0x476eb8fe, 0xff450dfb, 0xfbfeabfd, 0xddffe9d7}},
			{ref: 0x008b, set: pageSet{0x7fffedf7, 0x7eebddfd, 0xb7ffcfe7, 0xef91bde9, 0xd77c5d75, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0xfa800000, 0xb4f1ffee, 0x2fefbf76, 0x77bfb677, 0xfffd9fbf, 0xf6ae95bf, 0x7f3b75ff}},
			{ref: 0x008d, set: pageSet{0x0af9a7f5, 0x00000000, 0x00000000, 0x2bddfbd0, 0x9a7ff633, 0xd6fcfdab, 0xbfebf9e6, 0xf41fdfdf}},
			{ref: 0x008e, set: pageSet{0xffffa6fd, 0xf37b4aff, 0xfef97fb7, 0x1d5cb6ff, 0xe5ff7ff6, 0x24041f7b, 0xf99ebe05, 0xdff2dbe3}},
			{ref: 0x008f, set: pageSet{0xfdff6fef, 0xcbfcd679, 0xefffebfd, 0x0000001f, 0x98000000, 0x8017e148, 0x00fe6a74, 0xfdf16d7f}},
			{ref: 0x0090, set: pageSet{0xfef3b87f, 0xf176e01f, 0x7b3fee96, 0xfffdeb8d, 0xcbb3adff, 0xe17f84ef, 0xbff04daa, 0xfe3fbf3f}},
			{ref: 0x0091, set: pageSet{0xffd7ebff, 0xcf7fffdf, 0x85edfffb, 0x07bcd73f, 0xfe0faeff, 0x76bffdaf, 0x37bbfaef, 0xa3ba7fdc}},
			{ref: 0x0092, set: pageSet{0x56f7b6ff, 0xe7df60f8, 0x4cdfff61, 0xff45b0fb, 0x3ffa7ded, 0x18fc1fff, 0xe3afffff, 0xdf83c7d3}},
			{ref: 0x0093, set: pageSet{0xef7dfb57, 0x1378efff, 0x5ff7fec0, 0x5ee334bb, 0xeff6f70d, 0x00bfd7fe, 0xf7f7f59d, 0xffe051de}},
			{ref: 0x0094, set: pageSet{0x037ffec9, 0xbfef5f01, 0x60a79ff1, 0xf1ffef1d, 0x0000000f, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x3c800000, 0xd91ffb4d, 0xfee37b3a, 0xdc7f3fe9, 0x0000003f}},
			{ref: 0x0096, set: pageSet{0x50000000, 0xbe07f51f, 0xf91bfc1d, 0x71ffbc1e, 0x5bbe6ff9, 0x9b1b5796, 0xfffc7fff, 0xafe7872e}},
			{ref: 0x0097, set: pageSet{0xf34febf5, 0xe725dffd, 0x5d440bdc, 0xfddd5747, 0x7790ed3f, 0x8ac87d7f, 0xf3f9fafa, 0xef4b202a}},
			{ref: 0x0098, set: pageSet{0x79cff5ff, 0x0ba5abd3, 0xfb8ff77a, 0x001f8ebd, 0x00000000, 0xfd4ef300, 0x88001a57, 0x7654aeac}},
			{ref: 0x0099, set: pageSet{0xcdff17ad, 0xf42fffb2, 0xdbff5baa, 0x00000002, 0x73c00000, 0x2e3ff9ea, 0xbbfffa8e, 0xffd376bc}},
			{ref: 0x009a, set: pageSet{0x7e72eefe, 0xe7f77ebd, 0xcefdf77f, 0x00000ff5, 0x00000000, 0xdb9ba900, 0x917fa4c7, 0x7ecef8ca}},
			{ref: 0x009b, set: pageSet{0xc7e77d7a, 0xdcaecbbd, 0x8f76fd7e, 0x7cf391d3, 0x4c2f01e5, 0xa360ed77, 0x5ef807db, 0x21811df7}},
			{ref: 0x009c, set: pageSet{0x309c6be0, 0xfade3b3a, 0xc3f57f53, 0x07ba61cd, 0x00000000, 0x00000000, 0x00000000, 0xbefe26e0}},
			{ref: 0x009d, set: pageSet{0xebb503f9, 0xe9cbe36d, 0xbfde9c2f, 0xabbf9f83, 0xffd51ff7, 0xdffeb7df, 0xffeffdae, 0xeffdfb7e}},
			{ref: 0x009e, set: pageSet{0x6ebfaaff, 0x00000000, 0x00000000, 0xb6200000, 0xbe9e7fcd, 0x58f162b3, 0xfd7bf10d, 0xbefde9f1}},
			{ref: 0x009f, set: pageSet{0x5f6dc6c3, 0x69ffff3d, 0xfbf4ffcf, 0x4ff7dcfb, 0x11372000, 0x00000015, 0x00000000, 0x00000000}},
			{ref: 0x00fa, set: pageSet{0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 42 */
		"co",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x1a10cfc5, 0x9a10cfc5}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x000c0000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 43 */
		"crh",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10420084, 0x10420084}},
			{ref: 0x0001, set: pageSet{0xc0000000, 0x00030000, 0xc0000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 44 */
		"cs",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x24082202, 0x24082202}},
			{ref: 0x0001, set: pageSet{0x0c00f000, 0x00000000, 0x03000180, 0x6000c033, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 45 */
		"csb",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x021c0a08, 0x021c0a08}},
			{ref: 0x0001, set: pageSet{0x00000030, 0x00000000, 0x0000001e, 0x18000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 46 */
		"cu",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xfdffa966, 0xffffdfff, 0xa965dfff, 0x03ffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 47 */
		"cv",
		RuneSet{
			{ref: 0x0001, set: pageSet{0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000c00, 0x00c00000, 0x000c0000}},
		},
	},
	{ /** index: 48 */
		"cy",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x0010c604, 0x8010c604}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x01f00000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000003f, 0x00000000, 0x00000000, 0x000c0000}},
		},
	},
	{ /** index: 49 */
		"da",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x25082262, 0x25082262}},
		},
	},
	{ /** index: 50 */
		"de",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x90400010, 0x10400010}},
		},
	},
	{ /** index: 51 */
		"doi",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xfff99fec, 0xf3e5fdff, 0xf807399f, 0x0000ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 52 */
		"dsb",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x24082202, 0x24082202}},
			{ref: 0x0001, set: pageSet{0x0c00f000, 0x00000000, 0x03000180, 0x6000c033, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 53 */
		"dv",
		RuneSet{
			{ref: 0x0007, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x0001ffff, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 54 */
		"dz",
		RuneSet{
			{ref: 0x000f, set: pageSet{0x00000000, 0x00000000, 0xfffffeff, 0x3d7e03ff, 0xfeff0003, 0x03ffffff, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 55 */
		"ee",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x060c3303, 0x060c3303}},
			{ref: 0x0001, set: pageSet{0x0c000000, 0x00000000, 0x00000c00, 0x00000000, 0x00170240, 0x00040000, 0x001fe000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08500000, 0x00000008, 0x00000800, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00001003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 56 */
		"el",
		RuneSet{
			{ref: 0x0003, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffd740, 0xfffffffb, 0x00007fff, 0x00000000}},
		},
	},
	{ /** index: 57 */
		"en",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00528f81, 0x00528f81}},
		},
	},
	{ /** index: 58 */
		"eo",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x30000300, 0x00300030, 0x30000000, 0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 59 */
		"es",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x140a2202, 0x140a2202}},
		},
	},
	{ /** index: 60 */
		"et",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10600010, 0x10600010}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x60000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 61 */
		"eu",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10020000, 0x10020000}},
		},
	},
	{ /** index: 62 */
		"fa",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07ffffde, 0x001009f6, 0x40000000, 0x01000040, 0x00008200, 0x00001000, 0x00000000}},
		},
	},
	{ /** index: 63 */
		"fat",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00220008, 0x00220008}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000300, 0x00000000, 0x00000300, 0x00010040, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00000048, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x30000000, 0x00000000, 0x03000000}},
		},
	},
	{ /** index: 64 */
		"ff",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000c00, 0x00000000, 0x20000402, 0x00180000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00880000, 0x00040000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 65 */
		"fi",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00400030, 0x00400030}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x60000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 66 */
		"fil",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x0e1e7707, 0x0e1e7707}},
		},
	},
	{ /** index: 67 */
		"fj",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 68 */
		"fo",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x25092042, 0x25092042}},
		},
	},
	{ /** index: 69 */
		"fr",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x1a10cfc5, 0x9a10cfc5}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x000c0000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 70 */
		"fur",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x02041107, 0x02041107}},
		},
	},
	{ /** index: 71 */
		"fy",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x9c508e14, 0x1c508e14}},
		},
	},
	{ /** index: 72 */
		"ga",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x04082202, 0x04082202}},
			{ref: 0x0001, set: pageSet{0x00000c00, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0xc0000c0c, 0x00000000, 0x00c00003, 0x00000c03, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 73 */
		"gd",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x020c1383, 0x020c1383}},
		},
	},
	{ /** index: 74 */
		"gez",
		RuneSet{
			{ref: 0x0012, set: pageSet{0xff7fff7f, 0xff01ff7f, 0x00003d7f, 0x00ff00ff, 0x00ff3d7f, 0x003d7fff, 0xff7f7f00, 0x00ff7f00}},
			{ref: 0x0013, set: pageSet{0x003d7f00, 0xffff01ff, 0x007fff7f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 75 */
		"gl",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x140a2202, 0x140a2202}},
		},
	},
	{ /** index: 76 */
		"gn",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x040a2202, 0x042a220a}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000200, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x02000000}},
		},
	},
	{ /** index: 77 */
		"gu",
		RuneSet{
			{ref: 0x000a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffbafee, 0xf3edfdff, 0x00013bbf, 0x00000001}},
		},
	},
	{ /** index: 78 */
		"gv",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000080, 0x00000080}},
		},
	},
	{ /** index: 79 */
		"ha",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000402, 0x00180000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00880000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 80 */
		"hak",
		RuneSet{
			{ref: 0x004e, set: pageSet{0xc373ff8b, 0x1b0f6840, 0xf34ce9ac, 0xc0080200, 0xca3e795c, 0x06487976, 0xf7f02fdf, 0xa8ff033a}},
			{ref: 0x004f, set: pageSet{0x233fef37, 0xfd59b004, 0xfffff3ca, 0xfff9de9f, 0x7df7abff, 0x8eecc000, 0xffdbeebf, 0x45fad003}},
			{ref: 0x0050, set: pageSet{0xdffefae1, 0x10abbfef, 0xfcaaffeb, 0x24fdef3f, 0x7f7678ad, 0xedfff00c, 0x2cfacff6, 0xeb6bf7f9}},
			{ref: 0x0051, set: pageSet{0x95bf1ffd, 0xbfbf6677, 0xfeb43bfb, 0x11e27bae, 0x41bea681, 0x72c31435, 0x71917d70, 0x276b0003}},
			{ref: 0x0052, set: pageSet{0x70cf57cb, 0x0def4732, 0xfc747eda, 0xbdb4fe06, 0x8bca3f9f, 0x58007e49, 0xebec228f, 0xddbb8a5c}},
			{ref: 0x0053, set: pageSet{0xb6e7ef60, 0xf293a40f, 0x549e37bb, 0x9bafd04b, 0xf7d4c414, 0x0a1430b0, 0x88d02f08, 0x192fff7e}},
			{ref: 0x0054, set: pageSet{0xfb07ffda, 0x7beb7ff1, 0x0010c5ef, 0xfdff99ff, 0x056779d7, 0xfdcbffe7, 0x4040c3ff, 0xbd8e6ff7}},
			{ref: 0x0055, set: pageSet{0x0497dffa, 0x5bfff4c0, 0xd0e7ed7b, 0xf8e0047e, 0xb73eff9f, 0x882e7dfe, 0xbe7ffffd, 0xf6c483fe}},
			{ref: 0x0056, set: pageSet{0xb8fdf357, 0xef7dd680, 0x47885767, 0xc3dfff7d, 0x37a9f0ff, 0x70fc7de0, 0xec9a3f6f, 0x86814cb3}},
			{ref: 0x0057, set: pageSet{0xdd5c3f9e, 0x4819f70d, 0x0007fea3, 0x38ffaf56, 0xefb8980d, 0xb760403d, 0x9035d8ce, 0x3fff72bf}},
			{ref: 0x0058, set: pageSet{0x7a117ff7, 0xabfff7bb, 0x6fbeff00, 0xfe72a93c, 0xf11bcfef, 0xf40adb6b, 0xef7ec3e6, 0xf6109b9c}},
			{ref: 0x0059, set: pageSet{0x16f4f048, 0x5182feb5, 0x15bbc7b1, 0xfbdf6e87, 0x63cde43f, 0x7e7ec1ff, 0x7d5ffdeb, 0xfcfe777b}},
			{ref: 0x005a, set: pageSet{0xdbea960b, 0x53e86229, 0xfdef37df, 0xbd8136f5, 0xfcbddc18, 0xffffd2e4, 0xffe03fd7, 0xabf87f6f}},
			{ref: 0x005b, set: pageSet{0x6ed99bae, 0xf115f5fb, 0xbdfb79a9, 0xadaf5a3c, 0x1facdbba, 0x837971fc, 0xc35f7cf7, 0x0567dfff}},
			{ref: 0x005c, set: pageSet{0x8467ff9a, 0xdf8b1534, 0x3373f9f3, 0x5e1af7bd, 0xa03fbf40, 0x01ebffff, 0xcfdddfc0, 0xabd37500}},
			{ref: 0x005d, set: pageSet{0xeed6f8c3, 0xb7ff43fd, 0x42275eaf, 0xf6869bac, 0xf6bc27d7, 0x35b7f787, 0xe176aacd, 0xe29f49e7}},
			{ref: 0x005e, set: pageSet{0xaff2545c, 0x61d82b3f, 0xbbb8fc3b, 0x7b7dffcf, 0x1ce0bf95, 0x43ff7dfd, 0xfffe5ff6, 0xc4ced3ef}},
			{ref: 0x005f, set: pageSet{0xadbc8db6, 0x11eb63dc, 0x23d0df59, 0xf3dbbeb4, 0xdbc71fe7, 0xfae4ff63, 0x63f7b22b, 0xadbaed3b}},
			{ref: 0x0060, set: pageSet{0x7efffe01, 0x02bcfff7, 0xef3932ff, 0x8005fffc, 0xbcf577fb, 0xfff7010d, 0xbf3afffb, 0xdfff0057}},
			{ref: 0x0061, set: pageSet{0xbd7def7b, 0xc8d4db88, 0xed7cfff3, 0x56ff5dee, 0xac5f7e0d, 0xd57fff96, 0xc1403fee, 0xffe76ff9}},
			{ref: 0x0062, set: pageSet{0x8e77779b, 0xe45d6ebf, 0x5f1f6fcf, 0xfedfe07f, 0x01fed7db, 0xfb7bff00, 0x1fdfffd4, 0xfffff800}},
			{ref: 0x0063, set: pageSet{0x007bfb8f, 0x7f5cbf00, 0x07f3ffff, 0x3de7eba0, 0xfbd7f7bf, 0x6003ffbf, 0xbfedfffd, 0x027fefbb}},
			{ref: 0x0064, set: pageSet{0xddfdfe40, 0xe2f9fdff, 0xfb1f680b, 0xaffdfbe3, 0xf7ed9fa4, 0xf80f7a7d, 0x0fd5eebe, 0xfd9fbb5d}},
			{ref: 0x0065, set: pageSet{0x3bf9f2db, 0xebccfe7f, 0x73fa876a, 0x9ffc95fc, 0xfaf7109f, 0xbbcdddb7, 0xeccdf87e, 0x3c3ff366}},
			{ref: 0x0066, set: pageSet{0xb03ffffd, 0x067ee9f7, 0xfe0696ae, 0x5fd7d576, 0xa3f33fd1, 0x6fb7cf07, 0x7f449fd1, 0xd3dd7b59}},
			{ref: 0x0067, set: pageSet{0xa9bdaf3b, 0xff3a7dcf, 0xf6ebfbe0, 0xffffb401, 0xb7bf7afa, 0x0ffdc000, 0xff1fff7f, 0x95fffefc}},
			{ref: 0x0068, set: pageSet{0xb5dc0000, 0x3f3eef63, 0x001bfb7f, 0xfbf6e800, 0xb8df9eef, 0x003fff9f, 0xf5ff7bd0, 0x3fffdfdb}},
			{ref: 0x0069, set: pageSet{0x00bffdf0, 0xbbbd8420, 0xffdedf37, 0x0ff3ff6d, 0x5efb604c, 0xfafbfffb, 0x0219fe5e, 0xf9de79f4}},
			{ref: 0x006a, set: pageSet{0xebfaa7f7, 0xff3401eb, 0xef73ebd3, 0xc040afd7, 0xdcff72bb, 0x2fd8f17f, 0xfe0bb8ec, 0x1f0bdda3}},
			{ref: 0x006b, set: pageSet{0x47cf8f1d, 0xffdeb12b, 0xda737fee, 0xcbc424ff, 0xcbf2f75d, 0xb4edecfd, 0x4dddbff9, 0xfb8d99dd}},
			{ref: 0x006c, set: pageSet{0xaf7bbb7f, 0xc959ddfb, 0xfab5fc4f, 0x6d5fafe3, 0x3f7dffff, 0xffdb7800, 0x7effb6ff, 0x022ffbaf}},
			{ref: 0x006d, set: pageSet{0xefc7ff9b, 0xffffffa5, 0xc7000007, 0xfff1f7ff, 0x01bf7ffd, 0xfdbcdc00, 0xffffbff5, 0x3effff7f}},
			{ref: 0x006e, set: pageSet{0xbe000029, 0xff7ff9ff, 0xfd7e6efb, 0x039ecbff, 0xfbdde300, 0xf6dfccff, 0x117fffff, 0xfbf6f800}},
			{ref: 0x006f, set: pageSet{0xd73ce7ef, 0xdfeffeef, 0xedbfc00b, 0xfdcdfedf, 0x40fd7bf5, 0xb75fffff, 0xf930ffdf, 0xdc97fbdf}},
			{ref: 0x0070, set: pageSet{0xbff2fef3, 0xdfbf8fdf, 0xede6177f, 0x35530f7f, 0x877e447c, 0x45bbfa12, 0x779eede0, 0xbfd98017}},
			{ref: 0x0071, set: pageSet{0xde897e55, 0x0447c16f, 0xf75d7ade, 0x290557ff, 0xfe9586f7, 0xf32f97b3, 0x9f75cfff, 0xfb1771f7}},
			{ref: 0x0072, set: pageSet{0xee1934ee, 0xef6137cc, 0xef4c9fd6, 0xfbddd68f, 0x6def7b73, 0xa431d7fe, 0x97d75e7f, 0xffd80f5b}},
			{ref: 0x0073, set: pageSet{0x7bce9d83, 0xdcff22ec, 0xef87763d, 0xfdeddfe7, 0xa0fc4fff, 0xdbfc3b77, 0x7fdc3ded, 0xf5706fa9}},
			{ref: 0x0074, set: pageSet{0x2c403ffb, 0x847fff7f, 0xdeb7ec57, 0xf22fe69c, 0xd5b50feb, 0xede7afeb, 0xfff08c2f, 0xe8f0537f}},
			{ref: 0x0075, set: pageSet{0xb5ffb99d, 0xe78fff66, 0xbe10d981, 0xe3c19c7c, 0x27339cd1, 0xff6d0cbc, 0xefb7fcb7, 0xffffa0df}},
			{ref: 0x0076, set: pageSet{0xfe7bbf0b, 0x353fa3ff, 0x97cd13cc, 0xfb277637, 0x7e6ccfd6, 0xed31ec50, 0xfc1c677c, 0x5fbff6fa}},
			{ref: 0x0077, set: pageSet{0xae2f0fba, 0x7ffea3ad, 0xde74fcf0, 0xf200ffef, 0xfea2fbbf, 0xbcff3daf, 0x5fb9f694, 0x3f8ff3ad}},
			{ref: 0x0078, set: pageSet{0xa01ff26c, 0x01bfffef, 0x70057728, 0xda03ff35, 0xc7fad2f9, 0x5c1d3fbf, 0xec33ff3a, 0xfe9cb7af}},
			{ref: 0x0079, set: pageSet{0x7a9f5236, 0xe722bffa, 0xfcff9ff7, 0xb61d2fbb, 0x1dfded06, 0xefdf7dd7, 0xf166eb23, 0x0dc07ed9}},
			{ref: 0x007a, set: pageSet{0xdfbf3d3d, 0xba83c945, 0x9dd07dd1, 0xcf737b87, 0xc3f59ff3, 0xc5fedf0d, 0x83020cb3, 0xaec0e879}},
			{ref: 0x007b, set: pageSet{0x6f0fc773, 0x093ffd7d, 0x0157fff1, 0x01ff62fb, 0x3bf3fdb4, 0x43b2b013, 0xff305ed3, 0xeb9f0fff}},
			{ref: 0x007c, set: pageSet{0xf203feef, 0xfb893fef, 0x9e9937a9, 0xa72cdef9, 0xc1f63733, 0xfe3e812e, 0xf2f75d20, 0x69d7d585}},
			{ref: 0x007d, set: pageSet{0xffffffff, 0xff6fdb07, 0xd97fc4ff, 0xbe0fefce, 0xf05ef17b, 0xffb7f6cf, 0xef845ef7, 0x0edfd7cb}},
			{ref: 0x007e, set: pageSet{0xfcffff08, 0xffffee3f, 0xd7ff13ff, 0x7ffdaf0f, 0x1ffabdc7, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0xe7400000, 0xf933bd38, 0xfeed7feb, 0x7c767fe8, 0xffefb3f7, 0xd8b7feaf, 0xfbbfff6f}},
			{ref: 0x0080, set: pageSet{0xdbf7f8fb, 0xe2f91752, 0x754785c8, 0xe3ef9090, 0x3f6d9ef4, 0x0536ee2e, 0x7ff3f7bc, 0x7f3fa07b}},
			{ref: 0x0081, set: pageSet{0xeb600567, 0x6601babe, 0x583ffcd8, 0x87dfcaf7, 0xffa0bfcd, 0xfebf5bcd, 0xefa7b6fd, 0xdf9c77ef}},
			{ref: 0x0082, set: pageSet{0xf8773fb7, 0xb7fc9d27, 0xdfefcab5, 0xf1b6fb5a, 0xef1fec39, 0x7ffbfbbf, 0xdafe000d, 0x4e7fbdfb}},
			{ref: 0x0083, set: pageSet{0x5ac033ff, 0x9ffebff5, 0x005fffbf, 0xfdf80000, 0x6ffdffca, 0xa001cffd, 0xfbf2dfff, 0xff7fdfbf}},
			{ref: 0x0084, set: pageSet{0x080ffeda, 0xbfffba08, 0xeed77afd, 0x67f9fbeb, 0xff93e044, 0x9f57df97, 0x08dffef7, 0xfedfdf80}},
			{ref: 0x0085, set: pageSet{0xf7feffc5, 0x6803fffb, 0x6bfa67fb, 0x5fe27fff, 0xff73ffff, 0xe7fb87df, 0xf7a7ebfd, 0xefc7bf7e}},
			{ref: 0x0086, set: pageSet{0xdf821ef3, 0xdf7e76ff, 0xda7d79c9, 0x1e9befbe, 0x77fb7ce0, 0xfffb87be, 0xffdb1bff, 0x4fe03f5c}},
			{ref: 0x0087, set: pageSet{0x5f0e7fff, 0xddbf77ff, 0xfffff04f, 0x0ff8ffff, 0xfddfa3be, 0xfffdfc1c, 0xfb9e1f7d, 0xdedcbdff}},
			{ref: 0x0088, set: pageSet{0xbafb3f6f, 0xfbefdf7f, 0x2eec7d1b, 0xf2f7af8e, 0xcfee7b0f, 0x77c61d96, 0xfff57e07, 0x7fdfd982}},
			{ref: 0x0089, set: pageSet{0xc7ff5ee6, 0x79effeee, 0xffcf9a56, 0xde5efe5f, 0xf9e8896e, 0xe6c4f45e, 0xbe7c0001, 0xdddf3b7f}},
			{ref: 0x008a, set: pageSet{0xe9efd59d, 0xde5334ac, 0x4bf7f573, 0x9eff7b4f, 0x476eb8fe, 0xff450dfb, 0xfbfeabfd, 0xddffe9d7}},
			{ref: 0x008b, set: pageSet{0x7fffedf7, 0x7eebddfd, 0xb7ffcfe7, 0xef91bde9, 0xd77c5d75, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0xfa800000, 0xb4f1ffee, 0x2fefbf76, 0x77bfb677, 0xfffd9fbf, 0xf6ae95bf, 0x7f3b75ff}},
			{ref: 0x008d, set: pageSet{0x0af9a7f5, 0x00000000, 0x00000000, 0x2bddfbd0, 0x9a7ff633, 0xd6fcfdab, 0xbfebf9e6, 0xf41fdfdf}},
			{ref: 0x008e, set: pageSet{0xffffa6fd, 0xf37b4aff, 0xfef97fb7, 0x1d5cb6ff, 0xe5ff7ff6, 0x24041f7b, 0xf99ebe05, 0xdff2dbe3}},
			{ref: 0x008f, set: pageSet{0xfdff6fef, 0xcbfcd679, 0xefffebfd, 0x0000001f, 0x98000000, 0x8017e148, 0x00fe6a74, 0xfdf16d7f}},
			{ref: 0x0090, set: pageSet{0xfef3b87f, 0xf176e01f, 0x7b3fee96, 0xfffdeb8d, 0xcbb3adff, 0xe17f84ef, 0xbff04daa, 0xfe3fbf3f}},
			{ref: 0x0091, set: pageSet{0xffd7ebff, 0xcf7fffdf, 0x85edfffb, 0x07bcd73f, 0xfe0faeff, 0x76bffdaf, 0x37bbfaef, 0xa3ba7fdc}},
			{ref: 0x0092, set: pageSet{0x56f7b6ff, 0xe7df60f8, 0x4cdfff61, 0xff45b0fb, 0x3ffa7ded, 0x18fc1fff, 0xe3afffff, 0xdf83c7d3}},
			{ref: 0x0093, set: pageSet{0xef7dfb57, 0x1378efff, 0x5ff7fec0, 0x5ee334bb, 0xeff6f70d, 0x00bfd7fe, 0xf7f7f59d, 0xffe051de}},
			{ref: 0x0094, set: pageSet{0x037ffec9, 0xbfef5f01, 0x60a79ff1, 0xf1ffef1d, 0x0000000f, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x3c800000, 0xd91ffb4d, 0xfee37b3a, 0xdc7f3fe9, 0x0000003f}},
			{ref: 0x0096, set: pageSet{0x50000000, 0xbe07f51f, 0xf91bfc1d, 0x71ffbc1e, 0x5bbe6ff9, 0x9b1b5796, 0xfffc7fff, 0xafe7872e}},
			{ref: 0x0097, set: pageSet{0xf34febf5, 0xe725dffd, 0x5d440bdc, 0xfddd5747, 0x7790ed3f, 0x8ac87d7f, 0xf3f9fafa, 0xef4b202a}},
			{ref: 0x0098, set: pageSet{0x79cff5ff, 0x0ba5abd3, 0xfb8ff77a, 0x001f8ebd, 0x00000000, 0xfd4ef300, 0x88001a57, 0x7654aeac}},
			{ref: 0x0099, set: pageSet{0xcdff17ad, 0xf42fffb2, 0xdbff5baa, 0x00000002, 0x73c00000, 0x2e3ff9ea, 0xbbfffa8e, 0xffd376bc}},
			{ref: 0x009a, set: pageSet{0x7e72eefe, 0xe7f77ebd, 0xcefdf77f, 0x00000ff5, 0x00000000, 0xdb9ba900, 0x917fa4c7, 0x7ecef8ca}},
			{ref: 0x009b, set: pageSet{0xc7e77d7a, 0xdcaecbbd, 0x8f76fd7e, 0x7cf391d3, 0x4c2f01e5, 0xa360ed77, 0x5ef807db, 0x21811df7}},
			{ref: 0x009c, set: pageSet{0x309c6be0, 0xfade3b3a, 0xc3f57f53, 0x07ba61cd, 0x00000000, 0x00000000, 0x00000000, 0xbefe26e0}},
			{ref: 0x009d, set: pageSet{0xebb503f9, 0xe9cbe36d, 0xbfde9c2f, 0xabbf9f83, 0xffd51ff7, 0xdffeb7df, 0xffeffdae, 0xeffdfb7e}},
			{ref: 0x009e, set: pageSet{0x6ebfaaff, 0x00000000, 0x00000000, 0xb6200000, 0xbe9e7fcd, 0x58f162b3, 0xfd7bf10d, 0xbefde9f1}},
			{ref: 0x009f, set: pageSet{0x5f6dc6c3, 0x69ffff3d, 0xfbf4ffcf, 0x4ff7dcfb, 0x11372000, 0x00000015, 0x00000000, 0x00000000}},
			{ref: 0x00fa, set: pageSet{0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 81 */
		"haw",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000c0003, 0x00000c00, 0x00003000, 0x00000c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 82 */
		"he",
		RuneSet{
			{ref: 0x0005, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffff0000, 0x000007ff}},
		},
	},
	{ /** index: 83 */
		"hi",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 84 */
		"hif",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 85 */
		"hne",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 86 */
		"ho",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 87 */
		"hr",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000330c0, 0x00000000, 0x00000000, 0x60000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 88 */
		"hsb",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00080000, 0x00080000}},
			{ref: 0x0001, set: pageSet{0x0c0030c0, 0x00000000, 0x0300001e, 0x66000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 89 */
		"ht",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00040100, 0x00040100}},
		},
	},
	{ /** index: 90 */
		"hu",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x14482202, 0x14482202}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00030000, 0x00030000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 91 */
		"hy",
		RuneSet{
			{ref: 0x0005, set: pageSet{0x00000000, 0xfffe0000, 0x007fffff, 0xfffffffe, 0x000000ff, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 92 */
		"hz",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00000000, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x000c0000, 0x00000000, 0x00000c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 93 */
		"ia",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 94 */
		"id",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000200, 0x00000200}},
		},
	},
	{ /** index: 95 */
		"ie",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x24082202, 0x24082202}},
		},
	},
	{ /** index: 96 */
		"ig",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00003c00, 0x00000030}},
		},
	},
	{ /** index: 97 */
		"ii",
		RuneSet{
			{ref: 0x00a0, set: pageSet{0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff}},
			{ref: 0x00a1, set: pageSet{0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff}},
			{ref: 0x00a2, set: pageSet{0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff}},
			{ref: 0x00a3, set: pageSet{0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff}},
			{ref: 0x00a4, set: pageSet{0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00001fff, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 98 */
		"ik",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff4002, 0xffffffff, 0x4002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 99 */
		"io",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 100 */
		"is",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x64092242, 0x64092242}},
		},
	},
	{ /** index: 101 */
		"it",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x060cb301, 0x060cb301}},
		},
	},
	{ /** index: 102 */
		"iu",
		RuneSet{
			{ref: 0x0014, set: pageSet{0x00000c7e, 0x031f8000, 0x0063f200, 0x000df840, 0x00037e08, 0x08000dfa, 0x0df901bf, 0x5437e400}},
			{ref: 0x0015, set: pageSet{0x00000025, 0x40006fc0, 0x27f91be4, 0xdee00000, 0x007ff83f, 0x00007f7f, 0x00000000, 0x00000000}},
			{ref: 0x0016, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x007f8000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 103 */
		"ja",
		RuneSet{
			{ref: 0x0030, set: pageSet{0x000000a7, 0x00000000, 0xfffffffe, 0xffffffff, 0x780fffff, 0xfffffffe, 0xffffffff, 0x787fffff}},
			{ref: 0x004e, set: pageSet{0x03506f8b, 0x1b042042, 0x62808020, 0x400a0000, 0x10341b41, 0x04003812, 0x03608c02, 0x08454038}},
			{ref: 0x004f, set: pageSet{0x2403c002, 0x15108000, 0x1229e040, 0x80280000, 0x28002800, 0x8060c002, 0x2080040c, 0x05284002}},
			{ref: 0x0050, set: pageSet{0x82042a00, 0x02000818, 0x10008200, 0x20700020, 0x03022000, 0x40a41000, 0x0420a020, 0x00000080}},
			{ref: 0x0051, set: pageSet{0x80040011, 0x00000400, 0x04012b78, 0x11a23920, 0x02842460, 0x00c01021, 0x20002050, 0x07400042}},
			{ref: 0x0052, set: pageSet{0x208205c9, 0x0fc10230, 0x08402480, 0x00258018, 0x88000080, 0x42120609, 0xa32002a8, 0x40040094}},
			{ref: 0x0053, set: pageSet{0x00c00024, 0x8e000001, 0x059e058a, 0x013b0001, 0x85000010, 0x08080000, 0x02d07d04, 0x018d9838}},
			{ref: 0x0054, set: pageSet{0x8803f310, 0x03000840, 0x00000704, 0x30080500, 0x00001000, 0x20040000, 0x00000003, 0x04040002}},
			{ref: 0x0055, set: pageSet{0x000100d0, 0x40028000, 0x00088040, 0x00000000, 0x34000210, 0x00400e00, 0x00000020, 0x00000008}},
			{ref: 0x0056, set: pageSet{0x00000040, 0x00060000, 0x00000000, 0x00100100, 0x00000080, 0x00000000, 0x4c000000, 0x240d0009}},
			{ref: 0x0057, set: pageSet{0x80048000, 0x00010180, 0x00020484, 0x00000400, 0x00000804, 0x00000008, 0x80004800, 0x16800000}},
			{ref: 0x0058, set: pageSet{0x00200065, 0x00120410, 0x44920403, 0x40000200, 0x10880008, 0x40080100, 0x00001482, 0x00074800}},
			{ref: 0x0059, set: pageSet{0x14608200, 0x00024e84, 0x00128380, 0x20184520, 0x0240041c, 0x0a001120, 0x00180a00, 0x88000800}},
			{ref: 0x005a, set: pageSet{0x01000002, 0x00008001, 0x04000040, 0x80000040, 0x08040000, 0x00000000, 0x00001202, 0x00000002}},
			{ref: 0x005b, set: pageSet{0x00000000, 0x00000004, 0x21910000, 0x00000858, 0xbf8013a0, 0x8279401c, 0xa8041054, 0xc5004282}},
			{ref: 0x005c, set: pageSet{0x0402ce56, 0xfc020000, 0x40200d21, 0x00028030, 0x00010000, 0x01081202, 0x00000000, 0x00410003}},
			{ref: 0x005d, set: pageSet{0x00404080, 0x00000200, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x60000000, 0x480241ea}},
			{ref: 0x005e, set: pageSet{0x2000104c, 0x2109a820, 0x00200020, 0x7b1c0008, 0x10a0840a, 0x01c028c0, 0x00000608, 0x04c00000}},
			{ref: 0x005f, set: pageSet{0x80398412, 0x40a200e0, 0x02080000, 0x12030a04, 0x008d1833, 0x02184602, 0x13803028, 0x00200801}},
			{ref: 0x0060, set: pageSet{0x20440000, 0x000005a1, 0x00050800, 0x0020a328, 0x80100000, 0x10040649, 0x10020020, 0x00090180}},
			{ref: 0x0061, set: pageSet{0x8c008202, 0x00000000, 0x00205910, 0x0041410c, 0x00004004, 0x40441290, 0x00010080, 0x01040000}},
			{ref: 0x0062, set: pageSet{0x04070000, 0x89108040, 0x00282a81, 0x82420000, 0x51a20411, 0x32220800, 0x2b0d2220, 0x40c83003}},
			{ref: 0x0063, set: pageSet{0x82020082, 0x80008900, 0x10a00200, 0x08004100, 0x09041108, 0x000405a6, 0x0c018000, 0x04104002}},
			{ref: 0x0064, set: pageSet{0x00002000, 0x44003000, 0x01000004, 0x00008200, 0x00000008, 0x00044010, 0x00002002, 0x00001040}},
			{ref: 0x0065, set: pageSet{0x00000000, 0xca008000, 0x02828020, 0x00b1100c, 0x12824280, 0x22013030, 0x00808820, 0x040013e4}},
			{ref: 0x0066, set: pageSet{0x801840c0, 0x1000a1a1, 0x00000004, 0x0050c200, 0x00c20082, 0x00104840, 0x10400080, 0xa3140000}},
			{ref: 0x0067, set: pageSet{0xa8a02301, 0x24123d00, 0x80030200, 0xc0028022, 0x34a10000, 0x00408005, 0x00190010, 0x882a0000}},
			{ref: 0x0068, set: pageSet{0x00080018, 0x33000402, 0x9002010a, 0x00000000, 0x00800020, 0x00010100, 0x84040810, 0x04004000}},
			{ref: 0x0069, set: pageSet{0x10006020, 0x00000000, 0x00000000, 0x30a02000, 0x00000004, 0x00000000, 0x01000800, 0x20000000}},
			{ref: 0x006a, set: pageSet{0x02000000, 0x02000602, 0x80000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x006b, set: pageSet{0x00000010, 0x44040083, 0x00081000, 0x0818824c, 0x00400e00, 0x8c300000, 0x08146001, 0x00000000}},
			{ref: 0x006c, set: pageSet{0x00828000, 0x41900000, 0x84804006, 0x24010001, 0x02400108, 0x9b080006, 0x00201602, 0x0009012e}},
			{ref: 0x006d, set: pageSet{0x40800800, 0x48000420, 0x10000032, 0x01904440, 0x02000100, 0x10048000, 0x00020000, 0x08820802}},
			{ref: 0x006e, set: pageSet{0x08080ba0, 0x00009242, 0x00400000, 0xc0008080, 0x20410001, 0x04400000, 0x60020820, 0x00100000}},
			{ref: 0x006f, set: pageSet{0x00108046, 0x01001805, 0x90100000, 0x00014010, 0x00000010, 0x00000000, 0x0000000b, 0x00008800}},
			{ref: 0x0070, set: pageSet{0x00000000, 0x00001000, 0x00000000, 0x20018800, 0x00004600, 0x06002000, 0x00000100, 0x00000000}},
			{ref: 0x0071, set: pageSet{0x00000000, 0x10400042, 0x02004000, 0x00004280, 0x80000400, 0x00020000, 0x00000008, 0x00000020}},
			{ref: 0x0072, set: pageSet{0x00000040, 0x20600400, 0x0a000180, 0x02040280, 0x00000000, 0x00409001, 0x02000004, 0x00003200}},
			{ref: 0x0073, set: pageSet{0x88000000, 0x80404800, 0x00000010, 0x00040008, 0x00000a90, 0x00000200, 0x00002000, 0x40002001}},
			{ref: 0x0074, set: pageSet{0x00000048, 0x00100000, 0x00000000, 0x00000001, 0x00000008, 0x20010080, 0x00000000, 0x00400040}},
			{ref: 0x0075, set: pageSet{0x85000000, 0x0c8f0108, 0x32129000, 0x80090420, 0x00024000, 0x40040800, 0x092000a0, 0x00100204}},
			{ref: 0x0076, set: pageSet{0x00002000, 0x00000000, 0x00440004, 0x6c000000, 0x000000d0, 0x80004000, 0x88800440, 0x41144018}},
			{ref: 0x0077, set: pageSet{0x80001a02, 0x14000001, 0x00000001, 0x0000004a, 0x00000000, 0x00083000, 0x08000000, 0x0008a024}},
			{ref: 0x0078, set: pageSet{0x00300004, 0x00140000, 0x20000000, 0x00001800, 0x00020002, 0x04000000, 0x00000002, 0x00000100}},
			{ref: 0x0079, set: pageSet{0x00004002, 0x54000000, 0x60400300, 0x00002120, 0x0000a022, 0x00000000, 0x81060803, 0x08010200}},
			{ref: 0x007a, set: pageSet{0x04004800, 0xb0044000, 0x0000a005, 0x04500800, 0x800c000a, 0x0000c000, 0x10000800, 0x02408021}},
			{ref: 0x007b, set: pageSet{0x08020000, 0x00001040, 0x00540a40, 0x00000000, 0x00800880, 0x01020002, 0x00000211, 0x00000010}},
			{ref: 0x007c, set: pageSet{0x00000000, 0x80000002, 0x00002000, 0x00080001, 0x09840a00, 0x40000080, 0x00400000, 0x49000080}},
			{ref: 0x007d, set: pageSet{0x0e102831, 0x06098807, 0x40011014, 0x02620042, 0x06000000, 0x88062000, 0x04068400, 0x08108301}},
			{ref: 0x007e, set: pageSet{0x08000012, 0x40004840, 0x00300402, 0x00012000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0x00400000, 0x00000000, 0x00a54400, 0x40004420, 0x20000310, 0x00041002, 0x18000000}},
			{ref: 0x0080, set: pageSet{0x00a1002a, 0x00080000, 0x40400000, 0x00900000, 0x21401200, 0x04048626, 0x40005048, 0x21100000}},
			{ref: 0x0081, set: pageSet{0x040005a4, 0x000a0000, 0x00214000, 0x07010800, 0x34000000, 0x00080100, 0x00080040, 0x10182508}},
			{ref: 0x0082, set: pageSet{0xc0805100, 0x02c01400, 0x00000080, 0x00448040, 0x20000800, 0x210a8000, 0x08800000, 0x00020060}},
			{ref: 0x0083, set: pageSet{0x00004004, 0x00400100, 0x01040200, 0x00800000, 0x00000000, 0x00000000, 0x10081400, 0x00008000}},
			{ref: 0x0084, set: pageSet{0x00004000, 0x20000000, 0x08800200, 0x00001000, 0x00000000, 0x01000000, 0x00000810, 0x00000000}},
			{ref: 0x0085, set: pageSet{0x00020000, 0x20200000, 0x00000000, 0x00000000, 0x00000010, 0x00001c40, 0x00002000, 0x08000210}},
			{ref: 0x0086, set: pageSet{0x00000000, 0x00000000, 0x54014000, 0x02000800, 0x00200400, 0x00000000, 0x00002080, 0x00004000}},
			{ref: 0x0087, set: pageSet{0x10000004, 0x00000000, 0x00000000, 0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0088, set: pageSet{0x00000000, 0x00000000, 0x28881041, 0x0081010a, 0x00400800, 0x00000800, 0x10208026, 0x61000000}},
			{ref: 0x0089, set: pageSet{0x00050080, 0x00000000, 0x80000000, 0x80040000, 0x044088c2, 0x00080480, 0x00040000, 0x00000048}},
			{ref: 0x008a, set: pageSet{0x8188410d, 0x141a2400, 0x40310000, 0x000f4249, 0x41283280, 0x80053011, 0x00400880, 0x410060c0}},
			{ref: 0x008b, set: pageSet{0x2a004013, 0x02000002, 0x11000000, 0x00850040, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0x00800000, 0x04000440, 0x00000402, 0x60001000, 0x99909f87, 0x5808049d, 0x10002445}},
			{ref: 0x008d, set: pageSet{0x00000100, 0x00000000, 0x00000000, 0x00910050, 0x00000420, 0x00080008, 0x20000000, 0x00288002}},
			{ref: 0x008e, set: pageSet{0x00008400, 0x00000400, 0x00000000, 0x00100000, 0x00002000, 0x00000800, 0x80043400, 0x21000004}},
			{ref: 0x008f, set: pageSet{0x20000208, 0x01000600, 0x00000010, 0x00000000, 0x48000000, 0x14060008, 0x00124020, 0x20812800}},
			{ref: 0x0090, set: pageSet{0xa419804b, 0x01064009, 0x10386ca4, 0x85a0620b, 0x00000010, 0x01000448, 0x00004400, 0x20a02102}},
			{ref: 0x0091, set: pageSet{0x00000000, 0x00000000, 0x00147000, 0x01a01404, 0x10040000, 0x01000000, 0x3002f180, 0x00000008}},
			{ref: 0x0092, set: pageSet{0x00002000, 0x00100000, 0x08000010, 0x00020004, 0x01000029, 0x00002000, 0x00000000, 0x10082000}},
			{ref: 0x0093, set: pageSet{0x00000000, 0x0004d041, 0x08000800, 0x00200000, 0x00401000, 0x00004000, 0x00000000, 0x00000002}},
			{ref: 0x0094, set: pageSet{0x01000000, 0x00000000, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00800000, 0x000a0a01, 0x0004002c, 0x01000080, 0x00000000}},
			{ref: 0x0096, set: pageSet{0x10000000, 0x08040400, 0x08012010, 0x2569043c, 0x1a10c460, 0x08800009, 0x000210f0, 0x08c5050c}},
			{ref: 0x0097, set: pageSet{0x10000481, 0x00040080, 0x42040000, 0x00100204, 0x00000000, 0x00000000, 0x00080000, 0x88080000}},
			{ref: 0x0098, set: pageSet{0x010f016c, 0x18002000, 0x41307000, 0x00000080, 0x00000000, 0x00000100, 0x88000000, 0x70048004}},
			{ref: 0x0099, set: pageSet{0x00081420, 0x00000100, 0x00000000, 0x00000000, 0x02400000, 0x00001000, 0x00050070, 0x00000000}},
			{ref: 0x009a, set: pageSet{0x000c4000, 0x00010000, 0x04000000, 0x00000000, 0x00000000, 0x01000100, 0x01000010, 0x00000400}},
			{ref: 0x009b, set: pageSet{0x00000000, 0x10020000, 0x04100024, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x00000100}},
			{ref: 0x009c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100020}},
			{ref: 0x009d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000, 0x00100000, 0x00000000, 0x00000000}},
			{ref: 0x009e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x00880000, 0x0c000040, 0x02040010, 0x00000000}},
			{ref: 0x009f, set: pageSet{0x00080000, 0x08000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 104 */
		"jv",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000300, 0x00000300}},
		},
	},
	{ /** index: 105 */
		"ka",
		RuneSet{
			{ref: 0x0010, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffff0000, 0x0001ffff}},
		},
	},
	{ /** index: 106 */
		"kaa",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x0c0c0000, 0x000cc00c, 0x03000000, 0x00000000}},
		},
	},
	{ /** index: 107 */
		"kab",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00110000, 0x00000000, 0x00000000, 0x000000c0}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08000000, 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00003000, 0x00000030, 0x00000000, 0x0000300c, 0x000c0000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 108 */
		"ki",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000300, 0x00000000, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 109 */
		"kj",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 110 */
		"kk",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0000, 0xffffffff, 0x0040ffff, 0x00000000, 0x0c0c0000, 0x0c00000c, 0x03000000, 0x00000300}},
		},
	},
	{ /** index: 111 */
		"kl",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x0d10646e, 0x0d10646e}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x01000300, 0x00000000, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 112 */
		"km",
		RuneSet{
			{ref: 0x0017, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x9fffffff, 0xffcffee7, 0x0000003f, 0x00000000}},
		},
	},
	{ /** index: 113 */
		"kn",
		RuneSet{
			{ref: 0x000c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffddfec, 0xc3effdff, 0x40603ddf, 0x00000003}},
		},
	},
	{ /** index: 114 */
		"ko",
		RuneSet{
			{ref: 0x0031, set: pageSet{0x00000000, 0xfffe0000, 0xffffffff, 0xffffffef, 0x00007fff, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x00ac, set: pageSet{0x3eff0793, 0x1303b011, 0x11102801, 0x05930000, 0xb0111e7b, 0x3b019703, 0x00a01112, 0x306b9593}},
			{ref: 0x00ad, set: pageSet{0x1102b051, 0x11303201, 0x011102b0, 0xb879300a, 0x30011306, 0x00800010, 0x100b0113, 0x93000011}},
			{ref: 0x00ae, set: pageSet{0x00102b03, 0x05930000, 0xb051746b, 0x3b011323, 0x00001030, 0x70000000, 0x1303b011, 0x11102900}},
			{ref: 0x00af, set: pageSet{0x00012180, 0xb0153000, 0x3001030e, 0x02000030, 0x10230111, 0x13000000, 0x10106b81, 0x01130300}},
			{ref: 0x00b0, set: pageSet{0x30111013, 0x00000100, 0x22b85530, 0x30000000, 0x9702b011, 0x113afb07, 0x011303b0, 0x00000021}},
			{ref: 0x00b1, set: pageSet{0x3b0d1b00, 0x03b01138, 0x11330113, 0x13000001, 0x111c2b05, 0x00000100, 0xb0111000, 0x2a011300}},
			{ref: 0x00b2, set: pageSet{0x02b01930, 0x10100001, 0x11000000, 0x10300301, 0x07130230, 0x0011146b, 0x2b051300, 0x8fb8f974}},
			{ref: 0x00b3, set: pageSet{0x103b0113, 0x00000000, 0xd9700000, 0x01134ab0, 0x0011103b, 0x00001103, 0x2ab15930, 0x10000111}},
			{ref: 0x00b4, set: pageSet{0x11010000, 0x00100b01, 0x01130000, 0x0000102b, 0x20000101, 0x02a01110, 0x30210111, 0x0102b059}},
			{ref: 0x00b5, set: pageSet{0x19300000, 0x011307b0, 0xb011383b, 0x00000003, 0x00000000, 0x383b0d13, 0x0103b011, 0x00001000}},
			{ref: 0x00b6, set: pageSet{0x01130000, 0x00101020, 0x00000100, 0x00000110, 0x30000000, 0x00021811, 0x00100000, 0x01110000}},
			{ref: 0x00b7, set: pageSet{0x00000023, 0x0b019300, 0x00301110, 0x302b0111, 0x13c7b011, 0x01303b01, 0x00000280, 0xb0113000}},
			{ref: 0x00b8, set: pageSet{0x2b011383, 0x03b01130, 0x300a0011, 0x1102b011, 0x00002000, 0x01110100, 0xa011102b, 0x2b011302}},
			{ref: 0x00b9, set: pageSet{0x01000010, 0x30000001, 0x13029011, 0x11302b01, 0x000066b0, 0xb0113000, 0x6b07d302, 0x07b0113a}},
			{ref: 0x00ba, set: pageSet{0x00200103, 0x13000000, 0x11386b05, 0x011303b0, 0x000010b8, 0x2b051b00, 0x03000110, 0x10000000}},
			{ref: 0x00bb, set: pageSet{0x1102a011, 0x79700a01, 0x0111a2b0, 0x0000100a, 0x00011100, 0x00901110, 0x00090111, 0x93000000}},
			{ref: 0x00bc, set: pageSet{0xf9f2bb05, 0x011322b0, 0x2001323b, 0x00000000, 0x06b05930, 0x303b0193, 0x1123a011, 0x11700000}},
			{ref: 0x00bd, set: pageSet{0x001102b0, 0x00001010, 0x03011301, 0x00000110, 0x162b0793, 0x01010010, 0x11300000, 0x01110200}},
			{ref: 0x00be, set: pageSet{0xb0113029, 0x00000000, 0x0eb05130, 0x383b0513, 0x0303b011, 0x00000100, 0x01930000, 0x00001039}},
			{ref: 0x00bf, set: pageSet{0x3b000302, 0x00000000, 0x00230113, 0x00000000, 0x00100000, 0x00010000, 0x90113020, 0x00000002}},
			{ref: 0x00c0, set: pageSet{0x00000000, 0x10000000, 0x11020000, 0x00000301, 0x01130000, 0xb079b02b, 0x3b011323, 0x02b01130}},
			{ref: 0x00c1, set: pageSet{0xf0210111, 0x1343b0d9, 0x11303b01, 0x011103b0, 0xb0517020, 0x20011322, 0x01901110, 0x300b0111}},
			{ref: 0x00c2, set: pageSet{0x9302b011, 0x0016ab01, 0x01130100, 0xb0113021, 0x29010302, 0x02b03130, 0x30000000, 0x1b42b819}},
			{ref: 0x00c3, set: pageSet{0x11383301, 0x00000330, 0x00000020, 0x33051300, 0x00001110, 0x00000000, 0x93000000, 0x01302305}},
			{ref: 0x00c4, set: pageSet{0x00010100, 0x30111010, 0x00000100, 0x02301130, 0x10100001, 0x11000000, 0x00000000, 0x85130200}},
			{ref: 0x00c5, set: pageSet{0x10111003, 0x2b011300, 0x63b87730, 0x303b0113, 0x11a2b091, 0x7b300201, 0x011357f0, 0xf0d1702b}},
			{ref: 0x00c6, set: pageSet{0x1b0111e3, 0x0ab97130, 0x303b0113, 0x13029001, 0x11302b01, 0x071302b0, 0x3011302b, 0x23011303}},
			{ref: 0x00c7, set: pageSet{0x02b01130, 0x30ab0113, 0x11feb411, 0x71300901, 0x05d347b8, 0xb011307b, 0x21015303, 0x00001110}},
			{ref: 0x00c8, set: pageSet{0x306b0513, 0x1102b011, 0x00103301, 0x05130000, 0xa01038eb, 0x30000102, 0x02b01110, 0x30200013}},
			{ref: 0x00c9, set: pageSet{0x0102b071, 0x00101000, 0x01130000, 0x1011100b, 0x2b011300, 0x00000000, 0x366b0593, 0x1303b095}},
			{ref: 0x00ca, set: pageSet{0x01103b01, 0x00000200, 0xb0113000, 0x20000103, 0x01000010, 0x30000000, 0x030ab011, 0x00101001}},
			{ref: 0x00cb, set: pageSet{0x01110100, 0x00000003, 0x23011302, 0x03000010, 0x10000000, 0x01000000, 0x00100000, 0x00000290}},
			{ref: 0x00cc, set: pageSet{0x30113000, 0x7b015386, 0x03b01130, 0x00210151, 0x13000000, 0x11303b01, 0x001102b0, 0x00011010}},
			{ref: 0x00cd, set: pageSet{0x2b011302, 0x02001110, 0x10000000, 0x0102b011, 0x11300100, 0x000102b0, 0x00011010, 0x2b011100}},
			{ref: 0x00ce, set: pageSet{0x02101110, 0x002b0113, 0x93000000, 0x11302b03, 0x011302b0, 0x0000303b, 0x00000002, 0x03b01930}},
			{ref: 0x00cf, set: pageSet{0x102b0113, 0x0103b011, 0x11300000, 0x011302b0, 0x00001021, 0x00010102, 0x00000010, 0x102b0113}},
			{ref: 0x00d0, set: pageSet{0x01020011, 0x11302000, 0x011102b0, 0x30113001, 0x00000002, 0x02b01130, 0x303b0313, 0x0103b011}},
			{ref: 0x00d1, set: pageSet{0x00002000, 0x05130000, 0xb011303b, 0x10001102, 0x00000110, 0x142b0113, 0x01000001, 0x01100000}},
			{ref: 0x00d2, set: pageSet{0x00010280, 0xb0113000, 0x10000102, 0x00000010, 0x10230113, 0x93021011, 0x11100b05, 0x01130030}},
			{ref: 0x00d3, set: pageSet{0xb051702b, 0x3b011323, 0x00000030, 0x30000000, 0x1303b011, 0x11102b01, 0x01010330, 0xb011300a}},
			{ref: 0x00d4, set: pageSet{0x20000102, 0x00000000, 0x10000011, 0x9300a011, 0x00102b05, 0x00000200, 0x90111000, 0x29011100}},
			{ref: 0x00d5, set: pageSet{0x00b01110, 0x30000000, 0x1302b011, 0x11302b21, 0x000103b0, 0x00000020, 0x2b051300, 0x02b01130}},
			{ref: 0x00d6, set: pageSet{0x103b0113, 0x13002011, 0x11322b21, 0x00130280, 0xa0113028, 0x0a011102, 0x02921130, 0x30210111}},
			{ref: 0x00d7, set: pageSet{0x13020011, 0x11302b01, 0x03d30290, 0x3011122b, 0x2b011302, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 115 */
		"kok",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 116 */
		"kr",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x20000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 117 */
		"ks",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x040001df, 0x80800176, 0x420c0000, 0x01020140, 0x44008200, 0x00041018, 0x00000000}},
		},
	},
	{ /** index: 118 */
		"ku-am",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0000, 0xffff27bf, 0x000027bf, 0x00000000, 0x00000000, 0x0c000000, 0x03000000, 0x000000c0}},
			{ref: 0x0005, set: pageSet{0x3c000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 119 */
		"ku-iq",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x061ef5c0, 0x000001f6, 0x40000000, 0x01040040, 0x00208210, 0x00005040, 0x00000000}},
		},
	},
	{ /** index: 120 */
		"ku-ir",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x061ef5c0, 0x000001f6, 0x40000000, 0x01040040, 0x00208210, 0x00005040, 0x00000000}},
		},
	},
	{ /** index: 121 */
		"ku-tr",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x08004480, 0x08004480}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0xc0000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 122 */
		"kum",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 123 */
		"kv",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0042, 0xffffffff, 0x0042ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000c0}},
		},
	},
	{ /** index: 124 */
		"kw",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000c0003, 0x00000c00, 0x00003000, 0x00000c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x000c0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 125 */
		"kwm",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 126 */
		"ky",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x0000c00c, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 127 */
		"la",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000c0003, 0x00003c00, 0x0000f000, 0x00003c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 128 */
		"lah",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x040001de, 0x00000176, 0x42000000, 0x01020140, 0x44008200, 0x00041008, 0x00000000}},
		},
	},
	{ /** index: 129 */
		"lb",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x98504f14, 0x18504f14}},
		},
	},
	{ /** index: 130 */
		"lez",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0042, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 131 */
		"lg",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 132 */
		"li",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00480910, 0x00480910}},
		},
	},
	{ /** index: 133 */
		"lij",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x060cb301, 0x060eb3d5}},
		},
	},
	{ /** index: 134 */
		"ln",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x0c186606, 0x0c186606}},
			{ref: 0x0001, set: pageSet{0x0c000000, 0x00000000, 0x00000000, 0x00000000, 0x00010040, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00001006, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 135 */
		"lo",
		RuneSet{
			{ref: 0x000e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfef02596, 0x3bffecae, 0x30003f5f, 0x00000000}},
		},
	},
	{ /** index: 136 */
		"lt",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x03c03030, 0x0000c000, 0x00000000, 0x600c0c03, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 137 */
		"lv",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000c3003, 0x18c00c0c, 0x00c03060, 0x60000c03, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 138 */
		"lzh",
		RuneSet{
			{ref: 0x004e, set: pageSet{0xc373ff8b, 0x1b0f6840, 0xf34ce9ac, 0xc0080200, 0xca3e795c, 0x06487976, 0xf7f02fdf, 0xa8ff033a}},
			{ref: 0x004f, set: pageSet{0x233fef37, 0xfd59b004, 0xfffff3ca, 0xfff9de9f, 0x7df7abff, 0x8eecc000, 0xffdbeebf, 0x45fad003}},
			{ref: 0x0050, set: pageSet{0xdffefae1, 0x10abbfef, 0xfcaaffeb, 0x24fdef3f, 0x7f7678ad, 0xedfff00c, 0x2cfacff6, 0xeb6bf7f9}},
			{ref: 0x0051, set: pageSet{0x95bf1ffd, 0xbfbf6677, 0xfeb43bfb, 0x11e27bae, 0x41bea681, 0x72c31435, 0x71917d70, 0x276b0003}},
			{ref: 0x0052, set: pageSet{0x70cf57cb, 0x0def4732, 0xfc747eda, 0xbdb4fe06, 0x8bca3f9f, 0x58007e49, 0xebec228f, 0xddbb8a5c}},
			{ref: 0x0053, set: pageSet{0xb6e7ef60, 0xf293a40f, 0x549e37bb, 0x9bafd04b, 0xf7d4c414, 0x0a1430b0, 0x88d02f08, 0x192fff7e}},
			{ref: 0x0054, set: pageSet{0xfb07ffda, 0x7beb7ff1, 0x0010c5ef, 0xfdff99ff, 0x056779d7, 0xfdcbffe7, 0x4040c3ff, 0xbd8e6ff7}},
			{ref: 0x0055, set: pageSet{0x0497dffa, 0x5bfff4c0, 0xd0e7ed7b, 0xf8e0047e, 0xb73eff9f, 0x882e7dfe, 0xbe7ffffd, 0xf6c483fe}},
			{ref: 0x0056, set: pageSet{0xb8fdf357, 0xef7dd680, 0x47885767, 0xc3dfff7d, 0x37a9f0ff, 0x70fc7de0, 0xec9a3f6f, 0x86814cb3}},
			{ref: 0x0057, set: pageSet{0xdd5c3f9e, 0x4819f70d, 0x0007fea3, 0x38ffaf56, 0xefb8980d, 0xb760403d, 0x9035d8ce, 0x3fff72bf}},
			{ref: 0x0058, set: pageSet{0x7a117ff7, 0xabfff7bb, 0x6fbeff00, 0xfe72a93c, 0xf11bcfef, 0xf40adb6b, 0xef7ec3e6, 0xf6109b9c}},
			{ref: 0x0059, set: pageSet{0x16f4f048, 0x5182feb5, 0x15bbc7b1, 0xfbdf6e87, 0x63cde43f, 0x7e7ec1ff, 0x7d5ffdeb, 0xfcfe777b}},
			{ref: 0x005a, set: pageSet{0xdbea960b, 0x53e86229, 0xfdef37df, 0xbd8136f5, 0xfcbddc18, 0xffffd2e4, 0xffe03fd7, 0xabf87f6f}},
			{ref: 0x005b, set: pageSet{0x6ed99bae, 0xf115f5fb, 0xbdfb79a9, 0xadaf5a3c, 0x1facdbba, 0x837971fc, 0xc35f7cf7, 0x0567dfff}},
			{ref: 0x005c, set: pageSet{0x8467ff9a, 0xdf8b1534, 0x3373f9f3, 0x5e1af7bd, 0xa03fbf40, 0x01ebffff, 0xcfdddfc0, 0xabd37500}},
			{ref: 0x005d, set: pageSet{0xeed6f8c3, 0xb7ff43fd, 0x42275eaf, 0xf6869bac, 0xf6bc27d7, 0x35b7f787, 0xe176aacd, 0xe29f49e7}},
			{ref: 0x005e, set: pageSet{0xaff2545c, 0x61d82b3f, 0xbbb8fc3b, 0x7b7dffcf, 0x1ce0bf95, 0x43ff7dfd, 0xfffe5ff6, 0xc4ced3ef}},
			{ref: 0x005f, set: pageSet{0xadbc8db6, 0x11eb63dc, 0x23d0df59, 0xf3dbbeb4, 0xdbc71fe7, 0xfae4ff63, 0x63f7b22b, 0xadbaed3b}},
			{ref: 0x0060, set: pageSet{0x7efffe01, 0x02bcfff7, 0xef3932ff, 0x8005fffc, 0xbcf577fb, 0xfff7010d, 0xbf3afffb, 0xdfff0057}},
			{ref: 0x0061, set: pageSet{0xbd7def7b, 0xc8d4db88, 0xed7cfff3, 0x56ff5dee, 0xac5f7e0d, 0xd57fff96, 0xc1403fee, 0xffe76ff9}},
			{ref: 0x0062, set: pageSet{0x8e77779b, 0xe45d6ebf, 0x5f1f6fcf, 0xfedfe07f, 0x01fed7db, 0xfb7bff00, 0x1fdfffd4, 0xfffff800}},
			{ref: 0x0063, set: pageSet{0x007bfb8f, 0x7f5cbf00, 0x07f3ffff, 0x3de7eba0, 0xfbd7f7bf, 0x6003ffbf, 0xbfedfffd, 0x027fefbb}},
			{ref: 0x0064, set: pageSet{0xddfdfe40, 0xe2f9fdff, 0xfb1f680b, 0xaffdfbe3, 0xf7ed9fa4, 0xf80f7a7d, 0x0fd5eebe, 0xfd9fbb5d}},
			{ref: 0x0065, set: pageSet{0x3bf9f2db, 0xebccfe7f, 0x73fa876a, 0x9ffc95fc, 0xfaf7109f, 0xbbcdddb7, 0xeccdf87e, 0x3c3ff366}},
			{ref: 0x0066, set: pageSet{0xb03ffffd, 0x067ee9f7, 0xfe0696ae, 0x5fd7d576, 0xa3f33fd1, 0x6fb7cf07, 0x7f449fd1, 0xd3dd7b59}},
			{ref: 0x0067, set: pageSet{0xa9bdaf3b, 0xff3a7dcf, 0xf6ebfbe0, 0xffffb401, 0xb7bf7afa, 0x0ffdc000, 0xff1fff7f, 0x95fffefc}},
			{ref: 0x0068, set: pageSet{0xb5dc0000, 0x3f3eef63, 0x001bfb7f, 0xfbf6e800, 0xb8df9eef, 0x003fff9f, 0xf5ff7bd0, 0x3fffdfdb}},
			{ref: 0x0069, set: pageSet{0x00bffdf0, 0xbbbd8420, 0xffdedf37, 0x0ff3ff6d, 0x5efb604c, 0xfafbfffb, 0x0219fe5e, 0xf9de79f4}},
			{ref: 0x006a, set: pageSet{0xebfaa7f7, 0xff3401eb, 0xef73ebd3, 0xc040afd7, 0xdcff72bb, 0x2fd8f17f, 0xfe0bb8ec, 0x1f0bdda3}},
			{ref: 0x006b, set: pageSet{0x47cf8f1d, 0xffdeb12b, 0xda737fee, 0xcbc424ff, 0xcbf2f75d, 0xb4edecfd, 0x4dddbff9, 0xfb8d99dd}},
			{ref: 0x006c, set: pageSet{0xaf7bbb7f, 0xc959ddfb, 0xfab5fc4f, 0x6d5fafe3, 0x3f7dffff, 0xffdb7800, 0x7effb6ff, 0x022ffbaf}},
			{ref: 0x006d, set: pageSet{0xefc7ff9b, 0xffffffa5, 0xc7000007, 0xfff1f7ff, 0x01bf7ffd, 0xfdbcdc00, 0xffffbff5, 0x3effff7f}},
			{ref: 0x006e, set: pageSet{0xbe000029, 0xff7ff9ff, 0xfd7e6efb, 0x039ecbff, 0xfbdde300, 0xf6dfccff, 0x117fffff, 0xfbf6f800}},
			{ref: 0x006f, set: pageSet{0xd73ce7ef, 0xdfeffeef, 0xedbfc00b, 0xfdcdfedf, 0x40fd7bf5, 0xb75fffff, 0xf930ffdf, 0xdc97fbdf}},
			{ref: 0x0070, set: pageSet{0xbff2fef3, 0xdfbf8fdf, 0xede6177f, 0x35530f7f, 0x877e447c, 0x45bbfa12, 0x779eede0, 0xbfd98017}},
			{ref: 0x0071, set: pageSet{0xde897e55, 0x0447c16f, 0xf75d7ade, 0x290557ff, 0xfe9586f7, 0xf32f97b3, 0x9f75cfff, 0xfb1771f7}},
			{ref: 0x0072, set: pageSet{0xee1934ee, 0xef6137cc, 0xef4c9fd6, 0xfbddd68f, 0x6def7b73, 0xa431d7fe, 0x97d75e7f, 0xffd80f5b}},
			{ref: 0x0073, set: pageSet{0x7bce9d83, 0xdcff22ec, 0xef87763d, 0xfdeddfe7, 0xa0fc4fff, 0xdbfc3b77, 0x7fdc3ded, 0xf5706fa9}},
			{ref: 0x0074, set: pageSet{0x2c403ffb, 0x847fff7f, 0xdeb7ec57, 0xf22fe69c, 0xd5b50feb, 0xede7afeb, 0xfff08c2f, 0xe8f0537f}},
			{ref: 0x0075, set: pageSet{0xb5ffb99d, 0xe78fff66, 0xbe10d981, 0xe3c19c7c, 0x27339cd1, 0xff6d0cbc, 0xefb7fcb7, 0xffffa0df}},
			{ref: 0x0076, set: pageSet{0xfe7bbf0b, 0x353fa3ff, 0x97cd13cc, 0xfb277637, 0x7e6ccfd6, 0xed31ec50, 0xfc1c677c, 0x5fbff6fa}},
			{ref: 0x0077, set: pageSet{0xae2f0fba, 0x7ffea3ad, 0xde74fcf0, 0xf200ffef, 0xfea2fbbf, 0xbcff3daf, 0x5fb9f694, 0x3f8ff3ad}},
			{ref: 0x0078, set: pageSet{0xa01ff26c, 0x01bfffef, 0x70057728, 0xda03ff35, 0xc7fad2f9, 0x5c1d3fbf, 0xec33ff3a, 0xfe9cb7af}},
			{ref: 0x0079, set: pageSet{0x7a9f5236, 0xe722bffa, 0xfcff9ff7, 0xb61d2fbb, 0x1dfded06, 0xefdf7dd7, 0xf166eb23, 0x0dc07ed9}},
			{ref: 0x007a, set: pageSet{0xdfbf3d3d, 0xba83c945, 0x9dd07dd1, 0xcf737b87, 0xc3f59ff3, 0xc5fedf0d, 0x83020cb3, 0xaec0e879}},
			{ref: 0x007b, set: pageSet{0x6f0fc773, 0x093ffd7d, 0x0157fff1, 0x01ff62fb, 0x3bf3fdb4, 0x43b2b013, 0xff305ed3, 0xeb9f0fff}},
			{ref: 0x007c, set: pageSet{0xf203feef, 0xfb893fef, 0x9e9937a9, 0xa72cdef9, 0xc1f63733, 0xfe3e812e, 0xf2f75d20, 0x69d7d585}},
			{ref: 0x007d, set: pageSet{0xffffffff, 0xff6fdb07, 0xd97fc4ff, 0xbe0fefce, 0xf05ef17b, 0xffb7f6cf, 0xef845ef7, 0x0edfd7cb}},
			{ref: 0x007e, set: pageSet{0xfcffff08, 0xffffee3f, 0xd7ff13ff, 0x7ffdaf0f, 0x1ffabdc7, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0xe7400000, 0xf933bd38, 0xfeed7feb, 0x7c767fe8, 0xffefb3f7, 0xd8b7feaf, 0xfbbfff6f}},
			{ref: 0x0080, set: pageSet{0xdbf7f8fb, 0xe2f91752, 0x754785c8, 0xe3ef9090, 0x3f6d9ef4, 0x0536ee2e, 0x7ff3f7bc, 0x7f3fa07b}},
			{ref: 0x0081, set: pageSet{0xeb600567, 0x6601babe, 0x583ffcd8, 0x87dfcaf7, 0xffa0bfcd, 0xfebf5bcd, 0xefa7b6fd, 0xdf9c77ef}},
			{ref: 0x0082, set: pageSet{0xf8773fb7, 0xb7fc9d27, 0xdfefcab5, 0xf1b6fb5a, 0xef1fec39, 0x7ffbfbbf, 0xdafe000d, 0x4e7fbdfb}},
			{ref: 0x0083, set: pageSet{0x5ac033ff, 0x9ffebff5, 0x005fffbf, 0xfdf80000, 0x6ffdffca, 0xa001cffd, 0xfbf2dfff, 0xff7fdfbf}},
			{ref: 0x0084, set: pageSet{0x080ffeda, 0xbfffba08, 0xeed77afd, 0x67f9fbeb, 0xff93e044, 0x9f57df97, 0x08dffef7, 0xfedfdf80}},
			{ref: 0x0085, set: pageSet{0xf7feffc5, 0x6803fffb, 0x6bfa67fb, 0x5fe27fff, 0xff73ffff, 0xe7fb87df, 0xf7a7ebfd, 0xefc7bf7e}},
			{ref: 0x0086, set: pageSet{0xdf821ef3, 0xdf7e76ff, 0xda7d79c9, 0x1e9befbe, 0x77fb7ce0, 0xfffb87be, 0xffdb1bff, 0x4fe03f5c}},
			{ref: 0x0087, set: pageSet{0x5f0e7fff, 0xddbf77ff, 0xfffff04f, 0x0ff8ffff, 0xfddfa3be, 0xfffdfc1c, 0xfb9e1f7d, 0xdedcbdff}},
			{ref: 0x0088, set: pageSet{0xbafb3f6f, 0xfbefdf7f, 0x2eec7d1b, 0xf2f7af8e, 0xcfee7b0f, 0x77c61d96, 0xfff57e07, 0x7fdfd982}},
			{ref: 0x0089, set: pageSet{0xc7ff5ee6, 0x79effeee, 0xffcf9a56, 0xde5efe5f, 0xf9e8896e, 0xe6c4f45e, 0xbe7c0001, 0xdddf3b7f}},
			{ref: 0x008a, set: pageSet{0xe9efd59d, 0xde5334ac, 0x4bf7f573, 0x9eff7b4f, 0x476eb8fe, 0xff450dfb, 0xfbfeabfd, 0xddffe9d7}},
			{ref: 0x008b, set: pageSet{0x7fffedf7, 0x7eebddfd, 0xb7ffcfe7, 0xef91bde9, 0xd77c5d75, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0xfa800000, 0xb4f1ffee, 0x2fefbf76, 0x77bfb677, 0xfffd9fbf, 0xf6ae95bf, 0x7f3b75ff}},
			{ref: 0x008d, set: pageSet{0x0af9a7f5, 0x00000000, 0x00000000, 0x2bddfbd0, 0x9a7ff633, 0xd6fcfdab, 0xbfebf9e6, 0xf41fdfdf}},
			{ref: 0x008e, set: pageSet{0xffffa6fd, 0xf37b4aff, 0xfef97fb7, 0x1d5cb6ff, 0xe5ff7ff6, 0x24041f7b, 0xf99ebe05, 0xdff2dbe3}},
			{ref: 0x008f, set: pageSet{0xfdff6fef, 0xcbfcd679, 0xefffebfd, 0x0000001f, 0x98000000, 0x8017e148, 0x00fe6a74, 0xfdf16d7f}},
			{ref: 0x0090, set: pageSet{0xfef3b87f, 0xf176e01f, 0x7b3fee96, 0xfffdeb8d, 0xcbb3adff, 0xe17f84ef, 0xbff04daa, 0xfe3fbf3f}},
			{ref: 0x0091, set: pageSet{0xffd7ebff, 0xcf7fffdf, 0x85edfffb, 0x07bcd73f, 0xfe0faeff, 0x76bffdaf, 0x37bbfaef, 0xa3ba7fdc}},
			{ref: 0x0092, set: pageSet{0x56f7b6ff, 0xe7df60f8, 0x4cdfff61, 0xff45b0fb, 0x3ffa7ded, 0x18fc1fff, 0xe3afffff, 0xdf83c7d3}},
			{ref: 0x0093, set: pageSet{0xef7dfb57, 0x1378efff, 0x5ff7fec0, 0x5ee334bb, 0xeff6f70d, 0x00bfd7fe, 0xf7f7f59d, 0xffe051de}},
			{ref: 0x0094, set: pageSet{0x037ffec9, 0xbfef5f01, 0x60a79ff1, 0xf1ffef1d, 0x0000000f, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x3c800000, 0xd91ffb4d, 0xfee37b3a, 0xdc7f3fe9, 0x0000003f}},
			{ref: 0x0096, set: pageSet{0x50000000, 0xbe07f51f, 0xf91bfc1d, 0x71ffbc1e, 0x5bbe6ff9, 0x9b1b5796, 0xfffc7fff, 0xafe7872e}},
			{ref: 0x0097, set: pageSet{0xf34febf5, 0xe725dffd, 0x5d440bdc, 0xfddd5747, 0x7790ed3f, 0x8ac87d7f, 0xf3f9fafa, 0xef4b202a}},
			{ref: 0x0098, set: pageSet{0x79cff5ff, 0x0ba5abd3, 0xfb8ff77a, 0x001f8ebd, 0x00000000, 0xfd4ef300, 0x88001a57, 0x7654aeac}},
			{ref: 0x0099, set: pageSet{0xcdff17ad, 0xf42fffb2, 0xdbff5baa, 0x00000002, 0x73c00000, 0x2e3ff9ea, 0xbbfffa8e, 0xffd376bc}},
			{ref: 0x009a, set: pageSet{0x7e72eefe, 0xe7f77ebd, 0xcefdf77f, 0x00000ff5, 0x00000000, 0xdb9ba900, 0x917fa4c7, 0x7ecef8ca}},
			{ref: 0x009b, set: pageSet{0xc7e77d7a, 0xdcaecbbd, 0x8f76fd7e, 0x7cf391d3, 0x4c2f01e5, 0xa360ed77, 0x5ef807db, 0x21811df7}},
			{ref: 0x009c, set: pageSet{0x309c6be0, 0xfade3b3a, 0xc3f57f53, 0x07ba61cd, 0x00000000, 0x00000000, 0x00000000, 0xbefe26e0}},
			{ref: 0x009d, set: pageSet{0xebb503f9, 0xe9cbe36d, 0xbfde9c2f, 0xabbf9f83, 0xffd51ff7, 0xdffeb7df, 0xffeffdae, 0xeffdfb7e}},
			{ref: 0x009e, set: pageSet{0x6ebfaaff, 0x00000000, 0x00000000, 0xb6200000, 0xbe9e7fcd, 0x58f162b3, 0xfd7bf10d, 0xbefde9f1}},
			{ref: 0x009f, set: pageSet{0x5f6dc6c3, 0x69ffff3d, 0xfbf4ffcf, 0x4ff7dcfb, 0x11372000, 0x00000015, 0x00000000, 0x00000000}},
			{ref: 0x00fa, set: pageSet{0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 139 */
		"mag",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 140 */
		"mai",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 141 */
		"mfe",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x1a10cfc5, 0x9a10cfc5}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x000c0000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 142 */
		"mg",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00100002, 0x00100002}},
		},
	},
	{ /** index: 143 */
		"mh",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000003, 0x18000000, 0x00003060, 0x00000c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 144 */
		"mhr",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 145 */
		"mi",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000c0003, 0x00000c00, 0x00003000, 0x00000c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00300000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 146 */
		"miq",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x140a2202, 0x142a220a}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000200, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 147 */
		"mjw",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00528f81, 0x00528f81}},
		},
	},
	{ /** index: 148 */
		"mk",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xfdffb729, 0x000001ff, 0xb7290000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 149 */
		"ml",
		RuneSet{
			{ref: 0x000d, set: pageSet{0xfffddfec, 0xc3fffdff, 0x00803dcf, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 150 */
		"mn-cn",
		RuneSet{
			{ref: 0x0018, set: pageSet{0x00000000, 0xffffffff, 0xffffffff, 0x00ffffff, 0xffffffff, 0x000003ff, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 151 */
		"mn-mn",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x0000c000, 0x00000000, 0x00000300}},
		},
	},
	{ /** index: 152 */
		"mni",
		RuneSet{
			{ref: 0x0009, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000010, 0xfff99fee, 0xf3c5fdff, 0xb000798f, 0x0002ffc0}},
		},
	},
	{ /** index: 153 */
		"mnw",
		RuneSet{
			{ref: 0x0010, set: pageSet{0xffffffff, 0x0007f6fb, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 154 */
		"mo",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00004004, 0x00004004}},
			{ref: 0x0001, set: pageSet{0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x0f000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 155 */
		"mr",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 156 */
		"ms",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 157 */
		"mt",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x02045101, 0x02045101}},
			{ref: 0x0001, set: pageSet{0x00000c00, 0x000000c3, 0x00000000, 0x18000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 158 */
		"my",
		RuneSet{
			{ref: 0x0010, set: pageSet{0xffffffff, 0x0007f6fb, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 159 */
		"na",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00220008, 0x00220008}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 160 */
		"nan",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00528f81, 0x00528f81}},
			{ref: 0x004e, set: pageSet{0xc373ff8b, 0x1b0f6840, 0xf34ce9ac, 0xc0080200, 0xca3e795c, 0x06487976, 0xf7f02fdf, 0xa8ff033a}},
			{ref: 0x004f, set: pageSet{0x233fef37, 0xfd59b004, 0xfffff3ca, 0xfff9de9f, 0x7df7abff, 0x8eecc000, 0xffdbeebf, 0x45fad003}},
			{ref: 0x0050, set: pageSet{0xdffefae1, 0x10abbfef, 0xfcaaffeb, 0x24fdef3f, 0x7f7678ad, 0xedfff00c, 0x2cfacff6, 0xeb6bf7f9}},
			{ref: 0x0051, set: pageSet{0x95bf1ffd, 0xbfbf6677, 0xfeb43bfb, 0x11e27bae, 0x41bea681, 0x72c31435, 0x71917d70, 0x276b0003}},
			{ref: 0x0052, set: pageSet{0x70cf57cb, 0x0def4732, 0xfc747eda, 0xbdb4fe06, 0x8bca3f9f, 0x58007e49, 0xebec228f, 0xddbb8a5c}},
			{ref: 0x0053, set: pageSet{0xb6e7ef60, 0xf293a40f, 0x549e37bb, 0x9bafd04b, 0xf7d4c414, 0x0a1430b0, 0x88d02f08, 0x192fff7e}},
			{ref: 0x0054, set: pageSet{0xfb07ffda, 0x7beb7ff1, 0x0010c5ef, 0xfdff99ff, 0x056779d7, 0xfdcbffe7, 0x4040c3ff, 0xbd8e6ff7}},
			{ref: 0x0055, set: pageSet{0x0497dffa, 0x5bfff4c0, 0xd0e7ed7b, 0xf8e0047e, 0xb73eff9f, 0x882e7dfe, 0xbe7ffffd, 0xf6c483fe}},
			{ref: 0x0056, set: pageSet{0xb8fdf357, 0xef7dd680, 0x47885767, 0xc3dfff7d, 0x37a9f0ff, 0x70fc7de0, 0xec9a3f6f, 0x86814cb3}},
			{ref: 0x0057, set: pageSet{0xdd5c3f9e, 0x4819f70d, 0x0007fea3, 0x38ffaf56, 0xefb8980d, 0xb760403d, 0x9035d8ce, 0x3fff72bf}},
			{ref: 0x0058, set: pageSet{0x7a117ff7, 0xabfff7bb, 0x6fbeff00, 0xfe72a93c, 0xf11bcfef, 0xf40adb6b, 0xef7ec3e6, 0xf6109b9c}},
			{ref: 0x0059, set: pageSet{0x16f4f048, 0x5182feb5, 0x15bbc7b1, 0xfbdf6e87, 0x63cde43f, 0x7e7ec1ff, 0x7d5ffdeb, 0xfcfe777b}},
			{ref: 0x005a, set: pageSet{0xdbea960b, 0x53e86229, 0xfdef37df, 0xbd8136f5, 0xfcbddc18, 0xffffd2e4, 0xffe03fd7, 0xabf87f6f}},
			{ref: 0x005b, set: pageSet{0x6ed99bae, 0xf115f5fb, 0xbdfb79a9, 0xadaf5a3c, 0x1facdbba, 0x837971fc, 0xc35f7cf7, 0x0567dfff}},
			{ref: 0x005c, set: pageSet{0x8467ff9a, 0xdf8b1534, 0x3373f9f3, 0x5e1af7bd, 0xa03fbf40, 0x01ebffff, 0xcfdddfc0, 0xabd37500}},
			{ref: 0x005d, set: pageSet{0xeed6f8c3, 0xb7ff43fd, 0x42275eaf, 0xf6869bac, 0xf6bc27d7, 0x35b7f787, 0xe176aacd, 0xe29f49e7}},
			{ref: 0x005e, set: pageSet{0xaff2545c, 0x61d82b3f, 0xbbb8fc3b, 0x7b7dffcf, 0x1ce0bf95, 0x43ff7dfd, 0xfffe5ff6, 0xc4ced3ef}},
			{ref: 0x005f, set: pageSet{0xadbc8db6, 0x11eb63dc, 0x23d0df59, 0xf3dbbeb4, 0xdbc71fe7, 0xfae4ff63, 0x63f7b22b, 0xadbaed3b}},
			{ref: 0x0060, set: pageSet{0x7efffe01, 0x02bcfff7, 0xef3932ff, 0x8005fffc, 0xbcf577fb, 0xfff7010d, 0xbf3afffb, 0xdfff0057}},
			{ref: 0x0061, set: pageSet{0xbd7def7b, 0xc8d4db88, 0xed7cfff3, 0x56ff5dee, 0xac5f7e0d, 0xd57fff96, 0xc1403fee, 0xffe76ff9}},
			{ref: 0x0062, set: pageSet{0x8e77779b, 0xe45d6ebf, 0x5f1f6fcf, 0xfedfe07f, 0x01fed7db, 0xfb7bff00, 0x1fdfffd4, 0xfffff800}},
			{ref: 0x0063, set: pageSet{0x007bfb8f, 0x7f5cbf00, 0x07f3ffff, 0x3de7eba0, 0xfbd7f7bf, 0x6003ffbf, 0xbfedfffd, 0x027fefbb}},
			{ref: 0x0064, set: pageSet{0xddfdfe40, 0xe2f9fdff, 0xfb1f680b, 0xaffdfbe3, 0xf7ed9fa4, 0xf80f7a7d, 0x0fd5eebe, 0xfd9fbb5d}},
			{ref: 0x0065, set: pageSet{0x3bf9f2db, 0xebccfe7f, 0x73fa876a, 0x9ffc95fc, 0xfaf7109f, 0xbbcdddb7, 0xeccdf87e, 0x3c3ff366}},
			{ref: 0x0066, set: pageSet{0xb03ffffd, 0x067ee9f7, 0xfe0696ae, 0x5fd7d576, 0xa3f33fd1, 0x6fb7cf07, 0x7f449fd1, 0xd3dd7b59}},
			{ref: 0x0067, set: pageSet{0xa9bdaf3b, 0xff3a7dcf, 0xf6ebfbe0, 0xffffb401, 0xb7bf7afa, 0x0ffdc000, 0xff1fff7f, 0x95fffefc}},
			{ref: 0x0068, set: pageSet{0xb5dc0000, 0x3f3eef63, 0x001bfb7f, 0xfbf6e800, 0xb8df9eef, 0x003fff9f, 0xf5ff7bd0, 0x3fffdfdb}},
			{ref: 0x0069, set: pageSet{0x00bffdf0, 0xbbbd8420, 0xffdedf37, 0x0ff3ff6d, 0x5efb604c, 0xfafbfffb, 0x0219fe5e, 0xf9de79f4}},
			{ref: 0x006a, set: pageSet{0xebfaa7f7, 0xff3401eb, 0xef73ebd3, 0xc040afd7, 0xdcff72bb, 0x2fd8f17f, 0xfe0bb8ec, 0x1f0bdda3}},
			{ref: 0x006b, set: pageSet{0x47cf8f1d, 0xffdeb12b, 0xda737fee, 0xcbc424ff, 0xcbf2f75d, 0xb4edecfd, 0x4dddbff9, 0xfb8d99dd}},
			{ref: 0x006c, set: pageSet{0xaf7bbb7f, 0xc959ddfb, 0xfab5fc4f, 0x6d5fafe3, 0x3f7dffff, 0xffdb7800, 0x7effb6ff, 0x022ffbaf}},
			{ref: 0x006d, set: pageSet{0xefc7ff9b, 0xffffffa5, 0xc7000007, 0xfff1f7ff, 0x01bf7ffd, 0xfdbcdc00, 0xffffbff5, 0x3effff7f}},
			{ref: 0x006e, set: pageSet{0xbe000029, 0xff7ff9ff, 0xfd7e6efb, 0x039ecbff, 0xfbdde300, 0xf6dfccff, 0x117fffff, 0xfbf6f800}},
			{ref: 0x006f, set: pageSet{0xd73ce7ef, 0xdfeffeef, 0xedbfc00b, 0xfdcdfedf, 0x40fd7bf5, 0xb75fffff, 0xf930ffdf, 0xdc97fbdf}},
			{ref: 0x0070, set: pageSet{0xbff2fef3, 0xdfbf8fdf, 0xede6177f, 0x35530f7f, 0x877e447c, 0x45bbfa12, 0x779eede0, 0xbfd98017}},
			{ref: 0x0071, set: pageSet{0xde897e55, 0x0447c16f, 0xf75d7ade, 0x290557ff, 0xfe9586f7, 0xf32f97b3, 0x9f75cfff, 0xfb1771f7}},
			{ref: 0x0072, set: pageSet{0xee1934ee, 0xef6137cc, 0xef4c9fd6, 0xfbddd68f, 0x6def7b73, 0xa431d7fe, 0x97d75e7f, 0xffd80f5b}},
			{ref: 0x0073, set: pageSet{0x7bce9d83, 0xdcff22ec, 0xef87763d, 0xfdeddfe7, 0xa0fc4fff, 0xdbfc3b77, 0x7fdc3ded, 0xf5706fa9}},
			{ref: 0x0074, set: pageSet{0x2c403ffb, 0x847fff7f, 0xdeb7ec57, 0xf22fe69c, 0xd5b50feb, 0xede7afeb, 0xfff08c2f, 0xe8f0537f}},
			{ref: 0x0075, set: pageSet{0xb5ffb99d, 0xe78fff66, 0xbe10d981, 0xe3c19c7c, 0x27339cd1, 0xff6d0cbc, 0xefb7fcb7, 0xffffa0df}},
			{ref: 0x0076, set: pageSet{0xfe7bbf0b, 0x353fa3ff, 0x97cd13cc, 0xfb277637, 0x7e6ccfd6, 0xed31ec50, 0xfc1c677c, 0x5fbff6fa}},
			{ref: 0x0077, set: pageSet{0xae2f0fba, 0x7ffea3ad, 0xde74fcf0, 0xf200ffef, 0xfea2fbbf, 0xbcff3daf, 0x5fb9f694, 0x3f8ff3ad}},
			{ref: 0x0078, set: pageSet{0xa01ff26c, 0x01bfffef, 0x70057728, 0xda03ff35, 0xc7fad2f9, 0x5c1d3fbf, 0xec33ff3a, 0xfe9cb7af}},
			{ref: 0x0079, set: pageSet{0x7a9f5236, 0xe722bffa, 0xfcff9ff7, 0xb61d2fbb, 0x1dfded06, 0xefdf7dd7, 0xf166eb23, 0x0dc07ed9}},
			{ref: 0x007a, set: pageSet{0xdfbf3d3d, 0xba83c945, 0x9dd07dd1, 0xcf737b87, 0xc3f59ff3, 0xc5fedf0d, 0x83020cb3, 0xaec0e879}},
			{ref: 0x007b, set: pageSet{0x6f0fc773, 0x093ffd7d, 0x0157fff1, 0x01ff62fb, 0x3bf3fdb4, 0x43b2b013, 0xff305ed3, 0xeb9f0fff}},
			{ref: 0x007c, set: pageSet{0xf203feef, 0xfb893fef, 0x9e9937a9, 0xa72cdef9, 0xc1f63733, 0xfe3e812e, 0xf2f75d20, 0x69d7d585}},
			{ref: 0x007d, set: pageSet{0xffffffff, 0xff6fdb07, 0xd97fc4ff, 0xbe0fefce, 0xf05ef17b, 0xffb7f6cf, 0xef845ef7, 0x0edfd7cb}},
			{ref: 0x007e, set: pageSet{0xfcffff08, 0xffffee3f, 0xd7ff13ff, 0x7ffdaf0f, 0x1ffabdc7, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0xe7400000, 0xf933bd38, 0xfeed7feb, 0x7c767fe8, 0xffefb3f7, 0xd8b7feaf, 0xfbbfff6f}},
			{ref: 0x0080, set: pageSet{0xdbf7f8fb, 0xe2f91752, 0x754785c8, 0xe3ef9090, 0x3f6d9ef4, 0x0536ee2e, 0x7ff3f7bc, 0x7f3fa07b}},
			{ref: 0x0081, set: pageSet{0xeb600567, 0x6601babe, 0x583ffcd8, 0x87dfcaf7, 0xffa0bfcd, 0xfebf5bcd, 0xefa7b6fd, 0xdf9c77ef}},
			{ref: 0x0082, set: pageSet{0xf8773fb7, 0xb7fc9d27, 0xdfefcab5, 0xf1b6fb5a, 0xef1fec39, 0x7ffbfbbf, 0xdafe000d, 0x4e7fbdfb}},
			{ref: 0x0083, set: pageSet{0x5ac033ff, 0x9ffebff5, 0x005fffbf, 0xfdf80000, 0x6ffdffca, 0xa001cffd, 0xfbf2dfff, 0xff7fdfbf}},
			{ref: 0x0084, set: pageSet{0x080ffeda, 0xbfffba08, 0xeed77afd, 0x67f9fbeb, 0xff93e044, 0x9f57df97, 0x08dffef7, 0xfedfdf80}},
			{ref: 0x0085, set: pageSet{0xf7feffc5, 0x6803fffb, 0x6bfa67fb, 0x5fe27fff, 0xff73ffff, 0xe7fb87df, 0xf7a7ebfd, 0xefc7bf7e}},
			{ref: 0x0086, set: pageSet{0xdf821ef3, 0xdf7e76ff, 0xda7d79c9, 0x1e9befbe, 0x77fb7ce0, 0xfffb87be, 0xffdb1bff, 0x4fe03f5c}},
			{ref: 0x0087, set: pageSet{0x5f0e7fff, 0xddbf77ff, 0xfffff04f, 0x0ff8ffff, 0xfddfa3be, 0xfffdfc1c, 0xfb9e1f7d, 0xdedcbdff}},
			{ref: 0x0088, set: pageSet{0xbafb3f6f, 0xfbefdf7f, 0x2eec7d1b, 0xf2f7af8e, 0xcfee7b0f, 0x77c61d96, 0xfff57e07, 0x7fdfd982}},
			{ref: 0x0089, set: pageSet{0xc7ff5ee6, 0x79effeee, 0xffcf9a56, 0xde5efe5f, 0xf9e8896e, 0xe6c4f45e, 0xbe7c0001, 0xdddf3b7f}},
			{ref: 0x008a, set: pageSet{0xe9efd59d, 0xde5334ac, 0x4bf7f573, 0x9eff7b4f, 0x476eb8fe, 0xff450dfb, 0xfbfeabfd, 0xddffe9d7}},
			{ref: 0x008b, set: pageSet{0x7fffedf7, 0x7eebddfd, 0xb7ffcfe7, 0xef91bde9, 0xd77c5d75, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0xfa800000, 0xb4f1ffee, 0x2fefbf76, 0x77bfb677, 0xfffd9fbf, 0xf6ae95bf, 0x7f3b75ff}},
			{ref: 0x008d, set: pageSet{0x0af9a7f5, 0x00000000, 0x00000000, 0x2bddfbd0, 0x9a7ff633, 0xd6fcfdab, 0xbfebf9e6, 0xf41fdfdf}},
			{ref: 0x008e, set: pageSet{0xffffa6fd, 0xf37b4aff, 0xfef97fb7, 0x1d5cb6ff, 0xe5ff7ff6, 0x24041f7b, 0xf99ebe05, 0xdff2dbe3}},
			{ref: 0x008f, set: pageSet{0xfdff6fef, 0xcbfcd679, 0xefffebfd, 0x0000001f, 0x98000000, 0x8017e148, 0x00fe6a74, 0xfdf16d7f}},
			{ref: 0x0090, set: pageSet{0xfef3b87f, 0xf176e01f, 0x7b3fee96, 0xfffdeb8d, 0xcbb3adff, 0xe17f84ef, 0xbff04daa, 0xfe3fbf3f}},
			{ref: 0x0091, set: pageSet{0xffd7ebff, 0xcf7fffdf, 0x85edfffb, 0x07bcd73f, 0xfe0faeff, 0x76bffdaf, 0x37bbfaef, 0xa3ba7fdc}},
			{ref: 0x0092, set: pageSet{0x56f7b6ff, 0xe7df60f8, 0x4cdfff61, 0xff45b0fb, 0x3ffa7ded, 0x18fc1fff, 0xe3afffff, 0xdf83c7d3}},
			{ref: 0x0093, set: pageSet{0xef7dfb57, 0x1378efff, 0x5ff7fec0, 0x5ee334bb, 0xeff6f70d, 0x00bfd7fe, 0xf7f7f59d, 0xffe051de}},
			{ref: 0x0094, set: pageSet{0x037ffec9, 0xbfef5f01, 0x60a79ff1, 0xf1ffef1d, 0x0000000f, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x3c800000, 0xd91ffb4d, 0xfee37b3a, 0xdc7f3fe9, 0x0000003f}},
			{ref: 0x0096, set: pageSet{0x50000000, 0xbe07f51f, 0xf91bfc1d, 0x71ffbc1e, 0x5bbe6ff9, 0x9b1b5796, 0xfffc7fff, 0xafe7872e}},
			{ref: 0x0097, set: pageSet{0xf34febf5, 0xe725dffd, 0x5d440bdc, 0xfddd5747, 0x7790ed3f, 0x8ac87d7f, 0xf3f9fafa, 0xef4b202a}},
			{ref: 0x0098, set: pageSet{0x79cff5ff, 0x0ba5abd3, 0xfb8ff77a, 0x001f8ebd, 0x00000000, 0xfd4ef300, 0x88001a57, 0x7654aeac}},
			{ref: 0x0099, set: pageSet{0xcdff17ad, 0xf42fffb2, 0xdbff5baa, 0x00000002, 0x73c00000, 0x2e3ff9ea, 0xbbfffa8e, 0xffd376bc}},
			{ref: 0x009a, set: pageSet{0x7e72eefe, 0xe7f77ebd, 0xcefdf77f, 0x00000ff5, 0x00000000, 0xdb9ba900, 0x917fa4c7, 0x7ecef8ca}},
			{ref: 0x009b, set: pageSet{0xc7e77d7a, 0xdcaecbbd, 0x8f76fd7e, 0x7cf391d3, 0x4c2f01e5, 0xa360ed77, 0x5ef807db, 0x21811df7}},
			{ref: 0x009c, set: pageSet{0x309c6be0, 0xfade3b3a, 0xc3f57f53, 0x07ba61cd, 0x00000000, 0x00000000, 0x00000000, 0xbefe26e0}},
			{ref: 0x009d, set: pageSet{0xebb503f9, 0xe9cbe36d, 0xbfde9c2f, 0xabbf9f83, 0xffd51ff7, 0xdffeb7df, 0xffeffdae, 0xeffdfb7e}},
			{ref: 0x009e, set: pageSet{0x6ebfaaff, 0x00000000, 0x00000000, 0xb6200000, 0xbe9e7fcd, 0x58f162b3, 0xfd7bf10d, 0xbefde9f1}},
			{ref: 0x009f, set: pageSet{0x5f6dc6c3, 0x69ffff3d, 0xfbf4ffcf, 0x4ff7dcfb, 0x11372000, 0x00000015, 0x00000000, 0x00000000}},
			{ref: 0x00fa, set: pageSet{0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 161 */
		"nb",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x011c0661, 0x011c0661}},
		},
	},
	{ /** index: 162 */
		"nds",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x90400010, 0x10400010}},
		},
	},
	{ /** index: 163 */
		"ne",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xfff98fee, 0xc3e5fdff, 0x0001398f, 0x0001fff0, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 164 */
		"ng",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 165 */
		"nhn",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x140a2202, 0x140a2202}},
			{ref: 0x0001, set: pageSet{0x00000002, 0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 166 */
		"niu",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00528f81, 0x00528f81}},
			{ref: 0x0001, set: pageSet{0x00080002, 0x00000800, 0x00002000, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 167 */
		"nl",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x1c58af16, 0x1c58af16}},
		},
	},
	{ /** index: 168 */
		"nn",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x115c0671, 0x115c0671}},
		},
	},
	{ /** index: 169 */
		"no",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x011c0661, 0x011c0661}},
		},
	},
	{ /** index: 170 */
		"nqo",
		RuneSet{
			{ref: 0x0007, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x07ffffff}},
		},
	},
	{ /** index: 171 */
		"nr",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 172 */
		"nso",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00100400, 0x00100400}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 173 */
		"nv",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00082202, 0x00082202}},
			{ref: 0x0001, set: pageSet{0x03000030, 0x0000c000, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000c00}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 174 */
		"ny",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00300000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 175 */
		"oc",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x040c2383, 0x040c2383}},
		},
	},
	{ /** index: 176 */
		"om",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 177 */
		"or",
		RuneSet{
			{ref: 0x000b, set: pageSet{0xfff99fee, 0xf3cdfdff, 0xb0c0398f, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 178 */
		"os",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 179 */
		"ota",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07ffffc6, 0x000001fe, 0x40000000, 0x01000040, 0x0000a000, 0x00001000, 0x00000000}},
		},
	},
	{ /** index: 180 */
		"pa",
		RuneSet{
			{ref: 0x000a, set: pageSet{0xfff987e0, 0xd36dfdff, 0x1e003987, 0x001f0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 181 */
		"pa-pk",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x040001de, 0x00000176, 0x42000000, 0x01020140, 0x44008200, 0x00041008, 0x00000000}},
		},
	},
	{ /** index: 182 */
		"pap-an",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x160e2302, 0x160e2302}},
		},
	},
	{ /** index: 183 */
		"pap-aw",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00020000, 0x00020000}},
		},
	},
	{ /** index: 184 */
		"pes",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07ffffde, 0x001009f6, 0x40000000, 0x01000040, 0x00008200, 0x00001000, 0x00000000}},
		},
	},
	{ /** index: 185 */
		"pl",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00080000, 0x00080000}},
			{ref: 0x0001, set: pageSet{0x030000f0, 0x00000000, 0x0c00001e, 0x1e000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 186 */
		"prs",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07ffffde, 0x001009f6, 0x40000000, 0x01000040, 0x00008200, 0x00001000, 0x00000000}},
		},
	},
	{ /** index: 187 */
		"ps-af",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07ffffde, 0x000005f6, 0x50000000, 0x05480262, 0x10000a00, 0x00013000, 0x00000000}},
		},
	},
	{ /** index: 188 */
		"ps-pk",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07ffffde, 0x000005f6, 0x50000000, 0x05480262, 0x10000a00, 0x00052000, 0x00000000}},
		},
	},
	{ /** index: 189 */
		"pt",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x143c278f, 0x143c278f}},
		},
	},
	{ /** index: 190 */
		"qu",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00020000, 0x00020000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000}},
		},
	},
	{ /** index: 191 */
		"quz",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00020000, 0x00020000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000}},
		},
	},
	{ /** index: 192 */
		"raj",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 193 */
		"rif",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00528f81, 0x00528f81}},
			{ref: 0x0001, set: pageSet{0x00002000, 0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08000000, 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00002000, 0x00000020, 0x08000000, 0x00002008, 0x00080000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 194 */
		"rm",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x02045301, 0x02045301}},
		},
	},
	{ /** index: 195 */
		"rn",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 196 */
		"ro",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00004004, 0x00004004}},
			{ref: 0x0001, set: pageSet{0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x0f000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 197 */
		"ru",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 198 */
		"rw",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 199 */
		"sa",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 200 */
		"sah",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00300000, 0x0c00c030, 0x03000000, 0x00000000}},
		},
	},
	{ /** index: 201 */
		"sat",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xfff987ee, 0xf325fdff, 0x00013987, 0x0001fff0, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 202 */
		"sc",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x02041101, 0x02041101}},
		},
	},
	{ /** index: 203 */
		"sco",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00800000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00040000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 204 */
		"sd",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x07fffdd6, 0x000005f6, 0xec000000, 0x0200b4d9, 0x480a8640, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 205 */
		"se",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000002, 0x00000002}},
			{ref: 0x0001, set: pageSet{0x00033000, 0x00000000, 0x00000c00, 0x600000c3, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 206 */
		"sel",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 207 */
		"sg",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x1850cc14, 0x1850cc14}},
		},
	},
	{ /** index: 208 */
		"sgs",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00200000}},
			{ref: 0x0001, set: pageSet{0x03c83032, 0x0000c800, 0x00002000, 0x600c0c03, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 209 */
		"sh",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000330c0, 0x00000000, 0x00000000, 0x60000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0004, set: pageSet{0xffff8f04, 0xffffffff, 0x8f04ffff, 0x00000000, 0x030c0000, 0x0c00cc0f, 0x03000000, 0x00000300}},
		},
	},
	{ /** index: 210 */
		"shn",
		RuneSet{
			{ref: 0x0010, set: pageSet{0xffffffff, 0x0007f6fb, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 211 */
		"shs",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00800000, 0x03bffbaa, 0x03bffbaa, 0x00000000, 0x00000000, 0x00002202, 0x00002202}},
			{ref: 0x0003, set: pageSet{0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 212 */
		"si",
		RuneSet{
			{ref: 0x000d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfc7e3fec, 0x2ffbffbf, 0x7f5f847f, 0x00040000}},
		},
	},
	{ /** index: 213 */
		"sid",
		RuneSet{
			{ref: 0x0012, set: pageSet{0xff7fff7f, 0xff01ff7f, 0x3d7f3d7f, 0xffff7fff, 0xffff3d7f, 0x003d7fff, 0xff7f7f3d, 0x00ff7fff}},
			{ref: 0x0013, set: pageSet{0x003d7fff, 0xffffffff, 0x007fff7f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 214 */
		"sk",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x24182212, 0x24182212}},
			{ref: 0x0001, set: pageSet{0x0000f000, 0x66000000, 0x00300180, 0x60000033, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 215 */
		"sl",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0001, set: pageSet{0x000330c0, 0x00000000, 0x00000000, 0x60000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 216 */
		"sm",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 217 */
		"sma",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00408030, 0x00408030}},
		},
	},
	{ /** index: 218 */
		"smj",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00020032, 0x00020032}},
		},
	},
	{ /** index: 219 */
		"smn",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000016, 0x00000016}},
			{ref: 0x0001, set: pageSet{0x00033000, 0x00000000, 0x00000c00, 0x60000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 220 */
		"sms",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00200034, 0x00200034}},
			{ref: 0x0001, set: pageSet{0x00033000, 0x00000000, 0x00000c00, 0x60000003, 0x00000000, 0x00800000, 0x00000000, 0x0000c3f0}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 221 */
		"sn",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 222 */
		"so",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 223 */
		"sq",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000880, 0x00000880}},
		},
	},
	{ /** index: 224 */
		"sr",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xfdff8f04, 0xfdff01ff, 0x8f0401ff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 225 */
		"ss",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 226 */
		"st",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 227 */
		"su",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000200, 0x00000200}},
		},
	},
	{ /** index: 228 */
		"sv",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10400a33, 0x10400a33}},
		},
	},
	{ /** index: 229 */
		"sw",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 230 */
		"syr",
		RuneSet{
			{ref: 0x0007, set: pageSet{0xffff0000, 0xffff1fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 231 */
		"szl",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00380008, 0x00080000}},
			{ref: 0x0001, set: pageSet{0x030000f0, 0x00000000, 0x0c00501e, 0x1e004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 232 */
		"ta",
		RuneSet{
			{ref: 0x000b, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xd63dc7e8, 0xc3bfc718, 0x00803dc7, 0x00000000}},
		},
	},
	{ /** index: 233 */
		"tcy",
		RuneSet{
			{ref: 0x000c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffddfec, 0xc3effdff, 0x40603ddf, 0x00000003}},
		},
	},
	{ /** index: 234 */
		"te",
		RuneSet{
			{ref: 0x000c, set: pageSet{0xfffddfee, 0xc3effdff, 0x00603ddf, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 235 */
		"tg",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x0c0c0000, 0x00cc0000, 0x00000000, 0x0000c00c}},
		},
	},
	{ /** index: 236 */
		"th",
		RuneSet{
			{ref: 0x000e, set: pageSet{0xfffffffe, 0x87ffffff, 0x00007fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 237 */
		"the",
		RuneSet{
			{ref: 0x0009, set: pageSet{0xffffffe0, 0x83ffffff, 0x00003fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 238 */
		"ti-er",
		RuneSet{
			{ref: 0x0012, set: pageSet{0xff7fff7f, 0xff01ff00, 0x3d7f3d7f, 0xffff7fff, 0xffff0000, 0x003d7fff, 0xff7f7f3d, 0x00ff7fff}},
			{ref: 0x0013, set: pageSet{0x003d7fff, 0xffffffff, 0x007fff00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 239 */
		"ti-et",
		RuneSet{
			{ref: 0x0012, set: pageSet{0xff7fff7f, 0xff01ff7f, 0x3d7f3d7f, 0xffff7fff, 0xffff3d7f, 0x003d7fff, 0xff7f7f3d, 0x00ff7fff}},
			{ref: 0x0013, set: pageSet{0x003d7fff, 0xffffffff, 0x007fff7f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 240 */
		"tig",
		RuneSet{
			{ref: 0x0012, set: pageSet{0xff7fff7f, 0xff01ff00, 0x00003d7f, 0xffff7fff, 0x00ff0000, 0x003d7f7f, 0xff7f7f00, 0x00ff7f00}},
			{ref: 0x0013, set: pageSet{0x003d7fff, 0xffffffff, 0x007fff00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 241 */
		"tk",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x30400090, 0x30400090}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0xc0000180, 0x60000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 242 */
		"tl",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x0e1e7707, 0x0e1e7707}},
		},
	},
	{ /** index: 243 */
		"tn",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00100400, 0x00100400}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 244 */
		"to",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 245 */
		"tpi",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00528f81, 0x00528f81}},
		},
	},
	{ /** index: 246 */
		"tr",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x18404084, 0x18404084}},
			{ref: 0x0001, set: pageSet{0xc0000000, 0x00030000, 0xc0000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 247 */
		"ts",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 248 */
		"tt",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00c00000, 0x0c00c00c, 0x03000000, 0x00000000}},
		},
	},
	{ /** index: 249 */
		"tw",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00220008, 0x00220008}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000300, 0x00000000, 0x00000300, 0x00010040, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x08100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00000048, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x30000000, 0x00000000, 0x03000000}},
		},
	},
	{ /** index: 250 */
		"ty",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00008000, 0x00008000}},
			{ref: 0x0001, set: pageSet{0x000c0003, 0x00000c00, 0x00003000, 0x00000c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 251 */
		"tyv",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff0002, 0xffffffff, 0x0002ffff, 0x00000000, 0x00000000, 0x0000c00c, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 252 */
		"ug",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x041ed5c0, 0x0000077e, 0x40000000, 0x01000040, 0x4000a000, 0x002109c0, 0x00000000}},
		},
	},
	{ /** index: 253 */
		"uk",
		RuneSet{
			{ref: 0x0004, set: pageSet{0xffff00d0, 0xffffffff, 0x00d0ffff, 0x00000000, 0x00030000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 254 */
		"und-zmth",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0xffffff7b, 0x7fffffff, 0x7ffffffe, 0x00000000, 0x80e310fe, 0x00800000, 0x00800000}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x00001500, 0x01000000, 0x00000000, 0x00000000, 0xfffe0000, 0xfffe03db, 0x006003fb, 0x00030000}},
			{ref: 0x0020, set: pageSet{0x00400000, 0x00000047, 0x00800010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002}},
			{ref: 0x0021, set: pageSet{0x3f2fc004, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0022, set: pageSet{0xe3ffbfff, 0xfff007ff, 0x00000001, 0x00000000, 0xfffff000, 0x0000003f, 0x0000e10f, 0x00000000}},
			{ref: 0x0023, set: pageSet{0x00000f00, 0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0025, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000000}},
			{ref: 0x0027, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003c0}},
			{ref: 0x01d4, set: pageSet{0xffffffff, 0xffffffff, 0xffdfffff, 0xffffffff, 0xdfffffff, 0x00001e64, 0x00000000, 0x00000000}},
			{ref: 0x01d5, set: pageSet{0x00000000, 0x78000000, 0x0001fc5f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x01d6, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000030, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 255 */
		"und-zsye",
		RuneSet{
			{ref: 0x0023, set: pageSet{0x0c000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00091e00}},
			{ref: 0x0025, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x60000000}},
			{ref: 0x0026, set: pageSet{0x00300000, 0x00000000, 0x000fff00, 0x80000000, 0x00080000, 0x60000c02, 0x00104030, 0x242c0400}},
			{ref: 0x0027, set: pageSet{0x00000c20, 0x00000100, 0x00b85000, 0x00000000, 0x00e00000, 0x80010000, 0x00000000, 0x00000000}},
			{ref: 0x002b, set: pageSet{0x18000000, 0x00000000, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x01f0, set: pageSet{0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000, 0x00000000}},
			{ref: 0x01f1, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07fe4000, 0x00000000, 0x00000000, 0xffffffc0}},
			{ref: 0x01f2, set: pageSet{0x04000002, 0x077c8000, 0x00030000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x01f3, set: pageSet{0xffffffff, 0xffbf0001, 0xffffffff, 0x1fffffff, 0x000fffff, 0xffffffff, 0x000007df, 0x0001ffff}},
			{ref: 0x01f4, set: pageSet{0x00000000, 0x00000000, 0xfffffffd, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x1effffff}},
			{ref: 0x01f5, set: pageSet{0xffffffff, 0x3fffffff, 0xffff0000, 0x000000ff, 0x00000000, 0x00000000, 0x00000000, 0xf8000000}},
			{ref: 0x01f6, set: pageSet{0x755dfffe, 0xffef2f3f, 0x0000ffe1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 256 */
		"unm",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00528f81, 0x00528f81}},
		},
	},
	{ /** index: 257 */
		"ur",
		RuneSet{
			{ref: 0x0006, set: pageSet{0x00000000, 0x040001de, 0x00000176, 0x42000000, 0x01020140, 0x44008200, 0x00041008, 0x00000000}},
		},
	},
	{ /** index: 258 */
		"uz",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 259 */
		"ve",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x000c0000, 0x30000000, 0x00000c30, 0x00030000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 260 */
		"vi",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x263c370f, 0x263c370f}},
			{ref: 0x0001, set: pageSet{0x0003000c, 0x00000300, 0x00000000, 0x00000300, 0x00000000, 0x00018003, 0x00000000, 0x00000000}},
			{ref: 0x0003, set: pageSet{0x0800024f, 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0x03ffffff}},
		},
	},
	{ /** index: 261 */
		"vo",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x077dfffe, 0x077dfffe, 0x00000000, 0x00000000, 0x10400010, 0x10400010}},
		},
	},
	{ /** index: 262 */
		"vot",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x10400010, 0x10400010}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x60000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 263 */
		"wa",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x081047a4, 0x081047a4}},
		},
	},
	{ /** index: 264 */
		"wae",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x90400010, 0x10400010}},
		},
	},
	{ /** index: 265 */
		"wal",
		RuneSet{
			{ref: 0x0012, set: pageSet{0xff7fff7f, 0xff01ff7f, 0x3d7f3d7f, 0xffff7fff, 0xffff3d7f, 0x003d7fff, 0xff7f7f3d, 0x00ff7fff}},
			{ref: 0x0013, set: pageSet{0x003d7fff, 0xffffffff, 0x007fff7f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 266 */
		"wen",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00080000, 0x00080000}},
			{ref: 0x0001, set: pageSet{0x0c0030c0, 0x00000000, 0x0f30001e, 0x66000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 267 */
		"wo",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x000a0a09, 0x000a0a09}},
			{ref: 0x0001, set: pageSet{0x00000000, 0x00000000, 0x00000c00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 268 */
		"xh",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 269 */
		"yap",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00400810, 0x00400810}},
		},
	},
	{ /** index: 270 */
		"yi",
		RuneSet{
			{ref: 0x0005, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffff0000, 0x000007ff}},
		},
	},
	{ /** index: 271 */
		"yo",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x0e3c770f, 0x0e3c770f}},
			{ref: 0x0001, set: pageSet{0x0c000000, 0x00000300, 0x00000018, 0x00000300, 0x00000000, 0x00000000, 0x001fe000, 0x03000000}},
			{ref: 0x0003, set: pageSet{0x0000100f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x001e, set: pageSet{0x00000000, 0xc0000000, 0x00000000, 0x0000000c, 0x00000000, 0x33000000, 0x00003000, 0x00000000}},
		},
	},
	{ /** index: 272 */
		"yue",
		RuneSet{
			{ref: 0x0030, set: pageSet{0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0034, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x64080010, 0x00480000, 0x10000020, 0x80000102, 0x08000010}},
			{ref: 0x0035, set: pageSet{0x00000040, 0x40000000, 0x00020000, 0x01852002, 0x00800010, 0x80002022, 0x084444a2, 0x480e0000}},
			{ref: 0x0036, set: pageSet{0x04000200, 0x02202008, 0x80004380, 0x04000000, 0x00000002, 0x12231420, 0x2058003a, 0x00200060}},
			{ref: 0x0037, set: pageSet{0x10002508, 0x040d0028, 0x00000009, 0x00008004, 0x00800000, 0x42000001, 0x00000000, 0x09040000}},
			{ref: 0x0038, set: pageSet{0x02008000, 0x01402001, 0x00000000, 0x00000008, 0x00000000, 0x00000001, 0x00021008, 0x04000000}},
			{ref: 0x0039, set: pageSet{0x00100100, 0x80040080, 0x00002000, 0x00000008, 0x08040601, 0x01000012, 0x10000000, 0x49001024}},
			{ref: 0x003a, set: pageSet{0x0180004a, 0x00100600, 0x50840800, 0x000000c0, 0x00800000, 0x20000800, 0x40000000, 0x08050000}},
			{ref: 0x003b, set: pageSet{0x02004000, 0x02000804, 0x01000004, 0x18060001, 0x02400001, 0x40000002, 0x20800014, 0x000c1000}},
			{ref: 0x003c, set: pageSet{0x00222000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x10422800, 0x00000800}},
			{ref: 0x003d, set: pageSet{0x20080000, 0x00040000, 0x80025040, 0x20208604, 0x00028020, 0x80102020, 0x080820c0, 0x10880800}},
			{ref: 0x003e, set: pageSet{0x00000000, 0x00000000, 0x00200109, 0x00100000, 0x00000000, 0x81022700, 0x40c21404, 0x84010882}},
			{ref: 0x003f, set: pageSet{0x00004010, 0x00000000, 0x03000000, 0x00000008, 0x00080000, 0x00000000, 0x10800001, 0x06002020}},
			{ref: 0x0040, set: pageSet{0x00000010, 0x02000000, 0x00880020, 0x00008424, 0x00000000, 0x88000000, 0x81000100, 0x04000000}},
			{ref: 0x0041, set: pageSet{0x00004218, 0x00040000, 0x00000000, 0x80005080, 0x00010000, 0x00040000, 0x08008000, 0x02008000}},
			{ref: 0x0042, set: pageSet{0x00020000, 0x00000000, 0x00000001, 0x04000401, 0x00100000, 0x12200004, 0x00000000, 0x18100000}},
			{ref: 0x0043, set: pageSet{0x00000000, 0x00000800, 0x00000000, 0x00004000, 0x00800000, 0x04000000, 0x82000002, 0x00042000}},
			{ref: 0x0044, set: pageSet{0x00080006, 0x00000000, 0x00000000, 0x04000000, 0x80008000, 0x00810001, 0xa0000000, 0x00100410}},
			{ref: 0x0045, set: pageSet{0x00400218, 0x88084080, 0x00260008, 0x00800404, 0x00000020, 0x00000000, 0x00000000, 0x00000200}},
			{ref: 0x0046, set: pageSet{0x00a08048, 0x00000000, 0x08000000, 0x04000000, 0x00000000, 0x00000000, 0x00018000, 0x00200000}},
			{ref: 0x0047, set: pageSet{0x01000000, 0x00000000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00200000, 0x00102000}},
			{ref: 0x0048, set: pageSet{0x00000801, 0x00000000, 0x00000000, 0x00020000, 0x08000000, 0x00002000, 0x20010000, 0x04002000}},
			{ref: 0x0049, set: pageSet{0x40000040, 0x50202400, 0x000a0020, 0x00040420, 0x00000200, 0x00000080, 0x80000000, 0x00000020}},
			{ref: 0x004a, set: pageSet{0x20008000, 0x00200010, 0x00000000, 0x00000000, 0x00400000, 0x01100000, 0x00020000, 0x80000010}},
			{ref: 0x004b, set: pageSet{0x02000000, 0x00801000, 0x00000000, 0x48058000, 0x20c94000, 0x60000000, 0x00000001, 0x00000000}},
			{ref: 0x004c, set: pageSet{0x00004090, 0x48000000, 0x08000000, 0x28802000, 0x00000002, 0x00014000, 0x00002000, 0x00002002}},
			{ref: 0x004d, set: pageSet{0x00010200, 0x00100000, 0x00000000, 0x00800000, 0x10020000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x004e, set: pageSet{0x00000010, 0x00000402, 0x0c000000, 0x01000400, 0x01000021, 0x00000000, 0x00004000, 0x00004000}},
			{ref: 0x004f, set: pageSet{0x00000000, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000020}},
			{ref: 0x0050, set: pageSet{0x00000100, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00002000, 0x00000000}},
			{ref: 0x0051, set: pageSet{0x00006000, 0x00000000, 0x00000000, 0x00000400, 0x04000040, 0x003c0180, 0x00000200, 0x00102000}},
			{ref: 0x0052, set: pageSet{0x00000800, 0x101000c0, 0x00800000, 0x00000000, 0x00008000, 0x02200000, 0x00020020, 0x00000000}},
			{ref: 0x0053, set: pageSet{0x00000000, 0x01000000, 0x00000000, 0x20100000, 0x00080000, 0x00000141, 0x02001002, 0x40400001}},
			{ref: 0x0054, set: pageSet{0x00580000, 0x00000002, 0x00003000, 0x00002400, 0x00988000, 0x00040010, 0x00002800, 0x00000008}},
			{ref: 0x0055, set: pageSet{0x40080004, 0x00000020, 0x20080000, 0x02060a00, 0x00010040, 0x14010200, 0x40800000, 0x08031000}},
			{ref: 0x0056, set: pageSet{0x40020020, 0x0000202c, 0x2014a008, 0x00000000, 0x80040200, 0x82020012, 0x00400000, 0x20000000}},
			{ref: 0x0057, set: pageSet{0x00000000, 0x00000000, 0x00000004, 0x04000000, 0x00000000, 0x00000000, 0x40800100, 0x00000000}},
			{ref: 0x0058, set: pageSet{0x00000008, 0x04000040, 0x00000001, 0x000c0200, 0x00000000, 0x08000400, 0x00000000, 0x080c0001}},
			{ref: 0x0059, set: pageSet{0x00000400, 0x00000000, 0x00000000, 0x00200000, 0x80000000, 0x00001000, 0x00000200, 0x01000800}},
			{ref: 0x005a, set: pageSet{0x00000000, 0x00000800, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x04040000}},
			{ref: 0x005b, set: pageSet{0x00000000, 0x00000000, 0x00000040, 0x00002000, 0xa0000000, 0x00000000, 0x08000008, 0x00080000}},
			{ref: 0x005c, set: pageSet{0x00000020, 0x00000000, 0x40000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000}},
			{ref: 0x005d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0x00000000, 0x00200000}},
			{ref: 0x005e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000008, 0x00000000, 0x00010000, 0x1b000000}},
			{ref: 0x005f, set: pageSet{0x00007000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00000080, 0x80000000, 0x00000000}},
			{ref: 0x0060, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x00200000, 0x40000000, 0x00000010, 0x00800000, 0x00000008}},
			{ref: 0x0061, set: pageSet{0x00000000, 0x00000000, 0x02000000, 0x20000010, 0x00000080, 0x00000000, 0x00010000, 0x00000000}},
			{ref: 0x0062, set: pageSet{0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x20000000, 0x00000040, 0x00200028, 0x00000000}},
			{ref: 0x0063, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x02000000, 0x00000000, 0x02000000, 0x40020000, 0x51000040}},
			{ref: 0x0064, set: pageSet{0x00000080, 0x04040000, 0x00000000, 0x10000000, 0x00022000, 0x00100000, 0x20000000, 0x00000082}},
			{ref: 0x0065, set: pageSet{0x40000000, 0x00010000, 0x00002000, 0x00000000, 0x00000240, 0x00000000, 0x00000000, 0x00000008}},
			{ref: 0x0066, set: pageSet{0x00000000, 0x00010000, 0x00000810, 0x00080880, 0x00004000, 0x00000000, 0x00000000, 0x00020000}},
			{ref: 0x0067, set: pageSet{0x00000000, 0x00400020, 0x00000000, 0x00000082, 0x00000000, 0x00020001, 0x00000000, 0x00000000}},
			{ref: 0x0068, set: pageSet{0x40000018, 0x00000004, 0x00000000, 0x00000000, 0x01000000, 0x00400000, 0x00000000, 0x00000000}},
			{ref: 0x0069, set: pageSet{0x00000001, 0x00400000, 0x00000000, 0x00080002, 0x00000400, 0x00040000, 0x00000000, 0x00000000}},
			{ref: 0x006a, set: pageSet{0x00000800, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000}},
			{ref: 0x006b, set: pageSet{0x00000000, 0x00200000, 0x00000000, 0x04108000, 0x00000000, 0x00000000, 0x00000000, 0x00000002}},
			{ref: 0x006c, set: pageSet{0x00000000, 0x02800000, 0x04000000, 0x00000000, 0x00000000, 0x00000004, 0x00000000, 0x00000400}},
			{ref: 0x006d, set: pageSet{0x00000000, 0x00000000, 0x10000000, 0x00040000, 0x00400000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x006e, set: pageSet{0x00200000, 0x00000200, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x2a000000, 0x00000000}},
			{ref: 0x006f, set: pageSet{0x00400000, 0x00000000, 0x00400000, 0x00000000, 0x00000002, 0x40000000, 0x00000000, 0x00400000}},
			{ref: 0x0070, set: pageSet{0x40000000, 0x00001000, 0x00000000, 0x00000000, 0x00000202, 0x02000000, 0x80000000, 0x00020000}},
			{ref: 0x0071, set: pageSet{0x00000020, 0x00000800, 0x00020421, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00400000}},
			{ref: 0x0072, set: pageSet{0x00200000, 0x00000000, 0x00000001, 0x00000000, 0x00000084, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0073, set: pageSet{0x00000000, 0x00004400, 0x00000002, 0x00100000, 0x00000000, 0x00000000, 0x00008200, 0x00000000}},
			{ref: 0x0074, set: pageSet{0x00000000, 0x12000000, 0x00000100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0075, set: pageSet{0x00000020, 0x08100000, 0x000a0400, 0x00000081, 0x00006000, 0x00120000, 0x00000000, 0x00000000}},
			{ref: 0x0076, set: pageSet{0x00000004, 0x08000000, 0x00004000, 0x044000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0077, set: pageSet{0x40001000, 0x00000000, 0x01000001, 0x05000000, 0x00080000, 0x02000000, 0x00000800, 0x00000000}},
			{ref: 0x0078, set: pageSet{0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00002002, 0x01020000, 0x00800000, 0x00000000}},
			{ref: 0x0079, set: pageSet{0x00000040, 0x00004000, 0x01000000, 0x00000004, 0x00020000, 0x00000000, 0x00000010, 0x00000000}},
			{ref: 0x007a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00010000, 0x30000300, 0x00000400}},
			{ref: 0x007b, set: pageSet{0x00000800, 0x02000000, 0x00000000, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007c, set: pageSet{0x00200000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000040c0, 0x00002200, 0x12002000}},
			{ref: 0x007d, set: pageSet{0x00000000, 0x00000020, 0x20000000, 0x00000000, 0x00000200, 0x00080800, 0x1000a000, 0x00000000}},
			{ref: 0x007e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0x00000000, 0x00004280, 0x01000000, 0x00800000, 0x00000008, 0x00000000, 0x00000000}},
			{ref: 0x0080, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x20400000, 0x00000040, 0x00000000}},
			{ref: 0x0081, set: pageSet{0x00800080, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00400020, 0x00000000, 0x00008000}},
			{ref: 0x0082, set: pageSet{0x01000000, 0x00000040, 0x00000000, 0x00400000, 0x00000000, 0x00000440, 0x00000000, 0x00800000}},
			{ref: 0x0083, set: pageSet{0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000}},
			{ref: 0x0084, set: pageSet{0x01000000, 0x00000001, 0x00000000, 0x00020000, 0x00000000, 0x20002000, 0x00000000, 0x00000004}},
			{ref: 0x0085, set: pageSet{0x00000008, 0x00100000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0086, set: pageSet{0x00000004, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000}},
			{ref: 0x0087, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000000, 0x00004000, 0x00000000}},
			{ref: 0x0088, set: pageSet{0x00000010, 0x00002000, 0x40000040, 0x00000000, 0x10000000, 0x00000000, 0x00008080, 0x00000000}},
			{ref: 0x0089, set: pageSet{0x00000000, 0x00000000, 0x00000080, 0x00000000, 0x00100080, 0x000000a0, 0x00000000, 0x00000000}},
			{ref: 0x008a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008b, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x00000000, 0x0001000a, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08002000, 0x00000000}},
			{ref: 0x008d, set: pageSet{0x00000808, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008e, set: pageSet{0x00004000, 0x00002400, 0x00008000, 0x40000000, 0x00000001, 0x00002000, 0x04000000, 0x00040004}},
			{ref: 0x008f, set: pageSet{0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x1c200000, 0x00000000, 0x02000000}},
			{ref: 0x0090, set: pageSet{0x00000000, 0x00080000, 0x00400000, 0x00000002, 0x00000000, 0x00000100, 0x00000000, 0x00000000}},
			{ref: 0x0091, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0092, set: pageSet{0x00004100, 0x00000400, 0x20200010, 0x00004004, 0x00000000, 0x42000000, 0x00000000, 0x00000000}},
			{ref: 0x0093, set: pageSet{0x00000080, 0x00000000, 0x00000121, 0x00000200, 0x000000b0, 0x80002000, 0x00000000, 0x00010000}},
			{ref: 0x0094, set: pageSet{0x00000010, 0x000000c0, 0x08100000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x00000404, 0x00000000, 0x00000000}},
			{ref: 0x0096, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x00000008, 0x00000000, 0x00000000}},
			{ref: 0x0097, set: pageSet{0x00000000, 0x00000002, 0x00020000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00204000}},
			{ref: 0x0098, set: pageSet{0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00800000, 0x00000100, 0x00000001}},
			{ref: 0x0099, set: pageSet{0x10000000, 0x01000000, 0x00002400, 0x00000004, 0x00000000, 0x00000000, 0x00000020, 0x00000002}},
			{ref: 0x009a, set: pageSet{0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x009b, set: pageSet{0x00000000, 0x00002400, 0x00000000, 0x00000000, 0x00004802, 0x00000000, 0x00000000, 0x80022000}},
			{ref: 0x009c, set: pageSet{0x00001004, 0x04208000, 0x20000020, 0x00040000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x009d, set: pageSet{0x00000000, 0x00100000, 0x40010000, 0x00000000, 0x00080000, 0x00000000, 0x00100211, 0x00000000}},
			{ref: 0x009e, set: pageSet{0x00001400, 0x00000000, 0x00000000, 0x00000000, 0x00610000, 0x80008c00, 0x00000000, 0x00000000}},
			{ref: 0x009f, set: pageSet{0x00000100, 0x00000040, 0x00000000, 0x00000004, 0x00004000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0200, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000}},
			{ref: 0x0201, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000210, 0x00000000, 0x00000000}},
			{ref: 0x0203, set: pageSet{0x00000000, 0x00000020, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0207, set: pageSet{0x00004000, 0x00000000, 0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x020c, set: pageSet{0x00000000, 0x00000000, 0x00080002, 0x01000020, 0x00400000, 0x00200000, 0x00008000, 0x00000000}},
			{ref: 0x020d, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0xc0020000, 0x10000000, 0x00000080, 0x00000000, 0x00000000}},
			{ref: 0x020e, set: pageSet{0x00000210, 0x00000000, 0x00001000, 0x04480000, 0x20000000, 0x00000004, 0x00800000, 0x02000000}},
			{ref: 0x020f, set: pageSet{0x00000000, 0x08006000, 0x00001000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000400}},
			{ref: 0x0210, set: pageSet{0x00100000, 0x00000000, 0x10000000, 0x08608000, 0x00000000, 0x00000000, 0x00080002, 0x00000000}},
			{ref: 0x0211, set: pageSet{0x00000000, 0x20000000, 0x00008020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0219, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021a, set: pageSet{0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021c, set: pageSet{0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000}},
			{ref: 0x0220, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080, 0x00000000}},
			{ref: 0x0221, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x00000000}},
			{ref: 0x022a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000, 0x00000000}},
			{ref: 0x022b, set: pageSet{0x00000000, 0x00000000, 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000}},
			{ref: 0x022c, set: pageSet{0x00000000, 0x00000000, 0x00220000, 0x00000004, 0x00000000, 0x00040000, 0x00000004, 0x00000000}},
			{ref: 0x022d, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x00000080, 0x00002000, 0x00000000, 0x00000000, 0x00004000}},
			{ref: 0x022f, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0232, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0235, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0236, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000, 0x00000000}},
			{ref: 0x023c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00800000, 0x00000000, 0x00000000}},
			{ref: 0x023e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x023f, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0244, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000}},
			{ref: 0x024d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000400}},
			{ref: 0x024e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080, 0x00000000, 0x00000000}},
			{ref: 0x0251, set: pageSet{0x00000000, 0x00000800, 0x00000100, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0255, set: pageSet{0x00000000, 0x00200000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x025e, set: pageSet{0x00000000, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0262, set: pageSet{0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0266, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000}},
			{ref: 0x0267, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001000, 0x00000000}},
			{ref: 0x0268, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0269, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04040000}},
			{ref: 0x0272, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0275, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0276, set: pageSet{0x00000000, 0x00000000, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0277, set: pageSet{0x00000000, 0x00200000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0278, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0279, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000}},
			{ref: 0x027a, set: pageSet{0x00000000, 0x40000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x027d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0280, set: pageSet{0x00000000, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000}},
			{ref: 0x0281, set: pageSet{0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0282, set: pageSet{0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004}},
			{ref: 0x0283, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0289, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10000001, 0x00000000}},
			{ref: 0x028a, set: pageSet{0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028b, set: pageSet{0x00000000, 0x00000000, 0x00004040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00042400, 0x00000000}},
			{ref: 0x028d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080}},
			{ref: 0x0294, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000020}},
			{ref: 0x0297, set: pageSet{0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0298, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020000, 0x00000000}},
			{ref: 0x029a, set: pageSet{0x00000000, 0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x029d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x02a6, set: pageSet{0x00000000, 0x00040000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 273 */
		"yuw",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00528f81, 0x00528f81}},
		},
	},
	{ /** index: 274 */
		"za",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 275 */
		"zh-cn",
		RuneSet{
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000280, 0x00000000}},
			{ref: 0x004e, set: pageSet{0x7f7b7f8b, 0xef553db4, 0xf35dfba8, 0x400b0243, 0x8d3efb40, 0x8c2c7bf7, 0xe3fa6eff, 0xa8ed1d3a}},
			{ref: 0x004f, set: pageSet{0xcf83e602, 0x35558cf5, 0xffabe048, 0xd85992b9, 0x2892ab18, 0x8020d7e9, 0xf583c438, 0x450ae74a}},
			{ref: 0x0050, set: pageSet{0x9714b000, 0x54007762, 0x1420d188, 0xc8c01020, 0x00002121, 0x0c0413a8, 0x04408000, 0x082870c0}},
			{ref: 0x0051, set: pageSet{0x000408c0, 0x80000002, 0x14722b7b, 0x3bfb7924, 0x1ae43327, 0x38ef9835, 0x28029ad1, 0xbf69a813}},
			{ref: 0x0052, set: pageSet{0x2fc665cf, 0xafc96b11, 0x5053340f, 0xa00486a2, 0xe8090106, 0xc00e3f0f, 0x81450a88, 0xc6010010}},
			{ref: 0x0053, set: pageSet{0x26e1a161, 0xce00444b, 0xd4eec7aa, 0x85bbcadf, 0xa5203a74, 0x8840436c, 0x8bd23f06, 0x3befff79}},
			{ref: 0x0054, set: pageSet{0xe8eff75a, 0x5b36fbcb, 0x1bfd0d49, 0x39ee0154, 0x2e75d855, 0xa91abfd8, 0xf6bff3d7, 0xb40c67e0}},
			{ref: 0x0055, set: pageSet{0x081382c2, 0xd08bd49d, 0x1061065a, 0x59e074f2, 0xb3128f9f, 0x6aaa0080, 0xb05e3230, 0x60ac9d7a}},
			{ref: 0x0056, set: pageSet{0xc900d303, 0x8a563098, 0x13907000, 0x18421f14, 0x0008c060, 0x10808008, 0xec900400, 0xe6332817}},
			{ref: 0x0057, set: pageSet{0x90000758, 0x4e09f708, 0xfc83f485, 0x18c8af53, 0x080c187c, 0x01146adf, 0xa734c80c, 0x2710a011}},
			{ref: 0x0058, set: pageSet{0x422228c5, 0x00210413, 0x41123010, 0x40001820, 0xc60c022b, 0x10000300, 0x00220022, 0x02495810}},
			{ref: 0x0059, set: pageSet{0x9670a094, 0x1792eeb0, 0x05f2cb96, 0x23580025, 0x42cc25de, 0x4a04cf38, 0x359f0c40, 0x8a001128}},
			{ref: 0x005a, set: pageSet{0x910a13fa, 0x10560229, 0x04200641, 0x84f00484, 0x0c040000, 0x412c0400, 0x11541206, 0x00020a4b}},
			{ref: 0x005b, set: pageSet{0x00c00200, 0x00940000, 0xbfbb0001, 0x242b167c, 0x7fa89bbb, 0xe3790c7f, 0xe00d10f4, 0x9f014132}},
			{ref: 0x005c, set: pageSet{0x35728652, 0xff1210b4, 0x4223cf27, 0x8602c06b, 0x1fd33106, 0xa1aa3a0c, 0x02040812, 0x08012572}},
			{ref: 0x005d, set: pageSet{0x485040cc, 0x601062d0, 0x29001c80, 0x00109a00, 0x22000004, 0x00800000, 0x68002020, 0x609ecbe6}},
			{ref: 0x005e, set: pageSet{0x3f73916e, 0x398260c0, 0x48301034, 0xbd5c0006, 0xd6fb8cd1, 0x43e820e1, 0x084e0600, 0xc4d00500}},
			{ref: 0x005f, set: pageSet{0x89aa8d1f, 0x1602a6e1, 0x21ed0001, 0x1a8b3656, 0x13a51fb7, 0x30a06502, 0x23c7b278, 0xe9226c93}},
			{ref: 0x0060, set: pageSet{0x3a74e47f, 0x98208fe3, 0x2625280e, 0xbf49bf9c, 0xac543218, 0x1916b949, 0xb5220c60, 0x0659fbc1}},
			{ref: 0x0061, set: pageSet{0x8420e343, 0x800008d9, 0x20225500, 0x00a10184, 0x20104800, 0x40801380, 0x00160d04, 0x80200040}},
			{ref: 0x0062, set: pageSet{0x8de7fd40, 0xe0985436, 0x091e7b8b, 0xd249fec8, 0x8dee0611, 0xba221937, 0x9fdd77f4, 0xf0daf3ec}},
			{ref: 0x0063, set: pageSet{0xec424386, 0x26048d3f, 0xc021fa6c, 0x0cc2628e, 0x0145d785, 0x559977ad, 0x4045e250, 0xa154260b}},
			{ref: 0x0064, set: pageSet{0x58199827, 0xa4103443, 0x411405f2, 0x07002280, 0x426600b4, 0x15a17210, 0x41856025, 0x00000054}},
			{ref: 0x0065, set: pageSet{0x01040201, 0xcb70c820, 0x6a629320, 0x0095184c, 0x9a8b1880, 0x3201aab2, 0x00c4d87a, 0x04c3f3e5}},
			{ref: 0x0066, set: pageSet{0xa238d44d, 0x5072a1a1, 0x84fc980a, 0x44d1c152, 0x20c21094, 0x42104180, 0x3a000000, 0xd29d0240}},
			{ref: 0x0067, set: pageSet{0xa8b12f01, 0x2432bd40, 0xd04bd34d, 0xd0ada723, 0x75a10a92, 0x01e9adac, 0x771f801a, 0xa01b9225}},
			{ref: 0x0068, set: pageSet{0x20cadfa1, 0x738c0602, 0x003b577f, 0x00d00bff, 0x0088806a, 0x0029a1c4, 0x05242a05, 0x16234009}},
			{ref: 0x0069, set: pageSet{0x80056822, 0xa2112011, 0x64900004, 0x13824849, 0x193023d5, 0x08922980, 0x88115402, 0xa0042001}},
			{ref: 0x006a, set: pageSet{0x81800400, 0x60228502, 0x0b010090, 0x12020022, 0x00834011, 0x00001a01, 0x00000000, 0x00000000}},
			{ref: 0x006b, set: pageSet{0x00000000, 0x4684009f, 0x020012c8, 0x1a0004fc, 0x0c4c2ede, 0x80b80402, 0x0afca826, 0x22288c02}},
			{ref: 0x006c, set: pageSet{0x8f7ba0e0, 0x2135c7d6, 0xf8b106c7, 0x62550713, 0x8a19936e, 0xfb0e6efa, 0x48f91630, 0x7debcd2f}},
			{ref: 0x006d, set: pageSet{0x4e845892, 0x7a2e4ca0, 0x561eedea, 0x1190c649, 0xe83a5324, 0x8124cfdb, 0x634218f1, 0x1a8a5853}},
			{ref: 0x006e, set: pageSet{0x24d37420, 0x0514aa3b, 0x89586018, 0xc0004800, 0x91018268, 0x2cd684a4, 0xc4ba8886, 0x02100377}},
			{ref: 0x006f, set: pageSet{0x00388244, 0x404aae11, 0x510028c0, 0x15146044, 0x10007310, 0x02480082, 0x40060205, 0x0000c003}},
			{ref: 0x0070, set: pageSet{0x0c020000, 0x02200008, 0x40009000, 0xd161b800, 0x32744621, 0x3b8af800, 0x8b00050f, 0x2280bbd0}},
			{ref: 0x0071, set: pageSet{0x07690600, 0x00438040, 0x50005420, 0x250c41d0, 0x83108410, 0x02281101, 0x00304008, 0x020040a1}},
			{ref: 0x0072, set: pageSet{0x20000040, 0xabe31500, 0xaa443180, 0xc624c2c6, 0x8004ac13, 0x03d1b000, 0x4285611e, 0x1d9ff303}},
			{ref: 0x0073, set: pageSet{0x78e8440a, 0xc3925e26, 0x00852000, 0x4000b001, 0x88424a90, 0x0c8dca04, 0x4203a705, 0x000422a1}},
			{ref: 0x0074, set: pageSet{0x0c018668, 0x10795564, 0xdea00002, 0x40c12000, 0x5001488b, 0x04000380, 0x50040000, 0x80d0c05d}},
			{ref: 0x0075, set: pageSet{0x970aa010, 0x4dafbb20, 0x1e10d921, 0x83140460, 0xa6d68848, 0x733fd83b, 0x497427bc, 0x92130ddc}},
			{ref: 0x0076, set: pageSet{0x8ba1142b, 0xd1392e75, 0x50503009, 0x69008808, 0x024a49d4, 0x80164010, 0x89d7e564, 0x5316c020}},
			{ref: 0x0077, set: pageSet{0x86002b92, 0x15e0a345, 0x0c03008b, 0xe200196e, 0x80067031, 0xa82916a5, 0x18802000, 0xe1487aac}},
			{ref: 0x0078, set: pageSet{0xb5d63207, 0x5f9132e8, 0x20e550a1, 0x10807c00, 0x9d8a7280, 0x421f00aa, 0x02310e22, 0x04941100}},
			{ref: 0x0079, set: pageSet{0x40080022, 0x5c100010, 0xfcc80343, 0x0580a1a5, 0x04008433, 0x6e080080, 0x81262a4b, 0x2901aad8}},
			{ref: 0x007a, set: pageSet{0x4490684d, 0xba880009, 0x00820040, 0x87d10000, 0xb1e6215b, 0x80083161, 0xc2400800, 0xa600a069}},
			{ref: 0x007b, set: pageSet{0x4a328d58, 0x550a5d71, 0x2d579aa0, 0x4aa64005, 0x30b12021, 0x01123fc6, 0x260a10c2, 0x50824462}},
			{ref: 0x007c, set: pageSet{0x80409880, 0x810004c0, 0x00002003, 0x38180000, 0xf1a60200, 0x720e4434, 0x92e035a2, 0x09008101}},
			{ref: 0x007d, set: pageSet{0x00000400, 0x00008885, 0x00000000, 0x00804000, 0x00000000, 0x00004040, 0x00000000, 0x00000000}},
			{ref: 0x007e, set: pageSet{0x00000000, 0x08000000, 0x00000082, 0x00000000, 0x88000004, 0xe7efbfff, 0xffbfffff, 0xfdffefef}},
			{ref: 0x007f, set: pageSet{0xbffefbff, 0x057fffff, 0x85b30034, 0x42164706, 0xe4105402, 0xb3058092, 0x81305422, 0x180b4263}},
			{ref: 0x0080, set: pageSet{0x13f5387b, 0xa9ea07e5, 0x05143c4c, 0x80020600, 0xbd481ad9, 0xf496ee37, 0x7ec0705f, 0x355fbfb2}},
			{ref: 0x0081, set: pageSet{0x455fe644, 0x41469000, 0x063b1d40, 0xfe1362a1, 0x39028505, 0x0c080548, 0x0000144f, 0x58183488}},
			{ref: 0x0082, set: pageSet{0xd8153077, 0x4bfbbd0e, 0x85008a90, 0xe61dc100, 0xb386ed14, 0x639bff72, 0xd9befd92, 0x0a92887b}},
			{ref: 0x0083, set: pageSet{0x1cb2d3fe, 0x177ab980, 0xdc1782c9, 0x3980fffb, 0x590c4260, 0x37df0f01, 0xb15094a3, 0x23070623}},
			{ref: 0x0084, set: pageSet{0x3102f85a, 0x310201f0, 0x1e820040, 0x056a3a0a, 0x12805b84, 0xa7148002, 0xa04b2612, 0x90011069}},
			{ref: 0x0085, set: pageSet{0x848a1000, 0x3f801802, 0x42400708, 0x4e140110, 0x180080b0, 0x0281c510, 0x10298202, 0x88000210}},
			{ref: 0x0086, set: pageSet{0x00420020, 0x11000280, 0x4413e000, 0xfe025804, 0x30283c07, 0x04739798, 0xcb13ced1, 0x431f6210}},
			{ref: 0x0087, set: pageSet{0x55ac278d, 0xc892422e, 0x02885380, 0x78514039, 0x8088292c, 0x2428b900, 0x080e0c41, 0x42004421}},
			{ref: 0x0088, set: pageSet{0x08680408, 0x12040006, 0x02903031, 0xe0855b3e, 0x10442936, 0x10822814, 0x83344266, 0x531b013c}},
			{ref: 0x0089, set: pageSet{0x0e0d0404, 0x00510c22, 0xc0000012, 0x88000040, 0x0000004a, 0x00000000, 0x5447dff6, 0x00088868}},
			{ref: 0x008a, set: pageSet{0x00000081, 0x40000000, 0x00000100, 0x02000000, 0x00080600, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008b, set: pageSet{0x00000080, 0x00000040, 0x00000000, 0x00001040, 0x00000000, 0xf7fdefff, 0xfffeff7f, 0xfffffbff}},
			{ref: 0x008c, set: pageSet{0xbffffdff, 0x00ffffff, 0x042012c2, 0x07080c06, 0x01101624, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008d, set: pageSet{0xe0000000, 0xfffffffe, 0x7f79ffff, 0x00f928df, 0x80120c32, 0xd53a0008, 0xecc2d858, 0x2fa89d18}},
			{ref: 0x008e, set: pageSet{0xe0109620, 0x2622d60c, 0x02060f97, 0x9055b240, 0x501180a2, 0x04049800, 0x00004000, 0x00000000}},
			{ref: 0x008f, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0xfffffbc0, 0xdffbeffe, 0x62430b08, 0xfb3b41b6, 0x23896f74}},
			{ref: 0x0090, set: pageSet{0xecd7ae7f, 0x5960e047, 0x098fa096, 0xa030612c, 0x2aaa090d, 0x4f7bd44e, 0x388bc4b2, 0x6110a9c6}},
			{ref: 0x0091, set: pageSet{0x42000014, 0x0202800c, 0x6485fe48, 0xe3f7d63e, 0x0c073aa0, 0x0430e40c, 0x1002f680, 0x00000000}},
			{ref: 0x0092, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00004000, 0x00004000, 0x00000100, 0x00000000}},
			{ref: 0x0093, set: pageSet{0x00000000, 0x40000000, 0x00000000, 0x00000400, 0x00008000, 0x00000000, 0x00400400, 0x00000000}},
			{ref: 0x0094, set: pageSet{0x00000000, 0x40000000, 0x00000000, 0x00000800, 0xfebdffe0, 0xffffffff, 0xfbe77f7f, 0xf7ffffbf}},
			{ref: 0x0095, set: pageSet{0xefffffff, 0xdff7ff7e, 0xfbdff6f7, 0x804fbffe, 0x00000000, 0x00000000, 0x00000000, 0x7fffef00}},
			{ref: 0x0096, set: pageSet{0xb6f7ff7f, 0xb87e4406, 0x88313bf5, 0x00f41796, 0x1391a960, 0x72490080, 0x0024f2f3, 0x42c88701}},
			{ref: 0x0097, set: pageSet{0x5048e3d3, 0x43052400, 0x4a4c0000, 0x10580227, 0x01162820, 0x0014a809, 0x00000000, 0x00683ec0}},
			{ref: 0x0098, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0xffe00000, 0xfddbb7ff, 0x000000f7, 0xc72e4000, 0x00000180}},
			{ref: 0x0099, set: pageSet{0x00012000, 0x00004000, 0x00300000, 0xb4f7ffa8, 0x03ffadf3, 0x00000120, 0x00000000, 0x00000000}},
			{ref: 0x009a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0xfffbf000, 0xfdcf9df7, 0x15c301bf, 0x810a1827, 0x0a00a842}},
			{ref: 0x009b, set: pageSet{0x80088108, 0x18048008, 0x0012a3be, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x009c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x90000000, 0xdc3769e6, 0x3dff6bff, 0xf3f9fcf8, 0x00000004}},
			{ref: 0x009e, set: pageSet{0x80000000, 0xe7eebf6f, 0x5da2dffe, 0xc00b3fd8, 0xa00c0984, 0x69100040, 0xb912e210, 0x5a0086a5}},
			{ref: 0x009f, set: pageSet{0x02896800, 0x6a809005, 0x00030010, 0x80000000, 0x8e001ff9, 0x00000001, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 276 */
		"zh-hk",
		RuneSet{
			{ref: 0x0030, set: pageSet{0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0034, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x64080010, 0x00480000, 0x10000020, 0x80000102, 0x08000010}},
			{ref: 0x0035, set: pageSet{0x00000040, 0x40000000, 0x00020000, 0x01852002, 0x00800010, 0x80002022, 0x084444a2, 0x480e0000}},
			{ref: 0x0036, set: pageSet{0x04000200, 0x02202008, 0x80004380, 0x04000000, 0x00000002, 0x12231420, 0x2058003a, 0x00200060}},
			{ref: 0x0037, set: pageSet{0x10002508, 0x040d0028, 0x00000009, 0x00008004, 0x00800000, 0x42000001, 0x00000000, 0x09040000}},
			{ref: 0x0038, set: pageSet{0x02008000, 0x01402001, 0x00000000, 0x00000008, 0x00000000, 0x00000001, 0x00021008, 0x04000000}},
			{ref: 0x0039, set: pageSet{0x00100100, 0x80040080, 0x00002000, 0x00000008, 0x08040601, 0x01000012, 0x10000000, 0x49001024}},
			{ref: 0x003a, set: pageSet{0x0180004a, 0x00100600, 0x50840800, 0x000000c0, 0x00800000, 0x20000800, 0x40000000, 0x08050000}},
			{ref: 0x003b, set: pageSet{0x02004000, 0x02000804, 0x01000004, 0x18060001, 0x02400001, 0x40000002, 0x20800014, 0x000c1000}},
			{ref: 0x003c, set: pageSet{0x00222000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x10422800, 0x00000800}},
			{ref: 0x003d, set: pageSet{0x20080000, 0x00040000, 0x80025040, 0x20208604, 0x00028020, 0x80102020, 0x080820c0, 0x10880800}},
			{ref: 0x003e, set: pageSet{0x00000000, 0x00000000, 0x00200109, 0x00100000, 0x00000000, 0x81022700, 0x40c21404, 0x84010882}},
			{ref: 0x003f, set: pageSet{0x00004010, 0x00000000, 0x03000000, 0x00000008, 0x00080000, 0x00000000, 0x10800001, 0x06002020}},
			{ref: 0x0040, set: pageSet{0x00000010, 0x02000000, 0x00880020, 0x00008424, 0x00000000, 0x88000000, 0x81000100, 0x04000000}},
			{ref: 0x0041, set: pageSet{0x00004218, 0x00040000, 0x00000000, 0x80005080, 0x00010000, 0x00040000, 0x08008000, 0x02008000}},
			{ref: 0x0042, set: pageSet{0x00020000, 0x00000000, 0x00000001, 0x04000401, 0x00100000, 0x12200004, 0x00000000, 0x18100000}},
			{ref: 0x0043, set: pageSet{0x00000000, 0x00000800, 0x00000000, 0x00004000, 0x00800000, 0x04000000, 0x82000002, 0x00042000}},
			{ref: 0x0044, set: pageSet{0x00080006, 0x00000000, 0x00000000, 0x04000000, 0x80008000, 0x00810001, 0xa0000000, 0x00100410}},
			{ref: 0x0045, set: pageSet{0x00400218, 0x88084080, 0x00260008, 0x00800404, 0x00000020, 0x00000000, 0x00000000, 0x00000200}},
			{ref: 0x0046, set: pageSet{0x00a08048, 0x00000000, 0x08000000, 0x04000000, 0x00000000, 0x00000000, 0x00018000, 0x00200000}},
			{ref: 0x0047, set: pageSet{0x01000000, 0x00000000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00200000, 0x00102000}},
			{ref: 0x0048, set: pageSet{0x00000801, 0x00000000, 0x00000000, 0x00020000, 0x08000000, 0x00002000, 0x20010000, 0x04002000}},
			{ref: 0x0049, set: pageSet{0x40000040, 0x50202400, 0x000a0020, 0x00040420, 0x00000200, 0x00000080, 0x80000000, 0x00000020}},
			{ref: 0x004a, set: pageSet{0x20008000, 0x00200010, 0x00000000, 0x00000000, 0x00400000, 0x01100000, 0x00020000, 0x80000010}},
			{ref: 0x004b, set: pageSet{0x02000000, 0x00801000, 0x00000000, 0x48058000, 0x20c94000, 0x60000000, 0x00000001, 0x00000000}},
			{ref: 0x004c, set: pageSet{0x00004090, 0x48000000, 0x08000000, 0x28802000, 0x00000002, 0x00014000, 0x00002000, 0x00002002}},
			{ref: 0x004d, set: pageSet{0x00010200, 0x00100000, 0x00000000, 0x00800000, 0x10020000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x004e, set: pageSet{0x00000010, 0x00000402, 0x0c000000, 0x01000400, 0x01000021, 0x00000000, 0x00004000, 0x00004000}},
			{ref: 0x004f, set: pageSet{0x00000000, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000020}},
			{ref: 0x0050, set: pageSet{0x00000100, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00002000, 0x00000000}},
			{ref: 0x0051, set: pageSet{0x00006000, 0x00000000, 0x00000000, 0x00000400, 0x04000040, 0x003c0180, 0x00000200, 0x00102000}},
			{ref: 0x0052, set: pageSet{0x00000800, 0x101000c0, 0x00800000, 0x00000000, 0x00008000, 0x02200000, 0x00020020, 0x00000000}},
			{ref: 0x0053, set: pageSet{0x00000000, 0x01000000, 0x00000000, 0x20100000, 0x00080000, 0x00000141, 0x02001002, 0x40400001}},
			{ref: 0x0054, set: pageSet{0x00580000, 0x00000002, 0x00003000, 0x00002400, 0x00988000, 0x00040010, 0x00002800, 0x00000008}},
			{ref: 0x0055, set: pageSet{0x40080004, 0x00000020, 0x20080000, 0x02060a00, 0x00010040, 0x14010200, 0x40800000, 0x08031000}},
			{ref: 0x0056, set: pageSet{0x40020020, 0x0000202c, 0x2014a008, 0x00000000, 0x80040200, 0x82020012, 0x00400000, 0x20000000}},
			{ref: 0x0057, set: pageSet{0x00000000, 0x00000000, 0x00000004, 0x04000000, 0x00000000, 0x00000000, 0x40800100, 0x00000000}},
			{ref: 0x0058, set: pageSet{0x00000008, 0x04000040, 0x00000001, 0x000c0200, 0x00000000, 0x08000400, 0x00000000, 0x080c0001}},
			{ref: 0x0059, set: pageSet{0x00000400, 0x00000000, 0x00000000, 0x00200000, 0x80000000, 0x00001000, 0x00000200, 0x01000800}},
			{ref: 0x005a, set: pageSet{0x00000000, 0x00000800, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x04040000}},
			{ref: 0x005b, set: pageSet{0x00000000, 0x00000000, 0x00000040, 0x00002000, 0xa0000000, 0x00000000, 0x08000008, 0x00080000}},
			{ref: 0x005c, set: pageSet{0x00000020, 0x00000000, 0x40000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000}},
			{ref: 0x005d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0x00000000, 0x00200000}},
			{ref: 0x005e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000008, 0x00000000, 0x00010000, 0x1b000000}},
			{ref: 0x005f, set: pageSet{0x00007000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00000080, 0x80000000, 0x00000000}},
			{ref: 0x0060, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x00200000, 0x40000000, 0x00000010, 0x00800000, 0x00000008}},
			{ref: 0x0061, set: pageSet{0x00000000, 0x00000000, 0x02000000, 0x20000010, 0x00000080, 0x00000000, 0x00010000, 0x00000000}},
			{ref: 0x0062, set: pageSet{0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x20000000, 0x00000040, 0x00200028, 0x00000000}},
			{ref: 0x0063, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x02000000, 0x00000000, 0x02000000, 0x40020000, 0x51000040}},
			{ref: 0x0064, set: pageSet{0x00000080, 0x04040000, 0x00000000, 0x10000000, 0x00022000, 0x00100000, 0x20000000, 0x00000082}},
			{ref: 0x0065, set: pageSet{0x40000000, 0x00010000, 0x00002000, 0x00000000, 0x00000240, 0x00000000, 0x00000000, 0x00000008}},
			{ref: 0x0066, set: pageSet{0x00000000, 0x00010000, 0x00000810, 0x00080880, 0x00004000, 0x00000000, 0x00000000, 0x00020000}},
			{ref: 0x0067, set: pageSet{0x00000000, 0x00400020, 0x00000000, 0x00000082, 0x00000000, 0x00020001, 0x00000000, 0x00000000}},
			{ref: 0x0068, set: pageSet{0x40000018, 0x00000004, 0x00000000, 0x00000000, 0x01000000, 0x00400000, 0x00000000, 0x00000000}},
			{ref: 0x0069, set: pageSet{0x00000001, 0x00400000, 0x00000000, 0x00080002, 0x00000400, 0x00040000, 0x00000000, 0x00000000}},
			{ref: 0x006a, set: pageSet{0x00000800, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000}},
			{ref: 0x006b, set: pageSet{0x00000000, 0x00200000, 0x00000000, 0x04108000, 0x00000000, 0x00000000, 0x00000000, 0x00000002}},
			{ref: 0x006c, set: pageSet{0x00000000, 0x02800000, 0x04000000, 0x00000000, 0x00000000, 0x00000004, 0x00000000, 0x00000400}},
			{ref: 0x006d, set: pageSet{0x00000000, 0x00000000, 0x10000000, 0x00040000, 0x00400000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x006e, set: pageSet{0x00200000, 0x00000200, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x2a000000, 0x00000000}},
			{ref: 0x006f, set: pageSet{0x00400000, 0x00000000, 0x00400000, 0x00000000, 0x00000002, 0x40000000, 0x00000000, 0x00400000}},
			{ref: 0x0070, set: pageSet{0x40000000, 0x00001000, 0x00000000, 0x00000000, 0x00000202, 0x02000000, 0x80000000, 0x00020000}},
			{ref: 0x0071, set: pageSet{0x00000020, 0x00000800, 0x00020421, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00400000}},
			{ref: 0x0072, set: pageSet{0x00200000, 0x00000000, 0x00000001, 0x00000000, 0x00000084, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0073, set: pageSet{0x00000000, 0x00004400, 0x00000002, 0x00100000, 0x00000000, 0x00000000, 0x00008200, 0x00000000}},
			{ref: 0x0074, set: pageSet{0x00000000, 0x12000000, 0x00000100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0075, set: pageSet{0x00000020, 0x08100000, 0x000a0400, 0x00000081, 0x00006000, 0x00120000, 0x00000000, 0x00000000}},
			{ref: 0x0076, set: pageSet{0x00000004, 0x08000000, 0x00004000, 0x044000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0077, set: pageSet{0x40001000, 0x00000000, 0x01000001, 0x05000000, 0x00080000, 0x02000000, 0x00000800, 0x00000000}},
			{ref: 0x0078, set: pageSet{0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00002002, 0x01020000, 0x00800000, 0x00000000}},
			{ref: 0x0079, set: pageSet{0x00000040, 0x00004000, 0x01000000, 0x00000004, 0x00020000, 0x00000000, 0x00000010, 0x00000000}},
			{ref: 0x007a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00010000, 0x30000300, 0x00000400}},
			{ref: 0x007b, set: pageSet{0x00000800, 0x02000000, 0x00000000, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007c, set: pageSet{0x00200000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000040c0, 0x00002200, 0x12002000}},
			{ref: 0x007d, set: pageSet{0x00000000, 0x00000020, 0x20000000, 0x00000000, 0x00000200, 0x00080800, 0x1000a000, 0x00000000}},
			{ref: 0x007e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0x00000000, 0x00004280, 0x01000000, 0x00800000, 0x00000008, 0x00000000, 0x00000000}},
			{ref: 0x0080, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x20400000, 0x00000040, 0x00000000}},
			{ref: 0x0081, set: pageSet{0x00800080, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00400020, 0x00000000, 0x00008000}},
			{ref: 0x0082, set: pageSet{0x01000000, 0x00000040, 0x00000000, 0x00400000, 0x00000000, 0x00000440, 0x00000000, 0x00800000}},
			{ref: 0x0083, set: pageSet{0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000}},
			{ref: 0x0084, set: pageSet{0x01000000, 0x00000001, 0x00000000, 0x00020000, 0x00000000, 0x20002000, 0x00000000, 0x00000004}},
			{ref: 0x0085, set: pageSet{0x00000008, 0x00100000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0086, set: pageSet{0x00000004, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000}},
			{ref: 0x0087, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000000, 0x00004000, 0x00000000}},
			{ref: 0x0088, set: pageSet{0x00000010, 0x00002000, 0x40000040, 0x00000000, 0x10000000, 0x00000000, 0x00008080, 0x00000000}},
			{ref: 0x0089, set: pageSet{0x00000000, 0x00000000, 0x00000080, 0x00000000, 0x00100080, 0x000000a0, 0x00000000, 0x00000000}},
			{ref: 0x008a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008b, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x00000000, 0x0001000a, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08002000, 0x00000000}},
			{ref: 0x008d, set: pageSet{0x00000808, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008e, set: pageSet{0x00004000, 0x00002400, 0x00008000, 0x40000000, 0x00000001, 0x00002000, 0x04000000, 0x00040004}},
			{ref: 0x008f, set: pageSet{0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x1c200000, 0x00000000, 0x02000000}},
			{ref: 0x0090, set: pageSet{0x00000000, 0x00080000, 0x00400000, 0x00000002, 0x00000000, 0x00000100, 0x00000000, 0x00000000}},
			{ref: 0x0091, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0092, set: pageSet{0x00004100, 0x00000400, 0x20200010, 0x00004004, 0x00000000, 0x42000000, 0x00000000, 0x00000000}},
			{ref: 0x0093, set: pageSet{0x00000080, 0x00000000, 0x00000121, 0x00000200, 0x000000b0, 0x80002000, 0x00000000, 0x00010000}},
			{ref: 0x0094, set: pageSet{0x00000010, 0x000000c0, 0x08100000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x00000404, 0x00000000, 0x00000000}},
			{ref: 0x0096, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x00000008, 0x00000000, 0x00000000}},
			{ref: 0x0097, set: pageSet{0x00000000, 0x00000002, 0x00020000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00204000}},
			{ref: 0x0098, set: pageSet{0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00800000, 0x00000100, 0x00000001}},
			{ref: 0x0099, set: pageSet{0x10000000, 0x01000000, 0x00002400, 0x00000004, 0x00000000, 0x00000000, 0x00000020, 0x00000002}},
			{ref: 0x009a, set: pageSet{0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x009b, set: pageSet{0x00000000, 0x00002400, 0x00000000, 0x00000000, 0x00004802, 0x00000000, 0x00000000, 0x80022000}},
			{ref: 0x009c, set: pageSet{0x00001004, 0x04208000, 0x20000020, 0x00040000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x009d, set: pageSet{0x00000000, 0x00100000, 0x40010000, 0x00000000, 0x00080000, 0x00000000, 0x00100211, 0x00000000}},
			{ref: 0x009e, set: pageSet{0x00001400, 0x00000000, 0x00000000, 0x00000000, 0x00610000, 0x80008c00, 0x00000000, 0x00000000}},
			{ref: 0x009f, set: pageSet{0x00000100, 0x00000040, 0x00000000, 0x00000004, 0x00004000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0200, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000}},
			{ref: 0x0201, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000210, 0x00000000, 0x00000000}},
			{ref: 0x0203, set: pageSet{0x00000000, 0x00000020, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0207, set: pageSet{0x00004000, 0x00000000, 0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x020c, set: pageSet{0x00000000, 0x00000000, 0x00080002, 0x01000020, 0x00400000, 0x00200000, 0x00008000, 0x00000000}},
			{ref: 0x020d, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0xc0020000, 0x10000000, 0x00000080, 0x00000000, 0x00000000}},
			{ref: 0x020e, set: pageSet{0x00000210, 0x00000000, 0x00001000, 0x04480000, 0x20000000, 0x00000004, 0x00800000, 0x02000000}},
			{ref: 0x020f, set: pageSet{0x00000000, 0x08006000, 0x00001000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000400}},
			{ref: 0x0210, set: pageSet{0x00100000, 0x00000000, 0x10000000, 0x08608000, 0x00000000, 0x00000000, 0x00080002, 0x00000000}},
			{ref: 0x0211, set: pageSet{0x00000000, 0x20000000, 0x00008020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0219, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021a, set: pageSet{0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021c, set: pageSet{0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000}},
			{ref: 0x0220, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080, 0x00000000}},
			{ref: 0x0221, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x00000000}},
			{ref: 0x022a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000, 0x00000000}},
			{ref: 0x022b, set: pageSet{0x00000000, 0x00000000, 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000}},
			{ref: 0x022c, set: pageSet{0x00000000, 0x00000000, 0x00220000, 0x00000004, 0x00000000, 0x00040000, 0x00000004, 0x00000000}},
			{ref: 0x022d, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x00000080, 0x00002000, 0x00000000, 0x00000000, 0x00004000}},
			{ref: 0x022f, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0232, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0235, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0236, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000, 0x00000000}},
			{ref: 0x023c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00800000, 0x00000000, 0x00000000}},
			{ref: 0x023e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x023f, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0244, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000}},
			{ref: 0x024d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000400}},
			{ref: 0x024e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080, 0x00000000, 0x00000000}},
			{ref: 0x0251, set: pageSet{0x00000000, 0x00000800, 0x00000100, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0255, set: pageSet{0x00000000, 0x00200000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x025e, set: pageSet{0x00000000, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0262, set: pageSet{0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0266, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000}},
			{ref: 0x0267, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001000, 0x00000000}},
			{ref: 0x0268, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0269, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04040000}},
			{ref: 0x0272, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0275, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0276, set: pageSet{0x00000000, 0x00000000, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0277, set: pageSet{0x00000000, 0x00200000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0278, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0279, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000}},
			{ref: 0x027a, set: pageSet{0x00000000, 0x40000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x027d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0280, set: pageSet{0x00000000, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000}},
			{ref: 0x0281, set: pageSet{0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0282, set: pageSet{0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004}},
			{ref: 0x0283, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0289, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10000001, 0x00000000}},
			{ref: 0x028a, set: pageSet{0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028b, set: pageSet{0x00000000, 0x00000000, 0x00004040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00042400, 0x00000000}},
			{ref: 0x028d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080}},
			{ref: 0x0294, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000020}},
			{ref: 0x0297, set: pageSet{0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0298, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020000, 0x00000000}},
			{ref: 0x029a, set: pageSet{0x00000000, 0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x029d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x02a6, set: pageSet{0x00000000, 0x00040000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 277 */
		"zh-mo",
		RuneSet{
			{ref: 0x0030, set: pageSet{0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0034, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x64080010, 0x00480000, 0x10000020, 0x80000102, 0x08000010}},
			{ref: 0x0035, set: pageSet{0x00000040, 0x40000000, 0x00020000, 0x01852002, 0x00800010, 0x80002022, 0x084444a2, 0x480e0000}},
			{ref: 0x0036, set: pageSet{0x04000200, 0x02202008, 0x80004380, 0x04000000, 0x00000002, 0x12231420, 0x2058003a, 0x00200060}},
			{ref: 0x0037, set: pageSet{0x10002508, 0x040d0028, 0x00000009, 0x00008004, 0x00800000, 0x42000001, 0x00000000, 0x09040000}},
			{ref: 0x0038, set: pageSet{0x02008000, 0x01402001, 0x00000000, 0x00000008, 0x00000000, 0x00000001, 0x00021008, 0x04000000}},
			{ref: 0x0039, set: pageSet{0x00100100, 0x80040080, 0x00002000, 0x00000008, 0x08040601, 0x01000012, 0x10000000, 0x49001024}},
			{ref: 0x003a, set: pageSet{0x0180004a, 0x00100600, 0x50840800, 0x000000c0, 0x00800000, 0x20000800, 0x40000000, 0x08050000}},
			{ref: 0x003b, set: pageSet{0x02004000, 0x02000804, 0x01000004, 0x18060001, 0x02400001, 0x40000002, 0x20800014, 0x000c1000}},
			{ref: 0x003c, set: pageSet{0x00222000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x10422800, 0x00000800}},
			{ref: 0x003d, set: pageSet{0x20080000, 0x00040000, 0x80025040, 0x20208604, 0x00028020, 0x80102020, 0x080820c0, 0x10880800}},
			{ref: 0x003e, set: pageSet{0x00000000, 0x00000000, 0x00200109, 0x00100000, 0x00000000, 0x81022700, 0x40c21404, 0x84010882}},
			{ref: 0x003f, set: pageSet{0x00004010, 0x00000000, 0x03000000, 0x00000008, 0x00080000, 0x00000000, 0x10800001, 0x06002020}},
			{ref: 0x0040, set: pageSet{0x00000010, 0x02000000, 0x00880020, 0x00008424, 0x00000000, 0x88000000, 0x81000100, 0x04000000}},
			{ref: 0x0041, set: pageSet{0x00004218, 0x00040000, 0x00000000, 0x80005080, 0x00010000, 0x00040000, 0x08008000, 0x02008000}},
			{ref: 0x0042, set: pageSet{0x00020000, 0x00000000, 0x00000001, 0x04000401, 0x00100000, 0x12200004, 0x00000000, 0x18100000}},
			{ref: 0x0043, set: pageSet{0x00000000, 0x00000800, 0x00000000, 0x00004000, 0x00800000, 0x04000000, 0x82000002, 0x00042000}},
			{ref: 0x0044, set: pageSet{0x00080006, 0x00000000, 0x00000000, 0x04000000, 0x80008000, 0x00810001, 0xa0000000, 0x00100410}},
			{ref: 0x0045, set: pageSet{0x00400218, 0x88084080, 0x00260008, 0x00800404, 0x00000020, 0x00000000, 0x00000000, 0x00000200}},
			{ref: 0x0046, set: pageSet{0x00a08048, 0x00000000, 0x08000000, 0x04000000, 0x00000000, 0x00000000, 0x00018000, 0x00200000}},
			{ref: 0x0047, set: pageSet{0x01000000, 0x00000000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00200000, 0x00102000}},
			{ref: 0x0048, set: pageSet{0x00000801, 0x00000000, 0x00000000, 0x00020000, 0x08000000, 0x00002000, 0x20010000, 0x04002000}},
			{ref: 0x0049, set: pageSet{0x40000040, 0x50202400, 0x000a0020, 0x00040420, 0x00000200, 0x00000080, 0x80000000, 0x00000020}},
			{ref: 0x004a, set: pageSet{0x20008000, 0x00200010, 0x00000000, 0x00000000, 0x00400000, 0x01100000, 0x00020000, 0x80000010}},
			{ref: 0x004b, set: pageSet{0x02000000, 0x00801000, 0x00000000, 0x48058000, 0x20c94000, 0x60000000, 0x00000001, 0x00000000}},
			{ref: 0x004c, set: pageSet{0x00004090, 0x48000000, 0x08000000, 0x28802000, 0x00000002, 0x00014000, 0x00002000, 0x00002002}},
			{ref: 0x004d, set: pageSet{0x00010200, 0x00100000, 0x00000000, 0x00800000, 0x10020000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x004e, set: pageSet{0x00000010, 0x00000402, 0x0c000000, 0x01000400, 0x01000021, 0x00000000, 0x00004000, 0x00004000}},
			{ref: 0x004f, set: pageSet{0x00000000, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000020}},
			{ref: 0x0050, set: pageSet{0x00000100, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00002000, 0x00000000}},
			{ref: 0x0051, set: pageSet{0x00006000, 0x00000000, 0x00000000, 0x00000400, 0x04000040, 0x003c0180, 0x00000200, 0x00102000}},
			{ref: 0x0052, set: pageSet{0x00000800, 0x101000c0, 0x00800000, 0x00000000, 0x00008000, 0x02200000, 0x00020020, 0x00000000}},
			{ref: 0x0053, set: pageSet{0x00000000, 0x01000000, 0x00000000, 0x20100000, 0x00080000, 0x00000141, 0x02001002, 0x40400001}},
			{ref: 0x0054, set: pageSet{0x00580000, 0x00000002, 0x00003000, 0x00002400, 0x00988000, 0x00040010, 0x00002800, 0x00000008}},
			{ref: 0x0055, set: pageSet{0x40080004, 0x00000020, 0x20080000, 0x02060a00, 0x00010040, 0x14010200, 0x40800000, 0x08031000}},
			{ref: 0x0056, set: pageSet{0x40020020, 0x0000202c, 0x2014a008, 0x00000000, 0x80040200, 0x82020012, 0x00400000, 0x20000000}},
			{ref: 0x0057, set: pageSet{0x00000000, 0x00000000, 0x00000004, 0x04000000, 0x00000000, 0x00000000, 0x40800100, 0x00000000}},
			{ref: 0x0058, set: pageSet{0x00000008, 0x04000040, 0x00000001, 0x000c0200, 0x00000000, 0x08000400, 0x00000000, 0x080c0001}},
			{ref: 0x0059, set: pageSet{0x00000400, 0x00000000, 0x00000000, 0x00200000, 0x80000000, 0x00001000, 0x00000200, 0x01000800}},
			{ref: 0x005a, set: pageSet{0x00000000, 0x00000800, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x04040000}},
			{ref: 0x005b, set: pageSet{0x00000000, 0x00000000, 0x00000040, 0x00002000, 0xa0000000, 0x00000000, 0x08000008, 0x00080000}},
			{ref: 0x005c, set: pageSet{0x00000020, 0x00000000, 0x40000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000}},
			{ref: 0x005d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0x00000000, 0x00200000}},
			{ref: 0x005e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000008, 0x00000000, 0x00010000, 0x1b000000}},
			{ref: 0x005f, set: pageSet{0x00007000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00000080, 0x80000000, 0x00000000}},
			{ref: 0x0060, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x00200000, 0x40000000, 0x00000010, 0x00800000, 0x00000008}},
			{ref: 0x0061, set: pageSet{0x00000000, 0x00000000, 0x02000000, 0x20000010, 0x00000080, 0x00000000, 0x00010000, 0x00000000}},
			{ref: 0x0062, set: pageSet{0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x20000000, 0x00000040, 0x00200028, 0x00000000}},
			{ref: 0x0063, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x02000000, 0x00000000, 0x02000000, 0x40020000, 0x51000040}},
			{ref: 0x0064, set: pageSet{0x00000080, 0x04040000, 0x00000000, 0x10000000, 0x00022000, 0x00100000, 0x20000000, 0x00000082}},
			{ref: 0x0065, set: pageSet{0x40000000, 0x00010000, 0x00002000, 0x00000000, 0x00000240, 0x00000000, 0x00000000, 0x00000008}},
			{ref: 0x0066, set: pageSet{0x00000000, 0x00010000, 0x00000810, 0x00080880, 0x00004000, 0x00000000, 0x00000000, 0x00020000}},
			{ref: 0x0067, set: pageSet{0x00000000, 0x00400020, 0x00000000, 0x00000082, 0x00000000, 0x00020001, 0x00000000, 0x00000000}},
			{ref: 0x0068, set: pageSet{0x40000018, 0x00000004, 0x00000000, 0x00000000, 0x01000000, 0x00400000, 0x00000000, 0x00000000}},
			{ref: 0x0069, set: pageSet{0x00000001, 0x00400000, 0x00000000, 0x00080002, 0x00000400, 0x00040000, 0x00000000, 0x00000000}},
			{ref: 0x006a, set: pageSet{0x00000800, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000}},
			{ref: 0x006b, set: pageSet{0x00000000, 0x00200000, 0x00000000, 0x04108000, 0x00000000, 0x00000000, 0x00000000, 0x00000002}},
			{ref: 0x006c, set: pageSet{0x00000000, 0x02800000, 0x04000000, 0x00000000, 0x00000000, 0x00000004, 0x00000000, 0x00000400}},
			{ref: 0x006d, set: pageSet{0x00000000, 0x00000000, 0x10000000, 0x00040000, 0x00400000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x006e, set: pageSet{0x00200000, 0x00000200, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x2a000000, 0x00000000}},
			{ref: 0x006f, set: pageSet{0x00400000, 0x00000000, 0x00400000, 0x00000000, 0x00000002, 0x40000000, 0x00000000, 0x00400000}},
			{ref: 0x0070, set: pageSet{0x40000000, 0x00001000, 0x00000000, 0x00000000, 0x00000202, 0x02000000, 0x80000000, 0x00020000}},
			{ref: 0x0071, set: pageSet{0x00000020, 0x00000800, 0x00020421, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00400000}},
			{ref: 0x0072, set: pageSet{0x00200000, 0x00000000, 0x00000001, 0x00000000, 0x00000084, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0073, set: pageSet{0x00000000, 0x00004400, 0x00000002, 0x00100000, 0x00000000, 0x00000000, 0x00008200, 0x00000000}},
			{ref: 0x0074, set: pageSet{0x00000000, 0x12000000, 0x00000100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0075, set: pageSet{0x00000020, 0x08100000, 0x000a0400, 0x00000081, 0x00006000, 0x00120000, 0x00000000, 0x00000000}},
			{ref: 0x0076, set: pageSet{0x00000004, 0x08000000, 0x00004000, 0x044000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0077, set: pageSet{0x40001000, 0x00000000, 0x01000001, 0x05000000, 0x00080000, 0x02000000, 0x00000800, 0x00000000}},
			{ref: 0x0078, set: pageSet{0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00002002, 0x01020000, 0x00800000, 0x00000000}},
			{ref: 0x0079, set: pageSet{0x00000040, 0x00004000, 0x01000000, 0x00000004, 0x00020000, 0x00000000, 0x00000010, 0x00000000}},
			{ref: 0x007a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00010000, 0x30000300, 0x00000400}},
			{ref: 0x007b, set: pageSet{0x00000800, 0x02000000, 0x00000000, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007c, set: pageSet{0x00200000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000040c0, 0x00002200, 0x12002000}},
			{ref: 0x007d, set: pageSet{0x00000000, 0x00000020, 0x20000000, 0x00000000, 0x00000200, 0x00080800, 0x1000a000, 0x00000000}},
			{ref: 0x007e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0x00000000, 0x00004280, 0x01000000, 0x00800000, 0x00000008, 0x00000000, 0x00000000}},
			{ref: 0x0080, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x20400000, 0x00000040, 0x00000000}},
			{ref: 0x0081, set: pageSet{0x00800080, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00400020, 0x00000000, 0x00008000}},
			{ref: 0x0082, set: pageSet{0x01000000, 0x00000040, 0x00000000, 0x00400000, 0x00000000, 0x00000440, 0x00000000, 0x00800000}},
			{ref: 0x0083, set: pageSet{0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000}},
			{ref: 0x0084, set: pageSet{0x01000000, 0x00000001, 0x00000000, 0x00020000, 0x00000000, 0x20002000, 0x00000000, 0x00000004}},
			{ref: 0x0085, set: pageSet{0x00000008, 0x00100000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0086, set: pageSet{0x00000004, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000}},
			{ref: 0x0087, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000000, 0x00004000, 0x00000000}},
			{ref: 0x0088, set: pageSet{0x00000010, 0x00002000, 0x40000040, 0x00000000, 0x10000000, 0x00000000, 0x00008080, 0x00000000}},
			{ref: 0x0089, set: pageSet{0x00000000, 0x00000000, 0x00000080, 0x00000000, 0x00100080, 0x000000a0, 0x00000000, 0x00000000}},
			{ref: 0x008a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008b, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x00000000, 0x0001000a, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08002000, 0x00000000}},
			{ref: 0x008d, set: pageSet{0x00000808, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008e, set: pageSet{0x00004000, 0x00002400, 0x00008000, 0x40000000, 0x00000001, 0x00002000, 0x04000000, 0x00040004}},
			{ref: 0x008f, set: pageSet{0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x1c200000, 0x00000000, 0x02000000}},
			{ref: 0x0090, set: pageSet{0x00000000, 0x00080000, 0x00400000, 0x00000002, 0x00000000, 0x00000100, 0x00000000, 0x00000000}},
			{ref: 0x0091, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0092, set: pageSet{0x00004100, 0x00000400, 0x20200010, 0x00004004, 0x00000000, 0x42000000, 0x00000000, 0x00000000}},
			{ref: 0x0093, set: pageSet{0x00000080, 0x00000000, 0x00000121, 0x00000200, 0x000000b0, 0x80002000, 0x00000000, 0x00010000}},
			{ref: 0x0094, set: pageSet{0x00000010, 0x000000c0, 0x08100000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x00000404, 0x00000000, 0x00000000}},
			{ref: 0x0096, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x00000008, 0x00000000, 0x00000000}},
			{ref: 0x0097, set: pageSet{0x00000000, 0x00000002, 0x00020000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00204000}},
			{ref: 0x0098, set: pageSet{0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00800000, 0x00000100, 0x00000001}},
			{ref: 0x0099, set: pageSet{0x10000000, 0x01000000, 0x00002400, 0x00000004, 0x00000000, 0x00000000, 0x00000020, 0x00000002}},
			{ref: 0x009a, set: pageSet{0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x009b, set: pageSet{0x00000000, 0x00002400, 0x00000000, 0x00000000, 0x00004802, 0x00000000, 0x00000000, 0x80022000}},
			{ref: 0x009c, set: pageSet{0x00001004, 0x04208000, 0x20000020, 0x00040000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x009d, set: pageSet{0x00000000, 0x00100000, 0x40010000, 0x00000000, 0x00080000, 0x00000000, 0x00100211, 0x00000000}},
			{ref: 0x009e, set: pageSet{0x00001400, 0x00000000, 0x00000000, 0x00000000, 0x00610000, 0x80008c00, 0x00000000, 0x00000000}},
			{ref: 0x009f, set: pageSet{0x00000100, 0x00000040, 0x00000000, 0x00000004, 0x00004000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0200, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000}},
			{ref: 0x0201, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000210, 0x00000000, 0x00000000}},
			{ref: 0x0203, set: pageSet{0x00000000, 0x00000020, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0207, set: pageSet{0x00004000, 0x00000000, 0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x020c, set: pageSet{0x00000000, 0x00000000, 0x00080002, 0x01000020, 0x00400000, 0x00200000, 0x00008000, 0x00000000}},
			{ref: 0x020d, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0xc0020000, 0x10000000, 0x00000080, 0x00000000, 0x00000000}},
			{ref: 0x020e, set: pageSet{0x00000210, 0x00000000, 0x00001000, 0x04480000, 0x20000000, 0x00000004, 0x00800000, 0x02000000}},
			{ref: 0x020f, set: pageSet{0x00000000, 0x08006000, 0x00001000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000400}},
			{ref: 0x0210, set: pageSet{0x00100000, 0x00000000, 0x10000000, 0x08608000, 0x00000000, 0x00000000, 0x00080002, 0x00000000}},
			{ref: 0x0211, set: pageSet{0x00000000, 0x20000000, 0x00008020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0219, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021a, set: pageSet{0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021c, set: pageSet{0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x021d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000}},
			{ref: 0x0220, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080, 0x00000000}},
			{ref: 0x0221, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x00000000}},
			{ref: 0x022a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00008000, 0x00000000}},
			{ref: 0x022b, set: pageSet{0x00000000, 0x00000000, 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000}},
			{ref: 0x022c, set: pageSet{0x00000000, 0x00000000, 0x00220000, 0x00000004, 0x00000000, 0x00040000, 0x00000004, 0x00000000}},
			{ref: 0x022d, set: pageSet{0x00000000, 0x00000000, 0x00001000, 0x00000080, 0x00002000, 0x00000000, 0x00000000, 0x00004000}},
			{ref: 0x022f, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0232, set: pageSet{0x00000000, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0235, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0236, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000, 0x00000000}},
			{ref: 0x023c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00800000, 0x00000000, 0x00000000}},
			{ref: 0x023e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x023f, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0244, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000}},
			{ref: 0x024d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000400}},
			{ref: 0x024e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080, 0x00000000, 0x00000000}},
			{ref: 0x0251, set: pageSet{0x00000000, 0x00000800, 0x00000100, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0255, set: pageSet{0x00000000, 0x00200000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x025e, set: pageSet{0x00000000, 0x00000000, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0262, set: pageSet{0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0266, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000}},
			{ref: 0x0267, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001000, 0x00000000}},
			{ref: 0x0268, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0269, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04040000}},
			{ref: 0x0272, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0275, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0276, set: pageSet{0x00000000, 0x00000000, 0x00800000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0277, set: pageSet{0x00000000, 0x00200000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0278, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0279, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000}},
			{ref: 0x027a, set: pageSet{0x00000000, 0x40000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x027d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0280, set: pageSet{0x00000000, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000}},
			{ref: 0x0281, set: pageSet{0x00000000, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0282, set: pageSet{0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004}},
			{ref: 0x0283, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0289, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10000001, 0x00000000}},
			{ref: 0x028a, set: pageSet{0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028b, set: pageSet{0x00000000, 0x00000000, 0x00004040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00042400, 0x00000000}},
			{ref: 0x028d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x028e, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080}},
			{ref: 0x0294, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000020}},
			{ref: 0x0297, set: pageSet{0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0298, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020000, 0x00000000}},
			{ref: 0x029a, set: pageSet{0x00000000, 0x00000000, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x029d, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x02a6, set: pageSet{0x00000000, 0x00040000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 278 */
		"zh-sg",
		RuneSet{
			{ref: 0x0002, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000280, 0x00000000}},
			{ref: 0x004e, set: pageSet{0x7f7b7f8b, 0xef553db4, 0xf35dfba8, 0x400b0243, 0x8d3efb40, 0x8c2c7bf7, 0xe3fa6eff, 0xa8ed1d3a}},
			{ref: 0x004f, set: pageSet{0xcf83e602, 0x35558cf5, 0xffabe048, 0xd85992b9, 0x2892ab18, 0x8020d7e9, 0xf583c438, 0x450ae74a}},
			{ref: 0x0050, set: pageSet{0x9714b000, 0x54007762, 0x1420d188, 0xc8c01020, 0x00002121, 0x0c0413a8, 0x04408000, 0x082870c0}},
			{ref: 0x0051, set: pageSet{0x000408c0, 0x80000002, 0x14722b7b, 0x3bfb7924, 0x1ae43327, 0x38ef9835, 0x28029ad1, 0xbf69a813}},
			{ref: 0x0052, set: pageSet{0x2fc665cf, 0xafc96b11, 0x5053340f, 0xa00486a2, 0xe8090106, 0xc00e3f0f, 0x81450a88, 0xc6010010}},
			{ref: 0x0053, set: pageSet{0x26e1a161, 0xce00444b, 0xd4eec7aa, 0x85bbcadf, 0xa5203a74, 0x8840436c, 0x8bd23f06, 0x3befff79}},
			{ref: 0x0054, set: pageSet{0xe8eff75a, 0x5b36fbcb, 0x1bfd0d49, 0x39ee0154, 0x2e75d855, 0xa91abfd8, 0xf6bff3d7, 0xb40c67e0}},
			{ref: 0x0055, set: pageSet{0x081382c2, 0xd08bd49d, 0x1061065a, 0x59e074f2, 0xb3128f9f, 0x6aaa0080, 0xb05e3230, 0x60ac9d7a}},
			{ref: 0x0056, set: pageSet{0xc900d303, 0x8a563098, 0x13907000, 0x18421f14, 0x0008c060, 0x10808008, 0xec900400, 0xe6332817}},
			{ref: 0x0057, set: pageSet{0x90000758, 0x4e09f708, 0xfc83f485, 0x18c8af53, 0x080c187c, 0x01146adf, 0xa734c80c, 0x2710a011}},
			{ref: 0x0058, set: pageSet{0x422228c5, 0x00210413, 0x41123010, 0x40001820, 0xc60c022b, 0x10000300, 0x00220022, 0x02495810}},
			{ref: 0x0059, set: pageSet{0x9670a094, 0x1792eeb0, 0x05f2cb96, 0x23580025, 0x42cc25de, 0x4a04cf38, 0x359f0c40, 0x8a001128}},
			{ref: 0x005a, set: pageSet{0x910a13fa, 0x10560229, 0x04200641, 0x84f00484, 0x0c040000, 0x412c0400, 0x11541206, 0x00020a4b}},
			{ref: 0x005b, set: pageSet{0x00c00200, 0x00940000, 0xbfbb0001, 0x242b167c, 0x7fa89bbb, 0xe3790c7f, 0xe00d10f4, 0x9f014132}},
			{ref: 0x005c, set: pageSet{0x35728652, 0xff1210b4, 0x4223cf27, 0x8602c06b, 0x1fd33106, 0xa1aa3a0c, 0x02040812, 0x08012572}},
			{ref: 0x005d, set: pageSet{0x485040cc, 0x601062d0, 0x29001c80, 0x00109a00, 0x22000004, 0x00800000, 0x68002020, 0x609ecbe6}},
			{ref: 0x005e, set: pageSet{0x3f73916e, 0x398260c0, 0x48301034, 0xbd5c0006, 0xd6fb8cd1, 0x43e820e1, 0x084e0600, 0xc4d00500}},
			{ref: 0x005f, set: pageSet{0x89aa8d1f, 0x1602a6e1, 0x21ed0001, 0x1a8b3656, 0x13a51fb7, 0x30a06502, 0x23c7b278, 0xe9226c93}},
			{ref: 0x0060, set: pageSet{0x3a74e47f, 0x98208fe3, 0x2625280e, 0xbf49bf9c, 0xac543218, 0x1916b949, 0xb5220c60, 0x0659fbc1}},
			{ref: 0x0061, set: pageSet{0x8420e343, 0x800008d9, 0x20225500, 0x00a10184, 0x20104800, 0x40801380, 0x00160d04, 0x80200040}},
			{ref: 0x0062, set: pageSet{0x8de7fd40, 0xe0985436, 0x091e7b8b, 0xd249fec8, 0x8dee0611, 0xba221937, 0x9fdd77f4, 0xf0daf3ec}},
			{ref: 0x0063, set: pageSet{0xec424386, 0x26048d3f, 0xc021fa6c, 0x0cc2628e, 0x0145d785, 0x559977ad, 0x4045e250, 0xa154260b}},
			{ref: 0x0064, set: pageSet{0x58199827, 0xa4103443, 0x411405f2, 0x07002280, 0x426600b4, 0x15a17210, 0x41856025, 0x00000054}},
			{ref: 0x0065, set: pageSet{0x01040201, 0xcb70c820, 0x6a629320, 0x0095184c, 0x9a8b1880, 0x3201aab2, 0x00c4d87a, 0x04c3f3e5}},
			{ref: 0x0066, set: pageSet{0xa238d44d, 0x5072a1a1, 0x84fc980a, 0x44d1c152, 0x20c21094, 0x42104180, 0x3a000000, 0xd29d0240}},
			{ref: 0x0067, set: pageSet{0xa8b12f01, 0x2432bd40, 0xd04bd34d, 0xd0ada723, 0x75a10a92, 0x01e9adac, 0x771f801a, 0xa01b9225}},
			{ref: 0x0068, set: pageSet{0x20cadfa1, 0x738c0602, 0x003b577f, 0x00d00bff, 0x0088806a, 0x0029a1c4, 0x05242a05, 0x16234009}},
			{ref: 0x0069, set: pageSet{0x80056822, 0xa2112011, 0x64900004, 0x13824849, 0x193023d5, 0x08922980, 0x88115402, 0xa0042001}},
			{ref: 0x006a, set: pageSet{0x81800400, 0x60228502, 0x0b010090, 0x12020022, 0x00834011, 0x00001a01, 0x00000000, 0x00000000}},
			{ref: 0x006b, set: pageSet{0x00000000, 0x4684009f, 0x020012c8, 0x1a0004fc, 0x0c4c2ede, 0x80b80402, 0x0afca826, 0x22288c02}},
			{ref: 0x006c, set: pageSet{0x8f7ba0e0, 0x2135c7d6, 0xf8b106c7, 0x62550713, 0x8a19936e, 0xfb0e6efa, 0x48f91630, 0x7debcd2f}},
			{ref: 0x006d, set: pageSet{0x4e845892, 0x7a2e4ca0, 0x561eedea, 0x1190c649, 0xe83a5324, 0x8124cfdb, 0x634218f1, 0x1a8a5853}},
			{ref: 0x006e, set: pageSet{0x24d37420, 0x0514aa3b, 0x89586018, 0xc0004800, 0x91018268, 0x2cd684a4, 0xc4ba8886, 0x02100377}},
			{ref: 0x006f, set: pageSet{0x00388244, 0x404aae11, 0x510028c0, 0x15146044, 0x10007310, 0x02480082, 0x40060205, 0x0000c003}},
			{ref: 0x0070, set: pageSet{0x0c020000, 0x02200008, 0x40009000, 0xd161b800, 0x32744621, 0x3b8af800, 0x8b00050f, 0x2280bbd0}},
			{ref: 0x0071, set: pageSet{0x07690600, 0x00438040, 0x50005420, 0x250c41d0, 0x83108410, 0x02281101, 0x00304008, 0x020040a1}},
			{ref: 0x0072, set: pageSet{0x20000040, 0xabe31500, 0xaa443180, 0xc624c2c6, 0x8004ac13, 0x03d1b000, 0x4285611e, 0x1d9ff303}},
			{ref: 0x0073, set: pageSet{0x78e8440a, 0xc3925e26, 0x00852000, 0x4000b001, 0x88424a90, 0x0c8dca04, 0x4203a705, 0x000422a1}},
			{ref: 0x0074, set: pageSet{0x0c018668, 0x10795564, 0xdea00002, 0x40c12000, 0x5001488b, 0x04000380, 0x50040000, 0x80d0c05d}},
			{ref: 0x0075, set: pageSet{0x970aa010, 0x4dafbb20, 0x1e10d921, 0x83140460, 0xa6d68848, 0x733fd83b, 0x497427bc, 0x92130ddc}},
			{ref: 0x0076, set: pageSet{0x8ba1142b, 0xd1392e75, 0x50503009, 0x69008808, 0x024a49d4, 0x80164010, 0x89d7e564, 0x5316c020}},
			{ref: 0x0077, set: pageSet{0x86002b92, 0x15e0a345, 0x0c03008b, 0xe200196e, 0x80067031, 0xa82916a5, 0x18802000, 0xe1487aac}},
			{ref: 0x0078, set: pageSet{0xb5d63207, 0x5f9132e8, 0x20e550a1, 0x10807c00, 0x9d8a7280, 0x421f00aa, 0x02310e22, 0x04941100}},
			{ref: 0x0079, set: pageSet{0x40080022, 0x5c100010, 0xfcc80343, 0x0580a1a5, 0x04008433, 0x6e080080, 0x81262a4b, 0x2901aad8}},
			{ref: 0x007a, set: pageSet{0x4490684d, 0xba880009, 0x00820040, 0x87d10000, 0xb1e6215b, 0x80083161, 0xc2400800, 0xa600a069}},
			{ref: 0x007b, set: pageSet{0x4a328d58, 0x550a5d71, 0x2d579aa0, 0x4aa64005, 0x30b12021, 0x01123fc6, 0x260a10c2, 0x50824462}},
			{ref: 0x007c, set: pageSet{0x80409880, 0x810004c0, 0x00002003, 0x38180000, 0xf1a60200, 0x720e4434, 0x92e035a2, 0x09008101}},
			{ref: 0x007d, set: pageSet{0x00000400, 0x00008885, 0x00000000, 0x00804000, 0x00000000, 0x00004040, 0x00000000, 0x00000000}},
			{ref: 0x007e, set: pageSet{0x00000000, 0x08000000, 0x00000082, 0x00000000, 0x88000004, 0xe7efbfff, 0xffbfffff, 0xfdffefef}},
			{ref: 0x007f, set: pageSet{0xbffefbff, 0x057fffff, 0x85b30034, 0x42164706, 0xe4105402, 0xb3058092, 0x81305422, 0x180b4263}},
			{ref: 0x0080, set: pageSet{0x13f5387b, 0xa9ea07e5, 0x05143c4c, 0x80020600, 0xbd481ad9, 0xf496ee37, 0x7ec0705f, 0x355fbfb2}},
			{ref: 0x0081, set: pageSet{0x455fe644, 0x41469000, 0x063b1d40, 0xfe1362a1, 0x39028505, 0x0c080548, 0x0000144f, 0x58183488}},
			{ref: 0x0082, set: pageSet{0xd8153077, 0x4bfbbd0e, 0x85008a90, 0xe61dc100, 0xb386ed14, 0x639bff72, 0xd9befd92, 0x0a92887b}},
			{ref: 0x0083, set: pageSet{0x1cb2d3fe, 0x177ab980, 0xdc1782c9, 0x3980fffb, 0x590c4260, 0x37df0f01, 0xb15094a3, 0x23070623}},
			{ref: 0x0084, set: pageSet{0x3102f85a, 0x310201f0, 0x1e820040, 0x056a3a0a, 0x12805b84, 0xa7148002, 0xa04b2612, 0x90011069}},
			{ref: 0x0085, set: pageSet{0x848a1000, 0x3f801802, 0x42400708, 0x4e140110, 0x180080b0, 0x0281c510, 0x10298202, 0x88000210}},
			{ref: 0x0086, set: pageSet{0x00420020, 0x11000280, 0x4413e000, 0xfe025804, 0x30283c07, 0x04739798, 0xcb13ced1, 0x431f6210}},
			{ref: 0x0087, set: pageSet{0x55ac278d, 0xc892422e, 0x02885380, 0x78514039, 0x8088292c, 0x2428b900, 0x080e0c41, 0x42004421}},
			{ref: 0x0088, set: pageSet{0x08680408, 0x12040006, 0x02903031, 0xe0855b3e, 0x10442936, 0x10822814, 0x83344266, 0x531b013c}},
			{ref: 0x0089, set: pageSet{0x0e0d0404, 0x00510c22, 0xc0000012, 0x88000040, 0x0000004a, 0x00000000, 0x5447dff6, 0x00088868}},
			{ref: 0x008a, set: pageSet{0x00000081, 0x40000000, 0x00000100, 0x02000000, 0x00080600, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008b, set: pageSet{0x00000080, 0x00000040, 0x00000000, 0x00001040, 0x00000000, 0xf7fdefff, 0xfffeff7f, 0xfffffbff}},
			{ref: 0x008c, set: pageSet{0xbffffdff, 0x00ffffff, 0x042012c2, 0x07080c06, 0x01101624, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008d, set: pageSet{0xe0000000, 0xfffffffe, 0x7f79ffff, 0x00f928df, 0x80120c32, 0xd53a0008, 0xecc2d858, 0x2fa89d18}},
			{ref: 0x008e, set: pageSet{0xe0109620, 0x2622d60c, 0x02060f97, 0x9055b240, 0x501180a2, 0x04049800, 0x00004000, 0x00000000}},
			{ref: 0x008f, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0xfffffbc0, 0xdffbeffe, 0x62430b08, 0xfb3b41b6, 0x23896f74}},
			{ref: 0x0090, set: pageSet{0xecd7ae7f, 0x5960e047, 0x098fa096, 0xa030612c, 0x2aaa090d, 0x4f7bd44e, 0x388bc4b2, 0x6110a9c6}},
			{ref: 0x0091, set: pageSet{0x42000014, 0x0202800c, 0x6485fe48, 0xe3f7d63e, 0x0c073aa0, 0x0430e40c, 0x1002f680, 0x00000000}},
			{ref: 0x0092, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00004000, 0x00004000, 0x00000100, 0x00000000}},
			{ref: 0x0093, set: pageSet{0x00000000, 0x40000000, 0x00000000, 0x00000400, 0x00008000, 0x00000000, 0x00400400, 0x00000000}},
			{ref: 0x0094, set: pageSet{0x00000000, 0x40000000, 0x00000000, 0x00000800, 0xfebdffe0, 0xffffffff, 0xfbe77f7f, 0xf7ffffbf}},
			{ref: 0x0095, set: pageSet{0xefffffff, 0xdff7ff7e, 0xfbdff6f7, 0x804fbffe, 0x00000000, 0x00000000, 0x00000000, 0x7fffef00}},
			{ref: 0x0096, set: pageSet{0xb6f7ff7f, 0xb87e4406, 0x88313bf5, 0x00f41796, 0x1391a960, 0x72490080, 0x0024f2f3, 0x42c88701}},
			{ref: 0x0097, set: pageSet{0x5048e3d3, 0x43052400, 0x4a4c0000, 0x10580227, 0x01162820, 0x0014a809, 0x00000000, 0x00683ec0}},
			{ref: 0x0098, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0xffe00000, 0xfddbb7ff, 0x000000f7, 0xc72e4000, 0x00000180}},
			{ref: 0x0099, set: pageSet{0x00012000, 0x00004000, 0x00300000, 0xb4f7ffa8, 0x03ffadf3, 0x00000120, 0x00000000, 0x00000000}},
			{ref: 0x009a, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0xfffbf000, 0xfdcf9df7, 0x15c301bf, 0x810a1827, 0x0a00a842}},
			{ref: 0x009b, set: pageSet{0x80088108, 0x18048008, 0x0012a3be, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x009c, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x90000000, 0xdc3769e6, 0x3dff6bff, 0xf3f9fcf8, 0x00000004}},
			{ref: 0x009e, set: pageSet{0x80000000, 0xe7eebf6f, 0x5da2dffe, 0xc00b3fd8, 0xa00c0984, 0x69100040, 0xb912e210, 0x5a0086a5}},
			{ref: 0x009f, set: pageSet{0x02896800, 0x6a809005, 0x00030010, 0x80000000, 0x8e001ff9, 0x00000001, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 279 */
		"zh-tw",
		RuneSet{
			{ref: 0x004e, set: pageSet{0xc373ff8b, 0x1b0f6840, 0xf34ce9ac, 0xc0080200, 0xca3e795c, 0x06487976, 0xf7f02fdf, 0xa8ff033a}},
			{ref: 0x004f, set: pageSet{0x233fef37, 0xfd59b004, 0xfffff3ca, 0xfff9de9f, 0x7df7abff, 0x8eecc000, 0xffdbeebf, 0x45fad003}},
			{ref: 0x0050, set: pageSet{0xdffefae1, 0x10abbfef, 0xfcaaffeb, 0x24fdef3f, 0x7f7678ad, 0xedfff00c, 0x2cfacff6, 0xeb6bf7f9}},
			{ref: 0x0051, set: pageSet{0x95bf1ffd, 0xbfbf6677, 0xfeb43bfb, 0x11e27bae, 0x41bea681, 0x72c31435, 0x71917d70, 0x276b0003}},
			{ref: 0x0052, set: pageSet{0x70cf57cb, 0x0def4732, 0xfc747eda, 0xbdb4fe06, 0x8bca3f9f, 0x58007e49, 0xebec228f, 0xddbb8a5c}},
			{ref: 0x0053, set: pageSet{0xb6e7ef60, 0xf293a40f, 0x549e37bb, 0x9bafd04b, 0xf7d4c414, 0x0a1430b0, 0x88d02f08, 0x192fff7e}},
			{ref: 0x0054, set: pageSet{0xfb07ffda, 0x7beb7ff1, 0x0010c5ef, 0xfdff99ff, 0x056779d7, 0xfdcbffe7, 0x4040c3ff, 0xbd8e6ff7}},
			{ref: 0x0055, set: pageSet{0x0497dffa, 0x5bfff4c0, 0xd0e7ed7b, 0xf8e0047e, 0xb73eff9f, 0x882e7dfe, 0xbe7ffffd, 0xf6c483fe}},
			{ref: 0x0056, set: pageSet{0xb8fdf357, 0xef7dd680, 0x47885767, 0xc3dfff7d, 0x37a9f0ff, 0x70fc7de0, 0xec9a3f6f, 0x86814cb3}},
			{ref: 0x0057, set: pageSet{0xdd5c3f9e, 0x4819f70d, 0x0007fea3, 0x38ffaf56, 0xefb8980d, 0xb760403d, 0x9035d8ce, 0x3fff72bf}},
			{ref: 0x0058, set: pageSet{0x7a117ff7, 0xabfff7bb, 0x6fbeff00, 0xfe72a93c, 0xf11bcfef, 0xf40adb6b, 0xef7ec3e6, 0xf6109b9c}},
			{ref: 0x0059, set: pageSet{0x16f4f048, 0x5182feb5, 0x15bbc7b1, 0xfbdf6e87, 0x63cde43f, 0x7e7ec1ff, 0x7d5ffdeb, 0xfcfe777b}},
			{ref: 0x005a, set: pageSet{0xdbea960b, 0x53e86229, 0xfdef37df, 0xbd8136f5, 0xfcbddc18, 0xffffd2e4, 0xffe03fd7, 0xabf87f6f}},
			{ref: 0x005b, set: pageSet{0x6ed99bae, 0xf115f5fb, 0xbdfb79a9, 0xadaf5a3c, 0x1facdbba, 0x837971fc, 0xc35f7cf7, 0x0567dfff}},
			{ref: 0x005c, set: pageSet{0x8467ff9a, 0xdf8b1534, 0x3373f9f3, 0x5e1af7bd, 0xa03fbf40, 0x01ebffff, 0xcfdddfc0, 0xabd37500}},
			{ref: 0x005d, set: pageSet{0xeed6f8c3, 0xb7ff43fd, 0x42275eaf, 0xf6869bac, 0xf6bc27d7, 0x35b7f787, 0xe176aacd, 0xe29f49e7}},
			{ref: 0x005e, set: pageSet{0xaff2545c, 0x61d82b3f, 0xbbb8fc3b, 0x7b7dffcf, 0x1ce0bf95, 0x43ff7dfd, 0xfffe5ff6, 0xc4ced3ef}},
			{ref: 0x005f, set: pageSet{0xadbc8db6, 0x11eb63dc, 0x23d0df59, 0xf3dbbeb4, 0xdbc71fe7, 0xfae4ff63, 0x63f7b22b, 0xadbaed3b}},
			{ref: 0x0060, set: pageSet{0x7efffe01, 0x02bcfff7, 0xef3932ff, 0x8005fffc, 0xbcf577fb, 0xfff7010d, 0xbf3afffb, 0xdfff0057}},
			{ref: 0x0061, set: pageSet{0xbd7def7b, 0xc8d4db88, 0xed7cfff3, 0x56ff5dee, 0xac5f7e0d, 0xd57fff96, 0xc1403fee, 0xffe76ff9}},
			{ref: 0x0062, set: pageSet{0x8e77779b, 0xe45d6ebf, 0x5f1f6fcf, 0xfedfe07f, 0x01fed7db, 0xfb7bff00, 0x1fdfffd4, 0xfffff800}},
			{ref: 0x0063, set: pageSet{0x007bfb8f, 0x7f5cbf00, 0x07f3ffff, 0x3de7eba0, 0xfbd7f7bf, 0x6003ffbf, 0xbfedfffd, 0x027fefbb}},
			{ref: 0x0064, set: pageSet{0xddfdfe40, 0xe2f9fdff, 0xfb1f680b, 0xaffdfbe3, 0xf7ed9fa4, 0xf80f7a7d, 0x0fd5eebe, 0xfd9fbb5d}},
			{ref: 0x0065, set: pageSet{0x3bf9f2db, 0xebccfe7f, 0x73fa876a, 0x9ffc95fc, 0xfaf7109f, 0xbbcdddb7, 0xeccdf87e, 0x3c3ff366}},
			{ref: 0x0066, set: pageSet{0xb03ffffd, 0x067ee9f7, 0xfe0696ae, 0x5fd7d576, 0xa3f33fd1, 0x6fb7cf07, 0x7f449fd1, 0xd3dd7b59}},
			{ref: 0x0067, set: pageSet{0xa9bdaf3b, 0xff3a7dcf, 0xf6ebfbe0, 0xffffb401, 0xb7bf7afa, 0x0ffdc000, 0xff1fff7f, 0x95fffefc}},
			{ref: 0x0068, set: pageSet{0xb5dc0000, 0x3f3eef63, 0x001bfb7f, 0xfbf6e800, 0xb8df9eef, 0x003fff9f, 0xf5ff7bd0, 0x3fffdfdb}},
			{ref: 0x0069, set: pageSet{0x00bffdf0, 0xbbbd8420, 0xffdedf37, 0x0ff3ff6d, 0x5efb604c, 0xfafbfffb, 0x0219fe5e, 0xf9de79f4}},
			{ref: 0x006a, set: pageSet{0xebfaa7f7, 0xff3401eb, 0xef73ebd3, 0xc040afd7, 0xdcff72bb, 0x2fd8f17f, 0xfe0bb8ec, 0x1f0bdda3}},
			{ref: 0x006b, set: pageSet{0x47cf8f1d, 0xffdeb12b, 0xda737fee, 0xcbc424ff, 0xcbf2f75d, 0xb4edecfd, 0x4dddbff9, 0xfb8d99dd}},
			{ref: 0x006c, set: pageSet{0xaf7bbb7f, 0xc959ddfb, 0xfab5fc4f, 0x6d5fafe3, 0x3f7dffff, 0xffdb7800, 0x7effb6ff, 0x022ffbaf}},
			{ref: 0x006d, set: pageSet{0xefc7ff9b, 0xffffffa5, 0xc7000007, 0xfff1f7ff, 0x01bf7ffd, 0xfdbcdc00, 0xffffbff5, 0x3effff7f}},
			{ref: 0x006e, set: pageSet{0xbe000029, 0xff7ff9ff, 0xfd7e6efb, 0x039ecbff, 0xfbdde300, 0xf6dfccff, 0x117fffff, 0xfbf6f800}},
			{ref: 0x006f, set: pageSet{0xd73ce7ef, 0xdfeffeef, 0xedbfc00b, 0xfdcdfedf, 0x40fd7bf5, 0xb75fffff, 0xf930ffdf, 0xdc97fbdf}},
			{ref: 0x0070, set: pageSet{0xbff2fef3, 0xdfbf8fdf, 0xede6177f, 0x35530f7f, 0x877e447c, 0x45bbfa12, 0x779eede0, 0xbfd98017}},
			{ref: 0x0071, set: pageSet{0xde897e55, 0x0447c16f, 0xf75d7ade, 0x290557ff, 0xfe9586f7, 0xf32f97b3, 0x9f75cfff, 0xfb1771f7}},
			{ref: 0x0072, set: pageSet{0xee1934ee, 0xef6137cc, 0xef4c9fd6, 0xfbddd68f, 0x6def7b73, 0xa431d7fe, 0x97d75e7f, 0xffd80f5b}},
			{ref: 0x0073, set: pageSet{0x7bce9d83, 0xdcff22ec, 0xef87763d, 0xfdeddfe7, 0xa0fc4fff, 0xdbfc3b77, 0x7fdc3ded, 0xf5706fa9}},
			{ref: 0x0074, set: pageSet{0x2c403ffb, 0x847fff7f, 0xdeb7ec57, 0xf22fe69c, 0xd5b50feb, 0xede7afeb, 0xfff08c2f, 0xe8f0537f}},
			{ref: 0x0075, set: pageSet{0xb5ffb99d, 0xe78fff66, 0xbe10d981, 0xe3c19c7c, 0x27339cd1, 0xff6d0cbc, 0xefb7fcb7, 0xffffa0df}},
			{ref: 0x0076, set: pageSet{0xfe7bbf0b, 0x353fa3ff, 0x97cd13cc, 0xfb277637, 0x7e6ccfd6, 0xed31ec50, 0xfc1c677c, 0x5fbff6fa}},
			{ref: 0x0077, set: pageSet{0xae2f0fba, 0x7ffea3ad, 0xde74fcf0, 0xf200ffef, 0xfea2fbbf, 0xbcff3daf, 0x5fb9f694, 0x3f8ff3ad}},
			{ref: 0x0078, set: pageSet{0xa01ff26c, 0x01bfffef, 0x70057728, 0xda03ff35, 0xc7fad2f9, 0x5c1d3fbf, 0xec33ff3a, 0xfe9cb7af}},
			{ref: 0x0079, set: pageSet{0x7a9f5236, 0xe722bffa, 0xfcff9ff7, 0xb61d2fbb, 0x1dfded06, 0xefdf7dd7, 0xf166eb23, 0x0dc07ed9}},
			{ref: 0x007a, set: pageSet{0xdfbf3d3d, 0xba83c945, 0x9dd07dd1, 0xcf737b87, 0xc3f59ff3, 0xc5fedf0d, 0x83020cb3, 0xaec0e879}},
			{ref: 0x007b, set: pageSet{0x6f0fc773, 0x093ffd7d, 0x0157fff1, 0x01ff62fb, 0x3bf3fdb4, 0x43b2b013, 0xff305ed3, 0xeb9f0fff}},
			{ref: 0x007c, set: pageSet{0xf203feef, 0xfb893fef, 0x9e9937a9, 0xa72cdef9, 0xc1f63733, 0xfe3e812e, 0xf2f75d20, 0x69d7d585}},
			{ref: 0x007d, set: pageSet{0xffffffff, 0xff6fdb07, 0xd97fc4ff, 0xbe0fefce, 0xf05ef17b, 0xffb7f6cf, 0xef845ef7, 0x0edfd7cb}},
			{ref: 0x007e, set: pageSet{0xfcffff08, 0xffffee3f, 0xd7ff13ff, 0x7ffdaf0f, 0x1ffabdc7, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x007f, set: pageSet{0x00000000, 0xe7400000, 0xf933bd38, 0xfeed7feb, 0x7c767fe8, 0xffefb3f7, 0xd8b7feaf, 0xfbbfff6f}},
			{ref: 0x0080, set: pageSet{0xdbf7f8fb, 0xe2f91752, 0x754785c8, 0xe3ef9090, 0x3f6d9ef4, 0x0536ee2e, 0x7ff3f7bc, 0x7f3fa07b}},
			{ref: 0x0081, set: pageSet{0xeb600567, 0x6601babe, 0x583ffcd8, 0x87dfcaf7, 0xffa0bfcd, 0xfebf5bcd, 0xefa7b6fd, 0xdf9c77ef}},
			{ref: 0x0082, set: pageSet{0xf8773fb7, 0xb7fc9d27, 0xdfefcab5, 0xf1b6fb5a, 0xef1fec39, 0x7ffbfbbf, 0xdafe000d, 0x4e7fbdfb}},
			{ref: 0x0083, set: pageSet{0x5ac033ff, 0x9ffebff5, 0x005fffbf, 0xfdf80000, 0x6ffdffca, 0xa001cffd, 0xfbf2dfff, 0xff7fdfbf}},
			{ref: 0x0084, set: pageSet{0x080ffeda, 0xbfffba08, 0xeed77afd, 0x67f9fbeb, 0xff93e044, 0x9f57df97, 0x08dffef7, 0xfedfdf80}},
			{ref: 0x0085, set: pageSet{0xf7feffc5, 0x6803fffb, 0x6bfa67fb, 0x5fe27fff, 0xff73ffff, 0xe7fb87df, 0xf7a7ebfd, 0xefc7bf7e}},
			{ref: 0x0086, set: pageSet{0xdf821ef3, 0xdf7e76ff, 0xda7d79c9, 0x1e9befbe, 0x77fb7ce0, 0xfffb87be, 0xffdb1bff, 0x4fe03f5c}},
			{ref: 0x0087, set: pageSet{0x5f0e7fff, 0xddbf77ff, 0xfffff04f, 0x0ff8ffff, 0xfddfa3be, 0xfffdfc1c, 0xfb9e1f7d, 0xdedcbdff}},
			{ref: 0x0088, set: pageSet{0xbafb3f6f, 0xfbefdf7f, 0x2eec7d1b, 0xf2f7af8e, 0xcfee7b0f, 0x77c61d96, 0xfff57e07, 0x7fdfd982}},
			{ref: 0x0089, set: pageSet{0xc7ff5ee6, 0x79effeee, 0xffcf9a56, 0xde5efe5f, 0xf9e8896e, 0xe6c4f45e, 0xbe7c0001, 0xdddf3b7f}},
			{ref: 0x008a, set: pageSet{0xe9efd59d, 0xde5334ac, 0x4bf7f573, 0x9eff7b4f, 0x476eb8fe, 0xff450dfb, 0xfbfeabfd, 0xddffe9d7}},
			{ref: 0x008b, set: pageSet{0x7fffedf7, 0x7eebddfd, 0xb7ffcfe7, 0xef91bde9, 0xd77c5d75, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x008c, set: pageSet{0x00000000, 0xfa800000, 0xb4f1ffee, 0x2fefbf76, 0x77bfb677, 0xfffd9fbf, 0xf6ae95bf, 0x7f3b75ff}},
			{ref: 0x008d, set: pageSet{0x0af9a7f5, 0x00000000, 0x00000000, 0x2bddfbd0, 0x9a7ff633, 0xd6fcfdab, 0xbfebf9e6, 0xf41fdfdf}},
			{ref: 0x008e, set: pageSet{0xffffa6fd, 0xf37b4aff, 0xfef97fb7, 0x1d5cb6ff, 0xe5ff7ff6, 0x24041f7b, 0xf99ebe05, 0xdff2dbe3}},
			{ref: 0x008f, set: pageSet{0xfdff6fef, 0xcbfcd679, 0xefffebfd, 0x0000001f, 0x98000000, 0x8017e148, 0x00fe6a74, 0xfdf16d7f}},
			{ref: 0x0090, set: pageSet{0xfef3b87f, 0xf176e01f, 0x7b3fee96, 0xfffdeb8d, 0xcbb3adff, 0xe17f84ef, 0xbff04daa, 0xfe3fbf3f}},
			{ref: 0x0091, set: pageSet{0xffd7ebff, 0xcf7fffdf, 0x85edfffb, 0x07bcd73f, 0xfe0faeff, 0x76bffdaf, 0x37bbfaef, 0xa3ba7fdc}},
			{ref: 0x0092, set: pageSet{0x56f7b6ff, 0xe7df60f8, 0x4cdfff61, 0xff45b0fb, 0x3ffa7ded, 0x18fc1fff, 0xe3afffff, 0xdf83c7d3}},
			{ref: 0x0093, set: pageSet{0xef7dfb57, 0x1378efff, 0x5ff7fec0, 0x5ee334bb, 0xeff6f70d, 0x00bfd7fe, 0xf7f7f59d, 0xffe051de}},
			{ref: 0x0094, set: pageSet{0x037ffec9, 0xbfef5f01, 0x60a79ff1, 0xf1ffef1d, 0x0000000f, 0x00000000, 0x00000000, 0x00000000}},
			{ref: 0x0095, set: pageSet{0x00000000, 0x00000000, 0x00000000, 0x3c800000, 0xd91ffb4d, 0xfee37b3a, 0xdc7f3fe9, 0x0000003f}},
			{ref: 0x0096, set: pageSet{0x50000000, 0xbe07f51f, 0xf91bfc1d, 0x71ffbc1e, 0x5bbe6ff9, 0x9b1b5796, 0xfffc7fff, 0xafe7872e}},
			{ref: 0x0097, set: pageSet{0xf34febf5, 0xe725dffd, 0x5d440bdc, 0xfddd5747, 0x7790ed3f, 0x8ac87d7f, 0xf3f9fafa, 0xef4b202a}},
			{ref: 0x0098, set: pageSet{0x79cff5ff, 0x0ba5abd3, 0xfb8ff77a, 0x001f8ebd, 0x00000000, 0xfd4ef300, 0x88001a57, 0x7654aeac}},
			{ref: 0x0099, set: pageSet{0xcdff17ad, 0xf42fffb2, 0xdbff5baa, 0x00000002, 0x73c00000, 0x2e3ff9ea, 0xbbfffa8e, 0xffd376bc}},
			{ref: 0x009a, set: pageSet{0x7e72eefe, 0xe7f77ebd, 0xcefdf77f, 0x00000ff5, 0x00000000, 0xdb9ba900, 0x917fa4c7, 0x7ecef8ca}},
			{ref: 0x009b, set: pageSet{0xc7e77d7a, 0xdcaecbbd, 0x8f76fd7e, 0x7cf391d3, 0x4c2f01e5, 0xa360ed77, 0x5ef807db, 0x21811df7}},
			{ref: 0x009c, set: pageSet{0x309c6be0, 0xfade3b3a, 0xc3f57f53, 0x07ba61cd, 0x00000000, 0x00000000, 0x00000000, 0xbefe26e0}},
			{ref: 0x009d, set: pageSet{0xebb503f9, 0xe9cbe36d, 0xbfde9c2f, 0xabbf9f83, 0xffd51ff7, 0xdffeb7df, 0xffeffdae, 0xeffdfb7e}},
			{ref: 0x009e, set: pageSet{0x6ebfaaff, 0x00000000, 0x00000000, 0xb6200000, 0xbe9e7fcd, 0x58f162b3, 0xfd7bf10d, 0xbefde9f1}},
			{ref: 0x009f, set: pageSet{0x5f6dc6c3, 0x69ffff3d, 0xfbf4ffcf, 0x4ff7dcfb, 0x11372000, 0x00000015, 0x00000000, 0x00000000}},
			{ref: 0x00fa, set: pageSet{0x00003000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
	{ /** index: 280 */
		"zu",
		RuneSet{
			{ref: 0x0000, set: pageSet{0x00000000, 0x00000000, 0x07fffffe, 0x07fffffe, 0x00000000, 0x00000000, 0x00000000, 0x00000000}},
		},
	},
}
