# Contributing
We welcome contributions! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features

## We Develop with GitHub
We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [GitHub Flow](https://docs.github.com/en/get-started/quickstart/github-flow), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (we use [GitHub Flow](https://docs.github.com/en/get-started/quickstart/github-flow)). We actively welcome your pull requests:

1. Fork the repository and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. Ensure the test suite passes.
4. Ensure linters are happy, a CI pipeline will be run for your changes.
5. Submit that pull request!

## Report bugs using GitHub's [issues](https://github.com/boeing/config-file-validator/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/Boeing/config-file-validator/issues/new);

## Functional Testing
Until we can automate the functional testing, you must run through the [functional testing](./functional_test.md) procedures before submitting your PR for review.
