# v0.17 - Spec-tacular Citizen

![](./v0.17/banner.png)

[Specs] are now first-class citizens in carapace. They are integrated on root level and should behave similar to the existing completers (`carapace [spec.name] <TAB>`).

## List

Completers based on [Specs] are highlighted in shells that support colors (details: `carapace --list=json`):

![](./v0.17/list.png)

## Bridge

Using [Specs] for [bridging](../spec/bridge.html) is from now on the recommended approach.
As these are auto-loaded with `carapace _carapace` and provide support for embedded completion like `sudo [spec.name] <TAB>`.

Existing completers with the same name will also be overridden.
E.g. `kubectl` (which is currently a bit outdated) can be configured to use the official completer:

```yaml
# ${UserConfigDir}/carapace/specs/kubectl.yaml
name: kubectl
description: kubectl controls the Kubernetes cluster manager
completion:
  positionalany: ["$_bridge.Cobra(kubectl)"]
```

> Note that bridging adds a slight overhead (~7-9ms?) for each invocation and is limited to supported frameworks / commands.


## Plugin

Taking this one step further plugin completion like `cargo-[plugin]`, `gh-[plugin]`, `git-[plugin]` can now also be defined by [Specs].

E.g. the [gh-repo-collab](https://github.com/mislav/gh-repo-collab) extension for [github-cli](https://cli.github.com/):
```yaml
# ${UserConfigDir}/carapace/specs/gh-repo-collab.yaml
name: gh-repo-collab
description: manage repository collaborators
commands:
  -
    name: list
    completion:
      positional:
        - ["$_tools.gh.OwnerRepositories"]
  -
    name: add
    flags:
      --permission=: set permission
    completion:
      flag:
        permission: ["pull", "triage", "push", "maintain", "admin\t\tred"]
      positional:
        - ["$_tools.gh.OwnerRepositories"]
        - ["$_tools.gh.Users"]
  -
    name: remove
    completion:
      positional:
        - ["$_tools.gh.OwnerRepositories"]
        - ["$_tools.gh.Users"]
```

![](./v0.17/plugin.png)

## Nushell

With https://github.com/nushell/nushell/pull/6652 (upcoming [v0.70.0](https://github.com/nushell/nushell/milestone/11?closed=1)) the [nushell] integration is now working on positional arguments.
The recommended configuration is equivalent to the example configuration in `config.nu`:

```nu
let carapace_completer = {|spans| 
  carapace $spans.0 nushell $spans | from json
}

let-env config = {
  external_completer: $carapace_completer
}
```

> Be sure to remove the `module completions` example so that it won't override the carapace completion

[nushell]:https://www.nushell.sh/
[Specs]:https://github.com/carapace-sh/carapace-spec
