// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribestreaming

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/transcribestreaming/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpGetMedicalScribeStream struct {
}

func (*validateOpGetMedicalScribeStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetMedicalScribeStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetMedicalScribeStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetMedicalScribeStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartCallAnalyticsStreamTranscription struct {
}

func (*validateOpStartCallAnalyticsStreamTranscription) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartCallAnalyticsStreamTranscription) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartCallAnalyticsStreamTranscriptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartCallAnalyticsStreamTranscriptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartMedicalScribeStream struct {
}

func (*validateOpStartMedicalScribeStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartMedicalScribeStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartMedicalScribeStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartMedicalScribeStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartMedicalStreamTranscription struct {
}

func (*validateOpStartMedicalStreamTranscription) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartMedicalStreamTranscription) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartMedicalStreamTranscriptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartMedicalStreamTranscriptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartStreamTranscription struct {
}

func (*validateOpStartStreamTranscription) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartStreamTranscription) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartStreamTranscriptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartStreamTranscriptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpGetMedicalScribeStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetMedicalScribeStream{}, middleware.After)
}

func addOpStartCallAnalyticsStreamTranscriptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartCallAnalyticsStreamTranscription{}, middleware.After)
}

func addOpStartMedicalScribeStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartMedicalScribeStream{}, middleware.After)
}

func addOpStartMedicalStreamTranscriptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartMedicalStreamTranscription{}, middleware.After)
}

func addOpStartStreamTranscriptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartStreamTranscription{}, middleware.After)
}

func validateAudioStream(v types.AudioStream) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AudioStream"}
	switch uv := v.(type) {
	case *types.AudioStreamMemberConfigurationEvent:
		if err := validateConfigurationEvent(&uv.Value); err != nil {
			invalidParams.AddNested("[ConfigurationEvent]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateChannelDefinition(v *types.ChannelDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ChannelDefinition"}
	if len(v.ParticipantRole) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ParticipantRole"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateChannelDefinitions(v []types.ChannelDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ChannelDefinitions"}
	for i := range v {
		if err := validateChannelDefinition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClinicalNoteGenerationSettings(v *types.ClinicalNoteGenerationSettings) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClinicalNoteGenerationSettings"}
	if v.OutputBucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputBucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConfigurationEvent(v *types.ConfigurationEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConfigurationEvent"}
	if v.ChannelDefinitions != nil {
		if err := validateChannelDefinitions(v.ChannelDefinitions); err != nil {
			invalidParams.AddNested("ChannelDefinitions", err.(smithy.InvalidParamsError))
		}
	}
	if v.PostCallAnalyticsSettings != nil {
		if err := validatePostCallAnalyticsSettings(v.PostCallAnalyticsSettings); err != nil {
			invalidParams.AddNested("PostCallAnalyticsSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMedicalScribeAudioEvent(v *types.MedicalScribeAudioEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MedicalScribeAudioEvent"}
	if v.AudioChunk == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudioChunk"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMedicalScribeChannelDefinition(v *types.MedicalScribeChannelDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MedicalScribeChannelDefinition"}
	if len(v.ParticipantRole) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ParticipantRole"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMedicalScribeChannelDefinitions(v []types.MedicalScribeChannelDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MedicalScribeChannelDefinitions"}
	for i := range v {
		if err := validateMedicalScribeChannelDefinition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMedicalScribeConfigurationEvent(v *types.MedicalScribeConfigurationEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MedicalScribeConfigurationEvent"}
	if v.ResourceAccessRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceAccessRoleArn"))
	}
	if v.ChannelDefinitions != nil {
		if err := validateMedicalScribeChannelDefinitions(v.ChannelDefinitions); err != nil {
			invalidParams.AddNested("ChannelDefinitions", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptionSettings != nil {
		if err := validateMedicalScribeEncryptionSettings(v.EncryptionSettings); err != nil {
			invalidParams.AddNested("EncryptionSettings", err.(smithy.InvalidParamsError))
		}
	}
	if v.PostStreamAnalyticsSettings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PostStreamAnalyticsSettings"))
	} else if v.PostStreamAnalyticsSettings != nil {
		if err := validateMedicalScribePostStreamAnalyticsSettings(v.PostStreamAnalyticsSettings); err != nil {
			invalidParams.AddNested("PostStreamAnalyticsSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMedicalScribeEncryptionSettings(v *types.MedicalScribeEncryptionSettings) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MedicalScribeEncryptionSettings"}
	if v.KmsKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMedicalScribeInputStream(v types.MedicalScribeInputStream) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MedicalScribeInputStream"}
	switch uv := v.(type) {
	case *types.MedicalScribeInputStreamMemberAudioEvent:
		if err := validateMedicalScribeAudioEvent(&uv.Value); err != nil {
			invalidParams.AddNested("[AudioEvent]", err.(smithy.InvalidParamsError))
		}

	case *types.MedicalScribeInputStreamMemberConfigurationEvent:
		if err := validateMedicalScribeConfigurationEvent(&uv.Value); err != nil {
			invalidParams.AddNested("[ConfigurationEvent]", err.(smithy.InvalidParamsError))
		}

	case *types.MedicalScribeInputStreamMemberSessionControlEvent:
		if err := validateMedicalScribeSessionControlEvent(&uv.Value); err != nil {
			invalidParams.AddNested("[SessionControlEvent]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMedicalScribePostStreamAnalyticsSettings(v *types.MedicalScribePostStreamAnalyticsSettings) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MedicalScribePostStreamAnalyticsSettings"}
	if v.ClinicalNoteGenerationSettings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClinicalNoteGenerationSettings"))
	} else if v.ClinicalNoteGenerationSettings != nil {
		if err := validateClinicalNoteGenerationSettings(v.ClinicalNoteGenerationSettings); err != nil {
			invalidParams.AddNested("ClinicalNoteGenerationSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMedicalScribeSessionControlEvent(v *types.MedicalScribeSessionControlEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MedicalScribeSessionControlEvent"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePostCallAnalyticsSettings(v *types.PostCallAnalyticsSettings) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PostCallAnalyticsSettings"}
	if v.OutputLocation == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputLocation"))
	}
	if v.DataAccessRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataAccessRoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetMedicalScribeStreamInput(v *GetMedicalScribeStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetMedicalScribeStreamInput"}
	if v.SessionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartCallAnalyticsStreamTranscriptionInput(v *StartCallAnalyticsStreamTranscriptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartCallAnalyticsStreamTranscriptionInput"}
	if len(v.LanguageCode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LanguageCode"))
	}
	if v.MediaSampleRateHertz == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MediaSampleRateHertz"))
	}
	if len(v.MediaEncoding) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MediaEncoding"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartMedicalScribeStreamInput(v *StartMedicalScribeStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartMedicalScribeStreamInput"}
	if len(v.LanguageCode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LanguageCode"))
	}
	if v.MediaSampleRateHertz == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MediaSampleRateHertz"))
	}
	if len(v.MediaEncoding) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MediaEncoding"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartMedicalStreamTranscriptionInput(v *StartMedicalStreamTranscriptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartMedicalStreamTranscriptionInput"}
	if len(v.LanguageCode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("LanguageCode"))
	}
	if v.MediaSampleRateHertz == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MediaSampleRateHertz"))
	}
	if len(v.MediaEncoding) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MediaEncoding"))
	}
	if len(v.Specialty) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Specialty"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartStreamTranscriptionInput(v *StartStreamTranscriptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartStreamTranscriptionInput"}
	if v.MediaSampleRateHertz == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MediaSampleRateHertz"))
	}
	if len(v.MediaEncoding) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MediaEncoding"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
