// Code generated by smithy-go-codegen DO NOT EDIT.

package s3vectors

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/s3vectors/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateIndex struct {
}

func (*validateOpCreateIndex) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateIndex) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateIndexInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateIndexInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVectorBucket struct {
}

func (*validateOpCreateVectorBucket) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVectorBucket) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVectorBucketInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVectorBucketInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVectors struct {
}

func (*validateOpDeleteVectors) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVectors) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVectorsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVectorsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetVectors struct {
}

func (*validateOpGetVectors) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetVectors) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetVectorsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetVectorsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutVectorBucketPolicy struct {
}

func (*validateOpPutVectorBucketPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutVectorBucketPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutVectorBucketPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutVectorBucketPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutVectors struct {
}

func (*validateOpPutVectors) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutVectors) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutVectorsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutVectorsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpQueryVectors struct {
}

func (*validateOpQueryVectors) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpQueryVectors) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*QueryVectorsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpQueryVectorsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateIndexValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateIndex{}, middleware.After)
}

func addOpCreateVectorBucketValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVectorBucket{}, middleware.After)
}

func addOpDeleteVectorsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVectors{}, middleware.After)
}

func addOpGetVectorsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetVectors{}, middleware.After)
}

func addOpPutVectorBucketPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutVectorBucketPolicy{}, middleware.After)
}

func addOpPutVectorsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutVectors{}, middleware.After)
}

func addOpQueryVectorsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpQueryVectors{}, middleware.After)
}

func validateMetadataConfiguration(v *types.MetadataConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetadataConfiguration"}
	if v.NonFilterableMetadataKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NonFilterableMetadataKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePutInputVector(v *types.PutInputVector) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutInputVector"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Data == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Data"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePutVectorsInputList(v []types.PutInputVector) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutVectorsInputList"}
	for i := range v {
		if err := validatePutInputVector(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateIndexInput(v *CreateIndexInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateIndexInput"}
	if v.IndexName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IndexName"))
	}
	if len(v.DataType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DataType"))
	}
	if v.Dimension == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Dimension"))
	}
	if len(v.DistanceMetric) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DistanceMetric"))
	}
	if v.MetadataConfiguration != nil {
		if err := validateMetadataConfiguration(v.MetadataConfiguration); err != nil {
			invalidParams.AddNested("MetadataConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVectorBucketInput(v *CreateVectorBucketInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVectorBucketInput"}
	if v.VectorBucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VectorBucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVectorsInput(v *DeleteVectorsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVectorsInput"}
	if v.Keys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Keys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetVectorsInput(v *GetVectorsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetVectorsInput"}
	if v.Keys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Keys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutVectorBucketPolicyInput(v *PutVectorBucketPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutVectorBucketPolicyInput"}
	if v.Policy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Policy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutVectorsInput(v *PutVectorsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutVectorsInput"}
	if v.Vectors == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Vectors"))
	} else if v.Vectors != nil {
		if err := validatePutVectorsInputList(v.Vectors); err != nil {
			invalidParams.AddNested("Vectors", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpQueryVectorsInput(v *QueryVectorsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "QueryVectorsInput"}
	if v.TopK == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TopK"))
	}
	if v.QueryVector == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryVector"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
