// Code generated by smithy-go-codegen DO NOT EDIT.

package s3vectors

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3vectors/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
//
// Adds one or more vectors to a vector index. To specify the vector index, you
// can either use both the vector bucket name and the vector index name, or use the
// vector index Amazon Resource Name (ARN).
//
// For more information about limits, see [Limitations and restrictions] in the Amazon S3 User Guide.
//
// When inserting vector data into your vector index, you must provide the vector
// data as float32 (32-bit floating point) values. If you pass higher-precision
// values to an Amazon Web Services SDK, S3 Vectors converts the values to 32-bit
// floating point before storing them, and GetVectors , ListVectors , and
// QueryVectors operations return the float32 values. Different Amazon Web Services
// SDKs may have different default numeric types, so ensure your vectors are
// properly formatted as float32 values regardless of which SDK you're using. For
// example, in Python, use numpy.float32 or explicitly cast your values.
//
// Permissions You must have the s3vectors:PutVectors permission to use this
// operation.
//
// [Limitations and restrictions]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html
func (c *Client) PutVectors(ctx context.Context, params *PutVectorsInput, optFns ...func(*Options)) (*PutVectorsOutput, error) {
	if params == nil {
		params = &PutVectorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutVectors", params, optFns, c.addOperationPutVectorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutVectorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutVectorsInput struct {

	// The vectors to add to a vector index. The number of vectors in a single request
	// must not exceed the resource capacity, otherwise the request will be rejected
	// with the error ServiceUnavailableException with the error message "Currently
	// unable to handle the request".
	//
	// This member is required.
	Vectors []types.PutInputVector

	// The ARN of the vector index where you want to write vectors.
	IndexArn *string

	// The name of the vector index where you want to write vectors.
	IndexName *string

	// The name of the vector bucket that contains the vector index.
	VectorBucketName *string

	noSmithyDocumentSerde
}

type PutVectorsOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutVectorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutVectors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutVectors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutVectors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutVectorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutVectors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutVectors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutVectors",
	}
}
