// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplacereporting

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates an embedding URL for an Amazon QuickSight dashboard for an anonymous
// user.
//
// This API is available only to Amazon Web Services Organization management
// accounts or delegated administrators registered for the procurement insights (
// procurement-insights.marketplace.amazonaws.com ) feature.
//
// The following rules apply to a generated URL:
//
//   - It contains a temporary bearer token, valid for 5 minutes after it is
//     generated. Once redeemed within that period, it cannot be re-used again.
//
//   - It has a session lifetime of one hour. The 5-minute validity period runs
//     separately from the session lifetime.
func (c *Client) GetBuyerDashboard(ctx context.Context, params *GetBuyerDashboardInput, optFns ...func(*Options)) (*GetBuyerDashboardOutput, error) {
	if params == nil {
		params = &GetBuyerDashboardInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetBuyerDashboard", params, optFns, c.addOperationGetBuyerDashboardMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetBuyerDashboardOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetBuyerDashboardInput struct {

	// The ARN of the requested dashboard.
	//
	// This member is required.
	DashboardIdentifier *string

	// Fully qualified domains that you add to the allow list for access to the
	// generated URL that is then embedded. You can list up to two domains or
	// subdomains in each API call. To include all subdomains under a specific domain,
	// use * . For example, https://*.amazon.com includes all subdomains under
	// https://aws.amazon.com .
	//
	// This member is required.
	EmbeddingDomains []string

	noSmithyDocumentSerde
}

type GetBuyerDashboardOutput struct {

	// The ARN of the returned dashboard.
	//
	// This member is required.
	DashboardIdentifier *string

	// The dashboard's embedding URL.
	//
	// This member is required.
	EmbedUrl *string

	// The fully qualified domains specified in the request. The domains enable access
	// to the generated URL that is then embedded. You can list up to two domains or
	// subdomains in each API call. To include all subdomains under a specific domain,
	// use * . For example, https://*.amazon.com includes all subdomains under
	// https://aws.amazon.com .
	//
	// This member is required.
	EmbeddingDomains []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetBuyerDashboardMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetBuyerDashboard{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetBuyerDashboard{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetBuyerDashboard"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetBuyerDashboardValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetBuyerDashboard(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetBuyerDashboard(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetBuyerDashboard",
	}
}
