// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a managed thing. A managed thing contains the device identifier,
// protocol supported, and capabilities of the device in a protocol-specific
// format.
func (c *Client) CreateManagedThing(ctx context.Context, params *CreateManagedThingInput, optFns ...func(*Options)) (*CreateManagedThingOutput, error) {
	if params == nil {
		params = &CreateManagedThingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateManagedThing", params, optFns, c.addOperationCreateManagedThingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateManagedThingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateManagedThingInput struct {

	// The authentication material defining the device connectivity setup requests.
	// The authentication materials used are the device bar code.
	//
	// This member is required.
	AuthenticationMaterial *string

	// The type of authentication material used for device connectivity setup requests.
	//
	// This member is required.
	AuthenticationMaterialType types.AuthMaterialType

	// The type of device used. This will be the hub controller, cloud device, or AWS
	// IoT device.
	//
	// This member is required.
	Role types.Role

	// The brand of the device.
	Brand *string

	// The capabilities of the device such as light bulb.
	Capabilities *string

	// A report of the capabilities for the managed thing.
	CapabilityReport *types.CapabilityReport

	// The capability schemas that define the functionality and features supported by
	// the managed thing, including device capabilities and their associated
	// properties.
	CapabilitySchemas []types.CapabilitySchemaItem

	// The classification of the managed thing such as light bulb or thermostat.
	Classification *string

	// An idempotency token. If you retry a request that completed successfully
	// initially using the same client token and parameters, then the retry attempt
	// will succeed without performing any further actions.
	ClientToken *string

	// The identifier of the credential for the managed thing.
	CredentialLockerId *string

	// The metadata for the managed thing.
	//
	// The managedThing metadata parameter is used for associating attributes with a
	// managedThing that can be used for grouping over-the-air (OTA) tasks. Name value
	// pairs in metadata can be used in the OtaTargetQueryString parameter for the
	// CreateOtaTask API operation.
	MetaData map[string]string

	// The model of the device.
	Model *string

	// The name of the managed thing representing the physical device.
	Name *string

	// Owner of the device, usually an indication of whom the device belongs to. This
	// value should not contain personal identifiable information.
	Owner *string

	// The serial number of the device.
	SerialNumber *string

	// A set of key/value pairs that are used to manage the managed thing.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateManagedThingOutput struct {

	// The Amazon Resource Name (ARN) of the managed thing.
	Arn *string

	// The timestamp value of when the device creation request occurred.
	CreatedAt *time.Time

	// The id of the managed thing.
	Id *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateManagedThingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateManagedThing{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateManagedThing{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateManagedThing"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateManagedThingMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateManagedThingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateManagedThing(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateManagedThing struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateManagedThing) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateManagedThing) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateManagedThingInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateManagedThingInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateManagedThingMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateManagedThing{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateManagedThing(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateManagedThing",
	}
}
