// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Export the files that your application modifies or generates in a stream
//
// session, which can help you debug or verify your application. When your
// application runs, it generates output files such as logs, diagnostic
// information, crash dumps, save files, user data, screenshots, and so on. The
// files can be defined by the engine or frameworks that your application uses, or
// information that you've programmed your application to output.
//
// You can only call this action on a stream session that is in progress,
// specifically in one of the following statuses ACTIVE , CONNECTED ,
// PENDING_CLIENT_RECONNECTION , and RECONNECTING . You must provide an Amazon
// Simple Storage Service (Amazon S3) bucket to store the files in. When the
// session ends, Amazon GameLift Streams produces a compressed folder that contains
// all of the files and directories that were modified or created by the
// application during the stream session. AWS uses your security credentials to
// authenticate and authorize access to your Amazon S3 bucket.
//
// Amazon GameLift Streams collects the following generated and modified files.
// Find them in the corresponding folders in the .zip archive.
//
//   - application/ : The folder where your application or game is stored.
//
//   - profile/ : The user profile folder.
//
//   - temp/ : The system temp folder.
//
// To verify the status of the exported files, use GetStreamSession.
//
// To delete the files, delete the object in the S3 bucket.
func (c *Client) ExportStreamSessionFiles(ctx context.Context, params *ExportStreamSessionFilesInput, optFns ...func(*Options)) (*ExportStreamSessionFilesOutput, error) {
	if params == nil {
		params = &ExportStreamSessionFilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ExportStreamSessionFiles", params, optFns, c.addOperationExportStreamSessionFilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ExportStreamSessionFilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ExportStreamSessionFilesInput struct {

	// An [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream group resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	// Example ID: sg-1AB2C3De4 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Identifier *string

	//  The S3 bucket URI where Amazon GameLift Streams uploads the set of compressed
	// exported files for this stream session. Amazon GameLift Streams generates a ZIP
	// file name based on the stream session metadata. Alternatively, you can provide a
	// custom file name with a .zip file extension.
	//
	// Example 1: If you provide an S3 URI called
	// s3://amzn-s3-demo-destination-bucket/MyGame_Session1.zip , then Amazon GameLift
	// Streams will save the files at that location.
	//
	// Example 2: If you provide an S3 URI called
	// s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/ , then Amazon
	// GameLift Streams will save the files at
	// s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/YYYYMMDD-HHMMSS-appId-sg-Id-sessionId.zip
	// or another similar name.
	//
	// This member is required.
	OutputUri *string

	// An [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream session resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamsession/sg-1AB2C3De4/ABC123def4567
	// . Example ID: ABC123def4567 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	StreamSessionIdentifier *string

	noSmithyDocumentSerde
}

type ExportStreamSessionFilesOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationExportStreamSessionFilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpExportStreamSessionFiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpExportStreamSessionFiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ExportStreamSessionFiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpExportStreamSessionFilesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opExportStreamSessionFiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opExportStreamSessionFiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ExportStreamSessionFiles",
	}
}
