// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a transfer location for a Server Message Block (SMB) file server.
// DataSync can use this location as a source or destination for transferring data.
//
// Before you begin, make sure that you understand how DataSync accesses SMB file
// servers. For more information, see [Providing DataSync access to SMB file servers].
//
// [Providing DataSync access to SMB file servers]: https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions
func (c *Client) CreateLocationSmb(ctx context.Context, params *CreateLocationSmbInput, optFns ...func(*Options)) (*CreateLocationSmbOutput, error) {
	if params == nil {
		params = &CreateLocationSmbInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLocationSmb", params, optFns, c.addOperationCreateLocationSmbMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLocationSmbOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// CreateLocationSmbRequest
type CreateLocationSmbInput struct {

	// Specifies the DataSync agent (or agents) that can connect to your SMB file
	// server. You specify an agent by using its Amazon Resource Name (ARN).
	//
	// This member is required.
	AgentArns []string

	// Specifies the domain name or IP address (IPv4 or IPv6) of the SMB file server
	// that your DataSync agent connects to.
	//
	// If you're using Kerberos authentication, you must specify a domain name.
	//
	// This member is required.
	ServerHostname *string

	// Specifies the name of the share exported by your SMB file server where DataSync
	// will read or write data. You can include a subdirectory in the share path (for
	// example, /path/to/subdirectory ). Make sure that other SMB clients in your
	// network can also mount this path.
	//
	// To copy all data in the subdirectory, DataSync must be able to mount the SMB
	// share and access all of its data. For more information, see [Providing DataSync access to SMB file servers].
	//
	// [Providing DataSync access to SMB file servers]: https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions
	//
	// This member is required.
	Subdirectory *string

	// Specifies the authentication protocol that DataSync uses to connect to your SMB
	// file server. DataSync supports NTLM (default) and KERBEROS authentication.
	//
	// For more information, see [Providing DataSync access to SMB file servers].
	//
	// [Providing DataSync access to SMB file servers]: https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions
	AuthenticationType types.SmbAuthenticationType

	// Specifies the IPv4 or IPv6 addresses for the DNS servers that your SMB file
	// server belongs to. This parameter applies only if AuthenticationType is set to
	// KERBEROS .
	//
	// If you have multiple domains in your environment, configuring this parameter
	// makes sure that DataSync connects to the right SMB file server.
	DnsIpAddresses []string

	// Specifies the Windows domain name that your SMB file server belongs to. This
	// parameter applies only if AuthenticationType is set to NTLM .
	//
	// If you have multiple domains in your environment, configuring this parameter
	// makes sure that DataSync connects to the right file server.
	Domain *string

	// Specifies your Kerberos key table (keytab) file, which includes mappings
	// between your Kerberos principal and encryption keys.
	//
	// To avoid task execution errors, make sure that the Kerberos principal that you
	// use to create the keytab file matches exactly what you specify for
	// KerberosPrincipal .
	KerberosKeytab []byte

	// Specifies a Kerberos configuration file ( krb5.conf ) that defines your Kerberos
	// realm configuration.
	//
	// The file must be base64 encoded. If you're using the CLI, the encoding is done
	// for you.
	KerberosKrb5Conf []byte

	// Specifies a Kerberos principal, which is an identity in your Kerberos realm
	// that has permission to access the files, folders, and file metadata in your SMB
	// file server.
	//
	// A Kerberos principal might look like HOST/kerberosuser@MYDOMAIN.ORG .
	//
	// Principal names are case sensitive. Your DataSync task execution will fail if
	// the principal that you specify for this parameter doesn’t exactly match the
	// principal that you use to create the keytab file.
	KerberosPrincipal *string

	// Specifies the version of the SMB protocol that DataSync uses to access your SMB
	// file server.
	MountOptions *types.SmbMountOptions

	// Specifies the password of the user who can mount your SMB file server and has
	// permission to access the files and folders involved in your transfer. This
	// parameter applies only if AuthenticationType is set to NTLM .
	Password *string

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// location.
	Tags []types.TagListEntry

	// Specifies the user that can mount and access the files, folders, and file
	// metadata in your SMB file server. This parameter applies only if
	// AuthenticationType is set to NTLM .
	//
	// For information about choosing a user with the right level of access for your
	// transfer, see [Providing DataSync access to SMB file servers].
	//
	// [Providing DataSync access to SMB file servers]: https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions
	User *string

	noSmithyDocumentSerde
}

// CreateLocationSmbResponse
type CreateLocationSmbOutput struct {

	// The ARN of the SMB location that you created.
	LocationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLocationSmbMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateLocationSmb{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateLocationSmb{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLocationSmb"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLocationSmbValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLocationSmb(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLocationSmb(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLocationSmb",
	}
}
