// Code generated by smithy-go-codegen DO NOT EDIT.

package transfer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/transfer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Returns real-time updates and detailed information on the status of each
//
// individual file being transferred in a specific file transfer operation. You
// specify the file transfer by providing its ConnectorId and its TransferId .
//
// File transfer results are available up to 7 days after an operation has been
// requested.
func (c *Client) ListFileTransferResults(ctx context.Context, params *ListFileTransferResultsInput, optFns ...func(*Options)) (*ListFileTransferResultsOutput, error) {
	if params == nil {
		params = &ListFileTransferResultsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFileTransferResults", params, optFns, c.addOperationListFileTransferResultsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFileTransferResultsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFileTransferResultsInput struct {

	// A unique identifier for a connector. This value should match the value supplied
	// to the corresponding StartFileTransfer call.
	//
	// This member is required.
	ConnectorId *string

	// A unique identifier for a file transfer. This value should match the value
	// supplied to the corresponding StartFileTransfer call.
	//
	// This member is required.
	TransferId *string

	// The maximum number of files to return in a single page. Note that currently you
	// can specify a maximum of 10 file paths in a single [StartFileTransfer]operation. Thus, the maximum
	// number of file transfer results that can be returned in a single page is 10.
	//
	// [StartFileTransfer]: https://docs.aws.amazon.com/transfer/latest/APIReference/API_StartFileTransfer.html
	MaxResults *int32

	// If there are more file details than returned in this call, use this value for a
	// subsequent call to ListFileTransferResults to retrieve them.
	NextToken *string

	noSmithyDocumentSerde
}

type ListFileTransferResultsOutput struct {

	// Returns the details for the files transferred in the transfer identified by the
	// TransferId and ConnectorId specified.
	//
	//   - FilePath : the filename and path to where the file was sent to or retrieved
	//   from.
	//
	//   - StatusCode : current status for the transfer. The status returned is one of
	//   the following values: QUEUED , IN_PROGRESS , COMPLETED , or FAILED
	//
	//   - FailureCode : for transfers that fail, this parameter contains a code
	//   indicating the reason. For example, RETRIEVE_FILE_NOT_FOUND
	//
	//   - FailureMessage : for transfers that fail, this parameter describes the
	//   reason for the failure.
	//
	// This member is required.
	FileTransferResults []types.ConnectorFileTransferResult

	// Returns a token that you can use to call ListFileTransferResults again and
	// receive additional results, if there are any (against the same TransferId .
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFileTransferResultsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListFileTransferResults{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListFileTransferResults{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFileTransferResults"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListFileTransferResultsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFileTransferResults(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListFileTransferResultsPaginatorOptions is the paginator options for
// ListFileTransferResults
type ListFileTransferResultsPaginatorOptions struct {
	// The maximum number of files to return in a single page. Note that currently you
	// can specify a maximum of 10 file paths in a single [StartFileTransfer]operation. Thus, the maximum
	// number of file transfer results that can be returned in a single page is 10.
	//
	// [StartFileTransfer]: https://docs.aws.amazon.com/transfer/latest/APIReference/API_StartFileTransfer.html
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFileTransferResultsPaginator is a paginator for ListFileTransferResults
type ListFileTransferResultsPaginator struct {
	options   ListFileTransferResultsPaginatorOptions
	client    ListFileTransferResultsAPIClient
	params    *ListFileTransferResultsInput
	nextToken *string
	firstPage bool
}

// NewListFileTransferResultsPaginator returns a new
// ListFileTransferResultsPaginator
func NewListFileTransferResultsPaginator(client ListFileTransferResultsAPIClient, params *ListFileTransferResultsInput, optFns ...func(*ListFileTransferResultsPaginatorOptions)) *ListFileTransferResultsPaginator {
	if params == nil {
		params = &ListFileTransferResultsInput{}
	}

	options := ListFileTransferResultsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFileTransferResultsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFileTransferResultsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFileTransferResults page.
func (p *ListFileTransferResultsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFileTransferResultsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFileTransferResults(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFileTransferResultsAPIClient is a client that implements the
// ListFileTransferResults operation.
type ListFileTransferResultsAPIClient interface {
	ListFileTransferResults(context.Context, *ListFileTransferResultsInput, ...func(*Options)) (*ListFileTransferResultsOutput, error)
}

var _ ListFileTransferResultsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFileTransferResults(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFileTransferResults",
	}
}
