// Code generated by smithy-go-codegen DO NOT EDIT.

package neptune

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/neptune/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Switches over the specified secondary DB cluster to be the new primary DB
// cluster in the global database cluster. Switchover operations were previously
// called "managed planned failovers."
//
// Promotes the specified secondary cluster to assume full read/write capabilities
// and demotes the current primary cluster to a secondary (read-only) cluster,
// maintaining the original replication topology. All secondary clusters are
// synchronized with the primary at the beginning of the process so the new primary
// continues operations for the global database without losing any data. Your
// database is unavailable for a short time while the primary and selected
// secondary clusters are assuming their new roles.
//
// This operation is intended for controlled environments, for operations such as
// "regional rotation" or to fall back to the original primary after a global
// database failover.
func (c *Client) SwitchoverGlobalCluster(ctx context.Context, params *SwitchoverGlobalClusterInput, optFns ...func(*Options)) (*SwitchoverGlobalClusterOutput, error) {
	if params == nil {
		params = &SwitchoverGlobalClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SwitchoverGlobalCluster", params, optFns, c.addOperationSwitchoverGlobalClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SwitchoverGlobalClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SwitchoverGlobalClusterInput struct {

	// The identifier of the global database cluster to switch over. This parameter
	// isn't case-sensitive.
	//
	// Constraints: Must match the identifier of an existing global database cluster.
	//
	// This member is required.
	GlobalClusterIdentifier *string

	// The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that you
	// want to promote to primary for the global database.
	//
	// This member is required.
	TargetDbClusterIdentifier *string

	noSmithyDocumentSerde
}

type SwitchoverGlobalClusterOutput struct {

	// Contains the details of an Amazon Neptune global database.
	//
	// This data type is used as a response element for the CreateGlobalCluster, DescribeGlobalClusters, ModifyGlobalCluster, DeleteGlobalCluster, FailoverGlobalCluster, and RemoveFromGlobalCluster actions.
	GlobalCluster *types.GlobalCluster

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSwitchoverGlobalClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpSwitchoverGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpSwitchoverGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SwitchoverGlobalCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSwitchoverGlobalClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSwitchoverGlobalCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSwitchoverGlobalCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SwitchoverGlobalCluster",
	}
}
