// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the source of a flow.
func (c *Client) UpdateFlowSource(ctx context.Context, params *UpdateFlowSourceInput, optFns ...func(*Options)) (*UpdateFlowSourceOutput, error) {
	if params == nil {
		params = &UpdateFlowSourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateFlowSource", params, optFns, c.addOperationUpdateFlowSourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateFlowSourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateFlowSourceInput struct {

	//  The ARN of the flow that you want to update.
	//
	// This member is required.
	FlowArn *string

	// The ARN of the source that you want to update.
	//
	// This member is required.
	SourceArn *string

	// The type of encryption that is used on the content ingested from the source.
	Decryption *types.UpdateEncryption

	// A description of the source. This description is not visible outside of the
	// current Amazon Web Services account.
	Description *string

	// The Amazon Resource Name (ARN) of the entitlement that allows you to subscribe
	// to the flow. The entitlement is set by the content originator, and the ARN is
	// generated as part of the originator's flow.
	EntitlementArn *string

	// The source configuration for cloud flows receiving a stream from a bridge.
	GatewayBridgeSource *types.UpdateGatewayBridgeSourceRequest

	// The port that the flow listens on for incoming content. If the protocol of the
	// source is Zixi, the port must be set to 2088.
	IngestPort *int32

	// The maximum bitrate for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int32

	// The maximum latency in milliseconds. This parameter applies only to RIST-based
	// and Zixi-based streams.
	MaxLatency *int32

	// The size of the buffer (in milliseconds) to use to sync incoming source data.
	MaxSyncBuffer *int32

	// The media stream that is associated with the source, and the parameters for
	// that association.
	MediaStreamSourceConfigurations []types.MediaStreamSourceConfigurationRequest

	// The minimum latency in milliseconds for SRT-based streams. In streams that use
	// the SRT protocol, this value that you set on your MediaConnect source or output
	// represents the minimal potential latency of that connection. The latency of the
	// stream is set to the highest number between the sender’s minimum latency and the
	// receiver’s minimum latency.
	MinLatency *int32

	// The protocol that the source uses to deliver the content to MediaConnect.
	//
	// Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This
	// reference is maintained for legacy purposes only.
	Protocol types.Protocol

	// The port that the flow uses to send outbound requests to initiate connection
	// with the sender.
	SenderControlPort *int32

	// The IP address that the flow communicates with to initiate connection with the
	// sender.
	SenderIpAddress *string

	// The source IP or domain name for SRT-caller protocol.
	SourceListenerAddress *string

	// Source port for SRT-caller protocol.
	SourceListenerPort *int32

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi and SRT caller-based streams.
	StreamId *string

	// The name of the VPC interface that you want to send your output to.
	VpcInterfaceName *string

	// The range of IP addresses that are allowed to contribute content to your
	// source. Format the IP addresses as a Classless Inter-Domain Routing (CIDR)
	// block; for example, 10.0.0.0/16.
	WhitelistCidr *string

	noSmithyDocumentSerde
}

type UpdateFlowSourceOutput struct {

	// The ARN of the flow that you was updated.
	FlowArn *string

	// The details of the sources that are assigned to the flow.
	Source *types.Source

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateFlowSourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateFlowSource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateFlowSource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateFlowSource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateFlowSourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateFlowSource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateFlowSource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateFlowSource",
	}
}
