// Code generated by smithy-go-codegen DO NOT EDIT.

package geoplaces

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/geoplaces/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAutocomplete struct {
}

func (*awsRestjson1_serializeOpAutocomplete) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAutocomplete) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AutocompleteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/autocomplete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAutocompleteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAutocompleteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAutocompleteInput(v *AutocompleteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAutocompleteInput(v *AutocompleteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalFeatures != nil {
		ok := object.Key("AdditionalFeatures")
		if err := awsRestjson1_serializeDocumentAutocompleteAdditionalFeatureList(v.AdditionalFeatures, ok); err != nil {
			return err
		}
	}

	if v.BiasPosition != nil {
		ok := object.Key("BiasPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.BiasPosition, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentAutocompleteFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if len(v.IntendedUse) > 0 {
		ok := object.Key("IntendedUse")
		ok.String(string(v.IntendedUse))
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.PoliticalView != nil {
		ok := object.Key("PoliticalView")
		ok.String(*v.PoliticalView)
	}

	if len(v.PostalCodeMode) > 0 {
		ok := object.Key("PostalCodeMode")
		ok.String(string(v.PostalCodeMode))
	}

	if v.QueryText != nil {
		ok := object.Key("QueryText")
		ok.String(*v.QueryText)
	}

	return nil
}

type awsRestjson1_serializeOpGeocode struct {
}

func (*awsRestjson1_serializeOpGeocode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGeocode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GeocodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geocode")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGeocodeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGeocodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGeocodeInput(v *GeocodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGeocodeInput(v *GeocodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalFeatures != nil {
		ok := object.Key("AdditionalFeatures")
		if err := awsRestjson1_serializeDocumentGeocodeAdditionalFeatureList(v.AdditionalFeatures, ok); err != nil {
			return err
		}
	}

	if v.BiasPosition != nil {
		ok := object.Key("BiasPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.BiasPosition, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentGeocodeFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if len(v.IntendedUse) > 0 {
		ok := object.Key("IntendedUse")
		ok.String(string(v.IntendedUse))
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.PoliticalView != nil {
		ok := object.Key("PoliticalView")
		ok.String(*v.PoliticalView)
	}

	if v.QueryComponents != nil {
		ok := object.Key("QueryComponents")
		if err := awsRestjson1_serializeDocumentGeocodeQueryComponents(v.QueryComponents, ok); err != nil {
			return err
		}
	}

	if v.QueryText != nil {
		ok := object.Key("QueryText")
		ok.String(*v.QueryText)
	}

	return nil
}

type awsRestjson1_serializeOpGetPlace struct {
}

func (*awsRestjson1_serializeOpGetPlace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPlace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPlaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/place/{PlaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPlaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPlaceInput(v *GetPlaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AdditionalFeatures != nil {
		for i := range v.AdditionalFeatures {
			encoder.AddQuery("additional-features").String(string(v.AdditionalFeatures[i]))
		}
	}

	if len(v.IntendedUse) > 0 {
		encoder.SetQuery("intended-use").String(string(v.IntendedUse))
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.Language != nil {
		encoder.SetQuery("language").String(*v.Language)
	}

	if v.PlaceId == nil || len(*v.PlaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PlaceId must not be empty")}
	}
	if v.PlaceId != nil {
		if err := encoder.SetURI("PlaceId").String(*v.PlaceId); err != nil {
			return err
		}
	}

	if v.PoliticalView != nil {
		encoder.SetQuery("political-view").String(*v.PoliticalView)
	}

	return nil
}

type awsRestjson1_serializeOpReverseGeocode struct {
}

func (*awsRestjson1_serializeOpReverseGeocode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpReverseGeocode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReverseGeocodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/reverse-geocode")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsReverseGeocodeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentReverseGeocodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsReverseGeocodeInput(v *ReverseGeocodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentReverseGeocodeInput(v *ReverseGeocodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalFeatures != nil {
		ok := object.Key("AdditionalFeatures")
		if err := awsRestjson1_serializeDocumentReverseGeocodeAdditionalFeatureList(v.AdditionalFeatures, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentReverseGeocodeFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if len(v.IntendedUse) > 0 {
		ok := object.Key("IntendedUse")
		ok.String(string(v.IntendedUse))
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.PoliticalView != nil {
		ok := object.Key("PoliticalView")
		ok.String(*v.PoliticalView)
	}

	if v.QueryPosition != nil {
		ok := object.Key("QueryPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.QueryPosition, ok); err != nil {
			return err
		}
	}

	if v.QueryRadius != nil {
		ok := object.Key("QueryRadius")
		ok.Long(*v.QueryRadius)
	}

	return nil
}

type awsRestjson1_serializeOpSearchNearby struct {
}

func (*awsRestjson1_serializeOpSearchNearby) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchNearby) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchNearbyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/search-nearby")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchNearbyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchNearbyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchNearbyInput(v *SearchNearbyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchNearbyInput(v *SearchNearbyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalFeatures != nil {
		ok := object.Key("AdditionalFeatures")
		if err := awsRestjson1_serializeDocumentSearchNearbyAdditionalFeatureList(v.AdditionalFeatures, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentSearchNearbyFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if len(v.IntendedUse) > 0 {
		ok := object.Key("IntendedUse")
		ok.String(string(v.IntendedUse))
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.PoliticalView != nil {
		ok := object.Key("PoliticalView")
		ok.String(*v.PoliticalView)
	}

	if v.QueryPosition != nil {
		ok := object.Key("QueryPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.QueryPosition, ok); err != nil {
			return err
		}
	}

	if v.QueryRadius != nil {
		ok := object.Key("QueryRadius")
		ok.Long(*v.QueryRadius)
	}

	return nil
}

type awsRestjson1_serializeOpSearchText struct {
}

func (*awsRestjson1_serializeOpSearchText) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchText) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchTextInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/search-text")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchTextInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchTextInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchTextInput(v *SearchTextInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchTextInput(v *SearchTextInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalFeatures != nil {
		ok := object.Key("AdditionalFeatures")
		if err := awsRestjson1_serializeDocumentSearchTextAdditionalFeatureList(v.AdditionalFeatures, ok); err != nil {
			return err
		}
	}

	if v.BiasPosition != nil {
		ok := object.Key("BiasPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.BiasPosition, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentSearchTextFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if len(v.IntendedUse) > 0 {
		ok := object.Key("IntendedUse")
		ok.String(string(v.IntendedUse))
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.PoliticalView != nil {
		ok := object.Key("PoliticalView")
		ok.String(*v.PoliticalView)
	}

	if v.QueryId != nil {
		ok := object.Key("QueryId")
		ok.String(*v.QueryId)
	}

	if v.QueryText != nil {
		ok := object.Key("QueryText")
		ok.String(*v.QueryText)
	}

	return nil
}

type awsRestjson1_serializeOpSuggest struct {
}

func (*awsRestjson1_serializeOpSuggest) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSuggest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SuggestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/suggest")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSuggestInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSuggestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSuggestInput(v *SuggestInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSuggestInput(v *SuggestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalFeatures != nil {
		ok := object.Key("AdditionalFeatures")
		if err := awsRestjson1_serializeDocumentSuggestAdditionalFeatureList(v.AdditionalFeatures, ok); err != nil {
			return err
		}
	}

	if v.BiasPosition != nil {
		ok := object.Key("BiasPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.BiasPosition, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentSuggestFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if len(v.IntendedUse) > 0 {
		ok := object.Key("IntendedUse")
		ok.String(string(v.IntendedUse))
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxQueryRefinements != nil {
		ok := object.Key("MaxQueryRefinements")
		ok.Integer(*v.MaxQueryRefinements)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.PoliticalView != nil {
		ok := object.Key("PoliticalView")
		ok.String(*v.PoliticalView)
	}

	if v.QueryText != nil {
		ok := object.Key("QueryText")
		ok.String(*v.QueryText)
	}

	return nil
}

func awsRestjson1_serializeDocumentAutocompleteAdditionalFeatureList(v []types.AutocompleteAdditionalFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAutocompleteFilter(v *types.AutocompleteFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Circle != nil {
		ok := object.Key("Circle")
		if err := awsRestjson1_serializeDocumentFilterCircle(v.Circle, ok); err != nil {
			return err
		}
	}

	if v.IncludeCountries != nil {
		ok := object.Key("IncludeCountries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.IncludeCountries, ok); err != nil {
			return err
		}
	}

	if v.IncludePlaceTypes != nil {
		ok := object.Key("IncludePlaceTypes")
		if err := awsRestjson1_serializeDocumentAutocompleteFilterPlaceTypeList(v.IncludePlaceTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutocompleteFilterPlaceTypeList(v []types.AutocompleteFilterPlaceType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentBoundingBox(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCountryCodeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterBusinessChainList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterCategoryList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterCircle(v *types.FilterCircle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Center != nil {
		ok := object.Key("Center")
		if err := awsRestjson1_serializeDocumentPosition(v.Center, ok); err != nil {
			return err
		}
	}

	if v.Radius != nil {
		ok := object.Key("Radius")
		ok.Long(*v.Radius)
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterFoodTypeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentGeocodeAdditionalFeatureList(v []types.GeocodeAdditionalFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentGeocodeFilter(v *types.GeocodeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludeCountries != nil {
		ok := object.Key("IncludeCountries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.IncludeCountries, ok); err != nil {
			return err
		}
	}

	if v.IncludePlaceTypes != nil {
		ok := object.Key("IncludePlaceTypes")
		if err := awsRestjson1_serializeDocumentGeocodeFilterPlaceTypeList(v.IncludePlaceTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeocodeFilterPlaceTypeList(v []types.GeocodeFilterPlaceType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentGeocodeQueryComponents(v *types.GeocodeQueryComponents, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressNumber != nil {
		ok := object.Key("AddressNumber")
		ok.String(*v.AddressNumber)
	}

	if v.Country != nil {
		ok := object.Key("Country")
		ok.String(*v.Country)
	}

	if v.District != nil {
		ok := object.Key("District")
		ok.String(*v.District)
	}

	if v.Locality != nil {
		ok := object.Key("Locality")
		ok.String(*v.Locality)
	}

	if v.PostalCode != nil {
		ok := object.Key("PostalCode")
		ok.String(*v.PostalCode)
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	if v.Street != nil {
		ok := object.Key("Street")
		ok.String(*v.Street)
	}

	if v.SubRegion != nil {
		ok := object.Key("SubRegion")
		ok.String(*v.SubRegion)
	}

	return nil
}

func awsRestjson1_serializeDocumentPosition(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentReverseGeocodeAdditionalFeatureList(v []types.ReverseGeocodeAdditionalFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentReverseGeocodeFilter(v *types.ReverseGeocodeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IncludePlaceTypes != nil {
		ok := object.Key("IncludePlaceTypes")
		if err := awsRestjson1_serializeDocumentReverseGeocodeFilterPlaceTypeList(v.IncludePlaceTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentReverseGeocodeFilterPlaceTypeList(v []types.ReverseGeocodeFilterPlaceType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSearchNearbyAdditionalFeatureList(v []types.SearchNearbyAdditionalFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSearchNearbyFilter(v *types.SearchNearbyFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.ExcludeBusinessChains != nil {
		ok := object.Key("ExcludeBusinessChains")
		if err := awsRestjson1_serializeDocumentFilterBusinessChainList(v.ExcludeBusinessChains, ok); err != nil {
			return err
		}
	}

	if v.ExcludeCategories != nil {
		ok := object.Key("ExcludeCategories")
		if err := awsRestjson1_serializeDocumentFilterCategoryList(v.ExcludeCategories, ok); err != nil {
			return err
		}
	}

	if v.ExcludeFoodTypes != nil {
		ok := object.Key("ExcludeFoodTypes")
		if err := awsRestjson1_serializeDocumentFilterFoodTypeList(v.ExcludeFoodTypes, ok); err != nil {
			return err
		}
	}

	if v.IncludeBusinessChains != nil {
		ok := object.Key("IncludeBusinessChains")
		if err := awsRestjson1_serializeDocumentFilterBusinessChainList(v.IncludeBusinessChains, ok); err != nil {
			return err
		}
	}

	if v.IncludeCategories != nil {
		ok := object.Key("IncludeCategories")
		if err := awsRestjson1_serializeDocumentFilterCategoryList(v.IncludeCategories, ok); err != nil {
			return err
		}
	}

	if v.IncludeCountries != nil {
		ok := object.Key("IncludeCountries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.IncludeCountries, ok); err != nil {
			return err
		}
	}

	if v.IncludeFoodTypes != nil {
		ok := object.Key("IncludeFoodTypes")
		if err := awsRestjson1_serializeDocumentFilterFoodTypeList(v.IncludeFoodTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSearchTextAdditionalFeatureList(v []types.SearchTextAdditionalFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSearchTextFilter(v *types.SearchTextFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Circle != nil {
		ok := object.Key("Circle")
		if err := awsRestjson1_serializeDocumentFilterCircle(v.Circle, ok); err != nil {
			return err
		}
	}

	if v.IncludeCountries != nil {
		ok := object.Key("IncludeCountries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.IncludeCountries, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSuggestAdditionalFeatureList(v []types.SuggestAdditionalFeature, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSuggestFilter(v *types.SuggestFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Circle != nil {
		ok := object.Key("Circle")
		if err := awsRestjson1_serializeDocumentFilterCircle(v.Circle, ok); err != nil {
			return err
		}
	}

	if v.IncludeCountries != nil {
		ok := object.Key("IncludeCountries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.IncludeCountries, ok); err != nil {
			return err
		}
	}

	return nil
}
