// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allows clients to reconnect to a recently disconnected stream session without
// losing any data from the last session.
//
// A client can reconnect to a stream session that's in PENDING_CLIENT_RECONNECTION
// or ACTIVE status. In the stream session life cycle, when the client disconnects
// from the stream session, the stream session transitions from CONNECTED to
// PENDING_CLIENT_RECONNECTION status. When a client requests to reconnect by
// calling CreateStreamSessionConnection , the stream session transitions to
// RECONNECTING status. When the reconnection is successful, the stream session
// transitions to ACTIVE status. After a stream session is disconnected for longer
// than ConnectionTimeoutSeconds , the stream session transitions to the TERMINATED
// status.
//
// To connect to an existing stream session, specify the stream group ID and
// stream session ID that you want to reconnect to, as well as the signal request
// settings to use with the stream.
//
// ConnectionTimeoutSeconds defines the amount of time after the stream session
// disconnects that a reconnection is allowed. If a client is disconnected from the
// stream for longer than ConnectionTimeoutSeconds , the stream session ends.
func (c *Client) CreateStreamSessionConnection(ctx context.Context, params *CreateStreamSessionConnectionInput, optFns ...func(*Options)) (*CreateStreamSessionConnectionOutput, error) {
	if params == nil {
		params = &CreateStreamSessionConnectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateStreamSessionConnection", params, optFns, c.addOperationCreateStreamSessionConnectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateStreamSessionConnectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateStreamSessionConnectionInput struct {

	// [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream group resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	// Example ID: sg-1AB2C3De4 .
	//
	// The stream group that you want to run this stream session with. The stream
	// group must be in ACTIVE status and have idle stream capacity.
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Identifier *string

	// A WebRTC ICE offer string to use when initializing a WebRTC connection. The
	// offer is a very long JSON string. Provide the string as a text value in quotes.
	// The offer must be newly generated, not the same offer provided to
	// StartStreamSession .
	//
	// This member is required.
	SignalRequest *string

	// [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream session resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamsession/sg-1AB2C3De4/ABC123def4567
	// . Example ID: ABC123def4567 .
	//
	// The stream session must be in PENDING_CLIENT_RECONNECTION or ACTIVE status.
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	StreamSessionIdentifier *string

	//  A unique identifier that represents a client request. The request is
	// idempotent, which ensures that an API request completes only once. When users
	// send a request, Amazon GameLift Streams automatically populates this field.
	ClientToken *string

	noSmithyDocumentSerde
}

type CreateStreamSessionConnectionOutput struct {

	// The WebRTC answer string that the stream server generates in response to the
	// SignalRequest .
	SignalResponse *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateStreamSessionConnectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateStreamSessionConnection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateStreamSessionConnection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateStreamSessionConnection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateStreamSessionConnectionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateStreamSessionConnectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateStreamSessionConnection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateStreamSessionConnection struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateStreamSessionConnection) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateStreamSessionConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateStreamSessionConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateStreamSessionConnectionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateStreamSessionConnectionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateStreamSessionConnection{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateStreamSessionConnection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateStreamSessionConnection",
	}
}
