// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservicedata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/directoryservicedata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Searches the specified directory for a user. You can find users that match the
//
// SearchString parameter with the value of their attributes included in the
// SearchString parameter.
//
// This operation supports pagination with the use of the NextToken request and
// response parameters. If more results are available, the SearchUsers.NextToken
// member contains a token that you pass in the next call to SearchUsers . This
// retrieves the next set of items.
//
// You can also specify a maximum number of return results with the MaxResults
// parameter.
func (c *Client) SearchUsers(ctx context.Context, params *SearchUsersInput, optFns ...func(*Options)) (*SearchUsersOutput, error) {
	if params == nil {
		params = &SearchUsersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchUsers", params, optFns, c.addOperationSearchUsersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchUsersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchUsersInput struct {

	//  The identifier (ID) of the directory that's associated with the user.
	//
	// This member is required.
	DirectoryId *string

	//  One or more data attributes that are used to search for a user. For a list of
	// supported attributes, see [Directory Service Data Attributes].
	//
	// [Directory Service Data Attributes]: https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html
	//
	// This member is required.
	SearchAttributes []string

	//  The attribute value that you want to search for.
	//
	// Wildcard (*) searches aren't supported. For a list of supported attributes, see [Directory Service Data Attributes]
	// .
	//
	// [Directory Service Data Attributes]: https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html
	//
	// This member is required.
	SearchString *string

	//  The maximum number of results to be returned per request.
	MaxResults *int32

	//  An encoded paging token for paginated calls that can be passed back to
	// retrieve the next page.
	NextToken *string

	//  The domain name that's associated with the user.
	//
	// This parameter is optional, so you can return users outside of your Managed
	// Microsoft AD domain. When no value is defined, only your Managed Microsoft AD
	// users are returned.
	//
	// This value is case insensitive.
	Realm *string

	noSmithyDocumentSerde
}

type SearchUsersOutput struct {

	//  The identifier (ID) of the directory where the address block is added.
	DirectoryId *string

	//  An encoded paging token for paginated calls that can be passed back to
	// retrieve the next page.
	NextToken *string

	//  The domain that's associated with the user.
	Realm *string

	//  The user information that the request returns.
	Users []types.User

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchUsersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchUsers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchUsers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchUsers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchUsersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchUsers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// SearchUsersPaginatorOptions is the paginator options for SearchUsers
type SearchUsersPaginatorOptions struct {
	//  The maximum number of results to be returned per request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchUsersPaginator is a paginator for SearchUsers
type SearchUsersPaginator struct {
	options   SearchUsersPaginatorOptions
	client    SearchUsersAPIClient
	params    *SearchUsersInput
	nextToken *string
	firstPage bool
}

// NewSearchUsersPaginator returns a new SearchUsersPaginator
func NewSearchUsersPaginator(client SearchUsersAPIClient, params *SearchUsersInput, optFns ...func(*SearchUsersPaginatorOptions)) *SearchUsersPaginator {
	if params == nil {
		params = &SearchUsersInput{}
	}

	options := SearchUsersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchUsersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchUsersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchUsers page.
func (p *SearchUsersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchUsersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchUsers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchUsersAPIClient is a client that implements the SearchUsers operation.
type SearchUsersAPIClient interface {
	SearchUsers(context.Context, *SearchUsersInput, ...func(*Options)) (*SearchUsersOutput, error)
}

var _ SearchUsersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchUsers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchUsers",
	}
}
