// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the following configuration parameters of the Amazon EFS transfer
// location that you're using with DataSync.
//
// For more information, see [Configuring DataSync transfers with Amazon EFS].
//
// [Configuring DataSync transfers with Amazon EFS]: https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html
func (c *Client) UpdateLocationEfs(ctx context.Context, params *UpdateLocationEfsInput, optFns ...func(*Options)) (*UpdateLocationEfsOutput, error) {
	if params == nil {
		params = &UpdateLocationEfsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLocationEfs", params, optFns, c.addOperationUpdateLocationEfsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLocationEfsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLocationEfsInput struct {

	// Specifies the Amazon Resource Name (ARN) of the Amazon EFS transfer location
	// that you're updating.
	//
	// This member is required.
	LocationArn *string

	// Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses
	// to mount your Amazon EFS file system.
	//
	// For more information, see [Accessing restricted Amazon EFS file systems].
	//
	// [Accessing restricted Amazon EFS file systems]: https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam
	AccessPointArn *string

	// Specifies an Identity and Access Management (IAM) role that allows DataSync to
	// access your Amazon EFS file system.
	//
	// For information on creating this role, see [Creating a DataSync IAM role for Amazon EFS file system access].
	//
	// [Creating a DataSync IAM role for Amazon EFS file system access]: https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role
	FileSystemAccessRoleArn *string

	// Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2
	// encryption when it transfers data to or from your Amazon EFS file system.
	//
	// If you specify an access point using AccessPointArn or an IAM role using
	// FileSystemAccessRoleArn , you must set this parameter to TLS1_2 .
	InTransitEncryption types.EfsInTransitEncryption

	// Specifies a mount path for your Amazon EFS file system. This is where DataSync
	// reads or writes data on your file system (depending on if this is a source or
	// destination location).
	//
	// By default, DataSync uses the root directory (or [access point] if you provide one by using
	// AccessPointArn ). You can also include subdirectories using forward slashes (for
	// example, /path/to/folder ).
	//
	// [access point]: https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html
	Subdirectory *string

	noSmithyDocumentSerde
}

type UpdateLocationEfsOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLocationEfsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateLocationEfs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateLocationEfs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateLocationEfs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateLocationEfsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLocationEfs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLocationEfs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateLocationEfs",
	}
}
