// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of configuration recorders depending on the filters you specify.
func (c *Client) ListConfigurationRecorders(ctx context.Context, params *ListConfigurationRecordersInput, optFns ...func(*Options)) (*ListConfigurationRecordersOutput, error) {
	if params == nil {
		params = &ListConfigurationRecordersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConfigurationRecorders", params, optFns, c.addOperationListConfigurationRecordersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConfigurationRecordersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConfigurationRecordersInput struct {

	// Filters the results based on a list of ConfigurationRecorderFilter objects that
	// you specify.
	Filters []types.ConfigurationRecorderFilter

	// The maximum number of results to include in the response.
	MaxResults *int32

	// The NextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListConfigurationRecordersOutput struct {

	// A list of ConfigurationRecorderSummary objects that includes.
	//
	// This member is required.
	ConfigurationRecorderSummaries []types.ConfigurationRecorderSummary

	// The NextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConfigurationRecordersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListConfigurationRecorders{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListConfigurationRecorders{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConfigurationRecorders"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConfigurationRecorders(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListConfigurationRecordersPaginatorOptions is the paginator options for
// ListConfigurationRecorders
type ListConfigurationRecordersPaginatorOptions struct {
	// The maximum number of results to include in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConfigurationRecordersPaginator is a paginator for
// ListConfigurationRecorders
type ListConfigurationRecordersPaginator struct {
	options   ListConfigurationRecordersPaginatorOptions
	client    ListConfigurationRecordersAPIClient
	params    *ListConfigurationRecordersInput
	nextToken *string
	firstPage bool
}

// NewListConfigurationRecordersPaginator returns a new
// ListConfigurationRecordersPaginator
func NewListConfigurationRecordersPaginator(client ListConfigurationRecordersAPIClient, params *ListConfigurationRecordersInput, optFns ...func(*ListConfigurationRecordersPaginatorOptions)) *ListConfigurationRecordersPaginator {
	if params == nil {
		params = &ListConfigurationRecordersInput{}
	}

	options := ListConfigurationRecordersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConfigurationRecordersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConfigurationRecordersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConfigurationRecorders page.
func (p *ListConfigurationRecordersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConfigurationRecordersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConfigurationRecorders(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConfigurationRecordersAPIClient is a client that implements the
// ListConfigurationRecorders operation.
type ListConfigurationRecordersAPIClient interface {
	ListConfigurationRecorders(context.Context, *ListConfigurationRecordersInput, ...func(*Options)) (*ListConfigurationRecordersOutput, error)
}

var _ ListConfigurationRecordersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConfigurationRecorders(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConfigurationRecorders",
	}
}
