// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The information about the recovery points of the type specified by a resource
// Amazon Resource Name (ARN).
//
// For Amazon EFS and Amazon EC2, this action only lists recovery points created
// by Backup.
func (c *Client) ListRecoveryPointsByResource(ctx context.Context, params *ListRecoveryPointsByResourceInput, optFns ...func(*Options)) (*ListRecoveryPointsByResourceOutput, error) {
	if params == nil {
		params = &ListRecoveryPointsByResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRecoveryPointsByResource", params, optFns, c.addOperationListRecoveryPointsByResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRecoveryPointsByResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRecoveryPointsByResourceInput struct {

	// An ARN that uniquely identifies a resource. The format of the ARN depends on
	// the resource type.
	//
	// This member is required.
	ResourceArn *string

	// This attribute filters recovery points based on ownership.
	//
	// If this is set to TRUE , the response will contain recovery points associated
	// with the selected resources that are managed by Backup.
	//
	// If this is set to FALSE , the response will contain all recovery points
	// associated with the selected resource.
	//
	// Type: Boolean
	ManagedByAWSBackupOnly bool

	// The maximum number of items to be returned.
	//
	// Amazon RDS requires a value of at least 20.
	MaxResults *int32

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the next
	// token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRecoveryPointsByResourceOutput struct {

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the next
	// token.
	NextToken *string

	// An array of objects that contain detailed information about recovery points of
	// the specified resource type.
	//
	// Only Amazon EFS and Amazon EC2 recovery points return BackupVaultName.
	RecoveryPoints []types.RecoveryPointByResource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRecoveryPointsByResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRecoveryPointsByResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRecoveryPointsByResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRecoveryPointsByResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListRecoveryPointsByResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRecoveryPointsByResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListRecoveryPointsByResourcePaginatorOptions is the paginator options for
// ListRecoveryPointsByResource
type ListRecoveryPointsByResourcePaginatorOptions struct {
	// The maximum number of items to be returned.
	//
	// Amazon RDS requires a value of at least 20.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRecoveryPointsByResourcePaginator is a paginator for
// ListRecoveryPointsByResource
type ListRecoveryPointsByResourcePaginator struct {
	options   ListRecoveryPointsByResourcePaginatorOptions
	client    ListRecoveryPointsByResourceAPIClient
	params    *ListRecoveryPointsByResourceInput
	nextToken *string
	firstPage bool
}

// NewListRecoveryPointsByResourcePaginator returns a new
// ListRecoveryPointsByResourcePaginator
func NewListRecoveryPointsByResourcePaginator(client ListRecoveryPointsByResourceAPIClient, params *ListRecoveryPointsByResourceInput, optFns ...func(*ListRecoveryPointsByResourcePaginatorOptions)) *ListRecoveryPointsByResourcePaginator {
	if params == nil {
		params = &ListRecoveryPointsByResourceInput{}
	}

	options := ListRecoveryPointsByResourcePaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRecoveryPointsByResourcePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRecoveryPointsByResourcePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRecoveryPointsByResource page.
func (p *ListRecoveryPointsByResourcePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRecoveryPointsByResourceOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRecoveryPointsByResource(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRecoveryPointsByResourceAPIClient is a client that implements the
// ListRecoveryPointsByResource operation.
type ListRecoveryPointsByResourceAPIClient interface {
	ListRecoveryPointsByResource(context.Context, *ListRecoveryPointsByResourceInput, ...func(*Options)) (*ListRecoveryPointsByResourceOutput, error)
}

var _ ListRecoveryPointsByResourceAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRecoveryPointsByResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRecoveryPointsByResource",
	}
}
