// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"context"
	"encoding/base64"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"io"
	"net/http"
	"strconv"
	"time"
)

// PathClient contains the methods for the Path group.
// Don't use this type directly, use a constructor function instead.
type PathClient struct {
	internal         *azcore.Client
	endpoint         string
	xmsLeaseDuration int32
}

// AppendData - Append data to the file.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - body - Initial data
//   - options - PathClientAppendDataOptions contains the optional parameters for the PathClient.AppendData method.
//   - PathHTTPHeaders - PathHTTPHeaders contains a group of parameters for the PathClient.Create method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - CPKInfo - CPKInfo contains a group of parameters for the PathClient.Create method.
func (client *PathClient) AppendData(ctx context.Context, body io.ReadSeekCloser, options *PathClientAppendDataOptions, pathHTTPHeaders *PathHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CPKInfo) (PathClientAppendDataResponse, error) {
	var err error
	req, err := client.appendDataCreateRequest(ctx, body, options, pathHTTPHeaders, leaseAccessConditions, cpkInfo)
	if err != nil {
		return PathClientAppendDataResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientAppendDataResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return PathClientAppendDataResponse{}, err
	}
	resp, err := client.appendDataHandleResponse(httpResp)
	return resp, err
}

// appendDataCreateRequest creates the AppendData request.
func (client *PathClient) appendDataCreateRequest(ctx context.Context, body io.ReadSeekCloser, options *PathClientAppendDataOptions, pathHTTPHeaders *PathHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, cpkInfo *CPKInfo) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPatch, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", "append")
	if options != nil && options.Flush != nil {
		reqQP.Set("flush", strconv.FormatBool(*options.Flush))
	}
	if options != nil && options.Position != nil {
		reqQP.Set("position", strconv.FormatInt(*options.Position, 10))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ContentLength != nil {
		req.Raw().Header["Content-Length"] = []string{strconv.FormatInt(*options.ContentLength, 10)}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.TransactionalContentHash != nil {
		req.Raw().Header["Content-MD5"] = []string{base64.StdEncoding.EncodeToString(pathHTTPHeaders.TransactionalContentHash)}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if options != nil && options.TransactionalContentCRC64 != nil {
		req.Raw().Header["x-ms-content-crc64"] = []string{base64.StdEncoding.EncodeToString(options.TransactionalContentCRC64)}
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header["x-ms-encryption-algorithm"] = []string{string(*cpkInfo.EncryptionAlgorithm)}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header["x-ms-encryption-key"] = []string{*cpkInfo.EncryptionKey}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header["x-ms-encryption-key-sha256"] = []string{*cpkInfo.EncryptionKeySHA256}
	}
	if options != nil && options.LeaseAction != nil {
		req.Raw().Header["x-ms-lease-action"] = []string{string(*options.LeaseAction)}
	}
	if options != nil && options.LeaseDuration != nil {
		req.Raw().Header["x-ms-lease-duration"] = []string{strconv.FormatInt(*options.LeaseDuration, 10)}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.ProposedLeaseID != nil {
		req.Raw().Header["x-ms-proposed-lease-id"] = []string{*options.ProposedLeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	if err := req.SetBody(body, "application/json"); err != nil {
		return nil, err
	}
	return req, nil
}

// appendDataHandleResponse handles the AppendData response.
func (client *PathClient) appendDataHandleResponse(resp *http.Response) (PathClientAppendDataResponse, error) {
	result := PathClientAppendDataResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-content-crc64"); val != "" {
		contentCRC64, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return PathClientAppendDataResponse{}, err
		}
		result.ContentCRC64 = contentCRC64
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return PathClientAppendDataResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientAppendDataResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-encryption-key-sha256"); val != "" {
		result.EncryptionKeySHA256 = &val
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return PathClientAppendDataResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("x-ms-lease-renewed"); val != "" {
		leaseRenewed, err := strconv.ParseBool(val)
		if err != nil {
			return PathClientAppendDataResponse{}, err
		}
		result.LeaseRenewed = &leaseRenewed
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Create - Create or rename a file or directory. By default, the destination is overwritten and if the destination already
// exists and has a lease the lease is broken. This operation supports conditional HTTP
// requests. For more information, see Specifying Conditional Headers for Blob Service Operations
// [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// To fail if the destination already exists, use a conditional request with
// If-None-Match: "*".
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - options - PathClientCreateOptions contains the optional parameters for the PathClient.Create method.
//   - PathHTTPHeaders - PathHTTPHeaders contains a group of parameters for the PathClient.Create method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - ModifiedAccessConditions - ModifiedAccessConditions contains a group of parameters for the FileSystemClient.SetProperties
//     method.
//   - SourceModifiedAccessConditions - SourceModifiedAccessConditions contains a group of parameters for the PathClient.Create
//     method.
//   - CPKInfo - CPKInfo contains a group of parameters for the PathClient.Create method.
func (client *PathClient) Create(ctx context.Context, options *PathClientCreateOptions, pathHTTPHeaders *PathHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, sourceModifiedAccessConditions *SourceModifiedAccessConditions, cpkInfo *CPKInfo) (PathClientCreateResponse, error) {
	var err error
	req, err := client.createCreateRequest(ctx, options, pathHTTPHeaders, leaseAccessConditions, modifiedAccessConditions, sourceModifiedAccessConditions, cpkInfo)
	if err != nil {
		return PathClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return PathClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *PathClient) createCreateRequest(ctx context.Context, options *PathClientCreateOptions, pathHTTPHeaders *PathHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, sourceModifiedAccessConditions *SourceModifiedAccessConditions, cpkInfo *CPKInfo) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Continuation != nil {
		reqQP.Set("continuation", *options.Continuation)
	}
	if options != nil && options.Mode != nil {
		reqQP.Set("mode", string(*options.Mode))
	}
	if options != nil && options.Resource != nil {
		reqQP.Set("resource", string(*options.Resource))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{string(*modifiedAccessConditions.IfMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header["If-Modified-Since"] = []string{modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{string(*modifiedAccessConditions.IfNoneMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header["If-Unmodified-Since"] = []string{modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123)}
	}
	if options != nil && options.ACL != nil {
		req.Raw().Header["x-ms-acl"] = []string{*options.ACL}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.CacheControl != nil {
		req.Raw().Header["x-ms-cache-control"] = []string{*pathHTTPHeaders.CacheControl}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentDisposition != nil {
		req.Raw().Header["x-ms-content-disposition"] = []string{*pathHTTPHeaders.ContentDisposition}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentEncoding != nil {
		req.Raw().Header["x-ms-content-encoding"] = []string{*pathHTTPHeaders.ContentEncoding}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentLanguage != nil {
		req.Raw().Header["x-ms-content-language"] = []string{*pathHTTPHeaders.ContentLanguage}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentType != nil {
		req.Raw().Header["x-ms-content-type"] = []string{*pathHTTPHeaders.ContentType}
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header["x-ms-encryption-algorithm"] = []string{string(*cpkInfo.EncryptionAlgorithm)}
	}
	if options != nil && options.EncryptionContext != nil {
		req.Raw().Header["x-ms-encryption-context"] = []string{*options.EncryptionContext}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header["x-ms-encryption-key"] = []string{*cpkInfo.EncryptionKey}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header["x-ms-encryption-key-sha256"] = []string{*cpkInfo.EncryptionKeySHA256}
	}
	if options != nil && options.ExpiryOptions != nil {
		req.Raw().Header["x-ms-expiry-option"] = []string{string(*options.ExpiryOptions)}
	}
	if options != nil && options.ExpiresOn != nil {
		req.Raw().Header["x-ms-expiry-time"] = []string{*options.ExpiresOn}
	}
	if options != nil && options.Group != nil {
		req.Raw().Header["x-ms-group"] = []string{*options.Group}
	}
	if options != nil && options.LeaseDuration != nil {
		req.Raw().Header["x-ms-lease-duration"] = []string{strconv.FormatInt(*options.LeaseDuration, 10)}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.Owner != nil {
		req.Raw().Header["x-ms-owner"] = []string{*options.Owner}
	}
	if options != nil && options.Permissions != nil {
		req.Raw().Header["x-ms-permissions"] = []string{*options.Permissions}
	}
	if options != nil && options.Properties != nil {
		req.Raw().Header["x-ms-properties"] = []string{*options.Properties}
	}
	if options != nil && options.ProposedLeaseID != nil {
		req.Raw().Header["x-ms-proposed-lease-id"] = []string{*options.ProposedLeaseID}
	}
	if options != nil && options.RenameSource != nil {
		req.Raw().Header["x-ms-rename-source"] = []string{*options.RenameSource}
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfMatch != nil {
		req.Raw().Header["x-ms-source-if-match"] = []string{string(*sourceModifiedAccessConditions.SourceIfMatch)}
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfModifiedSince != nil {
		req.Raw().Header["x-ms-source-if-modified-since"] = []string{sourceModifiedAccessConditions.SourceIfModifiedSince.Format(time.RFC1123)}
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfNoneMatch != nil {
		req.Raw().Header["x-ms-source-if-none-match"] = []string{string(*sourceModifiedAccessConditions.SourceIfNoneMatch)}
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfUnmodifiedSince != nil {
		req.Raw().Header["x-ms-source-if-unmodified-since"] = []string{sourceModifiedAccessConditions.SourceIfUnmodifiedSince.Format(time.RFC1123)}
	}
	if options != nil && options.SourceLeaseID != nil {
		req.Raw().Header["x-ms-source-lease-id"] = []string{*options.SourceLeaseID}
	}
	if options != nil && options.Umask != nil {
		req.Raw().Header["x-ms-umask"] = []string{*options.Umask}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *PathClient) createHandleResponse(resp *http.Response) (PathClientCreateResponse, error) {
	result := PathClientCreateResponse{}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return PathClientCreateResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("x-ms-continuation"); val != "" {
		result.Continuation = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientCreateResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-encryption-key-sha256"); val != "" {
		result.EncryptionKeySHA256 = &val
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return PathClientCreateResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientCreateResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Delete - Delete the file or directory. This operation supports conditional HTTP requests. For more information, see Specifying
// Conditional Headers for Blob Service Operations
// [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - options - PathClientDeleteOptions contains the optional parameters for the PathClient.Delete method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - ModifiedAccessConditions - ModifiedAccessConditions contains a group of parameters for the FileSystemClient.SetProperties
//     method.
func (client *PathClient) Delete(ctx context.Context, options *PathClientDeleteOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (PathClientDeleteResponse, error) {
	var err error
	req, err := client.deleteCreateRequest(ctx, options, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return PathClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return PathClientDeleteResponse{}, err
	}
	resp, err := client.deleteHandleResponse(httpResp)
	return resp, err
}

// deleteCreateRequest creates the Delete request.
func (client *PathClient) deleteCreateRequest(ctx context.Context, options *PathClientDeleteOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodDelete, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Continuation != nil {
		reqQP.Set("continuation", *options.Continuation)
	}
	if options != nil && options.Paginated != nil {
		reqQP.Set("paginated", strconv.FormatBool(*options.Paginated))
	}
	if options != nil && options.Recursive != nil {
		reqQP.Set("recursive", strconv.FormatBool(*options.Recursive))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{string(*modifiedAccessConditions.IfMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header["If-Modified-Since"] = []string{modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{string(*modifiedAccessConditions.IfNoneMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header["If-Unmodified-Since"] = []string{modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123)}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *PathClient) deleteHandleResponse(resp *http.Response) (PathClientDeleteResponse, error) {
	result := PathClientDeleteResponse{}
	if val := resp.Header.Get("x-ms-continuation"); val != "" {
		result.Continuation = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientDeleteResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-deletion-id"); val != "" {
		result.DeletionID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-continuation"); val != "" {
		result.XMSContinuation = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.XMSVersion = &val
	}
	return result, nil
}

// FlushData - Set the owner, group, permissions, or access control list for a path.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - options - PathClientFlushDataOptions contains the optional parameters for the PathClient.FlushData method.
//   - PathHTTPHeaders - PathHTTPHeaders contains a group of parameters for the PathClient.Create method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - ModifiedAccessConditions - ModifiedAccessConditions contains a group of parameters for the FileSystemClient.SetProperties
//     method.
//   - CPKInfo - CPKInfo contains a group of parameters for the PathClient.Create method.
func (client *PathClient) FlushData(ctx context.Context, options *PathClientFlushDataOptions, pathHTTPHeaders *PathHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, cpkInfo *CPKInfo) (PathClientFlushDataResponse, error) {
	var err error
	req, err := client.flushDataCreateRequest(ctx, options, pathHTTPHeaders, leaseAccessConditions, modifiedAccessConditions, cpkInfo)
	if err != nil {
		return PathClientFlushDataResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientFlushDataResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PathClientFlushDataResponse{}, err
	}
	resp, err := client.flushDataHandleResponse(httpResp)
	return resp, err
}

// flushDataCreateRequest creates the FlushData request.
func (client *PathClient) flushDataCreateRequest(ctx context.Context, options *PathClientFlushDataOptions, pathHTTPHeaders *PathHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, cpkInfo *CPKInfo) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPatch, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", "flush")
	if options != nil && options.Close != nil {
		reqQP.Set("close", strconv.FormatBool(*options.Close))
	}
	if options != nil && options.Position != nil {
		reqQP.Set("position", strconv.FormatInt(*options.Position, 10))
	}
	if options != nil && options.RetainUncommittedData != nil {
		reqQP.Set("retainUncommittedData", strconv.FormatBool(*options.RetainUncommittedData))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ContentLength != nil {
		req.Raw().Header["Content-Length"] = []string{strconv.FormatInt(*options.ContentLength, 10)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{string(*modifiedAccessConditions.IfMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header["If-Modified-Since"] = []string{modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{string(*modifiedAccessConditions.IfNoneMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header["If-Unmodified-Since"] = []string{modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123)}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.CacheControl != nil {
		req.Raw().Header["x-ms-cache-control"] = []string{*pathHTTPHeaders.CacheControl}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentDisposition != nil {
		req.Raw().Header["x-ms-content-disposition"] = []string{*pathHTTPHeaders.ContentDisposition}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentEncoding != nil {
		req.Raw().Header["x-ms-content-encoding"] = []string{*pathHTTPHeaders.ContentEncoding}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentLanguage != nil {
		req.Raw().Header["x-ms-content-language"] = []string{*pathHTTPHeaders.ContentLanguage}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentMD5 != nil {
		req.Raw().Header["x-ms-content-md5"] = []string{base64.StdEncoding.EncodeToString(pathHTTPHeaders.ContentMD5)}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentType != nil {
		req.Raw().Header["x-ms-content-type"] = []string{*pathHTTPHeaders.ContentType}
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header["x-ms-encryption-algorithm"] = []string{string(*cpkInfo.EncryptionAlgorithm)}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header["x-ms-encryption-key"] = []string{*cpkInfo.EncryptionKey}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header["x-ms-encryption-key-sha256"] = []string{*cpkInfo.EncryptionKeySHA256}
	}
	if options != nil && options.LeaseAction != nil {
		req.Raw().Header["x-ms-lease-action"] = []string{string(*options.LeaseAction)}
	}
	if options != nil && options.LeaseDuration != nil {
		req.Raw().Header["x-ms-lease-duration"] = []string{strconv.FormatInt(*options.LeaseDuration, 10)}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.ProposedLeaseID != nil {
		req.Raw().Header["x-ms-proposed-lease-id"] = []string{*options.ProposedLeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// flushDataHandleResponse handles the FlushData response.
func (client *PathClient) flushDataHandleResponse(resp *http.Response) (PathClientFlushDataResponse, error) {
	result := PathClientFlushDataResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return PathClientFlushDataResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientFlushDataResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-encryption-key-sha256"); val != "" {
		result.EncryptionKeySHA256 = &val
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return PathClientFlushDataResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientFlushDataResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-renewed"); val != "" {
		leaseRenewed, err := strconv.ParseBool(val)
		if err != nil {
			return PathClientFlushDataResponse{}, err
		}
		result.LeaseRenewed = &leaseRenewed
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// GetProperties - Get Properties returns all system and user defined properties for a path. Get Status returns all system
// defined properties for a path. Get Access Control List returns the access control list for a
// path. This operation supports conditional HTTP requests. For more information, see Specifying Conditional Headers for Blob
// Service Operations
// [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - options - PathClientGetPropertiesOptions contains the optional parameters for the PathClient.GetProperties method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - ModifiedAccessConditions - ModifiedAccessConditions contains a group of parameters for the FileSystemClient.SetProperties
//     method.
func (client *PathClient) GetProperties(ctx context.Context, options *PathClientGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (PathClientGetPropertiesResponse, error) {
	var err error
	req, err := client.getPropertiesCreateRequest(ctx, options, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return PathClientGetPropertiesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientGetPropertiesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PathClientGetPropertiesResponse{}, err
	}
	resp, err := client.getPropertiesHandleResponse(httpResp)
	return resp, err
}

// getPropertiesCreateRequest creates the GetProperties request.
func (client *PathClient) getPropertiesCreateRequest(ctx context.Context, options *PathClientGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodHead, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Action != nil {
		reqQP.Set("action", string(*options.Action))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Upn != nil {
		reqQP.Set("upn", strconv.FormatBool(*options.Upn))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{string(*modifiedAccessConditions.IfMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header["If-Modified-Since"] = []string{modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{string(*modifiedAccessConditions.IfNoneMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header["If-Unmodified-Since"] = []string{modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123)}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// getPropertiesHandleResponse handles the GetProperties response.
func (client *PathClient) getPropertiesHandleResponse(resp *http.Response) (PathClientGetPropertiesResponse, error) {
	result := PathClientGetPropertiesResponse{}
	if val := resp.Header.Get("x-ms-acl"); val != "" {
		result.ACL = &val
	}
	if val := resp.Header.Get("Accept-Ranges"); val != "" {
		result.AcceptRanges = &val
	}
	if val := resp.Header.Get("Cache-Control"); val != "" {
		result.CacheControl = &val
	}
	if val := resp.Header.Get("Content-Disposition"); val != "" {
		result.ContentDisposition = &val
	}
	if val := resp.Header.Get("Content-Encoding"); val != "" {
		result.ContentEncoding = &val
	}
	if val := resp.Header.Get("Content-Language"); val != "" {
		result.ContentLanguage = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return PathClientGetPropertiesResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		result.ContentMD5 = &val
	}
	if val := resp.Header.Get("Content-Range"); val != "" {
		result.ContentRange = &val
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientGetPropertiesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.Group = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientGetPropertiesResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = &val
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = &val
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = &val
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.Owner = &val
	}
	if val := resp.Header.Get("x-ms-permissions"); val != "" {
		result.Permissions = &val
	}
	if val := resp.Header.Get("x-ms-properties"); val != "" {
		result.Properties = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-resource-type"); val != "" {
		result.ResourceType = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Lease - Create and manage a lease to restrict write and delete access to the path. This operation supports conditional
// HTTP requests. For more information, see Specifying Conditional Headers for Blob Service
// Operations [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - xmsLeaseAction - There are five lease actions: "acquire", "break", "change", "renew", and "release". Use "acquire" and
//     specify the "x-ms-proposed-lease-id" and "x-ms-lease-duration" to acquire a new lease. Use "break"
//     to break an existing lease. When a lease is broken, the lease break period is allowed to elapse, during which time no lease
//     operation except break and release can be performed on the file. When a
//     lease is successfully broken, the response indicates the interval in seconds until a new lease can be acquired. Use "change"
//     and specify the current lease ID in "x-ms-lease-id" and the new lease ID in
//     "x-ms-proposed-lease-id" to change the lease ID of an active lease. Use "renew" and specify the "x-ms-lease-id" to renew
//     an existing lease. Use "release" and specify the "x-ms-lease-id" to release a
//     lease.
//   - options - PathClientLeaseOptions contains the optional parameters for the PathClient.Lease method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - ModifiedAccessConditions - ModifiedAccessConditions contains a group of parameters for the FileSystemClient.SetProperties
//     method.
func (client *PathClient) Lease(ctx context.Context, xmsLeaseAction PathLeaseAction, options *PathClientLeaseOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (PathClientLeaseResponse, error) {
	var err error
	req, err := client.leaseCreateRequest(ctx, xmsLeaseAction, options, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return PathClientLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return PathClientLeaseResponse{}, err
	}
	resp, err := client.leaseHandleResponse(httpResp)
	return resp, err
}

// leaseCreateRequest creates the Lease request.
func (client *PathClient) leaseCreateRequest(ctx context.Context, xmsLeaseAction PathLeaseAction, options *PathClientLeaseOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{string(*modifiedAccessConditions.IfMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header["If-Modified-Since"] = []string{modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{string(*modifiedAccessConditions.IfNoneMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header["If-Unmodified-Since"] = []string{modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123)}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["x-ms-lease-action"] = []string{string(xmsLeaseAction)}
	if options != nil && options.XMSLeaseBreakPeriod != nil {
		req.Raw().Header["x-ms-lease-break-period"] = []string{strconv.FormatInt(int64(*options.XMSLeaseBreakPeriod), 10)}
	}
	req.Raw().Header["x-ms-lease-duration"] = []string{strconv.FormatInt(int64(client.xmsLeaseDuration), 10)}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.ProposedLeaseID != nil {
		req.Raw().Header["x-ms-proposed-lease-id"] = []string{*options.ProposedLeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// leaseHandleResponse handles the Lease response.
func (client *PathClient) leaseHandleResponse(resp *http.Response) (PathClientLeaseResponse, error) {
	result := PathClientLeaseResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-lease-time"); val != "" {
		result.LeaseTime = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Read - Read the contents of a file. For read operations, range requests are supported. This operation supports conditional
// HTTP requests. For more information, see Specifying Conditional Headers for Blob
// Service Operations [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - options - PathClientReadOptions contains the optional parameters for the PathClient.Read method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - ModifiedAccessConditions - ModifiedAccessConditions contains a group of parameters for the FileSystemClient.SetProperties
//     method.
//   - CPKInfo - CPKInfo contains a group of parameters for the PathClient.Create method.
func (client *PathClient) Read(ctx context.Context, options *PathClientReadOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, cpkInfo *CPKInfo) (PathClientReadResponse, error) {
	var err error
	req, err := client.readCreateRequest(ctx, options, leaseAccessConditions, modifiedAccessConditions, cpkInfo)
	if err != nil {
		return PathClientReadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientReadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusPartialContent) {
		err = runtime.NewResponseError(httpResp)
		return PathClientReadResponse{}, err
	}
	resp, err := client.readHandleResponse(httpResp)
	return resp, err
}

// readCreateRequest creates the Read request.
func (client *PathClient) readCreateRequest(ctx context.Context, options *PathClientReadOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, cpkInfo *CPKInfo) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/json"}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{string(*modifiedAccessConditions.IfMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header["If-Modified-Since"] = []string{modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{string(*modifiedAccessConditions.IfNoneMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header["If-Unmodified-Since"] = []string{modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123)}
	}
	if options != nil && options.Range != nil {
		req.Raw().Header["Range"] = []string{*options.Range}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if cpkInfo != nil && cpkInfo.EncryptionAlgorithm != nil {
		req.Raw().Header["x-ms-encryption-algorithm"] = []string{string(*cpkInfo.EncryptionAlgorithm)}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKey != nil {
		req.Raw().Header["x-ms-encryption-key"] = []string{*cpkInfo.EncryptionKey}
	}
	if cpkInfo != nil && cpkInfo.EncryptionKeySHA256 != nil {
		req.Raw().Header["x-ms-encryption-key-sha256"] = []string{*cpkInfo.EncryptionKeySHA256}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.XMSRangeGetContentMD5 != nil {
		req.Raw().Header["x-ms-range-get-content-md5"] = []string{strconv.FormatBool(*options.XMSRangeGetContentMD5)}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// readHandleResponse handles the Read response.
func (client *PathClient) readHandleResponse(resp *http.Response) (PathClientReadResponse, error) {
	result := PathClientReadResponse{Body: resp.Body}
	if val := resp.Header.Get("Accept-Ranges"); val != "" {
		result.AcceptRanges = &val
	}
	if val := resp.Header.Get("Cache-Control"); val != "" {
		result.CacheControl = &val
	}
	if val := resp.Header.Get("Content-Disposition"); val != "" {
		result.ContentDisposition = &val
	}
	if val := resp.Header.Get("Content-Encoding"); val != "" {
		result.ContentEncoding = &val
	}
	if val := resp.Header.Get("Content-Language"); val != "" {
		result.ContentLanguage = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return PathClientReadResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		result.ContentMD5 = &val
	}
	if val := resp.Header.Get("Content-Range"); val != "" {
		result.ContentRange = &val
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientReadResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-encryption-key-sha256"); val != "" {
		result.EncryptionKeySHA256 = &val
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return PathClientReadResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientReadResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = &val
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = &val
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = &val
	}
	if val := resp.Header.Get("x-ms-properties"); val != "" {
		result.Properties = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-resource-type"); val != "" {
		result.ResourceType = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-content-md5"); val != "" {
		result.XMSContentMD5 = &val
	}
	return result, nil
}

// SetAccessControl - Set the owner, group, permissions, or access control list for a path.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - options - PathClientSetAccessControlOptions contains the optional parameters for the PathClient.SetAccessControl method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - ModifiedAccessConditions - ModifiedAccessConditions contains a group of parameters for the FileSystemClient.SetProperties
//     method.
func (client *PathClient) SetAccessControl(ctx context.Context, options *PathClientSetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (PathClientSetAccessControlResponse, error) {
	var err error
	req, err := client.setAccessControlCreateRequest(ctx, options, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return PathClientSetAccessControlResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientSetAccessControlResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PathClientSetAccessControlResponse{}, err
	}
	resp, err := client.setAccessControlHandleResponse(httpResp)
	return resp, err
}

// setAccessControlCreateRequest creates the SetAccessControl request.
func (client *PathClient) setAccessControlCreateRequest(ctx context.Context, options *PathClientSetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPatch, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", "setAccessControl")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{string(*modifiedAccessConditions.IfMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header["If-Modified-Since"] = []string{modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{string(*modifiedAccessConditions.IfNoneMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header["If-Unmodified-Since"] = []string{modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123)}
	}
	if options != nil && options.ACL != nil {
		req.Raw().Header["x-ms-acl"] = []string{*options.ACL}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if options != nil && options.Group != nil {
		req.Raw().Header["x-ms-group"] = []string{*options.Group}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.Owner != nil {
		req.Raw().Header["x-ms-owner"] = []string{*options.Owner}
	}
	if options != nil && options.Permissions != nil {
		req.Raw().Header["x-ms-permissions"] = []string{*options.Permissions}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// setAccessControlHandleResponse handles the SetAccessControl response.
func (client *PathClient) setAccessControlHandleResponse(resp *http.Response) (PathClientSetAccessControlResponse, error) {
	result := PathClientSetAccessControlResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientSetAccessControlResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientSetAccessControlResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// SetAccessControlRecursive - Set the access control list for a path and sub-paths.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - mode - Mode "set" sets POSIX access control rights on files and directories, "modify" modifies one or more POSIX access
//     control rights that pre-exist on files and directories, "remove" removes one or more
//     POSIX access control rights that were present earlier on files and directories
//   - options - PathClientSetAccessControlRecursiveOptions contains the optional parameters for the PathClient.SetAccessControlRecursive
//     method.
func (client *PathClient) SetAccessControlRecursive(ctx context.Context, mode PathSetAccessControlRecursiveMode, options *PathClientSetAccessControlRecursiveOptions) (PathClientSetAccessControlRecursiveResponse, error) {
	var err error
	req, err := client.SetAccessControlRecursiveCreateRequest(ctx, mode, options)
	if err != nil {
		return PathClientSetAccessControlRecursiveResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientSetAccessControlRecursiveResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PathClientSetAccessControlRecursiveResponse{}, err
	}
	resp, err := client.SetAccessControlRecursiveHandleResponse(httpResp)
	return resp, err
}

// SetAccessControlRecursiveCreateRequest creates the SetAccessControlRecursive request.
func (client *PathClient) SetAccessControlRecursiveCreateRequest(ctx context.Context, mode PathSetAccessControlRecursiveMode, options *PathClientSetAccessControlRecursiveOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPatch, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", "setAccessControlRecursive")
	if options != nil && options.Continuation != nil {
		reqQP.Set("continuation", *options.Continuation)
	}
	if options != nil && options.ForceFlag != nil {
		reqQP.Set("forceFlag", strconv.FormatBool(*options.ForceFlag))
	}
	if options != nil && options.MaxRecords != nil {
		reqQP.Set("maxRecords", strconv.FormatInt(int64(*options.MaxRecords), 10))
	}
	reqQP.Set("mode", string(mode))
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ACL != nil {
		req.Raw().Header["x-ms-acl"] = []string{*options.ACL}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// SetAccessControlRecursiveHandleResponse handles the SetAccessControlRecursive response.
func (client *PathClient) SetAccessControlRecursiveHandleResponse(resp *http.Response) (PathClientSetAccessControlRecursiveResponse, error) {
	result := PathClientSetAccessControlRecursiveResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-continuation"); val != "" {
		result.Continuation = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientSetAccessControlRecursiveResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.SetAccessControlRecursiveResponse); err != nil {
		return PathClientSetAccessControlRecursiveResponse{}, err
	}
	return result, nil
}

// SetExpiry - Sets the time a blob will expire and be deleted.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - expiryOptions - Required. Indicates mode of the expiry time
//   - options - PathClientSetExpiryOptions contains the optional parameters for the PathClient.SetExpiry method.
func (client *PathClient) SetExpiry(ctx context.Context, expiryOptions ExpiryOptions, options *PathClientSetExpiryOptions) (PathClientSetExpiryResponse, error) {
	var err error
	req, err := client.setExpiryCreateRequest(ctx, expiryOptions, options)
	if err != nil {
		return PathClientSetExpiryResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientSetExpiryResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PathClientSetExpiryResponse{}, err
	}
	resp, err := client.setExpiryHandleResponse(httpResp)
	return resp, err
}

// setExpiryCreateRequest creates the SetExpiry request.
func (client *PathClient) setExpiryCreateRequest(ctx context.Context, expiryOptions ExpiryOptions, options *PathClientSetExpiryOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "expiry")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["x-ms-expiry-option"] = []string{string(expiryOptions)}
	if options != nil && options.ExpiresOn != nil {
		req.Raw().Header["x-ms-expiry-time"] = []string{*options.ExpiresOn}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// setExpiryHandleResponse handles the SetExpiry response.
func (client *PathClient) setExpiryHandleResponse(resp *http.Response) (PathClientSetExpiryResponse, error) {
	result := PathClientSetExpiryResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientSetExpiryResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientSetExpiryResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Undelete - Undelete a path that was previously soft deleted
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - options - PathClientUndeleteOptions contains the optional parameters for the PathClient.Undelete method.
func (client *PathClient) Undelete(ctx context.Context, options *PathClientUndeleteOptions) (PathClientUndeleteResponse, error) {
	var err error
	req, err := client.undeleteCreateRequest(ctx, options)
	if err != nil {
		return PathClientUndeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientUndeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PathClientUndeleteResponse{}, err
	}
	resp, err := client.undeleteHandleResponse(httpResp)
	return resp, err
}

// undeleteCreateRequest creates the Undelete request.
func (client *PathClient) undeleteCreateRequest(ctx context.Context, options *PathClientUndeleteOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "undelete")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if options != nil && options.UndeleteSource != nil {
		req.Raw().Header["x-ms-undelete-source"] = []string{*options.UndeleteSource}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	return req, nil
}

// undeleteHandleResponse handles the Undelete response.
func (client *PathClient) undeleteHandleResponse(resp *http.Response) (PathClientUndeleteResponse, error) {
	result := PathClientUndeleteResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientUndeleteResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-resource-type"); val != "" {
		result.ResourceType = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Update - Uploads data to be appended to a file, flushes (writes) previously uploaded data to a file, sets properties for
// a file or directory, or sets access control for a file or directory. Data can only be
// appended to a file. Concurrent writes to the same file using multiple clients are not supported. This operation supports
// conditional HTTP requests. For more information, see Specifying Conditional
// Headers for Blob Service Operations [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-03
//   - action - The action must be "append" to upload data to be appended to a file, "flush" to flush previously uploaded data
//     to a file, "setProperties" to set the properties of a file or directory,
//     "setAccessControl" to set the owner, group, permissions, or access control list for a file or directory, or "setAccessControlRecursive"
//     to set the access control list for a directory recursively. Note
//     that Hierarchical Namespace must be enabled for the account in order to use access control. Also note that the Access Control
//     List (ACL) includes permissions for the owner, owning group, and others,
//     so the x-ms-permissions and x-ms-acl request headers are mutually exclusive.
//   - mode - Mode "set" sets POSIX access control rights on files and directories, "modify" modifies one or more POSIX access
//     control rights that pre-exist on files and directories, "remove" removes one or more
//     POSIX access control rights that were present earlier on files and directories
//   - body - Initial data
//   - options - PathClientUpdateOptions contains the optional parameters for the PathClient.Update method.
//   - PathHTTPHeaders - PathHTTPHeaders contains a group of parameters for the PathClient.Create method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the PathClient.Create method.
//   - ModifiedAccessConditions - ModifiedAccessConditions contains a group of parameters for the FileSystemClient.SetProperties
//     method.
func (client *PathClient) Update(ctx context.Context, action PathUpdateAction, mode PathSetAccessControlRecursiveMode, body io.ReadSeekCloser, options *PathClientUpdateOptions, pathHTTPHeaders *PathHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (PathClientUpdateResponse, error) {
	var err error
	req, err := client.updateCreateRequest(ctx, action, mode, body, options, pathHTTPHeaders, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return PathClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PathClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return PathClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *PathClient) updateCreateRequest(ctx context.Context, action PathUpdateAction, mode PathSetAccessControlRecursiveMode, body io.ReadSeekCloser, options *PathClientUpdateOptions, pathHTTPHeaders *PathHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPatch, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", string(action))
	if options != nil && options.Close != nil {
		reqQP.Set("close", strconv.FormatBool(*options.Close))
	}
	if options != nil && options.Continuation != nil {
		reqQP.Set("continuation", *options.Continuation)
	}
	if options != nil && options.ForceFlag != nil {
		reqQP.Set("forceFlag", strconv.FormatBool(*options.ForceFlag))
	}
	if options != nil && options.MaxRecords != nil {
		reqQP.Set("maxRecords", strconv.FormatInt(int64(*options.MaxRecords), 10))
	}
	reqQP.Set("mode", string(mode))
	if options != nil && options.Position != nil {
		reqQP.Set("position", strconv.FormatInt(*options.Position, 10))
	}
	if options != nil && options.RetainUncommittedData != nil {
		reqQP.Set("retainUncommittedData", strconv.FormatBool(*options.RetainUncommittedData))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ContentLength != nil {
		req.Raw().Header["Content-Length"] = []string{strconv.FormatInt(*options.ContentLength, 10)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{string(*modifiedAccessConditions.IfMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header["If-Modified-Since"] = []string{modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{string(*modifiedAccessConditions.IfNoneMatch)}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header["If-Unmodified-Since"] = []string{modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123)}
	}
	if options != nil && options.ACL != nil {
		req.Raw().Header["x-ms-acl"] = []string{*options.ACL}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.CacheControl != nil {
		req.Raw().Header["x-ms-cache-control"] = []string{*pathHTTPHeaders.CacheControl}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentDisposition != nil {
		req.Raw().Header["x-ms-content-disposition"] = []string{*pathHTTPHeaders.ContentDisposition}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentEncoding != nil {
		req.Raw().Header["x-ms-content-encoding"] = []string{*pathHTTPHeaders.ContentEncoding}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentLanguage != nil {
		req.Raw().Header["x-ms-content-language"] = []string{*pathHTTPHeaders.ContentLanguage}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentMD5 != nil {
		req.Raw().Header["x-ms-content-md5"] = []string{base64.StdEncoding.EncodeToString(pathHTTPHeaders.ContentMD5)}
	}
	if pathHTTPHeaders != nil && pathHTTPHeaders.ContentType != nil {
		req.Raw().Header["x-ms-content-type"] = []string{*pathHTTPHeaders.ContentType}
	}
	if options != nil && options.Group != nil {
		req.Raw().Header["x-ms-group"] = []string{*options.Group}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.Owner != nil {
		req.Raw().Header["x-ms-owner"] = []string{*options.Owner}
	}
	if options != nil && options.Permissions != nil {
		req.Raw().Header["x-ms-permissions"] = []string{*options.Permissions}
	}
	if options != nil && options.Properties != nil {
		req.Raw().Header["x-ms-properties"] = []string{*options.Properties}
	}
	req.Raw().Header["x-ms-version"] = []string{ServiceVersion}
	if err := req.SetBody(body, "application/octet-stream"); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *PathClient) updateHandleResponse(resp *http.Response) (PathClientUpdateResponse, error) {
	result := PathClientUpdateResponse{}
	if val := resp.Header.Get("Accept-Ranges"); val != "" {
		result.AcceptRanges = &val
	}
	if val := resp.Header.Get("Cache-Control"); val != "" {
		result.CacheControl = &val
	}
	if val := resp.Header.Get("Content-Disposition"); val != "" {
		result.ContentDisposition = &val
	}
	if val := resp.Header.Get("Content-Encoding"); val != "" {
		result.ContentEncoding = &val
	}
	if val := resp.Header.Get("Content-Language"); val != "" {
		result.ContentLanguage = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return PathClientUpdateResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		result.ContentMD5 = &val
	}
	if val := resp.Header.Get("Content-Range"); val != "" {
		result.ContentRange = &val
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientUpdateResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return PathClientUpdateResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-properties"); val != "" {
		result.Properties = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-continuation"); val != "" {
		result.XMSContinuation = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.SetAccessControlRecursiveResponse); err != nil {
		return PathClientUpdateResponse{}, err
	}
	return result, nil
}
