//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstreamanalytics

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AggregateFunctionProperties.
func (a AggregateFunctionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Aggregate"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AggregateFunctionProperties.
func (a *AggregateFunctionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvroSerialization.
func (a AvroSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "properties", a.Properties)
	objectMap["type"] = EventSerializationTypeAvro
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvroSerialization.
func (a *AvroSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerOutputDataSource.
func (a AzureDataExplorerOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Kusto/clusters/databases"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerOutputDataSource.
func (a *AzureDataExplorerOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerOutputDataSourceProperties.
func (a AzureDataExplorerOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", a.AuthenticationMode)
	populate(objectMap, "cluster", a.Cluster)
	populate(objectMap, "database", a.Database)
	populate(objectMap, "table", a.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerOutputDataSourceProperties.
func (a *AzureDataExplorerOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &a.AuthenticationMode)
			delete(rawMsg, key)
		case "cluster":
			err = unpopulate(val, "Cluster", &a.Cluster)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreOutputDataSource.
func (a AzureDataLakeStoreOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.DataLake/Accounts"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreOutputDataSource.
func (a *AzureDataLakeStoreOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreOutputDataSourceProperties.
func (a AzureDataLakeStoreOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "authenticationMode", a.AuthenticationMode)
	populate(objectMap, "dateFormat", a.DateFormat)
	populate(objectMap, "filePathPrefix", a.FilePathPrefix)
	populate(objectMap, "refreshToken", a.RefreshToken)
	populate(objectMap, "tenantId", a.TenantID)
	populate(objectMap, "timeFormat", a.TimeFormat)
	populate(objectMap, "tokenUserDisplayName", a.TokenUserDisplayName)
	populate(objectMap, "tokenUserPrincipalName", a.TokenUserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreOutputDataSourceProperties.
func (a *AzureDataLakeStoreOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &a.AuthenticationMode)
			delete(rawMsg, key)
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &a.DateFormat)
			delete(rawMsg, key)
		case "filePathPrefix":
			err = unpopulate(val, "FilePathPrefix", &a.FilePathPrefix)
			delete(rawMsg, key)
		case "refreshToken":
			err = unpopulate(val, "RefreshToken", &a.RefreshToken)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		case "timeFormat":
			err = unpopulate(val, "TimeFormat", &a.TimeFormat)
			delete(rawMsg, key)
		case "tokenUserDisplayName":
			err = unpopulate(val, "TokenUserDisplayName", &a.TokenUserDisplayName)
			delete(rawMsg, key)
		case "tokenUserPrincipalName":
			err = unpopulate(val, "TokenUserPrincipalName", &a.TokenUserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionOutputDataSource.
func (a AzureFunctionOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.AzureFunction"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionOutputDataSource.
func (a *AzureFunctionOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionOutputDataSourceProperties.
func (a AzureFunctionOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiKey", a.APIKey)
	populate(objectMap, "functionAppName", a.FunctionAppName)
	populate(objectMap, "functionName", a.FunctionName)
	populate(objectMap, "maxBatchCount", a.MaxBatchCount)
	populate(objectMap, "maxBatchSize", a.MaxBatchSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionOutputDataSourceProperties.
func (a *AzureFunctionOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiKey":
			err = unpopulate(val, "APIKey", &a.APIKey)
			delete(rawMsg, key)
		case "functionAppName":
			err = unpopulate(val, "FunctionAppName", &a.FunctionAppName)
			delete(rawMsg, key)
		case "functionName":
			err = unpopulate(val, "FunctionName", &a.FunctionName)
			delete(rawMsg, key)
		case "maxBatchCount":
			err = unpopulate(val, "MaxBatchCount", &a.MaxBatchCount)
			delete(rawMsg, key)
		case "maxBatchSize":
			err = unpopulate(val, "MaxBatchSize", &a.MaxBatchSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningServiceFunctionBinding.
func (a AzureMachineLearningServiceFunctionBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.MachineLearningServices"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningServiceFunctionBinding.
func (a *AzureMachineLearningServiceFunctionBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningServiceFunctionBindingProperties.
func (a AzureMachineLearningServiceFunctionBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiKey", a.APIKey)
	populate(objectMap, "batchSize", a.BatchSize)
	populate(objectMap, "endpoint", a.Endpoint)
	populate(objectMap, "inputRequestName", a.InputRequestName)
	populate(objectMap, "inputs", a.Inputs)
	populate(objectMap, "numberOfParallelRequests", a.NumberOfParallelRequests)
	populate(objectMap, "outputResponseName", a.OutputResponseName)
	populate(objectMap, "outputs", a.Outputs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningServiceFunctionBindingProperties.
func (a *AzureMachineLearningServiceFunctionBindingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiKey":
			err = unpopulate(val, "APIKey", &a.APIKey)
			delete(rawMsg, key)
		case "batchSize":
			err = unpopulate(val, "BatchSize", &a.BatchSize)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "inputRequestName":
			err = unpopulate(val, "InputRequestName", &a.InputRequestName)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &a.Inputs)
			delete(rawMsg, key)
		case "numberOfParallelRequests":
			err = unpopulate(val, "NumberOfParallelRequests", &a.NumberOfParallelRequests)
			delete(rawMsg, key)
		case "outputResponseName":
			err = unpopulate(val, "OutputResponseName", &a.OutputResponseName)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &a.Outputs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningServiceFunctionBindingRetrievalProperties.
func (a AzureMachineLearningServiceFunctionBindingRetrievalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "executeEndpoint", a.ExecuteEndpoint)
	objectMap["udfType"] = "Scalar"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningServiceFunctionBindingRetrievalProperties.
func (a *AzureMachineLearningServiceFunctionBindingRetrievalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "executeEndpoint":
			err = unpopulate(val, "ExecuteEndpoint", &a.ExecuteEndpoint)
			delete(rawMsg, key)
		case "udfType":
			err = unpopulate(val, "UdfType", &a.UdfType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters.
func (a AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bindingRetrievalProperties", a.BindingRetrievalProperties)
	objectMap["bindingType"] = "Microsoft.MachineLearningServices"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters.
func (a *AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingRetrievalProperties":
			err = unpopulate(val, "BindingRetrievalProperties", &a.BindingRetrievalProperties)
			delete(rawMsg, key)
		case "bindingType":
			err = unpopulate(val, "BindingType", &a.BindingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningServiceInputColumn.
func (a AzureMachineLearningServiceInputColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", a.DataType)
	populate(objectMap, "mapTo", a.MapTo)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningServiceInputColumn.
func (a *AzureMachineLearningServiceInputColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &a.DataType)
			delete(rawMsg, key)
		case "mapTo":
			err = unpopulate(val, "MapTo", &a.MapTo)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningServiceInputs.
func (a AzureMachineLearningServiceInputs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columnNames", a.ColumnNames)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningServiceInputs.
func (a *AzureMachineLearningServiceInputs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnNames":
			err = unpopulate(val, "ColumnNames", &a.ColumnNames)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningServiceOutputColumn.
func (a AzureMachineLearningServiceOutputColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", a.DataType)
	populate(objectMap, "mapTo", a.MapTo)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningServiceOutputColumn.
func (a *AzureMachineLearningServiceOutputColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &a.DataType)
			delete(rawMsg, key)
		case "mapTo":
			err = unpopulate(val, "MapTo", &a.MapTo)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningStudioFunctionBinding.
func (a AzureMachineLearningStudioFunctionBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.MachineLearning/WebService"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningStudioFunctionBinding.
func (a *AzureMachineLearningStudioFunctionBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningStudioFunctionBindingProperties.
func (a AzureMachineLearningStudioFunctionBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiKey", a.APIKey)
	populate(objectMap, "batchSize", a.BatchSize)
	populate(objectMap, "endpoint", a.Endpoint)
	populate(objectMap, "inputs", a.Inputs)
	populate(objectMap, "outputs", a.Outputs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningStudioFunctionBindingProperties.
func (a *AzureMachineLearningStudioFunctionBindingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiKey":
			err = unpopulate(val, "APIKey", &a.APIKey)
			delete(rawMsg, key)
		case "batchSize":
			err = unpopulate(val, "BatchSize", &a.BatchSize)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &a.Inputs)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &a.Outputs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningStudioFunctionBindingRetrievalProperties.
func (a AzureMachineLearningStudioFunctionBindingRetrievalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "executeEndpoint", a.ExecuteEndpoint)
	objectMap["udfType"] = "Scalar"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningStudioFunctionBindingRetrievalProperties.
func (a *AzureMachineLearningStudioFunctionBindingRetrievalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "executeEndpoint":
			err = unpopulate(val, "ExecuteEndpoint", &a.ExecuteEndpoint)
			delete(rawMsg, key)
		case "udfType":
			err = unpopulate(val, "UdfType", &a.UdfType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters.
func (a AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bindingRetrievalProperties", a.BindingRetrievalProperties)
	objectMap["bindingType"] = "Microsoft.MachineLearning/WebService"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters.
func (a *AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingRetrievalProperties":
			err = unpopulate(val, "BindingRetrievalProperties", &a.BindingRetrievalProperties)
			delete(rawMsg, key)
		case "bindingType":
			err = unpopulate(val, "BindingType", &a.BindingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningStudioInputColumn.
func (a AzureMachineLearningStudioInputColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", a.DataType)
	populate(objectMap, "mapTo", a.MapTo)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningStudioInputColumn.
func (a *AzureMachineLearningStudioInputColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &a.DataType)
			delete(rawMsg, key)
		case "mapTo":
			err = unpopulate(val, "MapTo", &a.MapTo)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningStudioInputs.
func (a AzureMachineLearningStudioInputs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columnNames", a.ColumnNames)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningStudioInputs.
func (a *AzureMachineLearningStudioInputs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnNames":
			err = unpopulate(val, "ColumnNames", &a.ColumnNames)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningStudioOutputColumn.
func (a AzureMachineLearningStudioOutputColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", a.DataType)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningStudioOutputColumn.
func (a *AzureMachineLearningStudioOutputColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &a.DataType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDatabaseDataSourceProperties.
func (a AzureSQLDatabaseDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", a.AuthenticationMode)
	populate(objectMap, "database", a.Database)
	populate(objectMap, "maxBatchCount", a.MaxBatchCount)
	populate(objectMap, "maxWriterCount", a.MaxWriterCount)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "server", a.Server)
	populate(objectMap, "table", a.Table)
	populate(objectMap, "user", a.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDatabaseDataSourceProperties.
func (a *AzureSQLDatabaseDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &a.AuthenticationMode)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "maxBatchCount":
			err = unpopulate(val, "MaxBatchCount", &a.MaxBatchCount)
			delete(rawMsg, key)
		case "maxWriterCount":
			err = unpopulate(val, "MaxWriterCount", &a.MaxWriterCount)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &a.Server)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &a.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDatabaseOutputDataSource.
func (a AzureSQLDatabaseOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Sql/Server/Database"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDatabaseOutputDataSource.
func (a *AzureSQLDatabaseOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDatabaseOutputDataSourceProperties.
func (a AzureSQLDatabaseOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", a.AuthenticationMode)
	populate(objectMap, "database", a.Database)
	populate(objectMap, "maxBatchCount", a.MaxBatchCount)
	populate(objectMap, "maxWriterCount", a.MaxWriterCount)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "server", a.Server)
	populate(objectMap, "table", a.Table)
	populate(objectMap, "user", a.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDatabaseOutputDataSourceProperties.
func (a *AzureSQLDatabaseOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &a.AuthenticationMode)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "maxBatchCount":
			err = unpopulate(val, "MaxBatchCount", &a.MaxBatchCount)
			delete(rawMsg, key)
		case "maxWriterCount":
			err = unpopulate(val, "MaxWriterCount", &a.MaxWriterCount)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &a.Server)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &a.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLReferenceInputDataSource.
func (a AzureSQLReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Sql/Server/Database"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLReferenceInputDataSource.
func (a *AzureSQLReferenceInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLReferenceInputDataSourceProperties.
func (a AzureSQLReferenceInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", a.AuthenticationMode)
	populate(objectMap, "database", a.Database)
	populate(objectMap, "deltaSnapshotQuery", a.DeltaSnapshotQuery)
	populate(objectMap, "fullSnapshotQuery", a.FullSnapshotQuery)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "refreshRate", a.RefreshRate)
	populate(objectMap, "refreshType", a.RefreshType)
	populate(objectMap, "server", a.Server)
	populate(objectMap, "user", a.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLReferenceInputDataSourceProperties.
func (a *AzureSQLReferenceInputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &a.AuthenticationMode)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "deltaSnapshotQuery":
			err = unpopulate(val, "DeltaSnapshotQuery", &a.DeltaSnapshotQuery)
			delete(rawMsg, key)
		case "fullSnapshotQuery":
			err = unpopulate(val, "FullSnapshotQuery", &a.FullSnapshotQuery)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "refreshRate":
			err = unpopulate(val, "RefreshRate", &a.RefreshRate)
			delete(rawMsg, key)
		case "refreshType":
			err = unpopulate(val, "RefreshType", &a.RefreshType)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &a.Server)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &a.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSynapseDataSourceProperties.
func (a AzureSynapseDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", a.AuthenticationMode)
	populate(objectMap, "database", a.Database)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "server", a.Server)
	populate(objectMap, "table", a.Table)
	populate(objectMap, "user", a.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSynapseDataSourceProperties.
func (a *AzureSynapseDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &a.AuthenticationMode)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &a.Server)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &a.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSynapseOutputDataSource.
func (a AzureSynapseOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Sql/Server/DataWarehouse"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSynapseOutputDataSource.
func (a *AzureSynapseOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSynapseOutputDataSourceProperties.
func (a AzureSynapseOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", a.AuthenticationMode)
	populate(objectMap, "database", a.Database)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "server", a.Server)
	populate(objectMap, "table", a.Table)
	populate(objectMap, "user", a.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSynapseOutputDataSourceProperties.
func (a *AzureSynapseOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &a.AuthenticationMode)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &a.Server)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &a.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableOutputDataSource.
func (a AzureTableOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	objectMap["type"] = "Microsoft.Storage/Table"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableOutputDataSource.
func (a *AzureTableOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableOutputDataSourceProperties.
func (a AzureTableOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", a.AccountKey)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "batchSize", a.BatchSize)
	populate(objectMap, "columnsToRemove", a.ColumnsToRemove)
	populate(objectMap, "partitionKey", a.PartitionKey)
	populate(objectMap, "rowKey", a.RowKey)
	populate(objectMap, "table", a.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableOutputDataSourceProperties.
func (a *AzureTableOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &a.AccountKey)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "batchSize":
			err = unpopulate(val, "BatchSize", &a.BatchSize)
			delete(rawMsg, key)
		case "columnsToRemove":
			err = unpopulate(val, "ColumnsToRemove", &a.ColumnsToRemove)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &a.PartitionKey)
			delete(rawMsg, key)
		case "rowKey":
			err = unpopulate(val, "RowKey", &a.RowKey)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobDataSourceProperties.
func (b BlobDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", b.AuthenticationMode)
	populate(objectMap, "container", b.Container)
	populate(objectMap, "dateFormat", b.DateFormat)
	populate(objectMap, "pathPattern", b.PathPattern)
	populate(objectMap, "storageAccounts", b.StorageAccounts)
	populate(objectMap, "timeFormat", b.TimeFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobDataSourceProperties.
func (b *BlobDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &b.AuthenticationMode)
			delete(rawMsg, key)
		case "container":
			err = unpopulate(val, "Container", &b.Container)
			delete(rawMsg, key)
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &b.DateFormat)
			delete(rawMsg, key)
		case "pathPattern":
			err = unpopulate(val, "PathPattern", &b.PathPattern)
			delete(rawMsg, key)
		case "storageAccounts":
			err = unpopulate(val, "StorageAccounts", &b.StorageAccounts)
			delete(rawMsg, key)
		case "timeFormat":
			err = unpopulate(val, "TimeFormat", &b.TimeFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobOutputDataSource.
func (b BlobOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", b.Properties)
	objectMap["type"] = "Microsoft.Storage/Blob"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobOutputDataSource.
func (b *BlobOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobOutputDataSourceProperties.
func (b BlobOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", b.AuthenticationMode)
	populate(objectMap, "blobPathPrefix", b.BlobPathPrefix)
	populate(objectMap, "blobWriteMode", b.BlobWriteMode)
	populate(objectMap, "container", b.Container)
	populate(objectMap, "dateFormat", b.DateFormat)
	populate(objectMap, "pathPattern", b.PathPattern)
	populate(objectMap, "storageAccounts", b.StorageAccounts)
	populate(objectMap, "timeFormat", b.TimeFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobOutputDataSourceProperties.
func (b *BlobOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &b.AuthenticationMode)
			delete(rawMsg, key)
		case "blobPathPrefix":
			err = unpopulate(val, "BlobPathPrefix", &b.BlobPathPrefix)
			delete(rawMsg, key)
		case "blobWriteMode":
			err = unpopulate(val, "BlobWriteMode", &b.BlobWriteMode)
			delete(rawMsg, key)
		case "container":
			err = unpopulate(val, "Container", &b.Container)
			delete(rawMsg, key)
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &b.DateFormat)
			delete(rawMsg, key)
		case "pathPattern":
			err = unpopulate(val, "PathPattern", &b.PathPattern)
			delete(rawMsg, key)
		case "storageAccounts":
			err = unpopulate(val, "StorageAccounts", &b.StorageAccounts)
			delete(rawMsg, key)
		case "timeFormat":
			err = unpopulate(val, "TimeFormat", &b.TimeFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobReferenceInputDataSource.
func (b BlobReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", b.Properties)
	objectMap["type"] = "Microsoft.Storage/Blob"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobReferenceInputDataSource.
func (b *BlobReferenceInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobReferenceInputDataSourceProperties.
func (b BlobReferenceInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", b.AuthenticationMode)
	populate(objectMap, "blobName", b.BlobName)
	populate(objectMap, "container", b.Container)
	populate(objectMap, "dateFormat", b.DateFormat)
	populate(objectMap, "deltaPathPattern", b.DeltaPathPattern)
	populate(objectMap, "deltaSnapshotRefreshRate", b.DeltaSnapshotRefreshRate)
	populate(objectMap, "fullSnapshotRefreshRate", b.FullSnapshotRefreshRate)
	populate(objectMap, "pathPattern", b.PathPattern)
	populate(objectMap, "sourcePartitionCount", b.SourcePartitionCount)
	populate(objectMap, "storageAccounts", b.StorageAccounts)
	populate(objectMap, "timeFormat", b.TimeFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobReferenceInputDataSourceProperties.
func (b *BlobReferenceInputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &b.AuthenticationMode)
			delete(rawMsg, key)
		case "blobName":
			err = unpopulate(val, "BlobName", &b.BlobName)
			delete(rawMsg, key)
		case "container":
			err = unpopulate(val, "Container", &b.Container)
			delete(rawMsg, key)
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &b.DateFormat)
			delete(rawMsg, key)
		case "deltaPathPattern":
			err = unpopulate(val, "DeltaPathPattern", &b.DeltaPathPattern)
			delete(rawMsg, key)
		case "deltaSnapshotRefreshRate":
			err = unpopulate(val, "DeltaSnapshotRefreshRate", &b.DeltaSnapshotRefreshRate)
			delete(rawMsg, key)
		case "fullSnapshotRefreshRate":
			err = unpopulate(val, "FullSnapshotRefreshRate", &b.FullSnapshotRefreshRate)
			delete(rawMsg, key)
		case "pathPattern":
			err = unpopulate(val, "PathPattern", &b.PathPattern)
			delete(rawMsg, key)
		case "sourcePartitionCount":
			err = unpopulate(val, "SourcePartitionCount", &b.SourcePartitionCount)
			delete(rawMsg, key)
		case "storageAccounts":
			err = unpopulate(val, "StorageAccounts", &b.StorageAccounts)
			delete(rawMsg, key)
		case "timeFormat":
			err = unpopulate(val, "TimeFormat", &b.TimeFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobStreamInputDataSource.
func (b BlobStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", b.Properties)
	objectMap["type"] = "Microsoft.Storage/Blob"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobStreamInputDataSource.
func (b *BlobStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobStreamInputDataSourceProperties.
func (b BlobStreamInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", b.AuthenticationMode)
	populate(objectMap, "container", b.Container)
	populate(objectMap, "dateFormat", b.DateFormat)
	populate(objectMap, "pathPattern", b.PathPattern)
	populate(objectMap, "sourcePartitionCount", b.SourcePartitionCount)
	populate(objectMap, "storageAccounts", b.StorageAccounts)
	populate(objectMap, "timeFormat", b.TimeFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobStreamInputDataSourceProperties.
func (b *BlobStreamInputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &b.AuthenticationMode)
			delete(rawMsg, key)
		case "container":
			err = unpopulate(val, "Container", &b.Container)
			delete(rawMsg, key)
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &b.DateFormat)
			delete(rawMsg, key)
		case "pathPattern":
			err = unpopulate(val, "PathPattern", &b.PathPattern)
			delete(rawMsg, key)
		case "sourcePartitionCount":
			err = unpopulate(val, "SourcePartitionCount", &b.SourcePartitionCount)
			delete(rawMsg, key)
		case "storageAccounts":
			err = unpopulate(val, "StorageAccounts", &b.StorageAccounts)
			delete(rawMsg, key)
		case "timeFormat":
			err = unpopulate(val, "TimeFormat", &b.TimeFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CSVSerialization.
func (c CSVSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	objectMap["type"] = EventSerializationTypeCSV
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CSVSerialization.
func (c *CSVSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CSVSerializationProperties.
func (c CSVSerializationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encoding", c.Encoding)
	populate(objectMap, "fieldDelimiter", c.FieldDelimiter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CSVSerializationProperties.
func (c *CSVSerializationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encoding":
			err = unpopulate(val, "Encoding", &c.Encoding)
			delete(rawMsg, key)
		case "fieldDelimiter":
			err = unpopulate(val, "FieldDelimiter", &c.FieldDelimiter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CSharpFunctionBinding.
func (c CSharpFunctionBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	objectMap["type"] = "Microsoft.StreamAnalytics/CLRUdf"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CSharpFunctionBinding.
func (c *CSharpFunctionBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CSharpFunctionBindingProperties.
func (c CSharpFunctionBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "class", c.Class)
	populate(objectMap, "dllPath", c.DllPath)
	populate(objectMap, "method", c.Method)
	populate(objectMap, "updateMode", c.UpdateMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CSharpFunctionBindingProperties.
func (c *CSharpFunctionBindingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "class":
			err = unpopulate(val, "Class", &c.Class)
			delete(rawMsg, key)
		case "dllPath":
			err = unpopulate(val, "DllPath", &c.DllPath)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &c.Method)
			delete(rawMsg, key)
		case "updateMode":
			err = unpopulate(val, "UpdateMode", &c.UpdateMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CSharpFunctionBindingRetrievalProperties.
func (c CSharpFunctionBindingRetrievalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "script", c.Script)
	objectMap["udfType"] = "Scalar"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CSharpFunctionBindingRetrievalProperties.
func (c *CSharpFunctionBindingRetrievalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "script":
			err = unpopulate(val, "Script", &c.Script)
			delete(rawMsg, key)
		case "udfType":
			err = unpopulate(val, "UdfType", &c.UdfType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CSharpFunctionRetrieveDefaultDefinitionParameters.
func (c CSharpFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bindingRetrievalProperties", c.BindingRetrievalProperties)
	objectMap["bindingType"] = "Microsoft.StreamAnalytics/CLRUdf"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CSharpFunctionRetrieveDefaultDefinitionParameters.
func (c *CSharpFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingRetrievalProperties":
			err = unpopulate(val, "BindingRetrievalProperties", &c.BindingRetrievalProperties)
			delete(rawMsg, key)
		case "bindingType":
			err = unpopulate(val, "BindingType", &c.BindingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Cluster.
func (c *Cluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterInfo.
func (c ClusterInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterInfo.
func (c *ClusterInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterJob.
func (c ClusterJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "jobState", c.JobState)
	populate(objectMap, "streamingUnits", c.StreamingUnits)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterJob.
func (c *ClusterJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "jobState":
			err = unpopulate(val, "JobState", &c.JobState)
			delete(rawMsg, key)
		case "streamingUnits":
			err = unpopulate(val, "StreamingUnits", &c.StreamingUnits)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterJobListResult.
func (c ClusterJobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterJobListResult.
func (c *ClusterJobListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterListResult.
func (c ClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterListResult.
func (c *ClusterListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterProperties.
func (c ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityAllocated", c.CapacityAllocated)
	populate(objectMap, "capacityAssigned", c.CapacityAssigned)
	populate(objectMap, "clusterId", c.ClusterID)
	populateDateTimeRFC3339(objectMap, "createdDate", c.CreatedDate)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterProperties.
func (c *ClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityAllocated":
			err = unpopulate(val, "CapacityAllocated", &c.CapacityAllocated)
			delete(rawMsg, key)
		case "capacityAssigned":
			err = unpopulate(val, "CapacityAssigned", &c.CapacityAssigned)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &c.ClusterID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &c.CreatedDate)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterSKU.
func (c ClusterSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", c.Capacity)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterSKU.
func (c *ClusterSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &c.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CompileQuery.
func (c CompileQuery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compatibilityLevel", c.CompatibilityLevel)
	populate(objectMap, "functions", c.Functions)
	populate(objectMap, "inputs", c.Inputs)
	populate(objectMap, "jobType", c.JobType)
	populate(objectMap, "query", c.Query)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CompileQuery.
func (c *CompileQuery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compatibilityLevel":
			err = unpopulate(val, "CompatibilityLevel", &c.CompatibilityLevel)
			delete(rawMsg, key)
		case "functions":
			err = unpopulate(val, "Functions", &c.Functions)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &c.Inputs)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &c.JobType)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &c.Query)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Compression.
func (c Compression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Compression.
func (c *Compression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomClrSerialization.
func (c CustomClrSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	objectMap["type"] = EventSerializationTypeCustomClr
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomClrSerialization.
func (c *CustomClrSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomClrSerializationProperties.
func (c CustomClrSerializationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serializationClassName", c.SerializationClassName)
	populate(objectMap, "serializationDllPath", c.SerializationDllPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomClrSerializationProperties.
func (c *CustomClrSerializationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serializationClassName":
			err = unpopulate(val, "SerializationClassName", &c.SerializationClassName)
			delete(rawMsg, key)
		case "serializationDllPath":
			err = unpopulate(val, "SerializationDllPath", &c.SerializationDllPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeltaSerialization.
func (d DeltaSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	objectMap["type"] = EventSerializationTypeDelta
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeltaSerialization.
func (d *DeltaSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeltaSerializationProperties.
func (d DeltaSerializationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deltaTablePath", d.DeltaTablePath)
	populate(objectMap, "partitionColumns", d.PartitionColumns)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeltaSerializationProperties.
func (d *DeltaSerializationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deltaTablePath":
			err = unpopulate(val, "DeltaTablePath", &d.DeltaTablePath)
			delete(rawMsg, key)
		case "partitionColumns":
			err = unpopulate(val, "PartitionColumns", &d.PartitionColumns)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticCondition.
func (d DiagnosticCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "since", d.Since)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticCondition.
func (d *DiagnosticCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "since":
			err = unpopulate(val, "Since", &d.Since)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Diagnostics.
func (d Diagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "conditions", d.Conditions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Diagnostics.
func (d *Diagnostics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conditions":
			err = unpopulate(val, "Conditions", &d.Conditions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentDbOutputDataSource.
func (d DocumentDbOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	objectMap["type"] = "Microsoft.Storage/DocumentDB"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentDbOutputDataSource.
func (d *DocumentDbOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentDbOutputDataSourceProperties.
func (d DocumentDbOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountId", d.AccountID)
	populate(objectMap, "accountKey", d.AccountKey)
	populate(objectMap, "authenticationMode", d.AuthenticationMode)
	populate(objectMap, "collectionNamePattern", d.CollectionNamePattern)
	populate(objectMap, "database", d.Database)
	populate(objectMap, "documentId", d.DocumentID)
	populate(objectMap, "partitionKey", d.PartitionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentDbOutputDataSourceProperties.
func (d *DocumentDbOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &d.AccountID)
			delete(rawMsg, key)
		case "accountKey":
			err = unpopulate(val, "AccountKey", &d.AccountKey)
			delete(rawMsg, key)
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &d.AuthenticationMode)
			delete(rawMsg, key)
		case "collectionNamePattern":
			err = unpopulate(val, "CollectionNamePattern", &d.CollectionNamePattern)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &d.Database)
			delete(rawMsg, key)
		case "documentId":
			err = unpopulate(val, "DocumentID", &d.DocumentID)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &d.PartitionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorError.
func (e ErrorError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorError.
func (e *ErrorError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridStreamInputDataSource.
func (e EventGridStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.EventGrid/EventSubscriptions"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridStreamInputDataSource.
func (e *EventGridStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridStreamInputDataSourceProperties.
func (e EventGridStreamInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventTypes", e.EventTypes)
	populate(objectMap, "schema", e.Schema)
	populate(objectMap, "storageAccounts", e.StorageAccounts)
	populate(objectMap, "subscriber", e.Subscriber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridStreamInputDataSourceProperties.
func (e *EventGridStreamInputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventTypes":
			err = unpopulate(val, "EventTypes", &e.EventTypes)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &e.Schema)
			delete(rawMsg, key)
		case "storageAccounts":
			err = unpopulate(val, "StorageAccounts", &e.StorageAccounts)
			delete(rawMsg, key)
		case "subscriber":
			err = unpopulate(val, "Subscriber", &e.Subscriber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubDataSourceProperties.
func (e EventHubDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", e.AuthenticationMode)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "partitionCount", e.PartitionCount)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", e.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", e.SharedAccessPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubDataSourceProperties.
func (e *EventHubDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &e.AuthenticationMode)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "partitionCount":
			err = unpopulate(val, "PartitionCount", &e.PartitionCount)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "sharedAccessPolicyKey":
			err = unpopulate(val, "SharedAccessPolicyKey", &e.SharedAccessPolicyKey)
			delete(rawMsg, key)
		case "sharedAccessPolicyName":
			err = unpopulate(val, "SharedAccessPolicyName", &e.SharedAccessPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubOutputDataSource.
func (e EventHubOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.ServiceBus/EventHub"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubOutputDataSource.
func (e *EventHubOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubOutputDataSourceProperties.
func (e EventHubOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", e.AuthenticationMode)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "partitionCount", e.PartitionCount)
	populate(objectMap, "partitionKey", e.PartitionKey)
	populate(objectMap, "propertyColumns", e.PropertyColumns)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", e.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", e.SharedAccessPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubOutputDataSourceProperties.
func (e *EventHubOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &e.AuthenticationMode)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "partitionCount":
			err = unpopulate(val, "PartitionCount", &e.PartitionCount)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &e.PartitionKey)
			delete(rawMsg, key)
		case "propertyColumns":
			err = unpopulate(val, "PropertyColumns", &e.PropertyColumns)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "sharedAccessPolicyKey":
			err = unpopulate(val, "SharedAccessPolicyKey", &e.SharedAccessPolicyKey)
			delete(rawMsg, key)
		case "sharedAccessPolicyName":
			err = unpopulate(val, "SharedAccessPolicyName", &e.SharedAccessPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubStreamInputDataSource.
func (e EventHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.ServiceBus/EventHub"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubStreamInputDataSource.
func (e *EventHubStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubStreamInputDataSourceProperties.
func (e EventHubStreamInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", e.AuthenticationMode)
	populate(objectMap, "consumerGroupName", e.ConsumerGroupName)
	populate(objectMap, "eventHubName", e.EventHubName)
	populate(objectMap, "partitionCount", e.PartitionCount)
	populate(objectMap, "prefetchCount", e.PrefetchCount)
	populate(objectMap, "serviceBusNamespace", e.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", e.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", e.SharedAccessPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubStreamInputDataSourceProperties.
func (e *EventHubStreamInputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &e.AuthenticationMode)
			delete(rawMsg, key)
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &e.ConsumerGroupName)
			delete(rawMsg, key)
		case "eventHubName":
			err = unpopulate(val, "EventHubName", &e.EventHubName)
			delete(rawMsg, key)
		case "partitionCount":
			err = unpopulate(val, "PartitionCount", &e.PartitionCount)
			delete(rawMsg, key)
		case "prefetchCount":
			err = unpopulate(val, "PrefetchCount", &e.PrefetchCount)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &e.ServiceBusNamespace)
			delete(rawMsg, key)
		case "sharedAccessPolicyKey":
			err = unpopulate(val, "SharedAccessPolicyKey", &e.SharedAccessPolicyKey)
			delete(rawMsg, key)
		case "sharedAccessPolicyName":
			err = unpopulate(val, "SharedAccessPolicyName", &e.SharedAccessPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubV2OutputDataSource.
func (e EventHubV2OutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.EventHub/EventHub"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubV2OutputDataSource.
func (e *EventHubV2OutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubV2StreamInputDataSource.
func (e EventHubV2StreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	objectMap["type"] = "Microsoft.EventHub/EventHub"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubV2StreamInputDataSource.
func (e *EventHubV2StreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type External.
func (e External) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "container", e.Container)
	populate(objectMap, "path", e.Path)
	populate(objectMap, "refreshConfiguration", e.RefreshConfiguration)
	populate(objectMap, "storageAccount", e.StorageAccount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type External.
func (e *External) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "container":
			err = unpopulate(val, "Container", &e.Container)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &e.Path)
			delete(rawMsg, key)
		case "refreshConfiguration":
			err = unpopulate(val, "RefreshConfiguration", &e.RefreshConfiguration)
			delete(rawMsg, key)
		case "storageAccount":
			err = unpopulate(val, "StorageAccount", &e.StorageAccount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileReferenceInputDataSource.
func (f FileReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", f.Properties)
	objectMap["type"] = "File"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileReferenceInputDataSource.
func (f *FileReferenceInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileReferenceInputDataSourceProperties.
func (f FileReferenceInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "path", f.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileReferenceInputDataSourceProperties.
func (f *FileReferenceInputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "path":
			err = unpopulate(val, "Path", &f.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Function.
func (f Function) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Function.
func (f *Function) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			f.Properties, err = unmarshalFunctionPropertiesClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionBinding.
func (f FunctionBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = f.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionBinding.
func (f *FunctionBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionConfiguration.
func (f FunctionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "binding", f.Binding)
	populate(objectMap, "inputs", f.Inputs)
	populate(objectMap, "output", f.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionConfiguration.
func (f *FunctionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "binding":
			f.Binding, err = unmarshalFunctionBindingClassification(val)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &f.Inputs)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &f.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionInput.
func (f FunctionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", f.DataType)
	populate(objectMap, "isConfigurationParameter", f.IsConfigurationParameter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionInput.
func (f *FunctionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &f.DataType)
			delete(rawMsg, key)
		case "isConfigurationParameter":
			err = unpopulate(val, "IsConfigurationParameter", &f.IsConfigurationParameter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionListResult.
func (f FunctionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionListResult.
func (f *FunctionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionOutput.
func (f FunctionOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", f.DataType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionOutput.
func (f *FunctionOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &f.DataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionProperties.
func (f FunctionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "properties", f.Properties)
	objectMap["type"] = f.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionProperties.
func (f *FunctionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionRetrieveDefaultDefinitionParameters.
func (f FunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["bindingType"] = f.BindingType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionRetrieveDefaultDefinitionParameters.
func (f *FunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingType":
			err = unpopulate(val, "BindingType", &f.BindingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayMessageBusOutputDataSource.
func (g GatewayMessageBusOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", g.Properties)
	objectMap["type"] = "GatewayMessageBus"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayMessageBusOutputDataSource.
func (g *GatewayMessageBusOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayMessageBusOutputDataSourceProperties.
func (g GatewayMessageBusOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "topic", g.Topic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayMessageBusOutputDataSourceProperties.
func (g *GatewayMessageBusOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "topic":
			err = unpopulate(val, "Topic", &g.Topic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayMessageBusSourceProperties.
func (g GatewayMessageBusSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "topic", g.Topic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayMessageBusSourceProperties.
func (g *GatewayMessageBusSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "topic":
			err = unpopulate(val, "Topic", &g.Topic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayMessageBusStreamInputDataSource.
func (g GatewayMessageBusStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", g.Properties)
	objectMap["type"] = "GatewayMessageBus"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayMessageBusStreamInputDataSource.
func (g *GatewayMessageBusStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayMessageBusStreamInputDataSourceProperties.
func (g GatewayMessageBusStreamInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "topic", g.Topic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayMessageBusStreamInputDataSourceProperties.
func (g *GatewayMessageBusStreamInputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "topic":
			err = unpopulate(val, "Topic", &g.Topic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetStreamingJobSKUResult.
func (g GetStreamingJobSKUResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", g.Capacity)
	populate(objectMap, "resourceType", g.ResourceType)
	populate(objectMap, "sku", g.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetStreamingJobSKUResult.
func (g *GetStreamingJobSKUResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &g.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &g.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetStreamingJobSKUResultSKU.
func (g GetStreamingJobSKUResultSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", g.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetStreamingJobSKUResultSKU.
func (g *GetStreamingJobSKUResultSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetStreamingJobSKUResults.
func (g GetStreamingJobSKUResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetStreamingJobSKUResults.
func (g *GetStreamingJobSKUResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identity.
func (i *Identity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &i.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &i.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Input.
func (i Input) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Input.
func (i *Input) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalInputPropertiesClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InputListResult.
func (i InputListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InputListResult.
func (i *InputListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InputProperties.
func (i InputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", i.Compression)
	populate(objectMap, "diagnostics", i.Diagnostics)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "partitionKey", i.PartitionKey)
	populate(objectMap, "serialization", i.Serialization)
	objectMap["type"] = i.Type
	populate(objectMap, "watermarkSettings", i.WatermarkSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InputProperties.
func (i *InputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &i.Compression)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &i.Diagnostics)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &i.PartitionKey)
			delete(rawMsg, key)
		case "serialization":
			i.Serialization, err = unmarshalSerializationClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "watermarkSettings":
			err = unpopulate(val, "WatermarkSettings", &i.WatermarkSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InputWatermarkProperties.
func (i InputWatermarkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "watermarkMode", i.WatermarkMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InputWatermarkProperties.
func (i *InputWatermarkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "watermarkMode":
			err = unpopulate(val, "WatermarkMode", &i.WatermarkMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubStreamInputDataSource.
func (i IoTHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", i.Properties)
	objectMap["type"] = "Microsoft.Devices/IotHubs"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubStreamInputDataSource.
func (i *IoTHubStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTHubStreamInputDataSourceProperties.
func (i IoTHubStreamInputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumerGroupName", i.ConsumerGroupName)
	populate(objectMap, "endpoint", i.Endpoint)
	populate(objectMap, "iotHubNamespace", i.IotHubNamespace)
	populate(objectMap, "sharedAccessPolicyKey", i.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", i.SharedAccessPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTHubStreamInputDataSourceProperties.
func (i *IoTHubStreamInputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumerGroupName":
			err = unpopulate(val, "ConsumerGroupName", &i.ConsumerGroupName)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &i.Endpoint)
			delete(rawMsg, key)
		case "iotHubNamespace":
			err = unpopulate(val, "IotHubNamespace", &i.IotHubNamespace)
			delete(rawMsg, key)
		case "sharedAccessPolicyKey":
			err = unpopulate(val, "SharedAccessPolicyKey", &i.SharedAccessPolicyKey)
			delete(rawMsg, key)
		case "sharedAccessPolicyName":
			err = unpopulate(val, "SharedAccessPolicyName", &i.SharedAccessPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONSerialization.
func (j JSONSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", j.Properties)
	objectMap["type"] = EventSerializationTypeJSON
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONSerialization.
func (j *JSONSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONSerializationProperties.
func (j JSONSerializationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encoding", j.Encoding)
	populate(objectMap, "format", j.Format)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONSerializationProperties.
func (j *JSONSerializationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encoding":
			err = unpopulate(val, "Encoding", &j.Encoding)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &j.Format)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaScriptFunctionBinding.
func (j JavaScriptFunctionBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", j.Properties)
	objectMap["type"] = "Microsoft.StreamAnalytics/JavascriptUdf"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaScriptFunctionBinding.
func (j *JavaScriptFunctionBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaScriptFunctionBindingProperties.
func (j JavaScriptFunctionBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "script", j.Script)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaScriptFunctionBindingProperties.
func (j *JavaScriptFunctionBindingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "script":
			err = unpopulate(val, "Script", &j.Script)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaScriptFunctionBindingRetrievalProperties.
func (j JavaScriptFunctionBindingRetrievalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "script", j.Script)
	objectMap["udfType"] = "Scalar"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaScriptFunctionBindingRetrievalProperties.
func (j *JavaScriptFunctionBindingRetrievalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "script":
			err = unpopulate(val, "Script", &j.Script)
			delete(rawMsg, key)
		case "udfType":
			err = unpopulate(val, "UdfType", &j.UdfType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (j JavaScriptFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bindingRetrievalProperties", j.BindingRetrievalProperties)
	objectMap["bindingType"] = "Microsoft.StreamAnalytics/JavascriptUdf"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (j *JavaScriptFunctionRetrieveDefaultDefinitionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingRetrievalProperties":
			err = unpopulate(val, "BindingRetrievalProperties", &j.BindingRetrievalProperties)
			delete(rawMsg, key)
		case "bindingType":
			err = unpopulate(val, "BindingType", &j.BindingType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStorageAccount.
func (j JobStorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", j.AccountKey)
	populate(objectMap, "accountName", j.AccountName)
	populate(objectMap, "authenticationMode", j.AuthenticationMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStorageAccount.
func (j *JobStorageAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &j.AccountKey)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &j.AccountName)
			delete(rawMsg, key)
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &j.AuthenticationMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LastOutputEventTimestamp.
func (l LastOutputEventTimestamp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lastOutputEventTime", l.LastOutputEventTime)
	populate(objectMap, "lastUpdateTime", l.LastUpdateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LastOutputEventTimestamp.
func (l *LastOutputEventTimestamp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastOutputEventTime":
			err = unpopulate(val, "LastOutputEventTime", &l.LastOutputEventTime)
			delete(rawMsg, key)
		case "lastUpdateTime":
			err = unpopulate(val, "LastUpdateTime", &l.LastUpdateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OAuthBasedDataSourceProperties.
func (o OAuthBasedDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "refreshToken", o.RefreshToken)
	populate(objectMap, "tokenUserDisplayName", o.TokenUserDisplayName)
	populate(objectMap, "tokenUserPrincipalName", o.TokenUserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OAuthBasedDataSourceProperties.
func (o *OAuthBasedDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "refreshToken":
			err = unpopulate(val, "RefreshToken", &o.RefreshToken)
			delete(rawMsg, key)
		case "tokenUserDisplayName":
			err = unpopulate(val, "TokenUserDisplayName", &o.TokenUserDisplayName)
			delete(rawMsg, key)
		case "tokenUserPrincipalName":
			err = unpopulate(val, "TokenUserPrincipalName", &o.TokenUserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Output.
func (o Output) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Output.
func (o *Output) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutputDataSource.
func (o OutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = o.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutputDataSource.
func (o *OutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutputListResult.
func (o OutputListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutputListResult.
func (o *OutputListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutputProperties.
func (o OutputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasource", o.Datasource)
	populate(objectMap, "diagnostics", o.Diagnostics)
	populate(objectMap, "etag", o.Etag)
	populate(objectMap, "lastOutputEventTimestamps", o.LastOutputEventTimestamps)
	populate(objectMap, "serialization", o.Serialization)
	populate(objectMap, "sizeWindow", o.SizeWindow)
	populate(objectMap, "timeWindow", o.TimeWindow)
	populate(objectMap, "watermarkSettings", o.WatermarkSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutputProperties.
func (o *OutputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasource":
			o.Datasource, err = unmarshalOutputDataSourceClassification(val)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &o.Diagnostics)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &o.Etag)
			delete(rawMsg, key)
		case "lastOutputEventTimestamps":
			err = unpopulate(val, "LastOutputEventTimestamps", &o.LastOutputEventTimestamps)
			delete(rawMsg, key)
		case "serialization":
			o.Serialization, err = unmarshalSerializationClassification(val)
			delete(rawMsg, key)
		case "sizeWindow":
			err = unpopulate(val, "SizeWindow", &o.SizeWindow)
			delete(rawMsg, key)
		case "timeWindow":
			err = unpopulate(val, "TimeWindow", &o.TimeWindow)
			delete(rawMsg, key)
		case "watermarkSettings":
			err = unpopulate(val, "WatermarkSettings", &o.WatermarkSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutputWatermarkProperties.
func (o OutputWatermarkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxWatermarkDifferenceAcrossPartitions", o.MaxWatermarkDifferenceAcrossPartitions)
	populate(objectMap, "watermarkMode", o.WatermarkMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutputWatermarkProperties.
func (o *OutputWatermarkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxWatermarkDifferenceAcrossPartitions":
			err = unpopulate(val, "MaxWatermarkDifferenceAcrossPartitions", &o.MaxWatermarkDifferenceAcrossPartitions)
			delete(rawMsg, key)
		case "watermarkMode":
			err = unpopulate(val, "WatermarkMode", &o.WatermarkMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ParquetSerialization.
func (p ParquetSerialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "properties", p.Properties)
	objectMap["type"] = EventSerializationTypeParquet
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ParquetSerialization.
func (p *ParquetSerialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostgreSQLDataSourceProperties.
func (p PostgreSQLDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", p.AuthenticationMode)
	populate(objectMap, "database", p.Database)
	populate(objectMap, "maxWriterCount", p.MaxWriterCount)
	populate(objectMap, "password", p.Password)
	populate(objectMap, "server", p.Server)
	populate(objectMap, "table", p.Table)
	populate(objectMap, "user", p.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostgreSQLDataSourceProperties.
func (p *PostgreSQLDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &p.AuthenticationMode)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &p.Database)
			delete(rawMsg, key)
		case "maxWriterCount":
			err = unpopulate(val, "MaxWriterCount", &p.MaxWriterCount)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &p.Password)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &p.Server)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &p.Table)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &p.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostgreSQLOutputDataSource.
func (p PostgreSQLOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	objectMap["type"] = "Microsoft.DBForPostgreSQL/servers/databases"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostgreSQLOutputDataSource.
func (p *PostgreSQLOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostgreSQLOutputDataSourceProperties.
func (p PostgreSQLOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", p.AuthenticationMode)
	populate(objectMap, "database", p.Database)
	populate(objectMap, "maxWriterCount", p.MaxWriterCount)
	populate(objectMap, "password", p.Password)
	populate(objectMap, "server", p.Server)
	populate(objectMap, "table", p.Table)
	populate(objectMap, "user", p.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostgreSQLOutputDataSourceProperties.
func (p *PostgreSQLOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &p.AuthenticationMode)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &p.Database)
			delete(rawMsg, key)
		case "maxWriterCount":
			err = unpopulate(val, "MaxWriterCount", &p.MaxWriterCount)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &p.Password)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &p.Server)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &p.Table)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &p.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PowerBIOutputDataSource.
func (p PowerBIOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	objectMap["type"] = "PowerBI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PowerBIOutputDataSource.
func (p *PowerBIOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PowerBIOutputDataSourceProperties.
func (p PowerBIOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", p.AuthenticationMode)
	populate(objectMap, "dataset", p.Dataset)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "groupName", p.GroupName)
	populate(objectMap, "refreshToken", p.RefreshToken)
	populate(objectMap, "table", p.Table)
	populate(objectMap, "tokenUserDisplayName", p.TokenUserDisplayName)
	populate(objectMap, "tokenUserPrincipalName", p.TokenUserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PowerBIOutputDataSourceProperties.
func (p *PowerBIOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &p.AuthenticationMode)
			delete(rawMsg, key)
		case "dataset":
			err = unpopulate(val, "Dataset", &p.Dataset)
			delete(rawMsg, key)
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "groupName":
			err = unpopulate(val, "GroupName", &p.GroupName)
			delete(rawMsg, key)
		case "refreshToken":
			err = unpopulate(val, "RefreshToken", &p.RefreshToken)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &p.Table)
			delete(rawMsg, key)
		case "tokenUserDisplayName":
			err = unpopulate(val, "TokenUserDisplayName", &p.TokenUserDisplayName)
			delete(rawMsg, key)
		case "tokenUserPrincipalName":
			err = unpopulate(val, "TokenUserPrincipalName", &p.TokenUserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointListResult.
func (p PrivateEndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointListResult.
func (p *PrivateEndpointListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointProperties.
func (p PrivateEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createdDate", p.CreatedDate)
	populate(objectMap, "manualPrivateLinkServiceConnections", p.ManualPrivateLinkServiceConnections)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointProperties.
func (p *PrivateEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulate(val, "CreatedDate", &p.CreatedDate)
			delete(rawMsg, key)
		case "manualPrivateLinkServiceConnections":
			err = unpopulate(val, "ManualPrivateLinkServiceConnections", &p.ManualPrivateLinkServiceConnections)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkConnectionState.
func (p PrivateLinkConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkConnectionState.
func (p *PrivateLinkConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnection.
func (p PrivateLinkServiceConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnection.
func (p *PrivateLinkServiceConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionProperties.
func (p PrivateLinkServiceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "privateLinkServiceId", p.PrivateLinkServiceID)
	populate(objectMap, "requestMessage", p.RequestMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionProperties.
func (p *PrivateLinkServiceConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupIds":
			err = unpopulate(val, "GroupIDs", &p.GroupIDs)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "privateLinkServiceId":
			err = unpopulate(val, "PrivateLinkServiceID", &p.PrivateLinkServiceID)
			delete(rawMsg, key)
		case "requestMessage":
			err = unpopulate(val, "RequestMessage", &p.RequestMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryCompilationError.
func (q QueryCompilationError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endColumn", q.EndColumn)
	populate(objectMap, "endLine", q.EndLine)
	populate(objectMap, "isGlobal", q.IsGlobal)
	populate(objectMap, "message", q.Message)
	populate(objectMap, "startColumn", q.StartColumn)
	populate(objectMap, "startLine", q.StartLine)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryCompilationError.
func (q *QueryCompilationError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endColumn":
			err = unpopulate(val, "EndColumn", &q.EndColumn)
			delete(rawMsg, key)
		case "endLine":
			err = unpopulate(val, "EndLine", &q.EndLine)
			delete(rawMsg, key)
		case "isGlobal":
			err = unpopulate(val, "IsGlobal", &q.IsGlobal)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &q.Message)
			delete(rawMsg, key)
		case "startColumn":
			err = unpopulate(val, "StartColumn", &q.StartColumn)
			delete(rawMsg, key)
		case "startLine":
			err = unpopulate(val, "StartLine", &q.StartLine)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryCompilationResult.
func (q QueryCompilationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errors", q.Errors)
	populate(objectMap, "functions", q.Functions)
	populate(objectMap, "inputs", q.Inputs)
	populate(objectMap, "outputs", q.Outputs)
	populate(objectMap, "warnings", q.Warnings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryCompilationResult.
func (q *QueryCompilationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &q.Errors)
			delete(rawMsg, key)
		case "functions":
			err = unpopulate(val, "Functions", &q.Functions)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &q.Inputs)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &q.Outputs)
			delete(rawMsg, key)
		case "warnings":
			err = unpopulate(val, "Warnings", &q.Warnings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryFunction.
func (q QueryFunction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bindingType", q.BindingType)
	populate(objectMap, "inputs", q.Inputs)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "output", q.Output)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryFunction.
func (q *QueryFunction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingType":
			err = unpopulate(val, "BindingType", &q.BindingType)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &q.Inputs)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &q.Output)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryInput.
func (q QueryInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryInput.
func (q *QueryInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryTestingResult.
func (q QueryTestingResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", q.Error)
	populate(objectMap, "outputUri", q.OutputURI)
	populate(objectMap, "status", q.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryTestingResult.
func (q *QueryTestingResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &q.Error)
			delete(rawMsg, key)
		case "outputUri":
			err = unpopulate(val, "OutputURI", &q.OutputURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &q.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RawInputDatasourceProperties.
func (r RawInputDatasourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "payload", r.Payload)
	populate(objectMap, "payloadUri", r.PayloadURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RawInputDatasourceProperties.
func (r *RawInputDatasourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "payload":
			err = unpopulate(val, "Payload", &r.Payload)
			delete(rawMsg, key)
		case "payloadUri":
			err = unpopulate(val, "PayloadURI", &r.PayloadURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RawOutputDatasource.
func (r RawOutputDatasource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	objectMap["type"] = "Raw"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RawOutputDatasource.
func (r *RawOutputDatasource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RawOutputDatasourceProperties.
func (r RawOutputDatasourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "payloadUri", r.PayloadURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RawOutputDatasourceProperties.
func (r *RawOutputDatasourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "payloadUri":
			err = unpopulate(val, "PayloadURI", &r.PayloadURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RawReferenceInputDataSource.
func (r RawReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	objectMap["type"] = "Raw"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RawReferenceInputDataSource.
func (r *RawReferenceInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RawStreamInputDataSource.
func (r RawStreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	objectMap["type"] = "Raw"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RawStreamInputDataSource.
func (r *RawStreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceInputDataSource.
func (r ReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = r.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceInputDataSource.
func (r *ReferenceInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferenceInputProperties.
func (r ReferenceInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", r.Compression)
	populate(objectMap, "datasource", r.Datasource)
	populate(objectMap, "diagnostics", r.Diagnostics)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "partitionKey", r.PartitionKey)
	populate(objectMap, "serialization", r.Serialization)
	objectMap["type"] = "Reference"
	populate(objectMap, "watermarkSettings", r.WatermarkSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferenceInputProperties.
func (r *ReferenceInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &r.Compression)
			delete(rawMsg, key)
		case "datasource":
			r.Datasource, err = unmarshalReferenceInputDataSourceClassification(val)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &r.Diagnostics)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &r.PartitionKey)
			delete(rawMsg, key)
		case "serialization":
			r.Serialization, err = unmarshalSerializationClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "watermarkSettings":
			err = unpopulate(val, "WatermarkSettings", &r.WatermarkSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefreshConfiguration.
func (r RefreshConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dateFormat", r.DateFormat)
	populate(objectMap, "pathPattern", r.PathPattern)
	populate(objectMap, "refreshInterval", r.RefreshInterval)
	populate(objectMap, "refreshType", r.RefreshType)
	populate(objectMap, "timeFormat", r.TimeFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefreshConfiguration.
func (r *RefreshConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &r.DateFormat)
			delete(rawMsg, key)
		case "pathPattern":
			err = unpopulate(val, "PathPattern", &r.PathPattern)
			delete(rawMsg, key)
		case "refreshInterval":
			err = unpopulate(val, "RefreshInterval", &r.RefreshInterval)
			delete(rawMsg, key)
		case "refreshType":
			err = unpopulate(val, "RefreshType", &r.RefreshType)
			delete(rawMsg, key)
		case "timeFormat":
			err = unpopulate(val, "TimeFormat", &r.TimeFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTestStatus.
func (r ResourceTestStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTestStatus.
func (r *ResourceTestStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapacity.
func (s SKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedValues", s.AllowedValues)
	populate(objectMap, "default", s.Default)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "minimum", s.Minimum)
	populate(objectMap, "scaleType", s.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapacity.
func (s *SKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedValues":
			err = unpopulate(val, "AllowedValues", &s.AllowedValues)
			delete(rawMsg, key)
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &s.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &s.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SampleInput.
func (s SampleInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compatibilityLevel", s.CompatibilityLevel)
	populate(objectMap, "dataLocale", s.DataLocale)
	populate(objectMap, "eventsUri", s.EventsURI)
	populate(objectMap, "input", s.Input)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SampleInput.
func (s *SampleInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compatibilityLevel":
			err = unpopulate(val, "CompatibilityLevel", &s.CompatibilityLevel)
			delete(rawMsg, key)
		case "dataLocale":
			err = unpopulate(val, "DataLocale", &s.DataLocale)
			delete(rawMsg, key)
		case "eventsUri":
			err = unpopulate(val, "EventsURI", &s.EventsURI)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &s.Input)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SampleInputResult.
func (s SampleInputResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diagnostics", s.Diagnostics)
	populate(objectMap, "error", s.Error)
	populate(objectMap, "eventsDownloadUrl", s.EventsDownloadURL)
	populate(objectMap, "lastArrivalTime", s.LastArrivalTime)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SampleInputResult.
func (s *SampleInputResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &s.Diagnostics)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "eventsDownloadUrl":
			err = unpopulate(val, "EventsDownloadURL", &s.EventsDownloadURL)
			delete(rawMsg, key)
		case "lastArrivalTime":
			err = unpopulate(val, "LastArrivalTime", &s.LastArrivalTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalarFunctionProperties.
func (s ScalarFunctionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = "Scalar"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalarFunctionProperties.
func (s *ScalarFunctionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleStreamingJobParameters.
func (s ScaleStreamingJobParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "streamingUnits", s.StreamingUnits)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleStreamingJobParameters.
func (s *ScaleStreamingJobParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "streamingUnits":
			err = unpopulate(val, "StreamingUnits", &s.StreamingUnits)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Serialization.
func (s Serialization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = s.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Serialization.
func (s *Serialization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusDataSourceProperties.
func (s ServiceBusDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", s.AuthenticationMode)
	populate(objectMap, "serviceBusNamespace", s.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", s.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", s.SharedAccessPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusDataSourceProperties.
func (s *ServiceBusDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &s.AuthenticationMode)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &s.ServiceBusNamespace)
			delete(rawMsg, key)
		case "sharedAccessPolicyKey":
			err = unpopulate(val, "SharedAccessPolicyKey", &s.SharedAccessPolicyKey)
			delete(rawMsg, key)
		case "sharedAccessPolicyName":
			err = unpopulate(val, "SharedAccessPolicyName", &s.SharedAccessPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusQueueOutputDataSource.
func (s ServiceBusQueueOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = "Microsoft.ServiceBus/Queue"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusQueueOutputDataSource.
func (s *ServiceBusQueueOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusQueueOutputDataSourceProperties.
func (s ServiceBusQueueOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", s.AuthenticationMode)
	populate(objectMap, "propertyColumns", s.PropertyColumns)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "serviceBusNamespace", s.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", s.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", s.SharedAccessPolicyName)
	populateAny(objectMap, "systemPropertyColumns", s.SystemPropertyColumns)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusQueueOutputDataSourceProperties.
func (s *ServiceBusQueueOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &s.AuthenticationMode)
			delete(rawMsg, key)
		case "propertyColumns":
			err = unpopulate(val, "PropertyColumns", &s.PropertyColumns)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &s.QueueName)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &s.ServiceBusNamespace)
			delete(rawMsg, key)
		case "sharedAccessPolicyKey":
			err = unpopulate(val, "SharedAccessPolicyKey", &s.SharedAccessPolicyKey)
			delete(rawMsg, key)
		case "sharedAccessPolicyName":
			err = unpopulate(val, "SharedAccessPolicyName", &s.SharedAccessPolicyName)
			delete(rawMsg, key)
		case "systemPropertyColumns":
			err = unpopulate(val, "SystemPropertyColumns", &s.SystemPropertyColumns)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusTopicOutputDataSource.
func (s ServiceBusTopicOutputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = "Microsoft.ServiceBus/Topic"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusTopicOutputDataSource.
func (s *ServiceBusTopicOutputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusTopicOutputDataSourceProperties.
func (s ServiceBusTopicOutputDataSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMode", s.AuthenticationMode)
	populate(objectMap, "propertyColumns", s.PropertyColumns)
	populate(objectMap, "serviceBusNamespace", s.ServiceBusNamespace)
	populate(objectMap, "sharedAccessPolicyKey", s.SharedAccessPolicyKey)
	populate(objectMap, "sharedAccessPolicyName", s.SharedAccessPolicyName)
	populate(objectMap, "systemPropertyColumns", s.SystemPropertyColumns)
	populate(objectMap, "topicName", s.TopicName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusTopicOutputDataSourceProperties.
func (s *ServiceBusTopicOutputDataSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &s.AuthenticationMode)
			delete(rawMsg, key)
		case "propertyColumns":
			err = unpopulate(val, "PropertyColumns", &s.PropertyColumns)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &s.ServiceBusNamespace)
			delete(rawMsg, key)
		case "sharedAccessPolicyKey":
			err = unpopulate(val, "SharedAccessPolicyKey", &s.SharedAccessPolicyKey)
			delete(rawMsg, key)
		case "sharedAccessPolicyName":
			err = unpopulate(val, "SharedAccessPolicyName", &s.SharedAccessPolicyName)
			delete(rawMsg, key)
		case "systemPropertyColumns":
			err = unpopulate(val, "SystemPropertyColumns", &s.SystemPropertyColumns)
			delete(rawMsg, key)
		case "topicName":
			err = unpopulate(val, "TopicName", &s.TopicName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StartStreamingJobParameters.
func (s StartStreamingJobParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "outputStartMode", s.OutputStartMode)
	populateDateTimeRFC3339(objectMap, "outputStartTime", s.OutputStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StartStreamingJobParameters.
func (s *StartStreamingJobParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "outputStartMode":
			err = unpopulate(val, "OutputStartMode", &s.OutputStartMode)
			delete(rawMsg, key)
		case "outputStartTime":
			err = unpopulateDateTimeRFC3339(val, "OutputStartTime", &s.OutputStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccount.
func (s StorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", s.AccountKey)
	populate(objectMap, "accountName", s.AccountName)
	populate(objectMap, "authenticationMode", s.AuthenticationMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccount.
func (s *StorageAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &s.AccountKey)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &s.AccountName)
			delete(rawMsg, key)
		case "authenticationMode":
			err = unpopulate(val, "AuthenticationMode", &s.AuthenticationMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamInputDataSource.
func (s StreamInputDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = s.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamInputDataSource.
func (s *StreamInputDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamInputProperties.
func (s StreamInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", s.Compression)
	populate(objectMap, "datasource", s.Datasource)
	populate(objectMap, "diagnostics", s.Diagnostics)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "partitionKey", s.PartitionKey)
	populate(objectMap, "serialization", s.Serialization)
	objectMap["type"] = "Stream"
	populate(objectMap, "watermarkSettings", s.WatermarkSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamInputProperties.
func (s *StreamInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &s.Compression)
			delete(rawMsg, key)
		case "datasource":
			s.Datasource, err = unmarshalStreamInputDataSourceClassification(val)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &s.Diagnostics)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "partitionKey":
			err = unpopulate(val, "PartitionKey", &s.PartitionKey)
			delete(rawMsg, key)
		case "serialization":
			s.Serialization, err = unmarshalSerializationClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "watermarkSettings":
			err = unpopulate(val, "WatermarkSettings", &s.WatermarkSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingJob.
func (s StreamingJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingJob.
func (s *StreamingJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingJobListResult.
func (s StreamingJobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingJobListResult.
func (s *StreamingJobListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StreamingJobProperties.
func (s StreamingJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cluster", s.Cluster)
	populate(objectMap, "compatibilityLevel", s.CompatibilityLevel)
	populate(objectMap, "contentStoragePolicy", s.ContentStoragePolicy)
	populateDateTimeRFC3339(objectMap, "createdDate", s.CreatedDate)
	populate(objectMap, "dataLocale", s.DataLocale)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "eventsLateArrivalMaxDelayInSeconds", s.EventsLateArrivalMaxDelayInSeconds)
	populate(objectMap, "eventsOutOfOrderMaxDelayInSeconds", s.EventsOutOfOrderMaxDelayInSeconds)
	populate(objectMap, "eventsOutOfOrderPolicy", s.EventsOutOfOrderPolicy)
	populate(objectMap, "externals", s.Externals)
	populate(objectMap, "functions", s.Functions)
	populate(objectMap, "inputs", s.Inputs)
	populate(objectMap, "jobId", s.JobID)
	populate(objectMap, "jobState", s.JobState)
	populate(objectMap, "jobStorageAccount", s.JobStorageAccount)
	populate(objectMap, "jobType", s.JobType)
	populateDateTimeRFC3339(objectMap, "lastOutputEventTime", s.LastOutputEventTime)
	populate(objectMap, "outputErrorPolicy", s.OutputErrorPolicy)
	populate(objectMap, "outputStartMode", s.OutputStartMode)
	populateDateTimeRFC3339(objectMap, "outputStartTime", s.OutputStartTime)
	populate(objectMap, "outputs", s.Outputs)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "transformation", s.Transformation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StreamingJobProperties.
func (s *StreamingJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cluster":
			err = unpopulate(val, "Cluster", &s.Cluster)
			delete(rawMsg, key)
		case "compatibilityLevel":
			err = unpopulate(val, "CompatibilityLevel", &s.CompatibilityLevel)
			delete(rawMsg, key)
		case "contentStoragePolicy":
			err = unpopulate(val, "ContentStoragePolicy", &s.ContentStoragePolicy)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &s.CreatedDate)
			delete(rawMsg, key)
		case "dataLocale":
			err = unpopulate(val, "DataLocale", &s.DataLocale)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "eventsLateArrivalMaxDelayInSeconds":
			err = unpopulate(val, "EventsLateArrivalMaxDelayInSeconds", &s.EventsLateArrivalMaxDelayInSeconds)
			delete(rawMsg, key)
		case "eventsOutOfOrderMaxDelayInSeconds":
			err = unpopulate(val, "EventsOutOfOrderMaxDelayInSeconds", &s.EventsOutOfOrderMaxDelayInSeconds)
			delete(rawMsg, key)
		case "eventsOutOfOrderPolicy":
			err = unpopulate(val, "EventsOutOfOrderPolicy", &s.EventsOutOfOrderPolicy)
			delete(rawMsg, key)
		case "externals":
			err = unpopulate(val, "Externals", &s.Externals)
			delete(rawMsg, key)
		case "functions":
			err = unpopulate(val, "Functions", &s.Functions)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &s.Inputs)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &s.JobID)
			delete(rawMsg, key)
		case "jobState":
			err = unpopulate(val, "JobState", &s.JobState)
			delete(rawMsg, key)
		case "jobStorageAccount":
			err = unpopulate(val, "JobStorageAccount", &s.JobStorageAccount)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &s.JobType)
			delete(rawMsg, key)
		case "lastOutputEventTime":
			err = unpopulateDateTimeRFC3339(val, "LastOutputEventTime", &s.LastOutputEventTime)
			delete(rawMsg, key)
		case "outputErrorPolicy":
			err = unpopulate(val, "OutputErrorPolicy", &s.OutputErrorPolicy)
			delete(rawMsg, key)
		case "outputStartMode":
			err = unpopulate(val, "OutputStartMode", &s.OutputStartMode)
			delete(rawMsg, key)
		case "outputStartTime":
			err = unpopulateDateTimeRFC3339(val, "OutputStartTime", &s.OutputStartTime)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &s.Outputs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "transformation":
			err = unpopulate(val, "Transformation", &s.Transformation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionQuota.
func (s SubscriptionQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionQuota.
func (s *SubscriptionQuota) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionQuotaProperties.
func (s SubscriptionQuotaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentCount", s.CurrentCount)
	populate(objectMap, "maxCount", s.MaxCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionQuotaProperties.
func (s *SubscriptionQuotaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentCount":
			err = unpopulate(val, "CurrentCount", &s.CurrentCount)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &s.MaxCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionQuotasListResult.
func (s SubscriptionQuotasListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionQuotasListResult.
func (s *SubscriptionQuotasListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestDatasourceResult.
func (t TestDatasourceResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", t.Error)
	populate(objectMap, "status", t.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestDatasourceResult.
func (t *TestDatasourceResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &t.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestInput.
func (t TestInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "input", t.Input)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestInput.
func (t *TestInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "input":
			err = unpopulate(val, "Input", &t.Input)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestOutput.
func (t TestOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "output", t.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestOutput.
func (t *TestOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "output":
			err = unpopulate(val, "Output", &t.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestQuery.
func (t TestQuery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diagnostics", t.Diagnostics)
	populate(objectMap, "streamingJob", t.StreamingJob)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestQuery.
func (t *TestQuery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &t.Diagnostics)
			delete(rawMsg, key)
		case "streamingJob":
			err = unpopulate(val, "StreamingJob", &t.StreamingJob)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestQueryDiagnostics.
func (t TestQueryDiagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "path", t.Path)
	populate(objectMap, "writeUri", t.WriteURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestQueryDiagnostics.
func (t *TestQueryDiagnostics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "path":
			err = unpopulate(val, "Path", &t.Path)
			delete(rawMsg, key)
		case "writeUri":
			err = unpopulate(val, "WriteURI", &t.WriteURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Transformation.
func (t Transformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Transformation.
func (t *Transformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransformationProperties.
func (t TransformationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "query", t.Query)
	populate(objectMap, "streamingUnits", t.StreamingUnits)
	populate(objectMap, "validStreamingUnits", t.ValidStreamingUnits)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransformationProperties.
func (t *TransformationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &t.Query)
			delete(rawMsg, key)
		case "streamingUnits":
			err = unpopulate(val, "StreamingUnits", &t.StreamingUnits)
			delete(rawMsg, key)
		case "validStreamingUnits":
			err = unpopulate(val, "ValidStreamingUnits", &t.ValidStreamingUnits)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
