//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The subscription id
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAccessControlRecordsClient creates a new instance of AccessControlRecordsClient.
func (c *ClientFactory) NewAccessControlRecordsClient() *AccessControlRecordsClient {
	subClient, _ := NewAccessControlRecordsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAlertsClient creates a new instance of AlertsClient.
func (c *ClientFactory) NewAlertsClient() *AlertsClient {
	subClient, _ := NewAlertsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAvailableProviderOperationsClient creates a new instance of AvailableProviderOperationsClient.
func (c *ClientFactory) NewAvailableProviderOperationsClient() *AvailableProviderOperationsClient {
	subClient, _ := NewAvailableProviderOperationsClient(c.credential, c.options)
	return subClient
}

// NewBackupScheduleGroupsClient creates a new instance of BackupScheduleGroupsClient.
func (c *ClientFactory) NewBackupScheduleGroupsClient() *BackupScheduleGroupsClient {
	subClient, _ := NewBackupScheduleGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBackupsClient creates a new instance of BackupsClient.
func (c *ClientFactory) NewBackupsClient() *BackupsClient {
	subClient, _ := NewBackupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewChapSettingsClient creates a new instance of ChapSettingsClient.
func (c *ClientFactory) NewChapSettingsClient() *ChapSettingsClient {
	subClient, _ := NewChapSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDevicesClient creates a new instance of DevicesClient.
func (c *ClientFactory) NewDevicesClient() *DevicesClient {
	subClient, _ := NewDevicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFileServersClient creates a new instance of FileServersClient.
func (c *ClientFactory) NewFileServersClient() *FileServersClient {
	subClient, _ := NewFileServersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFileSharesClient creates a new instance of FileSharesClient.
func (c *ClientFactory) NewFileSharesClient() *FileSharesClient {
	subClient, _ := NewFileSharesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIscsiDisksClient creates a new instance of IscsiDisksClient.
func (c *ClientFactory) NewIscsiDisksClient() *IscsiDisksClient {
	subClient, _ := NewIscsiDisksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIscsiServersClient creates a new instance of IscsiServersClient.
func (c *ClientFactory) NewIscsiServersClient() *IscsiServersClient {
	subClient, _ := NewIscsiServersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobsClient creates a new instance of JobsClient.
func (c *ClientFactory) NewJobsClient() *JobsClient {
	subClient, _ := NewJobsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagersClient creates a new instance of ManagersClient.
func (c *ClientFactory) NewManagersClient() *ManagersClient {
	subClient, _ := NewManagersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStorageAccountCredentialsClient creates a new instance of StorageAccountCredentialsClient.
func (c *ClientFactory) NewStorageAccountCredentialsClient() *StorageAccountCredentialsClient {
	subClient, _ := NewStorageAccountCredentialsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStorageDomainsClient creates a new instance of StorageDomainsClient.
func (c *ClientFactory) NewStorageDomainsClient() *StorageDomainsClient {
	subClient, _ := NewStorageDomainsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
