//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorageactions

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// StorageTasksClient contains the methods for the StorageTasks group.
// Don't use this type directly, use NewStorageTasksClient() instead.
type StorageTasksClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewStorageTasksClient creates a new instance of StorageTasksClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewStorageTasksClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*StorageTasksClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &StorageTasksClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Asynchronously creates a new storage task resource with the specified parameters. If a storage task is already
// created and a subsequent create request is issued with different properties, the storage
// task properties will be updated. If a storage task is already created and a subsequent create or update request is issued
// with the exact same set of properties, the request will succeed.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - storageTaskName - The name of the storage task within the specified resource group. Storage task names must be between
//     3 and 18 characters in length and use numbers and lower-case letters only.
//   - parameters - The parameters to create a Storage Task.
//   - options - StorageTasksClientBeginCreateOptions contains the optional parameters for the StorageTasksClient.BeginCreate
//     method.
func (client *StorageTasksClient) BeginCreate(ctx context.Context, resourceGroupName string, storageTaskName string, parameters StorageTask, options *StorageTasksClientBeginCreateOptions) (*runtime.Poller[StorageTasksClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, storageTaskName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StorageTasksClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StorageTasksClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Asynchronously creates a new storage task resource with the specified parameters. If a storage task is already
// created and a subsequent create request is issued with different properties, the storage
// task properties will be updated. If a storage task is already created and a subsequent create or update request is issued
// with the exact same set of properties, the request will succeed.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StorageTasksClient) create(ctx context.Context, resourceGroupName string, storageTaskName string, parameters StorageTask, options *StorageTasksClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "StorageTasksClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, storageTaskName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *StorageTasksClient) createCreateRequest(ctx context.Context, resourceGroupName string, storageTaskName string, parameters StorageTask, options *StorageTasksClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if storageTaskName == "" {
		return nil, errors.New("parameter storageTaskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageTaskName}", url.PathEscape(storageTaskName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Delete the storage task resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - storageTaskName - The name of the storage task within the specified resource group. Storage task names must be between
//     3 and 18 characters in length and use numbers and lower-case letters only.
//   - options - StorageTasksClientBeginDeleteOptions contains the optional parameters for the StorageTasksClient.BeginDelete
//     method.
func (client *StorageTasksClient) BeginDelete(ctx context.Context, resourceGroupName string, storageTaskName string, options *StorageTasksClientBeginDeleteOptions) (*runtime.Poller[StorageTasksClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, storageTaskName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StorageTasksClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StorageTasksClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete the storage task resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StorageTasksClient) deleteOperation(ctx context.Context, resourceGroupName string, storageTaskName string, options *StorageTasksClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "StorageTasksClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, storageTaskName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *StorageTasksClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, storageTaskName string, options *StorageTasksClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if storageTaskName == "" {
		return nil, errors.New("parameter storageTaskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageTaskName}", url.PathEscape(storageTaskName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get the storage task properties
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - storageTaskName - The name of the storage task within the specified resource group. Storage task names must be between
//     3 and 18 characters in length and use numbers and lower-case letters only.
//   - options - StorageTasksClientGetOptions contains the optional parameters for the StorageTasksClient.Get method.
func (client *StorageTasksClient) Get(ctx context.Context, resourceGroupName string, storageTaskName string, options *StorageTasksClientGetOptions) (StorageTasksClientGetResponse, error) {
	var err error
	const operationName = "StorageTasksClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, storageTaskName, options)
	if err != nil {
		return StorageTasksClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StorageTasksClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StorageTasksClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *StorageTasksClient) getCreateRequest(ctx context.Context, resourceGroupName string, storageTaskName string, options *StorageTasksClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if storageTaskName == "" {
		return nil, errors.New("parameter storageTaskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageTaskName}", url.PathEscape(storageTaskName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *StorageTasksClient) getHandleResponse(resp *http.Response) (StorageTasksClientGetResponse, error) {
	result := StorageTasksClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StorageTask); err != nil {
		return StorageTasksClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Lists all the storage tasks available under the given resource group.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - StorageTasksClientListByResourceGroupOptions contains the optional parameters for the StorageTasksClient.NewListByResourceGroupPager
//     method.
func (client *StorageTasksClient) NewListByResourceGroupPager(resourceGroupName string, options *StorageTasksClientListByResourceGroupOptions) *runtime.Pager[StorageTasksClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[StorageTasksClientListByResourceGroupResponse]{
		More: func(page StorageTasksClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StorageTasksClientListByResourceGroupResponse) (StorageTasksClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StorageTasksClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return StorageTasksClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *StorageTasksClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *StorageTasksClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *StorageTasksClient) listByResourceGroupHandleResponse(resp *http.Response) (StorageTasksClientListByResourceGroupResponse, error) {
	result := StorageTasksClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StorageTasksListResult); err != nil {
		return StorageTasksClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Lists all the storage tasks available under the subscription.
//
// Generated from API version 2023-01-01
//   - options - StorageTasksClientListBySubscriptionOptions contains the optional parameters for the StorageTasksClient.NewListBySubscriptionPager
//     method.
func (client *StorageTasksClient) NewListBySubscriptionPager(options *StorageTasksClientListBySubscriptionOptions) *runtime.Pager[StorageTasksClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[StorageTasksClientListBySubscriptionResponse]{
		More: func(page StorageTasksClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StorageTasksClientListBySubscriptionResponse) (StorageTasksClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StorageTasksClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return StorageTasksClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *StorageTasksClient) listBySubscriptionCreateRequest(ctx context.Context, options *StorageTasksClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.StorageActions/storageTasks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *StorageTasksClient) listBySubscriptionHandleResponse(resp *http.Response) (StorageTasksClientListBySubscriptionResponse, error) {
	result := StorageTasksClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StorageTasksListResult); err != nil {
		return StorageTasksClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// PreviewActions - Runs the input conditions against input object metadata properties and designates matched objects in response.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - location - The location to perform preview of the actions.
//   - parameters - The parameters to preview action condition.
//   - options - StorageTasksClientPreviewActionsOptions contains the optional parameters for the StorageTasksClient.PreviewActions
//     method.
func (client *StorageTasksClient) PreviewActions(ctx context.Context, location string, parameters StorageTaskPreviewAction, options *StorageTasksClientPreviewActionsOptions) (StorageTasksClientPreviewActionsResponse, error) {
	var err error
	const operationName = "StorageTasksClient.PreviewActions"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.previewActionsCreateRequest(ctx, location, parameters, options)
	if err != nil {
		return StorageTasksClientPreviewActionsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StorageTasksClientPreviewActionsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StorageTasksClientPreviewActionsResponse{}, err
	}
	resp, err := client.previewActionsHandleResponse(httpResp)
	return resp, err
}

// previewActionsCreateRequest creates the PreviewActions request.
func (client *StorageTasksClient) previewActionsCreateRequest(ctx context.Context, location string, parameters StorageTaskPreviewAction, options *StorageTasksClientPreviewActionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.StorageActions/locations/{location}/previewActions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// previewActionsHandleResponse handles the PreviewActions response.
func (client *StorageTasksClient) previewActionsHandleResponse(resp *http.Response) (StorageTasksClientPreviewActionsResponse, error) {
	result := StorageTasksClientPreviewActionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StorageTaskPreviewAction); err != nil {
		return StorageTasksClientPreviewActionsResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Update storage task properties
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - storageTaskName - The name of the storage task within the specified resource group. Storage task names must be between
//     3 and 18 characters in length and use numbers and lower-case letters only.
//   - parameters - The parameters to provide to update the storage task resource.
//   - options - StorageTasksClientBeginUpdateOptions contains the optional parameters for the StorageTasksClient.BeginUpdate
//     method.
func (client *StorageTasksClient) BeginUpdate(ctx context.Context, resourceGroupName string, storageTaskName string, parameters StorageTaskUpdateParameters, options *StorageTasksClientBeginUpdateOptions) (*runtime.Poller[StorageTasksClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, storageTaskName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StorageTasksClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StorageTasksClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Update storage task properties
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *StorageTasksClient) update(ctx context.Context, resourceGroupName string, storageTaskName string, parameters StorageTaskUpdateParameters, options *StorageTasksClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "StorageTasksClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, storageTaskName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *StorageTasksClient) updateCreateRequest(ctx context.Context, resourceGroupName string, storageTaskName string, parameters StorageTaskUpdateParameters, options *StorageTasksClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if storageTaskName == "" {
		return nil, errors.New("parameter storageTaskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageTaskName}", url.PathEscape(storageTaskName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
