//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorageactions_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storageactions/armstorageactions"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/storageactions/resource-manager/Microsoft.StorageActions/stable/2023-01-01/examples/storageTasksList/ListStorageTaskAssignmentIds.json
func ExampleStorageTaskAssignmentClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageactions.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStorageTaskAssignmentClient().NewListPager("rgroup1", "mytask1", &armstorageactions.StorageTaskAssignmentClientListOptions{Maxpagesize: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StorageTaskAssignmentsListResult = armstorageactions.StorageTaskAssignmentsListResult{
		// 	Value: []*armstorageactions.StorageTaskAssignment{
		// 		{
		// 			ID: to.Ptr("/subscriptions/9d6baee9-681f-44d8-99f7-d06d180af6bb/resourcegroups/rgroup1/providers/microsoft.storage/storageaccounts/acc123/storagetaskassignments/assign123"),
		// 		},
		// 		{
		// 			ID: to.Ptr("/subscriptions/9d6baee9-681f-44d8-99f7-d06d180af6bb/resourcegroups/rgroup1/providers/microsoft.storage/storageaccounts/acc123/storagetaskassignments/assign455"),
		// 		},
		// 		{
		// 			ID: to.Ptr("/subscriptions/9d6baee9-681f-44d8-99f7-d06d180af6bb/resourcegroups/rgroup3/providers/microsoft.storage/storageaccounts/accxx1/storagetaskassignments/assign123"),
		// 		},
		// 		{
		// 			ID: to.Ptr("/subscriptions/28e089f2-9607-4285-a0d0-64dbe3771929/resourcegroups/rgroup4/providers/microsoft.storage/storageaccounts/accxx2/storagetaskassignments/assign123"),
		// 	}},
		// }
	}
}
