//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armspringappdiscovery

import "time"

// Error - Defines the error.
type Error struct {
	// The error code.
	Code *string

	// The error ID.
	ID *int64

	// The detailed error message.
	Message *string

	// The error possible causes.
	PossibleCauses *string

	// The error recommended action
	RecommendedAction *string

	// The account ID used to login.
	RunAsAccountID *string

	// The error severity
	Severity *string

	// The summarized error message.
	SummaryMessage *string

	// Time when this error was last updated.
	UpdatedTimeStamp *time.Time
}

// ErrorSummariesProperties - Error summary properties
type ErrorSummariesProperties struct {
	// The list of ErrorSummary.
	DiscoveryScopeErrorSummaries []*ErrorSummaryModel

	// The list of errors.
	Errors []*Error

	// The resource provisioning state.
	ProvisioningState *ProvisioningState
}

// ErrorSummary - The error summary resource definition.
type ErrorSummary struct {
	// Resource properties.
	Properties *ErrorSummariesProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ErrorSummaryList - The list of ErrorSummary.
type ErrorSummaryList struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// The list of ErrorSummary.
	Value []*ErrorSummary
}

// ErrorSummaryModel - ErrorSummary model.
type ErrorSummaryModel struct {
	// The count.
	AffectedObjectsCount *int64

	// The type of Object.
	AffectedResourceType *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// SpringbootappsListResult - The springbootapps list resource definition.
type SpringbootappsListResult struct {
	// The link used to get the next page of springbootapps resources list.
	NextLink *string

	// The springbootsites list.
	Value []*SpringbootappsModel
}

// SpringbootappsModel - The springbootapps envelope resource definition.
type SpringbootappsModel struct {
	// The springbootapps resource definition.
	Properties *SpringbootappsProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpringbootappsPatch - The springbootapps resource patch definition.
type SpringbootappsPatch struct {
	// The springbootapps resource definition.
	Properties *SpringbootappsProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpringbootappsProperties - The springbootapps resource definition.
type SpringbootappsProperties struct {
	// The name of SpringBootApp.
	AppName *string

	// The application port.
	AppPort *int32

	// The application type, whether it is a SpringBoot app.
	AppType *string

	// The application configuration file list.
	ApplicationConfigurations []*SpringbootappsPropertiesApplicationConfigurationsItem

	// The artifact name of SpringBootApp.
	ArtifactName *string

	// The application binding port list.
	BindingPorts []*int32

	// The jdk version in build.
	BuildJdkVersion *string

	// The certificate file list.
	Certificates []*string

	// The checksum of jar file.
	Checksum *string

	// The connection string list.
	ConnectionStrings []*string

	// The dependency list.
	Dependencies []*string

	// The environment variable list.
	Environments []*string

	// The list of errors.
	Errors []*Error

	// The total instance count the app deployed.
	InstanceCount *int32

	// The breakdown info for app instances on all the servers
	Instances []*SpringbootappsPropertiesInstancesItem

	// The jar file location on the server.
	JarFileLocation *string

	// The jvm heap memory allocated.
	JvmMemoryInMB *int32

	// The jvm options.
	JvmOptions []*string

	// Time when this springbootapps jar file was last modified.
	LastModifiedTime *time.Time

	// Time when this springbootapps instance was last refreshed.
	LastUpdatedTime *time.Time

	// The machine ARM id list the app belongs to.
	MachineArmIDs []*string

	// The other types of date collected.
	Miscs []*SpringbootappsPropertiesMiscsItem

	// The resource provisioning state.
	ProvisioningState *ProvisioningState

	// The jdk version installed on server
	RuntimeJdkVersion *string

	// The server list the app installed
	Servers []*string

	// The site name.
	SiteName *string

	// The spring boot version.
	SpringBootVersion *string

	// The static content location list.
	StaticContentLocations []*string
}

type SpringbootappsPropertiesApplicationConfigurationsItem struct {
	// REQUIRED; The application config file name.
	Key *string

	// The application config file content, only contains config keys.
	Value *string
}

type SpringbootappsPropertiesInstancesItem struct {
	// REQUIRED; The machine ARM resource Id of this app instance
	MachineArmID *string

	// The instance count of this app instance
	InstanceCount *int32

	// The jvm heap memory allocated of this app instance
	JvmMemoryInMB *int32
}

type SpringbootappsPropertiesMiscsItem struct {
	// REQUIRED; The miscs. key.
	Key *string

	// The miscs. value.
	Value *string
}

// SpringbootserversListResult - The springbootservers list resource definition.
type SpringbootserversListResult struct {
	// The link used to get the next page of springbootservers resources list.
	NextLink *string

	// The springbootsites list.
	Value []*SpringbootserversModel
}

// SpringbootserversModel - The springbootservers envelope resource definition.
type SpringbootserversModel struct {
	// The springbootservers resource definition.
	Properties *SpringbootserversProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpringbootserversPatch - The springbootservers resource patch definition.
type SpringbootserversPatch struct {
	// The springbootsites resource definition.
	Properties *SpringbootserversProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpringbootserversProperties - The springbootservers resource definition.
type SpringbootserversProperties struct {
	// REQUIRED; Server is the target server name or ip address to discover of SpringBootServer.
	Server *string

	// The list of errors.
	Errors []*Error

	// The alternative FQDN or IP addresses to discover for this server
	FqdnAndIPAddressList []*string

	// The machine Id from ARM
	MachineArmID *string

	// Target server port for remote login
	Port *int32

	// The resource provisioning state.
	ProvisioningState *ProvisioningState

	// The total number of spring boot apps been discovered
	SpringBootApps *int32

	// The total number of apps been discovered
	TotalApps *int32
}

// SpringbootsitesListResult - The springbootsites list resource definition.
type SpringbootsitesListResult struct {
	// The link used to get the next page of springbootsites resources list.
	NextLink *string

	// The springbootsites list.
	Value []*SpringbootsitesModel
}

// SpringbootsitesModel - The springbootsites envelope resource definition.
type SpringbootsitesModel struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extended location definition.
	ExtendedLocation *SpringbootsitesModelExtendedLocation

	// The springbootsites resource definition.
	Properties *SpringbootsitesProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpringbootsitesModelExtendedLocation - The extended location definition.
type SpringbootsitesModelExtendedLocation struct {
	// The extended location name.
	Name *string

	// The extended location type.
	Type *string
}

// SpringbootsitesPatch - The springbootsites resource patch definition.
type SpringbootsitesPatch struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The springbootsites resource definition.
	Properties *SpringbootsitesProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpringbootsitesProperties - The springbootsites resource definition.
type SpringbootsitesProperties struct {
	// The master site ID from Azure Migrate.
	MasterSiteID *string

	// The migrate project ID from Azure Migrate.
	MigrateProjectID *string

	// The resource provisioning state.
	ProvisioningState *ProvisioningState
}

// SummariesProperties - Summaries properties
type SummariesProperties struct {
	// The of number discovered spring boot apps.
	DiscoveredApps *int64

	// The of number discovered spring boot servers.
	DiscoveredServers *int64

	// The list of errors.
	Errors []*Error

	// The resource provisioning state.
	ProvisioningState *ProvisioningState
}

// Summary - The summary resource definition.
type Summary struct {
	// Resource properties.
	Properties *SummariesProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SummaryList - List of Sites.
type SummaryList struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Sites.
	Value []*Summary
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}
